//*****************************************************************************
//                               PnlNgSpiceTR.hpp                             *
//                              ------------------                            *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a Transient Analysis *
//                for NG-Spice electronic circuit simulator.                   *
//  Started     : 05/08/2004                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLNGSPICETR_HPP
#define PNLNGSPICETR_HPP

// System Includes

#include <cfloat>

// wxWidgets Library Includes


// Application Includes

#include "TypeDefs.hpp"
#include "base/PnlAnaBase.hpp"
#include "ngspice/dialogs/DlgSigSrcCfg.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlNgSpiceTR : public PnlAnaBase
{
  private:

    // Signal source configuration controls
    wxButton      m_oBtnSetup;
    DlgSigSrcCfg  m_oDlgSigSrcCfg;

    void  Create( void );
    bool  bSetInitC( eInitCType eInitC );

public:

    PnlNgSpiceTR( wxWindow * poWin );
   ~PnlNgSpiceTR( );

    bool  bClear( void );

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    // Event handlers
    void  OnChoSigSrcCpnt( wxCommandEvent & roEvtCmd );
    void  OnBtnSetup     ( wxCommandEvent & roEvtCmd );

    // Unique display control identifiers
    enum ePnlItemID
    {
      ID_BTN_SETUP = PnlAnaBase::ID_LST+1,

      ID_UNUSED,

      ID_FST = ID_BTN_SETUP,
      ID_LST = ID_BTN_SETUP
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLNGSPICETR_HPP
