//*****************************************************************************
//                               PnlNgSpiceAC.hpp                             *
//                              ------------------                            *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a AC Analysis for    *
//                NG Spice electronic circuit simulator.                      *
//  Started     : 04/08/2004                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLNGSPICEAC_HPP
#define PNLNGSPICEAC_HPP

// System Includes


// wxWindows Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlNgSpiceAC : public PnlAnaBase
{
  private:

    void  Create( void );
    void  InitStepScale( void );
    bool  bSetStepScale( eScaleType eScale );

  public:

    PnlNgSpiceAC( wxWindow * poWin );
   ~PnlNgSpiceAC( );

    bool  bClear( void );

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    // Event handlers
    void  OnStepScale ( wxCommandEvent & roEvtCmd );
    void  OnSigSrcCpnt( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLNGSPICEAC_HPP
