//*****************************************************************************
//                              CmdNgSpiceDC.hpp                              *
//                             ------------------                             *
//  Description : This class contains values associated with the NG-Spice DC  *
//                command. It inherits from the class CmdBase.                *
//  Started     : 23/08/2006                                                  *
//  Last Update : 29/01/2008                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICEDC_HPP
#define CMDNGSPICEDC_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdNgSpiceDC : public CmdBase
{
  public :

    float     m_fStart;    // Sweep start value
    float     m_fStop;     // Sweep stop  value
    float     m_fStep;     // Sweep step  value
    wxString  m_osSource;  // Sweep source

              CmdNgSpiceDC( void );
    virtual  ~CmdNgSpiceDC( );

    bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    wxString & operator = ( const wxString & ros )
                { *((wxString *) this) = ros; return( *((wxString *) this) ); }

    void  Print( const char * psPrefix="" );
};

//*****************************************************************************

#endif // CMDNGSPICEDC_HPP
