//*****************************************************************************
//                               PnlNgSpiceTR.cpp                             *
//                              ------------------                            *
//  Started     : 05/08/2004                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/panels/PnlNgSpiceTR.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( PnlNgSpiceTR, PnlAnaBase )

  EVT_CHOICE( ID_CHO_SIGSRCCPNT, PnlNgSpiceTR::OnChoSigSrcCpnt )
  EVT_BUTTON( ID_BTN_SETUP,      PnlNgSpiceTR::OnBtnSetup      )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.

PnlNgSpiceTR::PnlNgSpiceTR( wxWindow * poWin )
                          : PnlAnaBase( poWin ), m_oDlgSigSrcCfg( poWin )
{
  bSetSimrType( eSIMR_NGSPICE );
  bSetAnaType ( eANA_TR );

  Create( );  // Create the analysis panel
  bClear( );  // Clear all object attributes
}

//*****************************************************************************
// Destructor.

PnlNgSpiceTR::~PnlNgSpiceTR( )
{
}

//*****************************************************************************
// Create the display objects.

void  PnlNgSpiceTR::Create( void )
{
  wxStaticBox * poSbxSigSrc;
  int  ix, iy;

  // Disable the checkboxes for the parameters NG-Spice cannot calculate
  m_oCbxCurrent.Disable( );
  m_oCbxPower  .Disable( );
  m_oCbxResist .Disable( );

  // Set the frequency sweep parameter labels
  m_oSbxSwpPars.GetSize( &ix, &iy );
  m_oSbxSwpPars.SetSize(  ix, 167 );
  m_oSbxSwpPars.SetLabel( wxT(" Transient Sweep ") );
  m_oPnlStart  .bSetName( wxT("Start Time") );
  m_oPnlStop   .bSetName( wxT("Stop Time") );
  m_oPnlStep   .bSetName( wxT("Step Increment") );

  // Set sweep parameter units
  m_oPnlStart.bSetUnitsType( ChoUnits::eUNITS_TIME );
  m_oPnlStop .bSetUnitsType( ChoUnits::eUNITS_TIME );
  m_oPnlStep .bSetUnitsType( ChoUnits::eUNITS_TIME );

  // Create and add the initial conditions radio buttons
  wxString  osInitC[ 3 ] = { wxT("Warm"), wxT("Use ICs"), wxT("Cold ") };
  m_oRbxInitC.Create( this, ID_UNUSED, wxT(" Initial Conditions "),
                      wxPoint( 13, 123 ), wxDefaultSize, 3, osInitC, 3 );
  bSetInitC( eINITC_WARM );

  // Create and add generator controls
  poSbxSigSrc = new wxStaticBox( this, ID_UNUSED, wxT(" Signal Source "),
                           wxPoint( 6, 175 ),   wxSize( 235, 55 ) );
  m_oChoSigSrcCpnt.Create( this, ID_CHO_SIGSRCCPNT,
                           wxPoint( 18, 195 ),  wxSize( 107, -1 ) );
  m_oBtnSetup     .Create( this, ID_BTN_SETUP, wxT("Setup ..."),
                           wxPoint( 130, 195 ), wxSize( 100, 29 ) );
  poSbxSigSrc->SetOwnFont( FONT_SLANT );

  // Create and add the analysis temperature controls
  CreateTemp( );
}

//*****************************************************************************
// Set the state of the initial conditions radio box.
//
// Argument List:
//   eInitC - The enumerated initial conditions specifier
//
// Return Values:
//   Success - TRUE
//   Failure - FALSE

bool  PnlNgSpiceTR::bSetInitC( eInitCType eInitC )
{
  if( eInitC<eINITC_FST || eInitC>eINITC_LST )      return( FALSE );
#if wxCHECK_VERSION( 2,8,0 )
  if( m_oRbxInitC.GetCount( ) < (uint) eInitC + 1 ) return( FALSE );
#else
  if( m_oRbxInitC.GetCount( ) < (int)  eInitC + 1 ) return( FALSE );
#endif

  m_oRbxInitC.SetSelection( (int) eInitC );

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PnlNgSpiceTR::bClear( void )
{
  bool  bRtnValue=TRUE;

  // Clear the base class
  if( ! PnlAnaBase::bClear( ) )    bRtnValue = FALSE;
  m_oPnlStart.bSetValue( (float) 0.0 );
  m_oPnlStep .bSetValue( (float) 1.0 );

  // Set the default sweep units
  m_oPnlStart.bSetUnits( wxT("msec") );
  m_oPnlStop .bSetUnits( wxT("msec") );
  m_oPnlStep .bSetUnits( wxT("msec") );

  // Set default initial condition values
  if( ! bSetInitC( eINITC_WARM ) ) bRtnValue = FALSE;

  // Set input source default values
  m_oChoSigSrcCpnt.Clear( );
  m_oChoSigSrcCpnt.Append( wxT("None") );
  m_oChoSigSrcCpnt.SetSelection( 0 );

  // Clear the generator dialog
  m_oDlgSigSrcCfg.bClear( );
  m_oDlgSigSrcCfg.bSetDefaults( );

  return( bRtnValue );
}

//*****************************************************************************
// Load information from a Simulation object.
//
// Argument List:
//   roSim - The Simulation object
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PnlNgSpiceTR::bLoad( Simulation & roSim )
{
  bool  bRtnValue=TRUE;

  // Load the components into the choice box
  LoadSigSrcCpnts( roSim, wxT("VI") );

  // Don't go any further if the analysis type doesn't match
  if( roSim.eGetAnaType( ) != eGetAnaType( ) )               return( TRUE );

  // Set the initial conditions
  if( ! bSetInitC( (eInitCType) roSim.iGetSwpScale( ) ) )    bRtnValue = FALSE;

  // Set the sweep source
  if( ! PnlAnaBase::bSetSigSrc( roSim ) )                    bRtnValue = FALSE;

  // Load the source setup dialog
  if( ! m_oDlgSigSrcCfg.bSetSrcCmd( roSim.rosGetSigSrc() ) ) bRtnValue = FALSE;

  // Perform any base class load tasks
  if( ! PnlAnaBase::bLoad( roSim ) )                         bRtnValue = FALSE;

  return( bRtnValue );
}

//*****************************************************************************
// Save information to a simulation object.
// (Prior to it being passed to a simulator object.)
//
// Argument List:
//   roSim - The Simulation object
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PnlNgSpiceTR::bSave( Simulation & roSim )
{
  wxString  os1;

  // Execute base class save tasks
  PnlAnaBase::bSave( roSim );

  // Set the initial conditions
  if( ! roSim.bSetSwpScale( m_oRbxInitC.GetSelection( ) ) )
    SetErrMsg( wxT("Initial conditions couldn't be set.") );

  // Modify the component to be used as the sweep source
  os1 = roSim.rosGetSigSrc( );
  if( ! os1.IsEmpty( ) )
  {
    os1.Truncate( os1.Find( wxT(' '), TRUE ) + 1 );
    os1 << m_oDlgSigSrcCfg.rosGetSrcCmd( );
    roSim.bSetSigSrc( os1 );
  }

  return( bIsOk( ) );
}

//*****************************************************************************
//                                                                            *
//                             Event Handlers                                 *
//                                                                            *
//*****************************************************************************
// Generator component choice control event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event

void  PnlNgSpiceTR::OnChoSigSrcCpnt( wxCommandEvent & roEvtCmd )
{
  if( m_oChoSigSrcCpnt.GetSelection( ) > 0 ) m_oBtnSetup.Enable( );
  else                                       m_oBtnSetup.Disable( );
}

//*****************************************************************************
// Generator component setup button control event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event

void  PnlNgSpiceTR::OnBtnSetup( wxCommandEvent & roEvtCmd )
{
  m_oDlgSigSrcCfg.CenterOnParent( );
  m_oDlgSigSrcCfg.ShowModal( );
}

//*****************************************************************************
