//*****************************************************************************
//                              CmdNgSpiceAC.cpp                              *
//                             ------------------                             *
//  Started     : 11/10/2007                                                  *
//  Last Update : 16/10/2007                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/commands/CmdNgSpiceAC.hpp"

//*****************************************************************************
// Constructor.

CmdNgSpiceAC::CmdNgSpiceAC( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdNgSpiceAC::~CmdNgSpiceAC( )
{
}

//*****************************************************************************
// Parse the command string.
//
// Eg.s : .AC LIN 30 1.00K 300.00K
//        .AC DEC 30 1.00K 300.00K
//        .AC OCT 30 1.00K 300.00K
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceAC::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1;
  double             df1;
  long               li1;

  // Tokenize the command string
  ostk1.SetString( *this );
  if( ostk1.CountTokens( ) != 5 ) return( FALSE );

  // Clear object attributes but keep the command string
  bClear( );
  (wxString &) *this = ostk1.GetString( );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 3 ).Upper( );
  if( os1 != wxT(".AC") )         return( FALSE );
  m_osName = wxT("AC");

  m_bIsOk = TRUE;

  // Extract the sweep type: linear or log
  os1 = ostk1.GetNextToken( ).Upper( );
  if(      os1 == wxT("LIN") ) m_eScale = eSCALE_LIN;
  else if( os1 == wxT("DEC") ) m_eScale = eSCALE_DEC;
  else if( os1 == wxT("OCT") ) m_eScale = eSCALE_OCT;
  else m_bIsOk = FALSE;

  // Extract the step count
  os1 = ostk1.GetNextToken( );
  if( ! ConvertType::bStrToInt( os1, &li1 ) ) m_iStep  = (int) li1;
  else m_bIsOk = FALSE;

  // Extract the start frequency
  os1 = ostk1.GetNextToken( );
  if( ! ConvertType::bStrToFlt( os1, &df1 ) ) m_fStart = (float) df1;
  else m_bIsOk = FALSE;

  // Extract the stop frequency
  os1 = ostk1.GetNextToken( );
  if( ! ConvertType::bStrToFlt( os1, &df1 ) ) m_fStop  = (float) df1;
  else m_bIsOk = FALSE;

  return( m_bIsOk );
}

//*****************************************************************************
// Format the command string.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceAC::bFormat( void )
{
  wxString  os1, os2;

  m_bIsOk = FALSE;

  os1 = wxT(".DC");

  switch( m_eScale )
  {
    case eSCALE_LIN : os1 << wxT(" LIN"); break;
    case eSCALE_DEC : os1 << wxT(" DEC"); break;
    case eSCALE_OCT : os1 << wxT(" OCT"); break;
    default :                                              return( FALSE );
  }

  os1 << wxT(' ') << m_iStep;

  if( ! ConvertType::bFltToStr( (double) m_fStart, os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  if( ! ConvertType::bFltToStr( (double) m_fStop,  os2 ) ) return( FALSE );
  os1 << wxT(' ') << os2;

  m_bIsOk = TRUE;
  (wxString) *this = os1;

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceAC::bClear( void )
{
  bool  bRtnValue;

  bRtnValue = CmdBase::bClear( );

  m_fStart = -FLT_MAX;
  m_fStop  = -FLT_MAX;
  m_iStep  =  INT_MIN;

  m_eScale = eSCALE_NONE;

  return( bRtnValue );
}

//*****************************************************************************
