//*****************************************************************************
//                               PnlGnuCapOP.cpp                              *
//                              -----------------                             *
//  Started     : 06/11/2003                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2003 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "gnucap/panels/PnlGnuCapOP.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( PnlGnuCapOP, PnlAnaBase )

  EVT_RADIOBOX( ID_RBX_STEPSCALE,  PnlGnuCapOP::OnStepScale  )
  EVT_CHOICE  ( ID_CHO_SIGSRCCPNT, PnlGnuCapOP::OnSigSrcCpnt )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argunebt List:
//   poWin - A pointer to the parent window

PnlGnuCapOP::PnlGnuCapOP( wxWindow * poWin ) : PnlAnaBase( poWin )
{
  bSetSimrType( eSIMR_GNUCAP );
  bSetAnaType ( eANA_OP );

  Create( );

  bClear( );
}

//*****************************************************************************
// Destructor.

PnlGnuCapOP::~PnlGnuCapOP( )
{
}

//*****************************************************************************
// Create the display objects.

void  PnlGnuCapOP::Create( void )
{
  int  ix, iy;

  // Set the sweep parameter labels
  m_oSbxSwpPars.GetSize( &ix, &iy );
  m_oSbxSwpPars.SetSize(  ix, 167 );
  m_oSbxSwpPars.SetLabel( wxT(" Operating Point Sweep ") );
  m_oPnlStart  .bSetName( wxT("Start Temperature") );
  m_oPnlStop   .bSetName( wxT("Stop Temperature") );

  // Set sweep parameter units
  m_oPnlStart.bSetUnitsType( ChoUnits::eUNITS_TEMP );
  m_oPnlStop .bSetUnitsType( ChoUnits::eUNITS_TEMP );
  m_oPnlStep .bSetUnitsType( ChoUnits::eUNITS_TEMP );

  // Create and add the scale radio buttons
  wxString  osScale[ 3 ] = { wxT("Lin  "), wxT("Log "), wxT("Dec ") };
  m_oRbxStepScale.Create( this, ID_RBX_STEPSCALE, wxT(" Step Scale "),
                          wxPoint( 13, 123 ), wxDefaultSize, 3, osScale, 3 );
  bSetStepScale( eSCALE_LIN );

  CreateSigSrc( );  // Create input source controls
}

//*****************************************************************************
// Initialize the step scale.

void  PnlGnuCapOP::InitStepScale( void )
{
  switch( m_oRbxStepScale.GetSelection( ) )
  {
    case eSCALE_LIN :
      m_oPnlStep.bSetName( wxT("Step Increment") );
      m_oPnlStep.bSetVarType( SpinCtrl::eVAR_FLT );
      m_oPnlStep.bSetParms( 1.0, 0.0, 100.0, 1.0, 10.0 );
      m_oPnlStep.bShowUnits( TRUE );
      break;

    case eSCALE_LOG :
      m_oPnlStep.bSetName( wxT("Step Multiplier") );
      m_oPnlStep.bSetVarType( SpinCtrl::eVAR_FLT );
      m_oPnlStep.bSetParms( 1.01, 0.0, 100.0, 0.01, 0.1 );
      m_oPnlStep.bShowUnits( FALSE );
      break;

    case eSCALE_DEC :
      m_oPnlStep.bSetName( wxT("Steps / Decade") );
      m_oPnlStep.bSetVarType( SpinCtrl::eVAR_INT );
      m_oPnlStep.bSetParms( 10, 1, 1000, 1, 100 );
      m_oPnlStep.bShowUnits( FALSE );
      break;

    default :
      break;
  }
}

//*****************************************************************************
// Set the state of the step scale radio box.
//
// Argument List:
//   eScale - The enumerated scale specifier
//
// Return Values:
//   Success - TRUE
//   Failure - FALSE

bool  PnlGnuCapOP::bSetStepScale( eScaleType eScale )
{
  if( eScale<eSCALE_FST || eScale>eSCALE_LST )          return( FALSE );
#if wxCHECK_VERSION( 2,8,0 )
  if( m_oRbxStepScale.GetCount( ) < (uint) eScale + 1 ) return( FALSE );
#else
  if( m_oRbxStepScale.GetCount( ) < (int)  eScale + 1 ) return( FALSE );
#endif

  m_oRbxStepScale.SetSelection( (int) eScale );

  InitStepScale( );

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PnlGnuCapOP::bClear( void )
{
  bool  bRtnValue=TRUE;

  // Clear the base class
  if( ! PnlAnaBase::bClear( ) )       bRtnValue = FALSE;

  // Set the step scale type and default sweep values
  if( ! bSetStepScale( eSCALE_LIN ) ) bRtnValue = FALSE;
  m_oPnlStep.bSetValue( (float) 1.0 );

  return( bRtnValue );
}

//*****************************************************************************
// Load information from a Simulation object.
//
// Argument List:
//   roSim - The Simulation object
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PnlGnuCapOP::bLoad( Simulation & roSim )
{
  bool  bRtnValue=TRUE;

  // Load the components into the source choice box
  LoadSigSrcCpnts( roSim, wxT("VIRLC") );

  // Don't go any further if the analysis type doesn't match
  if( roSim.eGetAnaType( ) != eGetAnaType( ) ) return( bRtnValue );

  // Set the source component
  if( ! bSetSigSrc( roSim ) )                  bRtnValue = FALSE;

  // Set the sweep scale
  m_oRbxStepScale.SetSelection( roSim.iGetSwpScale( ) );

  // Set the parameters to derive
  m_oCbxVoltage.SetValue( roSim.bGetOutPar( ePAR_VLT ) );
  m_oCbxCurrent.SetValue( roSim.bGetOutPar( ePAR_CUR ) );
  m_oCbxPower  .SetValue( roSim.bGetOutPar( ePAR_PWR ) );
  m_oCbxResist .SetValue( roSim.bGetOutPar( ePAR_RES ) );

  // Perform any base class load tasks
  if( ! PnlAnaBase::bLoad( roSim ) )           bRtnValue = FALSE;

   return( bRtnValue );
}

//*****************************************************************************
// Save information to a Simulation object.
//
// Argument List:
//   roSim - The simulation object
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PnlGnuCapOP::bSave( Simulation & roSim )
{
  // Execute base class save tasks
  PnlAnaBase::bSave( roSim );

  // Set the sweep scale
  if( m_oRbxStepScale.GetSelection( ) == (int) eSCALE_LOG )
    if( m_oPnlStep.dfGetValue( ) == 1.0 )
      SetErrMsg( wxT("Step multiplier invalid, must be non-unity.") );
  if( ! roSim.bSetSwpScale( m_oRbxStepScale.GetSelection( ) ) )
    SetErrMsg( wxT("Sweep scale couldn't be set.") );

  return( bIsOk( ) );
}

//*****************************************************************************
//                                                                            *
//                             Event Handlers                                 *
//                                                                            *
//*****************************************************************************
// Step scale radio box event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event

void  PnlGnuCapOP::OnStepScale( wxCommandEvent & roEvtCmd )
{
  InitStepScale( );
}

//*****************************************************************************
// Source component choice box event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event

void  PnlGnuCapOP::OnSigSrcCpnt( wxCommandEvent & roEvtCmd )
{
  bSetSigSrcUnits( );

  if( m_oChoSigSrcCpnt.GetStringSelection( ) == wxT("None") )
    m_oPnlSigSrcLvl.bSetValue( (double) 0.0 );
  else if( m_oPnlSigSrcLvl.dfGetValue( ) == 0.0 )
    m_oPnlSigSrcLvl.bSetValue( (double) 1.0 );
}

//*****************************************************************************
