//*****************************************************************************
//                              CmdGnuCapOPT.hpp                              *
//                             ------------------                             *
//  Description : This class contains values associated with the GNU-CAP      *
//                OPTIONS command. It inherits from the class CmdBase.        *
//  Started     : 11/09/2006                                                  *
//  Last Update : 24/08/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGNUCAPOPT_HPP
#define CMDGNUCAPOPT_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and/or Constant Declarations

#define  GC_ABSTOL    (float) 1.0E-12
#define  GC_CHGTOL    (float) 1.0E-14
#define  GC_DEFAD     (float) 0.0
#define  GC_DEFAS     (float) 0.0
#define  GC_DEFL      (float) 100.0E-06
#define  GC_DEFW      (float) 100.0E-06
#define  GC_GMIN      (float) 1.0E-12
#define  GC_ITL1      (int)   100
#define  GC_ITL2      (int)   50
#define  GC_ITL4      (int)   10
#define  GC_METHOD    wxT("TRAP")
#define  GC_RELTOL    (float) 0.001
#define  GC_TNOM      (float) 27.0
#define  GC_TRTOL     (float) 7.0
#define  GC_VNTOL     (float) 1.0E-06

#define  GC_BYPASS    TRUE
#define  GC_CSTRAY    TRUE
#define  GC_DAMPMAX   (float) 1.0
#define  GC_DAMPMIN   (float) 0.5
#define  GC_DAMPST    (int)   0
#define  GC_DTMIN     (float) 1.0E-12
#define  GC_DTRATIO   (float) 1.0E+09
#define  GC_FLOOR     (float) 1.0E-21
#define  GC_HARMS     (int)   9
#define  GC_INCMODE   TRUE
#define  GC_ITL7      (int)   1
#define  GC_ITL8      (int)   100
#define  GC_LIMIT     (float) 1.0E+10
#define  GC_LUBYPASS  TRUE
#define  GC_MODE      wxT("MIXED")
#define  GC_NUMDGT    (int)   5
#define  GC_ORDER     wxT("AUTO")
#define  GC_RSTRAY    FALSE
#define  GC_SEED      (float) 1.0
#define  GC_SHORT     (float) 1.0E-07
#define  GC_TEMPAMB   (float) 27.0
#define  GC_TRACEL    TRUE
#define  GC_TRANSITS  (int)   2
#define  GC_TRREJECT  (float) 0.5
#define  GC_TRSTEPG   (float) 2.0
#define  GC_TRSTEPS   (float) 8.0
#define  GC_VBYPASS   FALSE
#define  GC_VFLOOR    (float) 1.0E-15
#define  GC_VMAX      (float)  30.0
#define  GC_VMIN      (float) -30.0
#define  GC_WCZERO    (float) 1.0E-09

//*****************************************************************************

class CmdGnuCapOPT : public CmdBase
{
  protected:

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

  public:

    // Options used by both NG-Spice and GNU-Cap
    float     m_fABSTOL;   // Absolute current error tolerance
    float     m_fCHGTOL;   // Charge tolerance
    float     m_fDEFAD;    // MOS drain diffusion area
    float     m_fDEFAS;    // MOS source diffusion area
    float     m_fDEFL;     // MOS channel length
    float     m_fDEFW;     // MOS channel width
    float     m_fGMIN;     // Minimum allowable conductance
    int       m_iITL1;     // DC iteration limit
    int       m_iITL2;     // DC transfer curve iteration limit
    int       m_iITL4;     // TR analysis timepoint iteration limit
    wxString  m_osMETHOD;  // Numerical integration method
    float     m_fRELTOL;   // Relative error tolerance
    float     m_fTNOM;     // Nominal temp. at which device parameters measured
    float     m_fTRTOL;    // TR error tolerance
    float     m_fVNTOL;    // Absolute voltage error tolerance

    // Options specific to GNU-Cap
    bool      m_bBYPASS;   // Bypass model evaluation if appropriate
    bool      m_bCSTRAY;   // Include capacitance in device models
    float     m_fDAMPMAX;  // Normal Newton damping factor (when all is well)
    float     m_fDAMPMIN;  // Newton damping factor when there's a problem
    int       m_iDAMPST;   // Damping strategy
    float     m_fDTMIN;    // Minimum time step
    float     m_fDTRATIO;  // The ratio between minimum and maximum time step
    float     m_fFLOOR;    // Effective zero value
    int       m_iHARMS;    // Harmonics in Fourier analysis
    bool      m_bINCMODE;  // Incrementally update the matrix
    int       m_iITL7;     // Worst case analysis iteration limit
    int       m_iITL8;     // Convergence diagnostic iteration threshold
    bool      m_bLUBYPASS; // Bypass parts of LU decomposition if appropriate
    float     m_fLIMIT;    // Internal differential branch voltage limit
    wxString  m_osMODE;    // Simulation mode selection
    int       m_iNUMDGT;   // No. of digits to print for analysis results
    wxString  m_osORDER;   // Equation ordering
    bool      m_bRSTRAY;   // Include series resistance in device models
    float     m_fSEED;     // Seed used by the random number generator
    float     m_fSHORT;    // Resistance of voltage source or short
    float     m_fTEMPAMB;  // Simulation temperature
    bool      m_bTRACEL;   // Use a queue to only load changed elements to the matrix
    int       m_iTRANSITS; // Mixed mode transition count
    float     m_fTRREJECT; // Transient error rejection threshold
    float     m_fTRSTEPG;  // Maximum internal step size growth in transient analysis
    float     m_fTRSTEPS;  // Amount to decrease the transient step size by when convergence fails
    bool      m_bVBYPASS;  // Check only voltage to bypass model evaluation
    float     m_fVFLOOR;   // Effective zero value for voltage probes
    float     m_fVMAX;     // Positive node voltage limit
    float     m_fVMIN;     // Negative node voltage limit
    float     m_fWCZERO;   // Worst case zero window

              CmdGnuCapOPT( void );
    virtual  ~CmdGnuCapOPT( );

    bool  bClear( void );
};

//*****************************************************************************

#endif // CMDGNUCAPOPT_HPP
