//*****************************************************************************
//                                NbkSimrBase.hpp                             *
//                               -----------------                            *
//  Description : Base class for all simulator notebooks which contains the   *
//                individual analysis panels.                                 *
//  Started     : 05/05/2004                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NBKSIMRBASE_HPP
#define NBKSIMRBASE_HPP

// System Includes

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/notebook.h>

// Application Includes

#include "TypeDefs.hpp"
#include "netlist/NetList.hpp"
#include "netlist/Simulation.hpp"
#include "base/PnlAnaBase.hpp"

// Local Constant Declarations


//*****************************************************************************

class NbkSimrBase : public wxNotebook
{
  private:

    eSimrType  m_eSimrType;

  protected:

    bool  bSetSimrType( eSimrType eType );

  public:

    NbkSimrBase( wxWindow * poParent, wxWindowID oWinID );
    NbkSimrBase( void );
   ~NbkSimrBase( );

    virtual  bool  bClear( void ) = 0;

    virtual  bool  bLoad( Simulation & roSim ) = 0;
    virtual  bool  bSave( Simulation & roSim ) = 0;

    virtual  bool  bSetPage( const wxChar * psType ) = 0;
    virtual  bool  bSetPage( eAnaType eType ) = 0;

    virtual  const  wxString & rosGetPage( void ) = 0;
    virtual         eAnaType     eGetPage( void ) = 0;

           eSimrType    eGetSimrType( void ) { return( m_eSimrType ); }
    const  wxString & rosGetErrMsg( void );
};

//*****************************************************************************

#endif // NBKSIMRBASE_HPP
