/* soapC.cpp
   Generated by gSOAP 2.8.11 from calculator.h

Copyright(C) 2000-2012, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.11 2012-11-20 03:48:27 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->version && soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->version && soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Detail)
		{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
			soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
		}
		return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
	}
	if (!soap->fault->detail)
	{	soap->fault->detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
	}
	return (const char**)&soap->fault->detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_xsd__duration:
		return soap_in_xsd__duration(soap, NULL, NULL, "xsd:duration");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType:
		return soap_in_wsrm__IncompleteSequenceBehaviorType(soap, NULL, NULL, "wsrm:IncompleteSequenceBehaviorType");
	case SOAP_TYPE_wsrm__FaultCodes:
		return soap_in_wsrm__FaultCodes(soap, NULL, NULL, "wsrm:FaultCodes");
	case SOAP_TYPE__wsa5__IsReferenceParameter:
		return soap_in__wsa5__IsReferenceParameter(soap, NULL, NULL, "wsa5:IsReferenceParameter");
	case SOAP_TYPE_wsa5__FaultCodesType:
		return soap_in_wsa5__FaultCodesType(soap, NULL, NULL, "wsa5:FaultCodesType");
	case SOAP_TYPE_wsa5__RelationshipType:
		return soap_in_wsa5__RelationshipType(soap, NULL, NULL, "wsa5:RelationshipType");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_wsrm__AcceptType:
		return soap_in_wsrm__AcceptType(soap, NULL, NULL, "wsrm:AcceptType");
	case SOAP_TYPE_wsrm__OfferType:
		return soap_in_wsrm__OfferType(soap, NULL, NULL, "wsrm:OfferType");
	case SOAP_TYPE_wsrm__TerminateSequenceResponseType:
		return soap_in_wsrm__TerminateSequenceResponseType(soap, NULL, NULL, "wsrm:TerminateSequenceResponseType");
	case SOAP_TYPE_wsrm__TerminateSequenceType:
		return soap_in_wsrm__TerminateSequenceType(soap, NULL, NULL, "wsrm:TerminateSequenceType");
	case SOAP_TYPE_wsrm__CloseSequenceResponseType:
		return soap_in_wsrm__CloseSequenceResponseType(soap, NULL, NULL, "wsrm:CloseSequenceResponseType");
	case SOAP_TYPE_wsrm__CloseSequenceType:
		return soap_in_wsrm__CloseSequenceType(soap, NULL, NULL, "wsrm:CloseSequenceType");
	case SOAP_TYPE_wsrm__CreateSequenceResponseType:
		return soap_in_wsrm__CreateSequenceResponseType(soap, NULL, NULL, "wsrm:CreateSequenceResponseType");
	case SOAP_TYPE_wsrm__CreateSequenceType:
		return soap_in_wsrm__CreateSequenceType(soap, NULL, NULL, "wsrm:CreateSequenceType");
	case SOAP_TYPE_wsrm__SequenceFaultType:
		return soap_in_wsrm__SequenceFaultType(soap, NULL, NULL, "wsrm:SequenceFaultType");
	case SOAP_TYPE_wsrm__AckRequestedType:
		return soap_in_wsrm__AckRequestedType(soap, NULL, NULL, "wsrm:AckRequestedType");
	case SOAP_TYPE_wsrm__SequenceType:
		return soap_in_wsrm__SequenceType(soap, NULL, NULL, "wsrm:SequenceType");
	case SOAP_TYPE_wsa5__ProblemActionType:
		return soap_in_wsa5__ProblemActionType(soap, NULL, NULL, "wsa5:ProblemActionType");
	case SOAP_TYPE_wsa5__RelatesToType:
		return soap_in_wsa5__RelatesToType(soap, NULL, NULL, "wsa5:RelatesToType");
	case SOAP_TYPE_wsa5__MetadataType:
		return soap_in_wsa5__MetadataType(soap, NULL, NULL, "wsa5:MetadataType");
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		return soap_in_wsa5__ReferenceParametersType(soap, NULL, NULL, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		return soap_in_wsa5__EndpointReferenceType(soap, NULL, NULL, "wsa5:EndpointReferenceType");
	case SOAP_TYPE_PointerTowsrm__TerminateSequenceResponseType:
		return soap_in_PointerTowsrm__TerminateSequenceResponseType(soap, NULL, NULL, "wsrm:TerminateSequenceResponseType");
	case SOAP_TYPE_PointerTowsrm__TerminateSequenceType:
		return soap_in_PointerTowsrm__TerminateSequenceType(soap, NULL, NULL, "wsrm:TerminateSequenceType");
	case SOAP_TYPE_PointerTowsrm__CloseSequenceResponseType:
		return soap_in_PointerTowsrm__CloseSequenceResponseType(soap, NULL, NULL, "wsrm:CloseSequenceResponseType");
	case SOAP_TYPE_PointerTowsrm__CloseSequenceType:
		return soap_in_PointerTowsrm__CloseSequenceType(soap, NULL, NULL, "wsrm:CloseSequenceType");
	case SOAP_TYPE_PointerTowsrm__CreateSequenceResponseType:
		return soap_in_PointerTowsrm__CreateSequenceResponseType(soap, NULL, NULL, "wsrm:CreateSequenceResponseType");
	case SOAP_TYPE_PointerTowsrm__CreateSequenceType:
		return soap_in_PointerTowsrm__CreateSequenceType(soap, NULL, NULL, "wsrm:CreateSequenceType");
	case SOAP_TYPE_PointerTowsrm__SequenceFaultType:
		return soap_in_PointerTowsrm__SequenceFaultType(soap, NULL, NULL, "wsrm:SequenceFaultType");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement:
		return soap_in_PointerTo_wsrm__SequenceAcknowledgement(soap, NULL, NULL, "wsrm:SequenceAcknowledgement");
	case SOAP_TYPE_PointerTowsrm__AckRequestedType:
		return soap_in_PointerTowsrm__AckRequestedType(soap, NULL, NULL, "wsrm:AckRequestedType");
	case SOAP_TYPE_PointerTowsrm__SequenceType:
		return soap_in_PointerTowsrm__SequenceType(soap, NULL, NULL, "wsrm:SequenceType");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_None:
		return soap_in_PointerTo_wsrm__SequenceAcknowledgement_None(soap, NULL, NULL, "wsrm:SequenceAcknowledgement-None");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange:
		return soap_in_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, NULL, NULL, "wsrm:SequenceAcknowledgement-AcknowledgementRange");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_Final:
		return soap_in_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, NULL, NULL, "wsrm:SequenceAcknowledgement-Final");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_in_PointerTounsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_PointerTowsrm__AcceptType:
		return soap_in_PointerTowsrm__AcceptType(soap, NULL, NULL, "wsrm:AcceptType");
	case SOAP_TYPE_PointerTowsrm__IncompleteSequenceBehaviorType:
		return soap_in_PointerTowsrm__IncompleteSequenceBehaviorType(soap, NULL, NULL, "wsrm:IncompleteSequenceBehaviorType");
	case SOAP_TYPE_PointerTowsrm__OfferType:
		return soap_in_PointerTowsrm__OfferType(soap, NULL, NULL, "wsrm:OfferType");
	case SOAP_TYPE_PointerToxsd__duration:
		return soap_in_PointerToxsd__duration(soap, NULL, NULL, "xsd:duration");
	case SOAP_TYPE_PointerTo_wsrm__UsesSequenceSSL:
		return soap_in_PointerTo_wsrm__UsesSequenceSSL(soap, NULL, NULL, "wsrm:UsesSequenceSSL");
	case SOAP_TYPE_PointerTo_wsa5__FaultTo:
		return soap_in_PointerTo_wsa5__FaultTo(soap, NULL, NULL, "wsa5:FaultTo");
	case SOAP_TYPE_PointerTo_wsa5__ReplyTo:
		return soap_in_PointerTo_wsa5__ReplyTo(soap, NULL, NULL, "wsa5:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa5__From:
		return soap_in_PointerTo_wsa5__From(soap, NULL, NULL, "wsa5:From");
	case SOAP_TYPE_PointerTo_wsa5__RelatesTo:
		return soap_in_PointerTo_wsa5__RelatesTo(soap, NULL, NULL, "wsa5:RelatesTo");
	case SOAP_TYPE__wsa5__ProblemHeaderQName:
	{	char **s;
		s = soap_in__wsa5__ProblemHeaderQName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTowsa5__MetadataType:
		return soap_in_PointerTowsa5__MetadataType(soap, NULL, NULL, "wsa5:MetadataType");
	case SOAP_TYPE_PointerTowsa5__ReferenceParametersType:
		return soap_in_PointerTowsa5__ReferenceParametersType(soap, NULL, NULL, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__FaultCodesOpenEnumType:
	{	char **s;
		s = soap_in_wsa5__FaultCodesOpenEnumType(soap, NULL, NULL, "wsa5:FaultCodesOpenEnumType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wsa5__RelationshipTypeOpenEnum:
	{	char **s;
		s = soap_in_wsa5__RelationshipTypeOpenEnum(soap, NULL, NULL, "wsa5:RelationshipTypeOpenEnum");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTo_mssadh__Equation:
		return soap_in_PointerTo_mssadh__Equation(soap, NULL, NULL, "mssadh:Equation");
	case SOAP_TYPE_PointerTo_mssadh__Result:
		return soap_in_PointerTo_mssadh__Result(soap, NULL, NULL, "mssadh:Result");
	case SOAP_TYPE_PointerTo_mssadh__DivideBy:
		return soap_in_PointerTo_mssadh__DivideBy(soap, NULL, NULL, "mssadh:DivideBy");
	case SOAP_TYPE_PointerTo_mssadh__MultiplyBy:
		return soap_in_PointerTo_mssadh__MultiplyBy(soap, NULL, NULL, "mssadh:MultiplyBy");
	case SOAP_TYPE_PointerTo_mssadh__SubtractFrom:
		return soap_in_PointerTo_mssadh__SubtractFrom(soap, NULL, NULL, "mssadh:SubtractFrom");
	case SOAP_TYPE_PointerTo_mssadh__AddTo:
		return soap_in_PointerTo_mssadh__AddTo(soap, NULL, NULL, "mssadh:AddTo");
	case SOAP_TYPE_PointerTo_mssadh__Clear:
		return soap_in_PointerTo_mssadh__Clear(soap, NULL, NULL, "mssadh:Clear");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTodouble:
		return soap_in_PointerTodouble(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:duration"))
		{	*type = SOAP_TYPE_xsd__duration;
			return soap_in_xsd__duration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:IncompleteSequenceBehaviorType"))
		{	*type = SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType;
			return soap_in_wsrm__IncompleteSequenceBehaviorType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:FaultCodes"))
		{	*type = SOAP_TYPE_wsrm__FaultCodes;
			return soap_in_wsrm__FaultCodes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:IsReferenceParameter"))
		{	*type = SOAP_TYPE__wsa5__IsReferenceParameter;
			return soap_in__wsa5__IsReferenceParameter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:FaultCodesType"))
		{	*type = SOAP_TYPE_wsa5__FaultCodesType;
			return soap_in_wsa5__FaultCodesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:RelationshipType"))
		{	*type = SOAP_TYPE_wsa5__RelationshipType;
			return soap_in_wsa5__RelationshipType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:AcceptType"))
		{	*type = SOAP_TYPE_wsrm__AcceptType;
			return soap_in_wsrm__AcceptType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:OfferType"))
		{	*type = SOAP_TYPE_wsrm__OfferType;
			return soap_in_wsrm__OfferType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:TerminateSequenceResponseType"))
		{	*type = SOAP_TYPE_wsrm__TerminateSequenceResponseType;
			return soap_in_wsrm__TerminateSequenceResponseType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:TerminateSequenceType"))
		{	*type = SOAP_TYPE_wsrm__TerminateSequenceType;
			return soap_in_wsrm__TerminateSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:CloseSequenceResponseType"))
		{	*type = SOAP_TYPE_wsrm__CloseSequenceResponseType;
			return soap_in_wsrm__CloseSequenceResponseType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:CloseSequenceType"))
		{	*type = SOAP_TYPE_wsrm__CloseSequenceType;
			return soap_in_wsrm__CloseSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:CreateSequenceResponseType"))
		{	*type = SOAP_TYPE_wsrm__CreateSequenceResponseType;
			return soap_in_wsrm__CreateSequenceResponseType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:CreateSequenceType"))
		{	*type = SOAP_TYPE_wsrm__CreateSequenceType;
			return soap_in_wsrm__CreateSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:SequenceFaultType"))
		{	*type = SOAP_TYPE_wsrm__SequenceFaultType;
			return soap_in_wsrm__SequenceFaultType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:AckRequestedType"))
		{	*type = SOAP_TYPE_wsrm__AckRequestedType;
			return soap_in_wsrm__AckRequestedType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:SequenceType"))
		{	*type = SOAP_TYPE_wsrm__SequenceType;
			return soap_in_wsrm__SequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ProblemActionType"))
		{	*type = SOAP_TYPE_wsa5__ProblemActionType;
			return soap_in_wsa5__ProblemActionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:RelatesToType"))
		{	*type = SOAP_TYPE_wsa5__RelatesToType;
			return soap_in_wsa5__RelatesToType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:MetadataType"))
		{	*type = SOAP_TYPE_wsa5__MetadataType;
			return soap_in_wsa5__MetadataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsa5__ReferenceParametersType;
			return soap_in_wsa5__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsa5__EndpointReferenceType;
			return soap_in_wsa5__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__ProblemHeaderQName;
			s = soap_in__wsa5__ProblemHeaderQName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:FaultCodesOpenEnumType"))
		{	char **s;
			*type = SOAP_TYPE_wsa5__FaultCodesOpenEnumType;
			s = soap_in_wsa5__FaultCodesOpenEnumType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:RelationshipTypeOpenEnum"))
		{	char **s;
			*type = SOAP_TYPE_wsa5__RelationshipTypeOpenEnum;
			s = soap_in_wsa5__RelationshipTypeOpenEnum(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "wsa5:RetryAfter"))
		{	*type = SOAP_TYPE__wsa5__RetryAfter;
			return soap_in__wsa5__RetryAfter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:Equation"))
		{	*type = SOAP_TYPE__mssadh__Equation;
			return soap_in__mssadh__Equation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:Result"))
		{	*type = SOAP_TYPE__mssadh__Result;
			return soap_in__mssadh__Result(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:DivideBy"))
		{	*type = SOAP_TYPE__mssadh__DivideBy;
			return soap_in__mssadh__DivideBy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:MultiplyBy"))
		{	*type = SOAP_TYPE__mssadh__MultiplyBy;
			return soap_in__mssadh__MultiplyBy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:SubtractFrom"))
		{	*type = SOAP_TYPE__mssadh__SubtractFrom;
			return soap_in__mssadh__SubtractFrom(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:AddTo"))
		{	*type = SOAP_TYPE__mssadh__AddTo;
			return soap_in__mssadh__AddTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssadh:Clear"))
		{	*type = SOAP_TYPE__mssadh__Clear;
			return soap_in__mssadh__Clear(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:SequenceAcknowledgement-None"))
		{	*type = SOAP_TYPE__wsrm__SequenceAcknowledgement_None;
			return soap_in__wsrm__SequenceAcknowledgement_None(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:SequenceAcknowledgement-AcknowledgementRange"))
		{	*type = SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange;
			return soap_in__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:SequenceAcknowledgement-Final"))
		{	*type = SOAP_TYPE__wsrm__SequenceAcknowledgement_Final;
			return soap_in__wsrm__SequenceAcknowledgement_Final(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:UsesSequenceSSL"))
		{	*type = SOAP_TYPE__wsrm__UsesSequenceSSL;
			return soap_in__wsrm__UsesSequenceSSL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:UsesSequenceSTR"))
		{	*type = SOAP_TYPE__wsrm__UsesSequenceSTR;
			return soap_in__wsrm__UsesSequenceSTR(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:SequenceAcknowledgement"))
		{	*type = SOAP_TYPE__wsrm__SequenceAcknowledgement;
			return soap_in__wsrm__SequenceAcknowledgement(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ProblemAction"))
		{	*type = SOAP_TYPE__wsa5__ProblemAction;
			return soap_in__wsa5__ProblemAction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:FaultTo"))
		{	*type = SOAP_TYPE__wsa5__FaultTo;
			return soap_in__wsa5__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:From"))
		{	*type = SOAP_TYPE__wsa5__From;
			return soap_in__wsa5__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ReplyTo"))
		{	*type = SOAP_TYPE__wsa5__ReplyTo;
			return soap_in__wsa5__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:RelatesTo"))
		{	*type = SOAP_TYPE__wsa5__RelatesTo;
			return soap_in__wsa5__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:Metadata"))
		{	*type = SOAP_TYPE__wsa5__Metadata;
			return soap_in__wsa5__Metadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ReferenceParameters"))
		{	*type = SOAP_TYPE__wsa5__ReferenceParameters;
			return soap_in__wsa5__ReferenceParameters(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:EndpointReference"))
		{	*type = SOAP_TYPE__wsa5__EndpointReference;
			return soap_in__wsa5__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrm:Identifier"))
		{	char **s;
			*type = SOAP_TYPE__wsrm__Identifier;
			s = soap_in__wsrm__Identifier(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:ProblemIRI"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__ProblemIRI;
			s = soap_in__wsa5__ProblemIRI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:Action"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__Action;
			s = soap_in__wsa5__Action(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:To"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__To;
			s = soap_in__wsa5__To(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:MessageID"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__MessageID;
			s = soap_in__wsa5__MessageID(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_xsd__duration:
		return soap_out_xsd__duration(soap, tag, id, (const LONG64 *)ptr, "xsd:duration");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE__wsa5__RetryAfter:
		return soap_out__wsa5__RetryAfter(soap, "wsa5:RetryAfter", id, (const ULONG64 *)ptr, NULL);
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType:
		return soap_out_wsrm__IncompleteSequenceBehaviorType(soap, tag, id, (const enum wsrm__IncompleteSequenceBehaviorType *)ptr, "wsrm:IncompleteSequenceBehaviorType");
	case SOAP_TYPE_wsrm__FaultCodes:
		return soap_out_wsrm__FaultCodes(soap, tag, id, (const enum wsrm__FaultCodes *)ptr, "wsrm:FaultCodes");
	case SOAP_TYPE__wsa5__IsReferenceParameter:
		return soap_out__wsa5__IsReferenceParameter(soap, tag, id, (const enum _wsa5__IsReferenceParameter *)ptr, "wsa5:IsReferenceParameter");
	case SOAP_TYPE_wsa5__FaultCodesType:
		return soap_out_wsa5__FaultCodesType(soap, tag, id, (const enum wsa5__FaultCodesType *)ptr, "wsa5:FaultCodesType");
	case SOAP_TYPE_wsa5__RelationshipType:
		return soap_out_wsa5__RelationshipType(soap, tag, id, (const enum wsa5__RelationshipType *)ptr, "wsa5:RelationshipType");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE__mssadh__Equation:
		return ((_mssadh__Equation *)ptr)->soap_out(soap, "mssadh:Equation", id, NULL);
	case SOAP_TYPE__mssadh__Result:
		return ((_mssadh__Result *)ptr)->soap_out(soap, "mssadh:Result", id, NULL);
	case SOAP_TYPE__mssadh__DivideBy:
		return ((_mssadh__DivideBy *)ptr)->soap_out(soap, "mssadh:DivideBy", id, NULL);
	case SOAP_TYPE__mssadh__MultiplyBy:
		return ((_mssadh__MultiplyBy *)ptr)->soap_out(soap, "mssadh:MultiplyBy", id, NULL);
	case SOAP_TYPE__mssadh__SubtractFrom:
		return ((_mssadh__SubtractFrom *)ptr)->soap_out(soap, "mssadh:SubtractFrom", id, NULL);
	case SOAP_TYPE__mssadh__AddTo:
		return ((_mssadh__AddTo *)ptr)->soap_out(soap, "mssadh:AddTo", id, NULL);
	case SOAP_TYPE__mssadh__Clear:
		return ((_mssadh__Clear *)ptr)->soap_out(soap, "mssadh:Clear", id, NULL);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_None:
		return soap_out__wsrm__SequenceAcknowledgement_None(soap, "wsrm:SequenceAcknowledgement-None", id, (const struct _wsrm__SequenceAcknowledgement_None *)ptr, NULL);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange:
		return soap_out__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, "wsrm:SequenceAcknowledgement-AcknowledgementRange", id, (const struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *)ptr, NULL);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_Final:
		return soap_out__wsrm__SequenceAcknowledgement_Final(soap, "wsrm:SequenceAcknowledgement-Final", id, (const struct _wsrm__SequenceAcknowledgement_Final *)ptr, NULL);
	case SOAP_TYPE__wsrm__UsesSequenceSSL:
		return soap_out__wsrm__UsesSequenceSSL(soap, "wsrm:UsesSequenceSSL", id, (const struct _wsrm__UsesSequenceSSL *)ptr, NULL);
	case SOAP_TYPE__wsrm__UsesSequenceSTR:
		return soap_out__wsrm__UsesSequenceSTR(soap, "wsrm:UsesSequenceSTR", id, (const struct _wsrm__UsesSequenceSTR *)ptr, NULL);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement:
		return soap_out__wsrm__SequenceAcknowledgement(soap, "wsrm:SequenceAcknowledgement", id, (const struct _wsrm__SequenceAcknowledgement *)ptr, NULL);
	case SOAP_TYPE_wsrm__AcceptType:
		return soap_out_wsrm__AcceptType(soap, tag, id, (const struct wsrm__AcceptType *)ptr, "wsrm:AcceptType");
	case SOAP_TYPE_wsrm__OfferType:
		return soap_out_wsrm__OfferType(soap, tag, id, (const struct wsrm__OfferType *)ptr, "wsrm:OfferType");
	case SOAP_TYPE_wsrm__TerminateSequenceResponseType:
		return soap_out_wsrm__TerminateSequenceResponseType(soap, tag, id, (const struct wsrm__TerminateSequenceResponseType *)ptr, "wsrm:TerminateSequenceResponseType");
	case SOAP_TYPE_wsrm__TerminateSequenceType:
		return soap_out_wsrm__TerminateSequenceType(soap, tag, id, (const struct wsrm__TerminateSequenceType *)ptr, "wsrm:TerminateSequenceType");
	case SOAP_TYPE_wsrm__CloseSequenceResponseType:
		return soap_out_wsrm__CloseSequenceResponseType(soap, tag, id, (const struct wsrm__CloseSequenceResponseType *)ptr, "wsrm:CloseSequenceResponseType");
	case SOAP_TYPE_wsrm__CloseSequenceType:
		return soap_out_wsrm__CloseSequenceType(soap, tag, id, (const struct wsrm__CloseSequenceType *)ptr, "wsrm:CloseSequenceType");
	case SOAP_TYPE_wsrm__CreateSequenceResponseType:
		return soap_out_wsrm__CreateSequenceResponseType(soap, tag, id, (const struct wsrm__CreateSequenceResponseType *)ptr, "wsrm:CreateSequenceResponseType");
	case SOAP_TYPE_wsrm__CreateSequenceType:
		return soap_out_wsrm__CreateSequenceType(soap, tag, id, (const struct wsrm__CreateSequenceType *)ptr, "wsrm:CreateSequenceType");
	case SOAP_TYPE_wsrm__SequenceFaultType:
		return soap_out_wsrm__SequenceFaultType(soap, tag, id, (const struct wsrm__SequenceFaultType *)ptr, "wsrm:SequenceFaultType");
	case SOAP_TYPE_wsrm__AckRequestedType:
		return soap_out_wsrm__AckRequestedType(soap, tag, id, (const struct wsrm__AckRequestedType *)ptr, "wsrm:AckRequestedType");
	case SOAP_TYPE_wsrm__SequenceType:
		return soap_out_wsrm__SequenceType(soap, tag, id, (const struct wsrm__SequenceType *)ptr, "wsrm:SequenceType");
	case SOAP_TYPE__wsa5__ProblemAction:
		return soap_out__wsa5__ProblemAction(soap, "wsa5:ProblemAction", id, (const struct wsa5__ProblemActionType *)ptr, NULL);
	case SOAP_TYPE__wsa5__FaultTo:
		return soap_out__wsa5__FaultTo(soap, "wsa5:FaultTo", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa5__From:
		return soap_out__wsa5__From(soap, "wsa5:From", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa5__ReplyTo:
		return soap_out__wsa5__ReplyTo(soap, "wsa5:ReplyTo", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa5__RelatesTo:
		return soap_out__wsa5__RelatesTo(soap, "wsa5:RelatesTo", id, (const struct wsa5__RelatesToType *)ptr, NULL);
	case SOAP_TYPE__wsa5__Metadata:
		return soap_out__wsa5__Metadata(soap, "wsa5:Metadata", id, (const struct wsa5__MetadataType *)ptr, NULL);
	case SOAP_TYPE__wsa5__ReferenceParameters:
		return soap_out__wsa5__ReferenceParameters(soap, "wsa5:ReferenceParameters", id, (const struct wsa5__ReferenceParametersType *)ptr, NULL);
	case SOAP_TYPE__wsa5__EndpointReference:
		return soap_out__wsa5__EndpointReference(soap, "wsa5:EndpointReference", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE_wsa5__ProblemActionType:
		return soap_out_wsa5__ProblemActionType(soap, tag, id, (const struct wsa5__ProblemActionType *)ptr, "wsa5:ProblemActionType");
	case SOAP_TYPE_wsa5__RelatesToType:
		return soap_out_wsa5__RelatesToType(soap, tag, id, (const struct wsa5__RelatesToType *)ptr, "wsa5:RelatesToType");
	case SOAP_TYPE_wsa5__MetadataType:
		return soap_out_wsa5__MetadataType(soap, tag, id, (const struct wsa5__MetadataType *)ptr, "wsa5:MetadataType");
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		return soap_out_wsa5__ReferenceParametersType(soap, tag, id, (const struct wsa5__ReferenceParametersType *)ptr, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		return soap_out_wsa5__EndpointReferenceType(soap, tag, id, (const struct wsa5__EndpointReferenceType *)ptr, "wsa5:EndpointReferenceType");
	case SOAP_TYPE_PointerTowsrm__TerminateSequenceResponseType:
		return soap_out_PointerTowsrm__TerminateSequenceResponseType(soap, tag, id, (struct wsrm__TerminateSequenceResponseType *const*)ptr, "wsrm:TerminateSequenceResponseType");
	case SOAP_TYPE_PointerTowsrm__TerminateSequenceType:
		return soap_out_PointerTowsrm__TerminateSequenceType(soap, tag, id, (struct wsrm__TerminateSequenceType *const*)ptr, "wsrm:TerminateSequenceType");
	case SOAP_TYPE_PointerTowsrm__CloseSequenceResponseType:
		return soap_out_PointerTowsrm__CloseSequenceResponseType(soap, tag, id, (struct wsrm__CloseSequenceResponseType *const*)ptr, "wsrm:CloseSequenceResponseType");
	case SOAP_TYPE_PointerTowsrm__CloseSequenceType:
		return soap_out_PointerTowsrm__CloseSequenceType(soap, tag, id, (struct wsrm__CloseSequenceType *const*)ptr, "wsrm:CloseSequenceType");
	case SOAP_TYPE_PointerTowsrm__CreateSequenceResponseType:
		return soap_out_PointerTowsrm__CreateSequenceResponseType(soap, tag, id, (struct wsrm__CreateSequenceResponseType *const*)ptr, "wsrm:CreateSequenceResponseType");
	case SOAP_TYPE_PointerTowsrm__CreateSequenceType:
		return soap_out_PointerTowsrm__CreateSequenceType(soap, tag, id, (struct wsrm__CreateSequenceType *const*)ptr, "wsrm:CreateSequenceType");
	case SOAP_TYPE_PointerTowsrm__SequenceFaultType:
		return soap_out_PointerTowsrm__SequenceFaultType(soap, tag, id, (struct wsrm__SequenceFaultType *const*)ptr, "wsrm:SequenceFaultType");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement:
		return soap_out_PointerTo_wsrm__SequenceAcknowledgement(soap, tag, id, (struct _wsrm__SequenceAcknowledgement *const*)ptr, "wsrm:SequenceAcknowledgement");
	case SOAP_TYPE_PointerTowsrm__AckRequestedType:
		return soap_out_PointerTowsrm__AckRequestedType(soap, tag, id, (struct wsrm__AckRequestedType *const*)ptr, "wsrm:AckRequestedType");
	case SOAP_TYPE_PointerTowsrm__SequenceType:
		return soap_out_PointerTowsrm__SequenceType(soap, tag, id, (struct wsrm__SequenceType *const*)ptr, "wsrm:SequenceType");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_None:
		return soap_out_PointerTo_wsrm__SequenceAcknowledgement_None(soap, tag, id, (struct _wsrm__SequenceAcknowledgement_None *const*)ptr, "wsrm:SequenceAcknowledgement-None");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange:
		return soap_out_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag, id, (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *const*)ptr, "wsrm:SequenceAcknowledgement-AcknowledgementRange");
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_Final:
		return soap_out_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, tag, id, (struct _wsrm__SequenceAcknowledgement_Final *const*)ptr, "wsrm:SequenceAcknowledgement-Final");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_out_PointerTounsignedLONG64(soap, tag, id, (ULONG64 *const*)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_PointerTowsrm__AcceptType:
		return soap_out_PointerTowsrm__AcceptType(soap, tag, id, (struct wsrm__AcceptType *const*)ptr, "wsrm:AcceptType");
	case SOAP_TYPE_PointerTowsrm__IncompleteSequenceBehaviorType:
		return soap_out_PointerTowsrm__IncompleteSequenceBehaviorType(soap, tag, id, (enum wsrm__IncompleteSequenceBehaviorType *const*)ptr, "wsrm:IncompleteSequenceBehaviorType");
	case SOAP_TYPE_PointerTowsrm__OfferType:
		return soap_out_PointerTowsrm__OfferType(soap, tag, id, (struct wsrm__OfferType *const*)ptr, "wsrm:OfferType");
	case SOAP_TYPE_PointerToxsd__duration:
		return soap_out_PointerToxsd__duration(soap, tag, id, (LONG64 *const*)ptr, "xsd:duration");
	case SOAP_TYPE_PointerTo_wsrm__UsesSequenceSSL:
		return soap_out_PointerTo_wsrm__UsesSequenceSSL(soap, tag, id, (struct _wsrm__UsesSequenceSSL *const*)ptr, "wsrm:UsesSequenceSSL");
	case SOAP_TYPE__wsrm__Identifier:
		return soap_out_string(soap, "wsrm:Identifier", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_PointerTo_wsa5__FaultTo:
		return soap_out_PointerTo_wsa5__FaultTo(soap, tag, id, (struct wsa5__EndpointReferenceType *const*)ptr, "wsa5:FaultTo");
	case SOAP_TYPE_PointerTo_wsa5__ReplyTo:
		return soap_out_PointerTo_wsa5__ReplyTo(soap, tag, id, (struct wsa5__EndpointReferenceType *const*)ptr, "wsa5:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa5__From:
		return soap_out_PointerTo_wsa5__From(soap, tag, id, (struct wsa5__EndpointReferenceType *const*)ptr, "wsa5:From");
	case SOAP_TYPE_PointerTo_wsa5__RelatesTo:
		return soap_out_PointerTo_wsa5__RelatesTo(soap, tag, id, (struct wsa5__RelatesToType *const*)ptr, "wsa5:RelatesTo");
	case SOAP_TYPE__wsa5__ProblemIRI:
		return soap_out_string(soap, "wsa5:ProblemIRI", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsa5__ProblemHeaderQName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE__wsa5__Action:
		return soap_out_string(soap, "wsa5:Action", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsa5__To:
		return soap_out_string(soap, "wsa5:To", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsa5__MessageID:
		return soap_out_string(soap, "wsa5:MessageID", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_PointerTowsa5__MetadataType:
		return soap_out_PointerTowsa5__MetadataType(soap, tag, id, (struct wsa5__MetadataType *const*)ptr, "wsa5:MetadataType");
	case SOAP_TYPE_PointerTowsa5__ReferenceParametersType:
		return soap_out_PointerTowsa5__ReferenceParametersType(soap, tag, id, (struct wsa5__ReferenceParametersType *const*)ptr, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__FaultCodesOpenEnumType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsa5:FaultCodesOpenEnumType");
	case SOAP_TYPE_wsa5__RelationshipTypeOpenEnum:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsa5:RelationshipTypeOpenEnum");
	case SOAP_TYPE_PointerTo_mssadh__Equation:
		return soap_out_PointerTo_mssadh__Equation(soap, tag, id, (_mssadh__Equation *const*)ptr, "mssadh:Equation");
	case SOAP_TYPE_PointerTo_mssadh__Result:
		return soap_out_PointerTo_mssadh__Result(soap, tag, id, (_mssadh__Result *const*)ptr, "mssadh:Result");
	case SOAP_TYPE_PointerTo_mssadh__DivideBy:
		return soap_out_PointerTo_mssadh__DivideBy(soap, tag, id, (_mssadh__DivideBy *const*)ptr, "mssadh:DivideBy");
	case SOAP_TYPE_PointerTo_mssadh__MultiplyBy:
		return soap_out_PointerTo_mssadh__MultiplyBy(soap, tag, id, (_mssadh__MultiplyBy *const*)ptr, "mssadh:MultiplyBy");
	case SOAP_TYPE_PointerTo_mssadh__SubtractFrom:
		return soap_out_PointerTo_mssadh__SubtractFrom(soap, tag, id, (_mssadh__SubtractFrom *const*)ptr, "mssadh:SubtractFrom");
	case SOAP_TYPE_PointerTo_mssadh__AddTo:
		return soap_out_PointerTo_mssadh__AddTo(soap, tag, id, (_mssadh__AddTo *const*)ptr, "mssadh:AddTo");
	case SOAP_TYPE_PointerTo_mssadh__Clear:
		return soap_out_PointerTo_mssadh__Clear(soap, tag, id, (_mssadh__Clear *const*)ptr, "mssadh:Clear");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTodouble:
		return soap_out_PointerTodouble(soap, tag, id, (double *const*)ptr, "xsd:double");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE__mssadh__Equation:
		((_mssadh__Equation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssadh__Result:
		((_mssadh__Result *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssadh__DivideBy:
		((_mssadh__DivideBy *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssadh__MultiplyBy:
		((_mssadh__MultiplyBy *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssadh__SubtractFrom:
		((_mssadh__SubtractFrom *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssadh__AddTo:
		((_mssadh__AddTo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssadh__Clear:
		((_mssadh__Clear *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___wsrm__LastMessage:
		soap_serialize___wsrm__LastMessage(soap, (const struct __wsrm__LastMessage *)ptr);
		break;
	case SOAP_TYPE___wsrm__AckRequested:
		soap_serialize___wsrm__AckRequested(soap, (const struct __wsrm__AckRequested *)ptr);
		break;
	case SOAP_TYPE___wsrm__SequenceAcknowledgement:
		soap_serialize___wsrm__SequenceAcknowledgement(soap, (const struct __wsrm__SequenceAcknowledgement *)ptr);
		break;
	case SOAP_TYPE___wsrm__TerminateSequenceResponse:
		soap_serialize___wsrm__TerminateSequenceResponse(soap, (const struct __wsrm__TerminateSequenceResponse *)ptr);
		break;
	case SOAP_TYPE___wsrm__CloseSequenceResponse:
		soap_serialize___wsrm__CloseSequenceResponse(soap, (const struct __wsrm__CloseSequenceResponse *)ptr);
		break;
	case SOAP_TYPE___wsrm__CreateSequenceResponse:
		soap_serialize___wsrm__CreateSequenceResponse(soap, (const struct __wsrm__CreateSequenceResponse *)ptr);
		break;
	case SOAP_TYPE___wsrm__TerminateSequence:
		soap_serialize___wsrm__TerminateSequence(soap, (const struct __wsrm__TerminateSequence *)ptr);
		break;
	case SOAP_TYPE___wsrm__CloseSequence:
		soap_serialize___wsrm__CloseSequence(soap, (const struct __wsrm__CloseSequence *)ptr);
		break;
	case SOAP_TYPE___wsrm__CreateSequence:
		soap_serialize___wsrm__CreateSequence(soap, (const struct __wsrm__CreateSequence *)ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_None:
		soap_serialize__wsrm__SequenceAcknowledgement_None(soap, (const struct _wsrm__SequenceAcknowledgement_None *)ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange:
		soap_serialize__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, (const struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *)ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_Final:
		soap_serialize__wsrm__SequenceAcknowledgement_Final(soap, (const struct _wsrm__SequenceAcknowledgement_Final *)ptr);
		break;
	case SOAP_TYPE__wsrm__UsesSequenceSSL:
		soap_serialize__wsrm__UsesSequenceSSL(soap, (const struct _wsrm__UsesSequenceSSL *)ptr);
		break;
	case SOAP_TYPE__wsrm__UsesSequenceSTR:
		soap_serialize__wsrm__UsesSequenceSTR(soap, (const struct _wsrm__UsesSequenceSTR *)ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement:
		soap_serialize__wsrm__SequenceAcknowledgement(soap, (const struct _wsrm__SequenceAcknowledgement *)ptr);
		break;
	case SOAP_TYPE_wsrm__AcceptType:
		soap_serialize_wsrm__AcceptType(soap, (const struct wsrm__AcceptType *)ptr);
		break;
	case SOAP_TYPE_wsrm__OfferType:
		soap_serialize_wsrm__OfferType(soap, (const struct wsrm__OfferType *)ptr);
		break;
	case SOAP_TYPE_wsrm__TerminateSequenceResponseType:
		soap_serialize_wsrm__TerminateSequenceResponseType(soap, (const struct wsrm__TerminateSequenceResponseType *)ptr);
		break;
	case SOAP_TYPE_wsrm__TerminateSequenceType:
		soap_serialize_wsrm__TerminateSequenceType(soap, (const struct wsrm__TerminateSequenceType *)ptr);
		break;
	case SOAP_TYPE_wsrm__CloseSequenceResponseType:
		soap_serialize_wsrm__CloseSequenceResponseType(soap, (const struct wsrm__CloseSequenceResponseType *)ptr);
		break;
	case SOAP_TYPE_wsrm__CloseSequenceType:
		soap_serialize_wsrm__CloseSequenceType(soap, (const struct wsrm__CloseSequenceType *)ptr);
		break;
	case SOAP_TYPE_wsrm__CreateSequenceResponseType:
		soap_serialize_wsrm__CreateSequenceResponseType(soap, (const struct wsrm__CreateSequenceResponseType *)ptr);
		break;
	case SOAP_TYPE_wsrm__CreateSequenceType:
		soap_serialize_wsrm__CreateSequenceType(soap, (const struct wsrm__CreateSequenceType *)ptr);
		break;
	case SOAP_TYPE_wsrm__SequenceFaultType:
		soap_serialize_wsrm__SequenceFaultType(soap, (const struct wsrm__SequenceFaultType *)ptr);
		break;
	case SOAP_TYPE_wsrm__AckRequestedType:
		soap_serialize_wsrm__AckRequestedType(soap, (const struct wsrm__AckRequestedType *)ptr);
		break;
	case SOAP_TYPE_wsrm__SequenceType:
		soap_serialize_wsrm__SequenceType(soap, (const struct wsrm__SequenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemAction:
		soap_serialize__wsa5__ProblemAction(soap, (const struct wsa5__ProblemActionType *)ptr);
		break;
	case SOAP_TYPE__wsa5__FaultTo:
		soap_serialize__wsa5__FaultTo(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__From:
		soap_serialize__wsa5__From(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__ReplyTo:
		soap_serialize__wsa5__ReplyTo(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__RelatesTo:
		soap_serialize__wsa5__RelatesTo(soap, (const struct wsa5__RelatesToType *)ptr);
		break;
	case SOAP_TYPE__wsa5__Metadata:
		soap_serialize__wsa5__Metadata(soap, (const struct wsa5__MetadataType *)ptr);
		break;
	case SOAP_TYPE__wsa5__ReferenceParameters:
		soap_serialize__wsa5__ReferenceParameters(soap, (const struct wsa5__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE__wsa5__EndpointReference:
		soap_serialize__wsa5__EndpointReference(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_wsa5__ProblemActionType:
		soap_serialize_wsa5__ProblemActionType(soap, (const struct wsa5__ProblemActionType *)ptr);
		break;
	case SOAP_TYPE_wsa5__RelatesToType:
		soap_serialize_wsa5__RelatesToType(soap, (const struct wsa5__RelatesToType *)ptr);
		break;
	case SOAP_TYPE_wsa5__MetadataType:
		soap_serialize_wsa5__MetadataType(soap, (const struct wsa5__MetadataType *)ptr);
		break;
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		soap_serialize_wsa5__ReferenceParametersType(soap, (const struct wsa5__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		soap_serialize_wsa5__EndpointReferenceType(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE___tempuri__Equation:
		soap_serialize___tempuri__Equation(soap, (const struct __tempuri__Equation *)ptr);
		break;
	case SOAP_TYPE___tempuri__Result:
		soap_serialize___tempuri__Result(soap, (const struct __tempuri__Result *)ptr);
		break;
	case SOAP_TYPE___tempuri__DivideBy:
		soap_serialize___tempuri__DivideBy(soap, (const struct __tempuri__DivideBy *)ptr);
		break;
	case SOAP_TYPE___tempuri__MultiplyBy:
		soap_serialize___tempuri__MultiplyBy(soap, (const struct __tempuri__MultiplyBy *)ptr);
		break;
	case SOAP_TYPE___tempuri__SubtractFrom:
		soap_serialize___tempuri__SubtractFrom(soap, (const struct __tempuri__SubtractFrom *)ptr);
		break;
	case SOAP_TYPE___tempuri__AddTo:
		soap_serialize___tempuri__AddTo(soap, (const struct __tempuri__AddTo *)ptr);
		break;
	case SOAP_TYPE___tempuri__Clear:
		soap_serialize___tempuri__Clear(soap, (const struct __tempuri__Clear *)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__TerminateSequenceResponseType:
		soap_serialize_PointerTowsrm__TerminateSequenceResponseType(soap, (struct wsrm__TerminateSequenceResponseType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__TerminateSequenceType:
		soap_serialize_PointerTowsrm__TerminateSequenceType(soap, (struct wsrm__TerminateSequenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__CloseSequenceResponseType:
		soap_serialize_PointerTowsrm__CloseSequenceResponseType(soap, (struct wsrm__CloseSequenceResponseType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__CloseSequenceType:
		soap_serialize_PointerTowsrm__CloseSequenceType(soap, (struct wsrm__CloseSequenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__CreateSequenceResponseType:
		soap_serialize_PointerTowsrm__CreateSequenceResponseType(soap, (struct wsrm__CreateSequenceResponseType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__CreateSequenceType:
		soap_serialize_PointerTowsrm__CreateSequenceType(soap, (struct wsrm__CreateSequenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__SequenceFaultType:
		soap_serialize_PointerTowsrm__SequenceFaultType(soap, (struct wsrm__SequenceFaultType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement:
		soap_serialize_PointerTo_wsrm__SequenceAcknowledgement(soap, (struct _wsrm__SequenceAcknowledgement *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__AckRequestedType:
		soap_serialize_PointerTowsrm__AckRequestedType(soap, (struct wsrm__AckRequestedType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__SequenceType:
		soap_serialize_PointerTowsrm__SequenceType(soap, (struct wsrm__SequenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_None:
		soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_None(soap, (struct _wsrm__SequenceAcknowledgement_None *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange:
		soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_Final:
		soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, (struct _wsrm__SequenceAcknowledgement_Final *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedLONG64:
		soap_serialize_PointerTounsignedLONG64(soap, (ULONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__AcceptType:
		soap_serialize_PointerTowsrm__AcceptType(soap, (struct wsrm__AcceptType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__IncompleteSequenceBehaviorType:
		soap_serialize_PointerTowsrm__IncompleteSequenceBehaviorType(soap, (enum wsrm__IncompleteSequenceBehaviorType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrm__OfferType:
		soap_serialize_PointerTowsrm__OfferType(soap, (struct wsrm__OfferType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__duration:
		soap_serialize_PointerToxsd__duration(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsrm__UsesSequenceSSL:
		soap_serialize_PointerTo_wsrm__UsesSequenceSSL(soap, (struct _wsrm__UsesSequenceSSL *const*)ptr);
		break;
	case SOAP_TYPE__wsrm__Identifier:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__FaultTo:
		soap_serialize_PointerTo_wsa5__FaultTo(soap, (struct wsa5__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__ReplyTo:
		soap_serialize_PointerTo_wsa5__ReplyTo(soap, (struct wsa5__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__From:
		soap_serialize_PointerTo_wsa5__From(soap, (struct wsa5__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__RelatesTo:
		soap_serialize_PointerTo_wsa5__RelatesTo(soap, (struct wsa5__RelatesToType *const*)ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemIRI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemHeaderQName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__Action:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__To:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__MessageID:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTowsa5__MetadataType:
		soap_serialize_PointerTowsa5__MetadataType(soap, (struct wsa5__MetadataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa5__ReferenceParametersType:
		soap_serialize_PointerTowsa5__ReferenceParametersType(soap, (struct wsa5__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_wsa5__FaultCodesOpenEnumType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_wsa5__RelationshipTypeOpenEnum:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__Equation:
		soap_serialize_PointerTo_mssadh__Equation(soap, (_mssadh__Equation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__Result:
		soap_serialize_PointerTo_mssadh__Result(soap, (_mssadh__Result *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__DivideBy:
		soap_serialize_PointerTo_mssadh__DivideBy(soap, (_mssadh__DivideBy *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__MultiplyBy:
		soap_serialize_PointerTo_mssadh__MultiplyBy(soap, (_mssadh__MultiplyBy *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__SubtractFrom:
		soap_serialize_PointerTo_mssadh__SubtractFrom(soap, (_mssadh__SubtractFrom *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__AddTo:
		soap_serialize_PointerTo_mssadh__AddTo(soap, (_mssadh__AddTo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssadh__Clear:
		soap_serialize_PointerTo_mssadh__Clear(soap, (_mssadh__Clear *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTodouble:
		soap_serialize_PointerTodouble(soap, (double *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE__mssadh__Clear:
		return (void*)soap_instantiate__mssadh__Clear(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssadh__AddTo:
		return (void*)soap_instantiate__mssadh__AddTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssadh__SubtractFrom:
		return (void*)soap_instantiate__mssadh__SubtractFrom(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssadh__MultiplyBy:
		return (void*)soap_instantiate__mssadh__MultiplyBy(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssadh__DivideBy:
		return (void*)soap_instantiate__mssadh__DivideBy(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssadh__Result:
		return (void*)soap_instantiate__mssadh__Result(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssadh__Equation:
		return (void*)soap_instantiate__mssadh__Equation(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Clear:
		return (void*)soap_instantiate___tempuri__Clear(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__AddTo:
		return (void*)soap_instantiate___tempuri__AddTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__SubtractFrom:
		return (void*)soap_instantiate___tempuri__SubtractFrom(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__MultiplyBy:
		return (void*)soap_instantiate___tempuri__MultiplyBy(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__DivideBy:
		return (void*)soap_instantiate___tempuri__DivideBy(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Result:
		return (void*)soap_instantiate___tempuri__Result(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Equation:
		return (void*)soap_instantiate___tempuri__Equation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		return (void*)soap_instantiate_wsa5__EndpointReferenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		return (void*)soap_instantiate_wsa5__ReferenceParametersType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsa5__MetadataType:
		return (void*)soap_instantiate_wsa5__MetadataType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsa5__ProblemActionType:
		return (void*)soap_instantiate_wsa5__ProblemActionType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsa5__RelatesToType:
		return (void*)soap_instantiate_wsa5__RelatesToType(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE_wsrm__SequenceType:
		return (void*)soap_instantiate_wsrm__SequenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__AckRequestedType:
		return (void*)soap_instantiate_wsrm__AckRequestedType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__SequenceFaultType:
		return (void*)soap_instantiate_wsrm__SequenceFaultType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__CreateSequenceType:
		return (void*)soap_instantiate_wsrm__CreateSequenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__CreateSequenceResponseType:
		return (void*)soap_instantiate_wsrm__CreateSequenceResponseType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__CloseSequenceType:
		return (void*)soap_instantiate_wsrm__CloseSequenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__CloseSequenceResponseType:
		return (void*)soap_instantiate_wsrm__CloseSequenceResponseType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__TerminateSequenceType:
		return (void*)soap_instantiate_wsrm__TerminateSequenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__TerminateSequenceResponseType:
		return (void*)soap_instantiate_wsrm__TerminateSequenceResponseType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__OfferType:
		return (void*)soap_instantiate_wsrm__OfferType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrm__AcceptType:
		return (void*)soap_instantiate_wsrm__AcceptType(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_Final:
		return (void*)soap_instantiate__wsrm__SequenceAcknowledgement_Final(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange:
		return (void*)soap_instantiate__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_None:
		return (void*)soap_instantiate__wsrm__SequenceAcknowledgement_None(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsrm__SequenceAcknowledgement:
		return (void*)soap_instantiate__wsrm__SequenceAcknowledgement(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsrm__UsesSequenceSTR:
		return (void*)soap_instantiate__wsrm__UsesSequenceSTR(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsrm__UsesSequenceSSL:
		return (void*)soap_instantiate__wsrm__UsesSequenceSSL(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__CreateSequence:
		return (void*)soap_instantiate___wsrm__CreateSequence(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__CloseSequence:
		return (void*)soap_instantiate___wsrm__CloseSequence(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__TerminateSequence:
		return (void*)soap_instantiate___wsrm__TerminateSequence(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__CreateSequenceResponse:
		return (void*)soap_instantiate___wsrm__CreateSequenceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__CloseSequenceResponse:
		return (void*)soap_instantiate___wsrm__CloseSequenceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__TerminateSequenceResponse:
		return (void*)soap_instantiate___wsrm__TerminateSequenceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__SequenceAcknowledgement:
		return (void*)soap_instantiate___wsrm__SequenceAcknowledgement(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__AckRequested:
		return (void*)soap_instantiate___wsrm__AckRequested(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsrm__LastMessage:
		return (void*)soap_instantiate___wsrm__LastMessage(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__EndpointReference:
		return (void*)soap_instantiate__wsa5__EndpointReference(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__ReferenceParameters:
		return (void*)soap_instantiate__wsa5__ReferenceParameters(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__Metadata:
		return (void*)soap_instantiate__wsa5__Metadata(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__RelatesTo:
		return (void*)soap_instantiate__wsa5__RelatesTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__ReplyTo:
		return (void*)soap_instantiate__wsa5__ReplyTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__From:
		return (void*)soap_instantiate__wsa5__From(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__FaultTo:
		return (void*)soap_instantiate__wsa5__FaultTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsa5__ProblemAction:
		return (void*)soap_instantiate__wsa5__ProblemAction(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE__mssadh__Clear:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__Clear*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__Clear*)p->ptr);
		break;
	case SOAP_TYPE__mssadh__AddTo:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__AddTo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__AddTo*)p->ptr);
		break;
	case SOAP_TYPE__mssadh__SubtractFrom:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__SubtractFrom*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__SubtractFrom*)p->ptr);
		break;
	case SOAP_TYPE__mssadh__MultiplyBy:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__MultiplyBy*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__MultiplyBy*)p->ptr);
		break;
	case SOAP_TYPE__mssadh__DivideBy:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__DivideBy*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__DivideBy*)p->ptr);
		break;
	case SOAP_TYPE__mssadh__Result:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__Result*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__Result*)p->ptr);
		break;
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			SOAP_DELETE((std::string*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::string*)p->ptr);
		break;
	case SOAP_TYPE__mssadh__Equation:
		if (p->size < 0)
			SOAP_DELETE((_mssadh__Equation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssadh__Equation*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Clear:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Clear*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Clear*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__AddTo:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__AddTo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__AddTo*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__SubtractFrom:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__SubtractFrom*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__SubtractFrom*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__MultiplyBy:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__MultiplyBy*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__MultiplyBy*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__DivideBy:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__DivideBy*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__DivideBy*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Result:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Result*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Result*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Equation:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Equation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Equation*)p->ptr);
		break;
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__EndpointReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__EndpointReferenceType*)p->ptr);
		break;
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__ReferenceParametersType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__ReferenceParametersType*)p->ptr);
		break;
	case SOAP_TYPE_wsa5__MetadataType:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__MetadataType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__MetadataType*)p->ptr);
		break;
	case SOAP_TYPE_wsa5__ProblemActionType:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__ProblemActionType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__ProblemActionType*)p->ptr);
		break;
	case SOAP_TYPE_wsa5__RelatesToType:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__RelatesToType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__RelatesToType*)p->ptr);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
		break;
#endif
	case SOAP_TYPE_wsrm__SequenceType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__SequenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__SequenceType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__AckRequestedType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__AckRequestedType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__AckRequestedType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__SequenceFaultType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__SequenceFaultType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__SequenceFaultType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__CreateSequenceType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__CreateSequenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__CreateSequenceType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__CreateSequenceResponseType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__CreateSequenceResponseType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__CreateSequenceResponseType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__CloseSequenceType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__CloseSequenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__CloseSequenceType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__CloseSequenceResponseType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__CloseSequenceResponseType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__CloseSequenceResponseType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__TerminateSequenceType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__TerminateSequenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__TerminateSequenceType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__TerminateSequenceResponseType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__TerminateSequenceResponseType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__TerminateSequenceResponseType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__OfferType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__OfferType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__OfferType*)p->ptr);
		break;
	case SOAP_TYPE_wsrm__AcceptType:
		if (p->size < 0)
			SOAP_DELETE((struct wsrm__AcceptType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsrm__AcceptType*)p->ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_Final:
		if (p->size < 0)
			SOAP_DELETE((struct _wsrm__SequenceAcknowledgement_Final*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsrm__SequenceAcknowledgement_Final*)p->ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange:
		if (p->size < 0)
			SOAP_DELETE((struct _wsrm__SequenceAcknowledgement_AcknowledgementRange*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsrm__SequenceAcknowledgement_AcknowledgementRange*)p->ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement_None:
		if (p->size < 0)
			SOAP_DELETE((struct _wsrm__SequenceAcknowledgement_None*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsrm__SequenceAcknowledgement_None*)p->ptr);
		break;
	case SOAP_TYPE__wsrm__SequenceAcknowledgement:
		if (p->size < 0)
			SOAP_DELETE((struct _wsrm__SequenceAcknowledgement*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsrm__SequenceAcknowledgement*)p->ptr);
		break;
	case SOAP_TYPE__wsrm__UsesSequenceSTR:
		if (p->size < 0)
			SOAP_DELETE((struct _wsrm__UsesSequenceSTR*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsrm__UsesSequenceSTR*)p->ptr);
		break;
	case SOAP_TYPE__wsrm__UsesSequenceSSL:
		if (p->size < 0)
			SOAP_DELETE((struct _wsrm__UsesSequenceSSL*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsrm__UsesSequenceSSL*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__CreateSequence:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__CreateSequence*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__CreateSequence*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__CloseSequence:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__CloseSequence*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__CloseSequence*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__TerminateSequence:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__TerminateSequence*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__TerminateSequence*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__CreateSequenceResponse:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__CreateSequenceResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__CreateSequenceResponse*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__CloseSequenceResponse:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__CloseSequenceResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__CloseSequenceResponse*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__TerminateSequenceResponse:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__TerminateSequenceResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__TerminateSequenceResponse*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__SequenceAcknowledgement:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__SequenceAcknowledgement*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__SequenceAcknowledgement*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__AckRequested:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__AckRequested*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__AckRequested*)p->ptr);
		break;
	case SOAP_TYPE___wsrm__LastMessage:
		if (p->size < 0)
			SOAP_DELETE((struct __wsrm__LastMessage*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsrm__LastMessage*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__EndpointReference:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__EndpointReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__EndpointReferenceType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__ReferenceParameters:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__ReferenceParametersType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__ReferenceParametersType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__Metadata:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__MetadataType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__MetadataType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__RelatesTo:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__RelatesToType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__RelatesToType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__ReplyTo:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__EndpointReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__EndpointReferenceType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__From:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__EndpointReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__EndpointReferenceType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__FaultTo:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__EndpointReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__EndpointReferenceType*)p->ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemAction:
		if (p->size < 0)
			SOAP_DELETE((struct wsa5__ProblemActionType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsa5__ProblemActionType*)p->ptr);
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
	(void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
	switch (tt)
	{
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__duration(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__duration);
	if (soap_out_xsd__duration(soap, tag?tag:"xsd:duration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_xsd__duration(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__duration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{	double *p;
	p = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{	ULONG64 *p;
	p = soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__IncompleteSequenceBehaviorType(struct soap *soap, enum wsrm__IncompleteSequenceBehaviorType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsrm__IncompleteSequenceBehaviorType
	*a = SOAP_DEFAULT_wsrm__IncompleteSequenceBehaviorType;
#else
	*a = (enum wsrm__IncompleteSequenceBehaviorType)0;
#endif
}

static const struct soap_code_map soap_codes_wsrm__IncompleteSequenceBehaviorType[] =
{	{ (long)DiscardEntireSequence, "DiscardEntireSequence" },
	{ (long)DiscardFollowingFirstGap, "DiscardFollowingFirstGap" },
	{ (long)NoDiscard, "NoDiscard" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsrm__IncompleteSequenceBehaviorType2s(struct soap *soap, enum wsrm__IncompleteSequenceBehaviorType n)
{	const char *s = soap_code_str(soap_codes_wsrm__IncompleteSequenceBehaviorType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__IncompleteSequenceBehaviorType(struct soap *soap, const char *tag, int id, const enum wsrm__IncompleteSequenceBehaviorType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType), type) || soap_send(soap, soap_wsrm__IncompleteSequenceBehaviorType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsrm__IncompleteSequenceBehaviorType(struct soap *soap, const char *s, enum wsrm__IncompleteSequenceBehaviorType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_wsrm__IncompleteSequenceBehaviorType, s);
	if (map)
		*a = (enum wsrm__IncompleteSequenceBehaviorType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsrm__IncompleteSequenceBehaviorType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsrm__IncompleteSequenceBehaviorType * SOAP_FMAC4 soap_in_wsrm__IncompleteSequenceBehaviorType(struct soap *soap, const char *tag, enum wsrm__IncompleteSequenceBehaviorType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsrm__IncompleteSequenceBehaviorType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType, sizeof(enum wsrm__IncompleteSequenceBehaviorType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsrm__IncompleteSequenceBehaviorType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsrm__IncompleteSequenceBehaviorType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType, 0, sizeof(enum wsrm__IncompleteSequenceBehaviorType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__IncompleteSequenceBehaviorType(struct soap *soap, const enum wsrm__IncompleteSequenceBehaviorType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType);
	if (soap_out_wsrm__IncompleteSequenceBehaviorType(soap, tag?tag:"wsrm:IncompleteSequenceBehaviorType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsrm__IncompleteSequenceBehaviorType * SOAP_FMAC4 soap_get_wsrm__IncompleteSequenceBehaviorType(struct soap *soap, enum wsrm__IncompleteSequenceBehaviorType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__IncompleteSequenceBehaviorType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__FaultCodes(struct soap *soap, enum wsrm__FaultCodes *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsrm__FaultCodes
	*a = SOAP_DEFAULT_wsrm__FaultCodes;
#else
	*a = (enum wsrm__FaultCodes)0;
#endif
}

static const struct soap_code_map soap_codes_wsrm__FaultCodes[] =
{	{ (long)wsrm__SequenceTerminated, "wsrm:SequenceTerminated" },
	{ (long)wsrm__UnknownSequence, "wsrm:UnknownSequence" },
	{ (long)wsrm__InvalidAcknowledgement, "wsrm:InvalidAcknowledgement" },
	{ (long)wsrm__MessageNumberRollover, "wsrm:MessageNumberRollover" },
	{ (long)wsrm__LastMessageNumberExceeded, "wsrm:LastMessageNumberExceeded" },
	{ (long)wsrm__CreateSequenceRefused, "wsrm:CreateSequenceRefused" },
	{ (long)wsrm__WSRMRequired, "wsrm:WSRMRequired" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsrm__FaultCodes2s(struct soap *soap, enum wsrm__FaultCodes n)
{	const char *s = soap_code_str(soap_codes_wsrm__FaultCodes, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__FaultCodes(struct soap *soap, const char *tag, int id, const enum wsrm__FaultCodes *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__FaultCodes), type) || soap_send(soap, soap_wsrm__FaultCodes2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsrm__FaultCodes(struct soap *soap, const char *s, enum wsrm__FaultCodes *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, 0, -1);
	map = soap_code(soap_codes_wsrm__FaultCodes, t);
	if (map)
		*a = (enum wsrm__FaultCodes)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsrm__FaultCodes)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsrm__FaultCodes * SOAP_FMAC4 soap_in_wsrm__FaultCodes(struct soap *soap, const char *tag, enum wsrm__FaultCodes *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsrm__FaultCodes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__FaultCodes, sizeof(enum wsrm__FaultCodes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsrm__FaultCodes(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsrm__FaultCodes *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__FaultCodes, 0, sizeof(enum wsrm__FaultCodes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__FaultCodes(struct soap *soap, const enum wsrm__FaultCodes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__FaultCodes);
	if (soap_out_wsrm__FaultCodes(soap, tag?tag:"wsrm:FaultCodes", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsrm__FaultCodes * SOAP_FMAC4 soap_get_wsrm__FaultCodes(struct soap *soap, enum wsrm__FaultCodes *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__FaultCodes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsa5__IsReferenceParameter(struct soap *soap, enum _wsa5__IsReferenceParameter *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT__wsa5__IsReferenceParameter
	*a = SOAP_DEFAULT__wsa5__IsReferenceParameter;
#else
	*a = (enum _wsa5__IsReferenceParameter)0;
#endif
}

static const struct soap_code_map soap_codes__wsa5__IsReferenceParameter[] =
{	{ (long)wsa5__false, "wsa5:false" },
	{ (long)wsa5__true, "wsa5:true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap__wsa5__IsReferenceParameter2s(struct soap *soap, enum _wsa5__IsReferenceParameter n)
{	const char *s = soap_code_str(soap_codes__wsa5__IsReferenceParameter, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsa5__IsReferenceParameter(struct soap *soap, const char *tag, int id, const enum _wsa5__IsReferenceParameter *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsa5__IsReferenceParameter), type) || soap_send(soap, soap__wsa5__IsReferenceParameter2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2_wsa5__IsReferenceParameter(struct soap *soap, const char *s, enum _wsa5__IsReferenceParameter *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, 0, -1);
	map = soap_code(soap_codes__wsa5__IsReferenceParameter, t);
	if (map)
		*a = (enum _wsa5__IsReferenceParameter)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum _wsa5__IsReferenceParameter)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum _wsa5__IsReferenceParameter * SOAP_FMAC4 soap_in__wsa5__IsReferenceParameter(struct soap *soap, const char *tag, enum _wsa5__IsReferenceParameter *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum _wsa5__IsReferenceParameter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsa5__IsReferenceParameter, sizeof(enum _wsa5__IsReferenceParameter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2_wsa5__IsReferenceParameter(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum _wsa5__IsReferenceParameter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsa5__IsReferenceParameter, 0, sizeof(enum _wsa5__IsReferenceParameter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsa5__IsReferenceParameter(struct soap *soap, const enum _wsa5__IsReferenceParameter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsa5__IsReferenceParameter);
	if (soap_out__wsa5__IsReferenceParameter(soap, tag?tag:"wsa5:IsReferenceParameter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum _wsa5__IsReferenceParameter * SOAP_FMAC4 soap_get__wsa5__IsReferenceParameter(struct soap *soap, enum _wsa5__IsReferenceParameter *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsa5__IsReferenceParameter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__FaultCodesType(struct soap *soap, enum wsa5__FaultCodesType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa5__FaultCodesType
	*a = SOAP_DEFAULT_wsa5__FaultCodesType;
#else
	*a = (enum wsa5__FaultCodesType)0;
#endif
}

static const struct soap_code_map soap_codes_wsa5__FaultCodesType[] =
{	{ (long)wsa5__InvalidAddressingHeader, "wsa5:InvalidAddressingHeader" },
	{ (long)wsa5__InvalidAddress, "wsa5:InvalidAddress" },
	{ (long)wsa5__InvalidEPR, "wsa5:InvalidEPR" },
	{ (long)wsa5__InvalidCardinality, "wsa5:InvalidCardinality" },
	{ (long)wsa5__MissingAddressInEPR, "wsa5:MissingAddressInEPR" },
	{ (long)wsa5__DuplicateMessageID, "wsa5:DuplicateMessageID" },
	{ (long)wsa5__ActionMismatch, "wsa5:ActionMismatch" },
	{ (long)wsa5__MessageAddressingHeaderRequired, "wsa5:MessageAddressingHeaderRequired" },
	{ (long)wsa5__DestinationUnreachable, "wsa5:DestinationUnreachable" },
	{ (long)wsa5__ActionNotSupported, "wsa5:ActionNotSupported" },
	{ (long)wsa5__EndpointUnavailable, "wsa5:EndpointUnavailable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa5__FaultCodesType2s(struct soap *soap, enum wsa5__FaultCodesType n)
{	const char *s = soap_code_str(soap_codes_wsa5__FaultCodesType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__FaultCodesType(struct soap *soap, const char *tag, int id, const enum wsa5__FaultCodesType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__FaultCodesType), type) || soap_send(soap, soap_wsa5__FaultCodesType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa5__FaultCodesType(struct soap *soap, const char *s, enum wsa5__FaultCodesType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, 0, -1);
	map = soap_code(soap_codes_wsa5__FaultCodesType, t);
	if (map)
		*a = (enum wsa5__FaultCodesType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 10)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa5__FaultCodesType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa5__FaultCodesType * SOAP_FMAC4 soap_in_wsa5__FaultCodesType(struct soap *soap, const char *tag, enum wsa5__FaultCodesType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa5__FaultCodesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__FaultCodesType, sizeof(enum wsa5__FaultCodesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa5__FaultCodesType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa5__FaultCodesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__FaultCodesType, 0, sizeof(enum wsa5__FaultCodesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__FaultCodesType(struct soap *soap, const enum wsa5__FaultCodesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__FaultCodesType);
	if (soap_out_wsa5__FaultCodesType(soap, tag?tag:"wsa5:FaultCodesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa5__FaultCodesType * SOAP_FMAC4 soap_get_wsa5__FaultCodesType(struct soap *soap, enum wsa5__FaultCodesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__FaultCodesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__RelationshipType(struct soap *soap, enum wsa5__RelationshipType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa5__RelationshipType
	*a = SOAP_DEFAULT_wsa5__RelationshipType;
#else
	*a = (enum wsa5__RelationshipType)0;
#endif
}

static const struct soap_code_map soap_codes_wsa5__RelationshipType[] =
{	{ (long)http_x003a_x002f_x002fwww_x002ew3_x002eorg_x002f2005_x002f08_x002faddressing_x002freply, "http://www.w3.org/2005/08/addressing/reply" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa5__RelationshipType2s(struct soap *soap, enum wsa5__RelationshipType n)
{	const char *s = soap_code_str(soap_codes_wsa5__RelationshipType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__RelationshipType(struct soap *soap, const char *tag, int id, const enum wsa5__RelationshipType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__RelationshipType), type) || soap_send(soap, soap_wsa5__RelationshipType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa5__RelationshipType(struct soap *soap, const char *s, enum wsa5__RelationshipType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_wsa5__RelationshipType, s);
	if (map)
		*a = (enum wsa5__RelationshipType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa5__RelationshipType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa5__RelationshipType * SOAP_FMAC4 soap_in_wsa5__RelationshipType(struct soap *soap, const char *tag, enum wsa5__RelationshipType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa5__RelationshipType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__RelationshipType, sizeof(enum wsa5__RelationshipType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa5__RelationshipType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa5__RelationshipType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__RelationshipType, 0, sizeof(enum wsa5__RelationshipType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__RelationshipType(struct soap *soap, const enum wsa5__RelationshipType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__RelationshipType);
	if (soap_out_wsa5__RelationshipType(soap, tag?tag:"wsa5:RelationshipType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa5__RelationshipType * SOAP_FMAC4 soap_get_wsa5__RelationshipType(struct soap *soap, enum wsa5__RelationshipType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__RelationshipType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{
	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *a)
{	(void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
		{	if (!(t = soap_string_in(soap, 1, 0, -1)))
				return NULL;
			s->assign(t);
		}
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag?tag:"string", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::string);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(std::string, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void _mssadh__Equation::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssadh__Equation::eqn = NULL;
	/* transient soap skipped */
}

void _mssadh__Equation::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &this->_mssadh__Equation::eqn);
	/* transient soap skipped */
}

int _mssadh__Equation::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__Equation(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__Equation(struct soap *soap, const char *tag, int id, const _mssadh__Equation *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__Equation), type))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "mssadh:eqn", -1, &(a->_mssadh__Equation::eqn), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__Equation::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__Equation(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__Equation * SOAP_FMAC4 soap_in__mssadh__Equation(struct soap *soap, const char *tag, _mssadh__Equation *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__Equation *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__Equation, sizeof(_mssadh__Equation), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__Equation)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__Equation *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_eqn1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_eqn1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "mssadh:eqn", &(a->_mssadh__Equation::eqn), "xsd:string"))
				{	soap_flag_eqn1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__Equation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__Equation, 0, sizeof(_mssadh__Equation), 0, soap_copy__mssadh__Equation);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__Equation::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__Equation);
	if (this->soap_out(soap, tag?tag:"mssadh:Equation", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__Equation::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__Equation(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__Equation * SOAP_FMAC4 soap_get__mssadh__Equation(struct soap *soap, _mssadh__Equation *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__Equation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__Equation * SOAP_FMAC2 soap_instantiate__mssadh__Equation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__Equation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__Equation, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__Equation);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__Equation);
		((_mssadh__Equation*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__Equation, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__Equation);
		for (int i = 0; i < n; i++)
			((_mssadh__Equation*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__Equation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__Equation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__Equation %p -> %p\n", q, p));
	*(_mssadh__Equation*)p = *(_mssadh__Equation*)q;
}

void _mssadh__Result::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssadh__Result::result = NULL;
	/* transient soap skipped */
}

void _mssadh__Result::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssadh__Result::result);
	/* transient soap skipped */
}

int _mssadh__Result::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__Result(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__Result(struct soap *soap, const char *tag, int id, const _mssadh__Result *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__Result), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssadh:result", -1, &(a->_mssadh__Result::result), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__Result::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__Result(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__Result * SOAP_FMAC4 soap_in__mssadh__Result(struct soap *soap, const char *tag, _mssadh__Result *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__Result *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__Result, sizeof(_mssadh__Result), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__Result)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__Result *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_result1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssadh:result", &(a->_mssadh__Result::result), "xsd:double"))
				{	soap_flag_result1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__Result *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__Result, 0, sizeof(_mssadh__Result), 0, soap_copy__mssadh__Result);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__Result::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__Result);
	if (this->soap_out(soap, tag?tag:"mssadh:Result", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__Result::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__Result(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__Result * SOAP_FMAC4 soap_get__mssadh__Result(struct soap *soap, _mssadh__Result *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__Result(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__Result * SOAP_FMAC2 soap_instantiate__mssadh__Result(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__Result(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__Result, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__Result);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__Result);
		((_mssadh__Result*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__Result, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__Result);
		for (int i = 0; i < n; i++)
			((_mssadh__Result*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__Result*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__Result(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__Result %p -> %p\n", q, p));
	*(_mssadh__Result*)p = *(_mssadh__Result*)q;
}

void _mssadh__DivideBy::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssadh__DivideBy::n = NULL;
	/* transient soap skipped */
}

void _mssadh__DivideBy::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssadh__DivideBy::n);
	/* transient soap skipped */
}

int _mssadh__DivideBy::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__DivideBy(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__DivideBy(struct soap *soap, const char *tag, int id, const _mssadh__DivideBy *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__DivideBy), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssadh:n", -1, &(a->_mssadh__DivideBy::n), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__DivideBy::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__DivideBy(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__DivideBy * SOAP_FMAC4 soap_in__mssadh__DivideBy(struct soap *soap, const char *tag, _mssadh__DivideBy *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__DivideBy *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__DivideBy, sizeof(_mssadh__DivideBy), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__DivideBy)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__DivideBy *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssadh:n", &(a->_mssadh__DivideBy::n), "xsd:double"))
				{	soap_flag_n1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__DivideBy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__DivideBy, 0, sizeof(_mssadh__DivideBy), 0, soap_copy__mssadh__DivideBy);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__DivideBy::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__DivideBy);
	if (this->soap_out(soap, tag?tag:"mssadh:DivideBy", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__DivideBy::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__DivideBy(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__DivideBy * SOAP_FMAC4 soap_get__mssadh__DivideBy(struct soap *soap, _mssadh__DivideBy *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__DivideBy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__DivideBy * SOAP_FMAC2 soap_instantiate__mssadh__DivideBy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__DivideBy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__DivideBy, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__DivideBy);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__DivideBy);
		((_mssadh__DivideBy*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__DivideBy, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__DivideBy);
		for (int i = 0; i < n; i++)
			((_mssadh__DivideBy*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__DivideBy*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__DivideBy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__DivideBy %p -> %p\n", q, p));
	*(_mssadh__DivideBy*)p = *(_mssadh__DivideBy*)q;
}

void _mssadh__MultiplyBy::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssadh__MultiplyBy::n = NULL;
	/* transient soap skipped */
}

void _mssadh__MultiplyBy::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssadh__MultiplyBy::n);
	/* transient soap skipped */
}

int _mssadh__MultiplyBy::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__MultiplyBy(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__MultiplyBy(struct soap *soap, const char *tag, int id, const _mssadh__MultiplyBy *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__MultiplyBy), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssadh:n", -1, &(a->_mssadh__MultiplyBy::n), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__MultiplyBy::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__MultiplyBy(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__MultiplyBy * SOAP_FMAC4 soap_in__mssadh__MultiplyBy(struct soap *soap, const char *tag, _mssadh__MultiplyBy *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__MultiplyBy *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__MultiplyBy, sizeof(_mssadh__MultiplyBy), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__MultiplyBy)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__MultiplyBy *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssadh:n", &(a->_mssadh__MultiplyBy::n), "xsd:double"))
				{	soap_flag_n1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__MultiplyBy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__MultiplyBy, 0, sizeof(_mssadh__MultiplyBy), 0, soap_copy__mssadh__MultiplyBy);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__MultiplyBy::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__MultiplyBy);
	if (this->soap_out(soap, tag?tag:"mssadh:MultiplyBy", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__MultiplyBy::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__MultiplyBy(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__MultiplyBy * SOAP_FMAC4 soap_get__mssadh__MultiplyBy(struct soap *soap, _mssadh__MultiplyBy *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__MultiplyBy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__MultiplyBy * SOAP_FMAC2 soap_instantiate__mssadh__MultiplyBy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__MultiplyBy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__MultiplyBy, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__MultiplyBy);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__MultiplyBy);
		((_mssadh__MultiplyBy*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__MultiplyBy, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__MultiplyBy);
		for (int i = 0; i < n; i++)
			((_mssadh__MultiplyBy*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__MultiplyBy*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__MultiplyBy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__MultiplyBy %p -> %p\n", q, p));
	*(_mssadh__MultiplyBy*)p = *(_mssadh__MultiplyBy*)q;
}

void _mssadh__SubtractFrom::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssadh__SubtractFrom::n = NULL;
	/* transient soap skipped */
}

void _mssadh__SubtractFrom::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssadh__SubtractFrom::n);
	/* transient soap skipped */
}

int _mssadh__SubtractFrom::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__SubtractFrom(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__SubtractFrom(struct soap *soap, const char *tag, int id, const _mssadh__SubtractFrom *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__SubtractFrom), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssadh:n", -1, &(a->_mssadh__SubtractFrom::n), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__SubtractFrom::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__SubtractFrom(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__SubtractFrom * SOAP_FMAC4 soap_in__mssadh__SubtractFrom(struct soap *soap, const char *tag, _mssadh__SubtractFrom *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__SubtractFrom *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__SubtractFrom, sizeof(_mssadh__SubtractFrom), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__SubtractFrom)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__SubtractFrom *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssadh:n", &(a->_mssadh__SubtractFrom::n), "xsd:double"))
				{	soap_flag_n1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__SubtractFrom *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__SubtractFrom, 0, sizeof(_mssadh__SubtractFrom), 0, soap_copy__mssadh__SubtractFrom);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__SubtractFrom::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__SubtractFrom);
	if (this->soap_out(soap, tag?tag:"mssadh:SubtractFrom", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__SubtractFrom::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__SubtractFrom(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__SubtractFrom * SOAP_FMAC4 soap_get__mssadh__SubtractFrom(struct soap *soap, _mssadh__SubtractFrom *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__SubtractFrom(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__SubtractFrom * SOAP_FMAC2 soap_instantiate__mssadh__SubtractFrom(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__SubtractFrom(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__SubtractFrom, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__SubtractFrom);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__SubtractFrom);
		((_mssadh__SubtractFrom*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__SubtractFrom, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__SubtractFrom);
		for (int i = 0; i < n; i++)
			((_mssadh__SubtractFrom*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__SubtractFrom*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__SubtractFrom(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__SubtractFrom %p -> %p\n", q, p));
	*(_mssadh__SubtractFrom*)p = *(_mssadh__SubtractFrom*)q;
}

void _mssadh__AddTo::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssadh__AddTo::n = NULL;
	/* transient soap skipped */
}

void _mssadh__AddTo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssadh__AddTo::n);
	/* transient soap skipped */
}

int _mssadh__AddTo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__AddTo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__AddTo(struct soap *soap, const char *tag, int id, const _mssadh__AddTo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__AddTo), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssadh:n", -1, &(a->_mssadh__AddTo::n), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__AddTo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__AddTo(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__AddTo * SOAP_FMAC4 soap_in__mssadh__AddTo(struct soap *soap, const char *tag, _mssadh__AddTo *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__AddTo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__AddTo, sizeof(_mssadh__AddTo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__AddTo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__AddTo *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssadh:n", &(a->_mssadh__AddTo::n), "xsd:double"))
				{	soap_flag_n1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__AddTo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__AddTo, 0, sizeof(_mssadh__AddTo), 0, soap_copy__mssadh__AddTo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__AddTo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__AddTo);
	if (this->soap_out(soap, tag?tag:"mssadh:AddTo", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__AddTo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__AddTo(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__AddTo * SOAP_FMAC4 soap_get__mssadh__AddTo(struct soap *soap, _mssadh__AddTo *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__AddTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__AddTo * SOAP_FMAC2 soap_instantiate__mssadh__AddTo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__AddTo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__AddTo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__AddTo);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__AddTo);
		((_mssadh__AddTo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__AddTo, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__AddTo);
		for (int i = 0; i < n; i++)
			((_mssadh__AddTo*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__AddTo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__AddTo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__AddTo %p -> %p\n", q, p));
	*(_mssadh__AddTo*)p = *(_mssadh__AddTo*)q;
}

void _mssadh__Clear::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void _mssadh__Clear::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _mssadh__Clear::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssadh__Clear(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssadh__Clear(struct soap *soap, const char *tag, int id, const _mssadh__Clear *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssadh__Clear), type))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssadh__Clear::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssadh__Clear(soap, tag, this, type);
}

SOAP_FMAC3 _mssadh__Clear * SOAP_FMAC4 soap_in__mssadh__Clear(struct soap *soap, const char *tag, _mssadh__Clear *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssadh__Clear *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssadh__Clear, sizeof(_mssadh__Clear), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssadh__Clear)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssadh__Clear *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssadh__Clear *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssadh__Clear, 0, sizeof(_mssadh__Clear), 0, soap_copy__mssadh__Clear);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssadh__Clear::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssadh__Clear);
	if (this->soap_out(soap, tag?tag:"mssadh:Clear", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssadh__Clear::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssadh__Clear(soap, this, tag, type);
}

SOAP_FMAC3 _mssadh__Clear * SOAP_FMAC4 soap_get__mssadh__Clear(struct soap *soap, _mssadh__Clear *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssadh__Clear(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssadh__Clear * SOAP_FMAC2 soap_instantiate__mssadh__Clear(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssadh__Clear(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssadh__Clear, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssadh__Clear);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(_mssadh__Clear);
		((_mssadh__Clear*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssadh__Clear, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_mssadh__Clear);
		for (int i = 0; i < n; i++)
			((_mssadh__Clear*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_mssadh__Clear*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssadh__Clear(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssadh__Clear %p -> %p\n", q, p));
	*(_mssadh__Clear*)p = *(_mssadh__Clear*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__LastMessage(struct soap *soap, struct __wsrm__LastMessage *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__LastMessage(struct soap *soap, const struct __wsrm__LastMessage *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__LastMessage(struct soap *soap, const char *tag, int id, const struct __wsrm__LastMessage *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__LastMessage * SOAP_FMAC4 soap_in___wsrm__LastMessage(struct soap *soap, const char *tag, struct __wsrm__LastMessage *a, const char *type)
{
	a = (struct __wsrm__LastMessage *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__LastMessage, sizeof(struct __wsrm__LastMessage), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__LastMessage(soap, a);
	soap->error = SOAP_TAG_MISMATCH;
	a = NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__LastMessage(struct soap *soap, const struct __wsrm__LastMessage *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__LastMessage(soap, tag?tag:"-wsrm:LastMessage", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__LastMessage * SOAP_FMAC4 soap_get___wsrm__LastMessage(struct soap *soap, struct __wsrm__LastMessage *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__LastMessage(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__LastMessage * SOAP_FMAC2 soap_instantiate___wsrm__LastMessage(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__LastMessage(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__LastMessage, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__LastMessage);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__LastMessage);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__LastMessage, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__LastMessage);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__LastMessage*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__LastMessage(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__LastMessage %p -> %p\n", q, p));
	*(struct __wsrm__LastMessage*)p = *(struct __wsrm__LastMessage*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__AckRequested(struct soap *soap, struct __wsrm__AckRequested *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__AckRequested(struct soap *soap, const struct __wsrm__AckRequested *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__AckRequested(struct soap *soap, const char *tag, int id, const struct __wsrm__AckRequested *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__AckRequested * SOAP_FMAC4 soap_in___wsrm__AckRequested(struct soap *soap, const char *tag, struct __wsrm__AckRequested *a, const char *type)
{
	a = (struct __wsrm__AckRequested *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__AckRequested, sizeof(struct __wsrm__AckRequested), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__AckRequested(soap, a);
	soap->error = SOAP_TAG_MISMATCH;
	a = NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__AckRequested(struct soap *soap, const struct __wsrm__AckRequested *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__AckRequested(soap, tag?tag:"-wsrm:AckRequested", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__AckRequested * SOAP_FMAC4 soap_get___wsrm__AckRequested(struct soap *soap, struct __wsrm__AckRequested *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__AckRequested(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__AckRequested * SOAP_FMAC2 soap_instantiate___wsrm__AckRequested(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__AckRequested(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__AckRequested, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__AckRequested);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__AckRequested);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__AckRequested, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__AckRequested);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__AckRequested*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__AckRequested(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__AckRequested %p -> %p\n", q, p));
	*(struct __wsrm__AckRequested*)p = *(struct __wsrm__AckRequested*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__SequenceAcknowledgement(struct soap *soap, struct __wsrm__SequenceAcknowledgement *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__SequenceAcknowledgement(struct soap *soap, const struct __wsrm__SequenceAcknowledgement *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__SequenceAcknowledgement(struct soap *soap, const char *tag, int id, const struct __wsrm__SequenceAcknowledgement *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__SequenceAcknowledgement * SOAP_FMAC4 soap_in___wsrm__SequenceAcknowledgement(struct soap *soap, const char *tag, struct __wsrm__SequenceAcknowledgement *a, const char *type)
{
	a = (struct __wsrm__SequenceAcknowledgement *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__SequenceAcknowledgement, sizeof(struct __wsrm__SequenceAcknowledgement), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__SequenceAcknowledgement(soap, a);
	soap->error = SOAP_TAG_MISMATCH;
	a = NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__SequenceAcknowledgement(struct soap *soap, const struct __wsrm__SequenceAcknowledgement *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__SequenceAcknowledgement(soap, tag?tag:"-wsrm:SequenceAcknowledgement", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__SequenceAcknowledgement * SOAP_FMAC4 soap_get___wsrm__SequenceAcknowledgement(struct soap *soap, struct __wsrm__SequenceAcknowledgement *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__SequenceAcknowledgement(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__SequenceAcknowledgement * SOAP_FMAC2 soap_instantiate___wsrm__SequenceAcknowledgement(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__SequenceAcknowledgement(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__SequenceAcknowledgement, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__SequenceAcknowledgement);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__SequenceAcknowledgement);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__SequenceAcknowledgement, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__SequenceAcknowledgement);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__SequenceAcknowledgement*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__SequenceAcknowledgement(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__SequenceAcknowledgement %p -> %p\n", q, p));
	*(struct __wsrm__SequenceAcknowledgement*)p = *(struct __wsrm__SequenceAcknowledgement*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__TerminateSequenceResponse(struct soap *soap, struct __wsrm__TerminateSequenceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsrm__TerminateSequenceResponse = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__TerminateSequenceResponse(struct soap *soap, const struct __wsrm__TerminateSequenceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsrm__TerminateSequenceResponseType(soap, &a->wsrm__TerminateSequenceResponse);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__TerminateSequenceResponse(struct soap *soap, const char *tag, int id, const struct __wsrm__TerminateSequenceResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTowsrm__TerminateSequenceResponseType(soap, "wsrm:TerminateSequenceResponse", -1, &a->wsrm__TerminateSequenceResponse, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__TerminateSequenceResponse * SOAP_FMAC4 soap_in___wsrm__TerminateSequenceResponse(struct soap *soap, const char *tag, struct __wsrm__TerminateSequenceResponse *a, const char *type)
{
	size_t soap_flag_wsrm__TerminateSequenceResponse = 1;
	short soap_flag;
	a = (struct __wsrm__TerminateSequenceResponse *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__TerminateSequenceResponse, sizeof(struct __wsrm__TerminateSequenceResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__TerminateSequenceResponse(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsrm__TerminateSequenceResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__TerminateSequenceResponseType(soap, "wsrm:TerminateSequenceResponse", &a->wsrm__TerminateSequenceResponse, "wsrm:TerminateSequenceResponseType"))
				{	soap_flag_wsrm__TerminateSequenceResponse--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__TerminateSequenceResponse(struct soap *soap, const struct __wsrm__TerminateSequenceResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__TerminateSequenceResponse(soap, tag?tag:"-wsrm:TerminateSequenceResponse", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__TerminateSequenceResponse * SOAP_FMAC4 soap_get___wsrm__TerminateSequenceResponse(struct soap *soap, struct __wsrm__TerminateSequenceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__TerminateSequenceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__TerminateSequenceResponse * SOAP_FMAC2 soap_instantiate___wsrm__TerminateSequenceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__TerminateSequenceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__TerminateSequenceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__TerminateSequenceResponse);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__TerminateSequenceResponse);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__TerminateSequenceResponse, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__TerminateSequenceResponse);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__TerminateSequenceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__TerminateSequenceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__TerminateSequenceResponse %p -> %p\n", q, p));
	*(struct __wsrm__TerminateSequenceResponse*)p = *(struct __wsrm__TerminateSequenceResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__CloseSequenceResponse(struct soap *soap, struct __wsrm__CloseSequenceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsrm__CloseSequenceResponse = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__CloseSequenceResponse(struct soap *soap, const struct __wsrm__CloseSequenceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsrm__CloseSequenceResponseType(soap, &a->wsrm__CloseSequenceResponse);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__CloseSequenceResponse(struct soap *soap, const char *tag, int id, const struct __wsrm__CloseSequenceResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTowsrm__CloseSequenceResponseType(soap, "wsrm:CloseSequenceResponse", -1, &a->wsrm__CloseSequenceResponse, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CloseSequenceResponse * SOAP_FMAC4 soap_in___wsrm__CloseSequenceResponse(struct soap *soap, const char *tag, struct __wsrm__CloseSequenceResponse *a, const char *type)
{
	size_t soap_flag_wsrm__CloseSequenceResponse = 1;
	short soap_flag;
	a = (struct __wsrm__CloseSequenceResponse *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__CloseSequenceResponse, sizeof(struct __wsrm__CloseSequenceResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__CloseSequenceResponse(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsrm__CloseSequenceResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__CloseSequenceResponseType(soap, "wsrm:CloseSequenceResponse", &a->wsrm__CloseSequenceResponse, "wsrm:CloseSequenceResponseType"))
				{	soap_flag_wsrm__CloseSequenceResponse--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__CloseSequenceResponse(struct soap *soap, const struct __wsrm__CloseSequenceResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__CloseSequenceResponse(soap, tag?tag:"-wsrm:CloseSequenceResponse", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CloseSequenceResponse * SOAP_FMAC4 soap_get___wsrm__CloseSequenceResponse(struct soap *soap, struct __wsrm__CloseSequenceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__CloseSequenceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__CloseSequenceResponse * SOAP_FMAC2 soap_instantiate___wsrm__CloseSequenceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__CloseSequenceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__CloseSequenceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__CloseSequenceResponse);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__CloseSequenceResponse);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__CloseSequenceResponse, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__CloseSequenceResponse);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__CloseSequenceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__CloseSequenceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__CloseSequenceResponse %p -> %p\n", q, p));
	*(struct __wsrm__CloseSequenceResponse*)p = *(struct __wsrm__CloseSequenceResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__CreateSequenceResponse(struct soap *soap, struct __wsrm__CreateSequenceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsrm__CreateSequenceResponse = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__CreateSequenceResponse(struct soap *soap, const struct __wsrm__CreateSequenceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsrm__CreateSequenceResponseType(soap, &a->wsrm__CreateSequenceResponse);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__CreateSequenceResponse(struct soap *soap, const char *tag, int id, const struct __wsrm__CreateSequenceResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTowsrm__CreateSequenceResponseType(soap, "wsrm:CreateSequenceResponse", -1, &a->wsrm__CreateSequenceResponse, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CreateSequenceResponse * SOAP_FMAC4 soap_in___wsrm__CreateSequenceResponse(struct soap *soap, const char *tag, struct __wsrm__CreateSequenceResponse *a, const char *type)
{
	size_t soap_flag_wsrm__CreateSequenceResponse = 1;
	short soap_flag;
	a = (struct __wsrm__CreateSequenceResponse *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__CreateSequenceResponse, sizeof(struct __wsrm__CreateSequenceResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__CreateSequenceResponse(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsrm__CreateSequenceResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__CreateSequenceResponseType(soap, "wsrm:CreateSequenceResponse", &a->wsrm__CreateSequenceResponse, "wsrm:CreateSequenceResponseType"))
				{	soap_flag_wsrm__CreateSequenceResponse--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__CreateSequenceResponse(struct soap *soap, const struct __wsrm__CreateSequenceResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__CreateSequenceResponse(soap, tag?tag:"-wsrm:CreateSequenceResponse", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CreateSequenceResponse * SOAP_FMAC4 soap_get___wsrm__CreateSequenceResponse(struct soap *soap, struct __wsrm__CreateSequenceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__CreateSequenceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__CreateSequenceResponse * SOAP_FMAC2 soap_instantiate___wsrm__CreateSequenceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__CreateSequenceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__CreateSequenceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__CreateSequenceResponse);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__CreateSequenceResponse);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__CreateSequenceResponse, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__CreateSequenceResponse);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__CreateSequenceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__CreateSequenceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__CreateSequenceResponse %p -> %p\n", q, p));
	*(struct __wsrm__CreateSequenceResponse*)p = *(struct __wsrm__CreateSequenceResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__TerminateSequence(struct soap *soap, struct __wsrm__TerminateSequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsrm__TerminateSequence = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__TerminateSequence(struct soap *soap, const struct __wsrm__TerminateSequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsrm__TerminateSequenceType(soap, &a->wsrm__TerminateSequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__TerminateSequence(struct soap *soap, const char *tag, int id, const struct __wsrm__TerminateSequence *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTowsrm__TerminateSequenceType(soap, "wsrm:TerminateSequence", -1, &a->wsrm__TerminateSequence, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__TerminateSequence * SOAP_FMAC4 soap_in___wsrm__TerminateSequence(struct soap *soap, const char *tag, struct __wsrm__TerminateSequence *a, const char *type)
{
	size_t soap_flag_wsrm__TerminateSequence = 1;
	short soap_flag;
	a = (struct __wsrm__TerminateSequence *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__TerminateSequence, sizeof(struct __wsrm__TerminateSequence), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__TerminateSequence(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsrm__TerminateSequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__TerminateSequenceType(soap, "wsrm:TerminateSequence", &a->wsrm__TerminateSequence, "wsrm:TerminateSequenceType"))
				{	soap_flag_wsrm__TerminateSequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__TerminateSequence(struct soap *soap, const struct __wsrm__TerminateSequence *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__TerminateSequence(soap, tag?tag:"-wsrm:TerminateSequence", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__TerminateSequence * SOAP_FMAC4 soap_get___wsrm__TerminateSequence(struct soap *soap, struct __wsrm__TerminateSequence *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__TerminateSequence(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__TerminateSequence * SOAP_FMAC2 soap_instantiate___wsrm__TerminateSequence(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__TerminateSequence(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__TerminateSequence, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__TerminateSequence);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__TerminateSequence);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__TerminateSequence, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__TerminateSequence);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__TerminateSequence*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__TerminateSequence(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__TerminateSequence %p -> %p\n", q, p));
	*(struct __wsrm__TerminateSequence*)p = *(struct __wsrm__TerminateSequence*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__CloseSequence(struct soap *soap, struct __wsrm__CloseSequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsrm__CloseSequence = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__CloseSequence(struct soap *soap, const struct __wsrm__CloseSequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsrm__CloseSequenceType(soap, &a->wsrm__CloseSequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__CloseSequence(struct soap *soap, const char *tag, int id, const struct __wsrm__CloseSequence *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTowsrm__CloseSequenceType(soap, "wsrm:CloseSequence", -1, &a->wsrm__CloseSequence, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CloseSequence * SOAP_FMAC4 soap_in___wsrm__CloseSequence(struct soap *soap, const char *tag, struct __wsrm__CloseSequence *a, const char *type)
{
	size_t soap_flag_wsrm__CloseSequence = 1;
	short soap_flag;
	a = (struct __wsrm__CloseSequence *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__CloseSequence, sizeof(struct __wsrm__CloseSequence), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__CloseSequence(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsrm__CloseSequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__CloseSequenceType(soap, "wsrm:CloseSequence", &a->wsrm__CloseSequence, "wsrm:CloseSequenceType"))
				{	soap_flag_wsrm__CloseSequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__CloseSequence(struct soap *soap, const struct __wsrm__CloseSequence *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__CloseSequence(soap, tag?tag:"-wsrm:CloseSequence", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CloseSequence * SOAP_FMAC4 soap_get___wsrm__CloseSequence(struct soap *soap, struct __wsrm__CloseSequence *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__CloseSequence(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__CloseSequence * SOAP_FMAC2 soap_instantiate___wsrm__CloseSequence(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__CloseSequence(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__CloseSequence, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__CloseSequence);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__CloseSequence);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__CloseSequence, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__CloseSequence);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__CloseSequence*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__CloseSequence(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__CloseSequence %p -> %p\n", q, p));
	*(struct __wsrm__CloseSequence*)p = *(struct __wsrm__CloseSequence*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsrm__CreateSequence(struct soap *soap, struct __wsrm__CreateSequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsrm__CreateSequence = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsrm__CreateSequence(struct soap *soap, const struct __wsrm__CreateSequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsrm__CreateSequenceType(soap, &a->wsrm__CreateSequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsrm__CreateSequence(struct soap *soap, const char *tag, int id, const struct __wsrm__CreateSequence *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTowsrm__CreateSequenceType(soap, "wsrm:CreateSequence", -1, &a->wsrm__CreateSequence, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CreateSequence * SOAP_FMAC4 soap_in___wsrm__CreateSequence(struct soap *soap, const char *tag, struct __wsrm__CreateSequence *a, const char *type)
{
	size_t soap_flag_wsrm__CreateSequence = 1;
	short soap_flag;
	a = (struct __wsrm__CreateSequence *)soap_id_enter(soap, "", a, SOAP_TYPE___wsrm__CreateSequence, sizeof(struct __wsrm__CreateSequence), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsrm__CreateSequence(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsrm__CreateSequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__CreateSequenceType(soap, "wsrm:CreateSequence", &a->wsrm__CreateSequence, "wsrm:CreateSequenceType"))
				{	soap_flag_wsrm__CreateSequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsrm__CreateSequence(struct soap *soap, const struct __wsrm__CreateSequence *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsrm__CreateSequence(soap, tag?tag:"-wsrm:CreateSequence", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsrm__CreateSequence * SOAP_FMAC4 soap_get___wsrm__CreateSequence(struct soap *soap, struct __wsrm__CreateSequence *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsrm__CreateSequence(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsrm__CreateSequence * SOAP_FMAC2 soap_instantiate___wsrm__CreateSequence(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsrm__CreateSequence(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsrm__CreateSequence, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsrm__CreateSequence);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __wsrm__CreateSequence);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsrm__CreateSequence, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __wsrm__CreateSequence);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __wsrm__CreateSequence*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsrm__CreateSequence(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsrm__CreateSequence %p -> %p\n", q, p));
	*(struct __wsrm__CreateSequence*)p = *(struct __wsrm__CreateSequence*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsrm__SequenceAcknowledgement_None(struct soap *soap, struct _wsrm__SequenceAcknowledgement_None *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsrm__SequenceAcknowledgement_None(struct soap *soap, const struct _wsrm__SequenceAcknowledgement_None *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsrm__SequenceAcknowledgement_None(struct soap *soap, const char *tag, int id, const struct _wsrm__SequenceAcknowledgement_None *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement_None), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_None * SOAP_FMAC4 soap_in__wsrm__SequenceAcknowledgement_None(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement_None *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsrm__SequenceAcknowledgement_None *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement_None, sizeof(struct _wsrm__SequenceAcknowledgement_None), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsrm__SequenceAcknowledgement_None(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement_None *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsrm__SequenceAcknowledgement_None, 0, sizeof(struct _wsrm__SequenceAcknowledgement_None), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsrm__SequenceAcknowledgement_None(struct soap *soap, const struct _wsrm__SequenceAcknowledgement_None *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsrm__SequenceAcknowledgement_None);
	if (soap_out__wsrm__SequenceAcknowledgement_None(soap, tag?tag:"wsrm:SequenceAcknowledgement-None", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_None * SOAP_FMAC4 soap_get__wsrm__SequenceAcknowledgement_None(struct soap *soap, struct _wsrm__SequenceAcknowledgement_None *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsrm__SequenceAcknowledgement_None(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsrm__SequenceAcknowledgement_None * SOAP_FMAC2 soap_instantiate__wsrm__SequenceAcknowledgement_None(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsrm__SequenceAcknowledgement_None(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsrm__SequenceAcknowledgement_None, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsrm__SequenceAcknowledgement_None);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct _wsrm__SequenceAcknowledgement_None);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsrm__SequenceAcknowledgement_None, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct _wsrm__SequenceAcknowledgement_None);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct _wsrm__SequenceAcknowledgement_None*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsrm__SequenceAcknowledgement_None(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsrm__SequenceAcknowledgement_None %p -> %p\n", q, p));
	*(struct _wsrm__SequenceAcknowledgement_None*)p = *(struct _wsrm__SequenceAcknowledgement_None*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedLONG64(soap, &a->Upper);
	soap_default_unsignedLONG64(soap, &a->Lower);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, const struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, const char *tag, int id, const struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *a, const char *type)
{
	soap_set_attr(soap, "Upper", soap_ULONG642s(soap, a->Upper), 1);
	soap_set_attr(soap, "Lower", soap_ULONG642s(soap, a->Lower), 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_AcknowledgementRange * SOAP_FMAC4 soap_in__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange, sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, a);
	if (soap_s2ULONG64(soap, soap_attr_value(soap, "Upper", 1), &a->Upper))
		return NULL;
	if (soap_s2ULONG64(soap, soap_attr_value(soap, "Lower", 1), &a->Lower))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange, 0, sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, const struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange);
	if (soap_out__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag?tag:"wsrm:SequenceAcknowledgement-AcknowledgementRange", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_AcknowledgementRange * SOAP_FMAC4 soap_get__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsrm__SequenceAcknowledgement_AcknowledgementRange * SOAP_FMAC2 soap_instantiate__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsrm__SequenceAcknowledgement_AcknowledgementRange(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsrm__SequenceAcknowledgement_AcknowledgementRange %p -> %p\n", q, p));
	*(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange*)p = *(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsrm__SequenceAcknowledgement_Final(struct soap *soap, struct _wsrm__SequenceAcknowledgement_Final *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsrm__SequenceAcknowledgement_Final(struct soap *soap, const struct _wsrm__SequenceAcknowledgement_Final *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsrm__SequenceAcknowledgement_Final(struct soap *soap, const char *tag, int id, const struct _wsrm__SequenceAcknowledgement_Final *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_Final * SOAP_FMAC4 soap_in__wsrm__SequenceAcknowledgement_Final(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement_Final *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsrm__SequenceAcknowledgement_Final *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final, sizeof(struct _wsrm__SequenceAcknowledgement_Final), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsrm__SequenceAcknowledgement_Final(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement_Final *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final, 0, sizeof(struct _wsrm__SequenceAcknowledgement_Final), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsrm__SequenceAcknowledgement_Final(struct soap *soap, const struct _wsrm__SequenceAcknowledgement_Final *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final);
	if (soap_out__wsrm__SequenceAcknowledgement_Final(soap, tag?tag:"wsrm:SequenceAcknowledgement-Final", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_Final * SOAP_FMAC4 soap_get__wsrm__SequenceAcknowledgement_Final(struct soap *soap, struct _wsrm__SequenceAcknowledgement_Final *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsrm__SequenceAcknowledgement_Final(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsrm__SequenceAcknowledgement_Final * SOAP_FMAC2 soap_instantiate__wsrm__SequenceAcknowledgement_Final(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsrm__SequenceAcknowledgement_Final(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsrm__SequenceAcknowledgement_Final);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct _wsrm__SequenceAcknowledgement_Final);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsrm__SequenceAcknowledgement_Final, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct _wsrm__SequenceAcknowledgement_Final);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct _wsrm__SequenceAcknowledgement_Final*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsrm__SequenceAcknowledgement_Final(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsrm__SequenceAcknowledgement_Final %p -> %p\n", q, p));
	*(struct _wsrm__SequenceAcknowledgement_Final*)p = *(struct _wsrm__SequenceAcknowledgement_Final*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsrm__UsesSequenceSSL(struct soap *soap, struct _wsrm__UsesSequenceSSL *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsrm__UsesSequenceSSL(struct soap *soap, const struct _wsrm__UsesSequenceSSL *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsrm__UsesSequenceSSL(struct soap *soap, const char *tag, int id, const struct _wsrm__UsesSequenceSSL *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsrm__UsesSequenceSSL), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsrm__UsesSequenceSSL * SOAP_FMAC4 soap_in__wsrm__UsesSequenceSSL(struct soap *soap, const char *tag, struct _wsrm__UsesSequenceSSL *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsrm__UsesSequenceSSL *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsrm__UsesSequenceSSL, sizeof(struct _wsrm__UsesSequenceSSL), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsrm__UsesSequenceSSL(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsrm__UsesSequenceSSL *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsrm__UsesSequenceSSL, 0, sizeof(struct _wsrm__UsesSequenceSSL), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsrm__UsesSequenceSSL(struct soap *soap, const struct _wsrm__UsesSequenceSSL *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsrm__UsesSequenceSSL);
	if (soap_out__wsrm__UsesSequenceSSL(soap, tag?tag:"wsrm:UsesSequenceSSL", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__UsesSequenceSSL * SOAP_FMAC4 soap_get__wsrm__UsesSequenceSSL(struct soap *soap, struct _wsrm__UsesSequenceSSL *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsrm__UsesSequenceSSL(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsrm__UsesSequenceSSL * SOAP_FMAC2 soap_instantiate__wsrm__UsesSequenceSSL(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsrm__UsesSequenceSSL(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsrm__UsesSequenceSSL, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsrm__UsesSequenceSSL);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct _wsrm__UsesSequenceSSL);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsrm__UsesSequenceSSL, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct _wsrm__UsesSequenceSSL);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct _wsrm__UsesSequenceSSL*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsrm__UsesSequenceSSL(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsrm__UsesSequenceSSL %p -> %p\n", q, p));
	*(struct _wsrm__UsesSequenceSSL*)p = *(struct _wsrm__UsesSequenceSSL*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsrm__UsesSequenceSTR(struct soap *soap, struct _wsrm__UsesSequenceSTR *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsrm__UsesSequenceSTR(struct soap *soap, const struct _wsrm__UsesSequenceSTR *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsrm__UsesSequenceSTR(struct soap *soap, const char *tag, int id, const struct _wsrm__UsesSequenceSTR *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsrm__UsesSequenceSTR), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsrm__UsesSequenceSTR * SOAP_FMAC4 soap_in__wsrm__UsesSequenceSTR(struct soap *soap, const char *tag, struct _wsrm__UsesSequenceSTR *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsrm__UsesSequenceSTR *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsrm__UsesSequenceSTR, sizeof(struct _wsrm__UsesSequenceSTR), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsrm__UsesSequenceSTR(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsrm__UsesSequenceSTR *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsrm__UsesSequenceSTR, 0, sizeof(struct _wsrm__UsesSequenceSTR), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsrm__UsesSequenceSTR(struct soap *soap, const struct _wsrm__UsesSequenceSTR *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsrm__UsesSequenceSTR);
	if (soap_out__wsrm__UsesSequenceSTR(soap, tag?tag:"wsrm:UsesSequenceSTR", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__UsesSequenceSTR * SOAP_FMAC4 soap_get__wsrm__UsesSequenceSTR(struct soap *soap, struct _wsrm__UsesSequenceSTR *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsrm__UsesSequenceSTR(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsrm__UsesSequenceSTR * SOAP_FMAC2 soap_instantiate__wsrm__UsesSequenceSTR(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsrm__UsesSequenceSTR(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsrm__UsesSequenceSTR, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsrm__UsesSequenceSTR);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct _wsrm__UsesSequenceSTR);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsrm__UsesSequenceSTR, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct _wsrm__UsesSequenceSTR);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct _wsrm__UsesSequenceSTR*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsrm__UsesSequenceSTR(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsrm__UsesSequenceSTR %p -> %p\n", q, p));
	*(struct _wsrm__UsesSequenceSTR*)p = *(struct _wsrm__UsesSequenceSTR*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsrm__SequenceAcknowledgement(struct soap *soap, struct _wsrm__SequenceAcknowledgement *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	a->__sizeNack = 0;
	a->Nack = NULL;
	a->Final = NULL;
	a->__sizeAcknowledgementRange = 0;
	a->AcknowledgementRange = NULL;
	a->None = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsrm__SequenceAcknowledgement(struct soap *soap, const struct _wsrm__SequenceAcknowledgement *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	if (a->Nack)
	{	int i;
		for (i = 0; i < a->__sizeNack; i++)
		{
			soap_embedded(soap, a->Nack + i, SOAP_TYPE_unsignedLONG64);
		}
	}
	soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, &a->Final);
	if (a->AcknowledgementRange)
	{	int i;
		for (i = 0; i < a->__sizeAcknowledgementRange; i++)
		{
			soap_embedded(soap, a->AcknowledgementRange + i, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange);
			soap_serialize__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, a->AcknowledgementRange + i);
		}
	}
	soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_None(soap, &a->None);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsrm__SequenceAcknowledgement(struct soap *soap, const char *tag, int id, const struct _wsrm__SequenceAcknowledgement *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement), type))
		return soap->error;
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (a->Nack)
	{	int i;
		for (i = 0; i < a->__sizeNack; i++)
			if (soap_out_unsignedLONG64(soap, "wsrm:Nack", -1, a->Nack + i, ""))
				return soap->error;
	}
	if (soap_out_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, "wsrm:Final", -1, &a->Final, ""))
		return soap->error;
	if (a->AcknowledgementRange)
	{	int i;
		for (i = 0; i < a->__sizeAcknowledgementRange; i++)
			if (soap_out__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, "wsrm:AcknowledgementRange", -1, a->AcknowledgementRange + i, ""))
				return soap->error;
	}
	if (soap_out_PointerTo_wsrm__SequenceAcknowledgement_None(soap, "wsrm:None", -1, &a->None, ""))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement * SOAP_FMAC4 soap_in__wsrm__SequenceAcknowledgement(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	struct soap_blist *soap_blist_Nack = NULL;
	size_t soap_flag_Final = 1;
	struct soap_blist *soap_blist_AcknowledgementRange = NULL;
	size_t soap_flag_None = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsrm__SequenceAcknowledgement *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsrm__SequenceAcknowledgement, sizeof(struct _wsrm__SequenceAcknowledgement), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsrm__SequenceAcknowledgement(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "wsrm:Nack", 1, NULL))
			{	if (a->Nack == NULL)
				{	if (soap_blist_Nack == NULL)
						soap_blist_Nack = soap_new_block(soap);
					a->Nack = (ULONG64 *)soap_push_block(soap, soap_blist_Nack, sizeof(ULONG64));
					if (a->Nack == NULL)
						return NULL;
					soap_default_unsignedLONG64(soap, a->Nack);
				}
				soap_revert(soap);
				if (soap_in_unsignedLONG64(soap, "wsrm:Nack", a->Nack, "xsd:unsignedLong"))
				{	a->__sizeNack++;
					a->Nack = NULL;
					continue;
				}
			}
			if (soap_flag_Final && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, "wsrm:Final", &a->Final, ""))
				{	soap_flag_Final--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "wsrm:AcknowledgementRange", 1, NULL))
			{	if (a->AcknowledgementRange == NULL)
				{	if (soap_blist_AcknowledgementRange == NULL)
						soap_blist_AcknowledgementRange = soap_new_block(soap);
					a->AcknowledgementRange = (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *)soap_push_block(soap, soap_blist_AcknowledgementRange, sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange));
					if (a->AcknowledgementRange == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->AcknowledgementRange, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange);
					soap_default__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, a->AcknowledgementRange);
				}
				soap_revert(soap);
				if (soap_in__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, "wsrm:AcknowledgementRange", a->AcknowledgementRange, ""))
				{	a->__sizeAcknowledgementRange++;
					a->AcknowledgementRange = NULL;
					continue;
				}
			}
			if (soap_flag_None && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsrm__SequenceAcknowledgement_None(soap, "wsrm:None", &a->None, ""))
				{	soap_flag_None--;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Nack)
			soap_pop_block(soap, soap_blist_Nack);
		if (a->__sizeNack)
			a->Nack = (ULONG64 *)soap_save_block(soap, soap_blist_Nack, NULL, 1);
		else
		{	a->Nack = NULL;
			if (soap_blist_Nack)
				soap_end_block(soap, soap_blist_Nack);
		}
		if (a->AcknowledgementRange)
			soap_pop_block(soap, soap_blist_AcknowledgementRange);
		if (a->__sizeAcknowledgementRange)
			a->AcknowledgementRange = (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *)soap_save_block(soap, soap_blist_AcknowledgementRange, NULL, 1);
		else
		{	a->AcknowledgementRange = NULL;
			if (soap_blist_AcknowledgementRange)
				soap_end_block(soap, soap_blist_AcknowledgementRange);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsrm__SequenceAcknowledgement, 0, sizeof(struct _wsrm__SequenceAcknowledgement), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsrm__SequenceAcknowledgement(struct soap *soap, const struct _wsrm__SequenceAcknowledgement *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsrm__SequenceAcknowledgement);
	if (soap_out__wsrm__SequenceAcknowledgement(soap, tag?tag:"wsrm:SequenceAcknowledgement", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement * SOAP_FMAC4 soap_get__wsrm__SequenceAcknowledgement(struct soap *soap, struct _wsrm__SequenceAcknowledgement *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsrm__SequenceAcknowledgement(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsrm__SequenceAcknowledgement * SOAP_FMAC2 soap_instantiate__wsrm__SequenceAcknowledgement(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsrm__SequenceAcknowledgement(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsrm__SequenceAcknowledgement, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsrm__SequenceAcknowledgement);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct _wsrm__SequenceAcknowledgement);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsrm__SequenceAcknowledgement, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct _wsrm__SequenceAcknowledgement);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct _wsrm__SequenceAcknowledgement*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsrm__SequenceAcknowledgement(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsrm__SequenceAcknowledgement %p -> %p\n", q, p));
	*(struct _wsrm__SequenceAcknowledgement*)p = *(struct _wsrm__SequenceAcknowledgement*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__AcceptType(struct soap *soap, struct wsrm__AcceptType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_wsa5__EndpointReferenceType(soap, &a->AcksTo);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__AcceptType(struct soap *soap, const struct wsrm__AcceptType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_wsa5__EndpointReferenceType(soap, &a->AcksTo);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__AcceptType(struct soap *soap, const char *tag, int id, const struct wsrm__AcceptType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__AcceptType), type))
		return soap->error;
	if (soap_out_wsa5__EndpointReferenceType(soap, "wsrm:AcksTo", -1, &a->AcksTo, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__AcceptType * SOAP_FMAC4 soap_in_wsrm__AcceptType(struct soap *soap, const char *tag, struct wsrm__AcceptType *a, const char *type)
{
	size_t soap_flag_AcksTo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__AcceptType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__AcceptType, sizeof(struct wsrm__AcceptType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__AcceptType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AcksTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_wsa5__EndpointReferenceType(soap, "wsrm:AcksTo", &a->AcksTo, "wsa5:EndpointReferenceType"))
				{	soap_flag_AcksTo--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__AcceptType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__AcceptType, 0, sizeof(struct wsrm__AcceptType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AcksTo > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__AcceptType(struct soap *soap, const struct wsrm__AcceptType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__AcceptType);
	if (soap_out_wsrm__AcceptType(soap, tag?tag:"wsrm:AcceptType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__AcceptType * SOAP_FMAC4 soap_get_wsrm__AcceptType(struct soap *soap, struct wsrm__AcceptType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__AcceptType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__AcceptType * SOAP_FMAC2 soap_instantiate_wsrm__AcceptType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__AcceptType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__AcceptType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__AcceptType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__AcceptType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__AcceptType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__AcceptType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__AcceptType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__AcceptType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__AcceptType %p -> %p\n", q, p));
	*(struct wsrm__AcceptType*)p = *(struct wsrm__AcceptType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__OfferType(struct soap *soap, struct wsrm__OfferType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	soap_default_wsa5__EndpointReferenceType(soap, &a->Endpoint);
	a->Expires = NULL;
	a->IncompleteSequenceBehavior = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__OfferType(struct soap *soap, const struct wsrm__OfferType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_serialize_wsa5__EndpointReferenceType(soap, &a->Endpoint);
	soap_serialize_PointerToxsd__duration(soap, &a->Expires);
	soap_serialize_PointerTowsrm__IncompleteSequenceBehaviorType(soap, &a->IncompleteSequenceBehavior);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__OfferType(struct soap *soap, const char *tag, int id, const struct wsrm__OfferType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__OfferType), type))
		return soap->error;
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (soap_out_wsa5__EndpointReferenceType(soap, "wsrm:Endpoint", -1, &a->Endpoint, ""))
		return soap->error;
	if (soap_out_PointerToxsd__duration(soap, "wsrm:Expires", -1, &a->Expires, ""))
		return soap->error;
	if (soap_out_PointerTowsrm__IncompleteSequenceBehaviorType(soap, "wsrm:IncompleteSequenceBehavior", -1, &a->IncompleteSequenceBehavior, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__OfferType * SOAP_FMAC4 soap_in_wsrm__OfferType(struct soap *soap, const char *tag, struct wsrm__OfferType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_Endpoint = 1;
	size_t soap_flag_Expires = 1;
	size_t soap_flag_IncompleteSequenceBehavior = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__OfferType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__OfferType, sizeof(struct wsrm__OfferType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__OfferType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_Endpoint && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_wsa5__EndpointReferenceType(soap, "wsrm:Endpoint", &a->Endpoint, "wsa5:EndpointReferenceType"))
				{	soap_flag_Endpoint--;
					continue;
				}
			if (soap_flag_Expires && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__duration(soap, "wsrm:Expires", &a->Expires, "xsd:duration"))
				{	soap_flag_Expires--;
					continue;
				}
			if (soap_flag_IncompleteSequenceBehavior && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__IncompleteSequenceBehaviorType(soap, "wsrm:IncompleteSequenceBehavior", &a->IncompleteSequenceBehavior, "wsrm:IncompleteSequenceBehaviorType"))
				{	soap_flag_IncompleteSequenceBehavior--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__OfferType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__OfferType, 0, sizeof(struct wsrm__OfferType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0 || soap_flag_Endpoint > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__OfferType(struct soap *soap, const struct wsrm__OfferType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__OfferType);
	if (soap_out_wsrm__OfferType(soap, tag?tag:"wsrm:OfferType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__OfferType * SOAP_FMAC4 soap_get_wsrm__OfferType(struct soap *soap, struct wsrm__OfferType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__OfferType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__OfferType * SOAP_FMAC2 soap_instantiate_wsrm__OfferType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__OfferType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__OfferType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__OfferType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__OfferType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__OfferType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__OfferType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__OfferType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__OfferType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__OfferType %p -> %p\n", q, p));
	*(struct wsrm__OfferType*)p = *(struct wsrm__OfferType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__TerminateSequenceResponseType(struct soap *soap, struct wsrm__TerminateSequenceResponseType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	a->LastMsgNumber = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__TerminateSequenceResponseType(struct soap *soap, const struct wsrm__TerminateSequenceResponseType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_serialize_PointerTounsignedLONG64(soap, &a->LastMsgNumber);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__TerminateSequenceResponseType(struct soap *soap, const char *tag, int id, const struct wsrm__TerminateSequenceResponseType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__TerminateSequenceResponseType), type))
		return soap->error;
	if (a->Identifier)
		soap_element_result(soap, "wsrm:Identifier");
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (soap_out_PointerTounsignedLONG64(soap, "wsrm:LastMsgNumber", -1, &a->LastMsgNumber, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceResponseType * SOAP_FMAC4 soap_in_wsrm__TerminateSequenceResponseType(struct soap *soap, const char *tag, struct wsrm__TerminateSequenceResponseType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_LastMsgNumber = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__TerminateSequenceResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__TerminateSequenceResponseType, sizeof(struct wsrm__TerminateSequenceResponseType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__TerminateSequenceResponseType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_LastMsgNumber && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "wsrm:LastMsgNumber", &a->LastMsgNumber, "xsd:unsignedLong"))
				{	soap_flag_LastMsgNumber--;
					continue;
				}
			soap_check_result(soap, "wsrm:Identifier");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__TerminateSequenceResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__TerminateSequenceResponseType, 0, sizeof(struct wsrm__TerminateSequenceResponseType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__TerminateSequenceResponseType(struct soap *soap, const struct wsrm__TerminateSequenceResponseType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__TerminateSequenceResponseType);
	if (soap_out_wsrm__TerminateSequenceResponseType(soap, tag?tag:"wsrm:TerminateSequenceResponseType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceResponseType * SOAP_FMAC4 soap_get_wsrm__TerminateSequenceResponseType(struct soap *soap, struct wsrm__TerminateSequenceResponseType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__TerminateSequenceResponseType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__TerminateSequenceResponseType * SOAP_FMAC2 soap_instantiate_wsrm__TerminateSequenceResponseType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__TerminateSequenceResponseType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__TerminateSequenceResponseType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__TerminateSequenceResponseType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__TerminateSequenceResponseType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__TerminateSequenceResponseType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__TerminateSequenceResponseType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__TerminateSequenceResponseType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__TerminateSequenceResponseType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__TerminateSequenceResponseType %p -> %p\n", q, p));
	*(struct wsrm__TerminateSequenceResponseType*)p = *(struct wsrm__TerminateSequenceResponseType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__TerminateSequenceType(struct soap *soap, struct wsrm__TerminateSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	a->LastMsgNumber = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__TerminateSequenceType(struct soap *soap, const struct wsrm__TerminateSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_serialize_PointerTounsignedLONG64(soap, &a->LastMsgNumber);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__TerminateSequenceType(struct soap *soap, const char *tag, int id, const struct wsrm__TerminateSequenceType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__TerminateSequenceType), type))
		return soap->error;
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (soap_out_PointerTounsignedLONG64(soap, "wsrm:LastMsgNumber", -1, &a->LastMsgNumber, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceType * SOAP_FMAC4 soap_in_wsrm__TerminateSequenceType(struct soap *soap, const char *tag, struct wsrm__TerminateSequenceType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_LastMsgNumber = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__TerminateSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__TerminateSequenceType, sizeof(struct wsrm__TerminateSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__TerminateSequenceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_LastMsgNumber && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "wsrm:LastMsgNumber", &a->LastMsgNumber, "xsd:unsignedLong"))
				{	soap_flag_LastMsgNumber--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__TerminateSequenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__TerminateSequenceType, 0, sizeof(struct wsrm__TerminateSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__TerminateSequenceType(struct soap *soap, const struct wsrm__TerminateSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__TerminateSequenceType);
	if (soap_out_wsrm__TerminateSequenceType(soap, tag?tag:"wsrm:TerminateSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceType * SOAP_FMAC4 soap_get_wsrm__TerminateSequenceType(struct soap *soap, struct wsrm__TerminateSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__TerminateSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__TerminateSequenceType * SOAP_FMAC2 soap_instantiate_wsrm__TerminateSequenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__TerminateSequenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__TerminateSequenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__TerminateSequenceType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__TerminateSequenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__TerminateSequenceType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__TerminateSequenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__TerminateSequenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__TerminateSequenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__TerminateSequenceType %p -> %p\n", q, p));
	*(struct wsrm__TerminateSequenceType*)p = *(struct wsrm__TerminateSequenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__CloseSequenceResponseType(struct soap *soap, struct wsrm__CloseSequenceResponseType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__CloseSequenceResponseType(struct soap *soap, const struct wsrm__CloseSequenceResponseType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__CloseSequenceResponseType(struct soap *soap, const char *tag, int id, const struct wsrm__CloseSequenceResponseType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__CloseSequenceResponseType), type))
		return soap->error;
	if (a->Identifier)
		soap_element_result(soap, "wsrm:Identifier");
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__CloseSequenceResponseType * SOAP_FMAC4 soap_in_wsrm__CloseSequenceResponseType(struct soap *soap, const char *tag, struct wsrm__CloseSequenceResponseType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__CloseSequenceResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__CloseSequenceResponseType, sizeof(struct wsrm__CloseSequenceResponseType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__CloseSequenceResponseType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			soap_check_result(soap, "wsrm:Identifier");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__CloseSequenceResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__CloseSequenceResponseType, 0, sizeof(struct wsrm__CloseSequenceResponseType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__CloseSequenceResponseType(struct soap *soap, const struct wsrm__CloseSequenceResponseType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__CloseSequenceResponseType);
	if (soap_out_wsrm__CloseSequenceResponseType(soap, tag?tag:"wsrm:CloseSequenceResponseType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CloseSequenceResponseType * SOAP_FMAC4 soap_get_wsrm__CloseSequenceResponseType(struct soap *soap, struct wsrm__CloseSequenceResponseType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__CloseSequenceResponseType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__CloseSequenceResponseType * SOAP_FMAC2 soap_instantiate_wsrm__CloseSequenceResponseType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__CloseSequenceResponseType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__CloseSequenceResponseType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__CloseSequenceResponseType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__CloseSequenceResponseType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__CloseSequenceResponseType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__CloseSequenceResponseType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__CloseSequenceResponseType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__CloseSequenceResponseType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__CloseSequenceResponseType %p -> %p\n", q, p));
	*(struct wsrm__CloseSequenceResponseType*)p = *(struct wsrm__CloseSequenceResponseType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__CloseSequenceType(struct soap *soap, struct wsrm__CloseSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	a->LastMsgNumber = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__CloseSequenceType(struct soap *soap, const struct wsrm__CloseSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_serialize_PointerTounsignedLONG64(soap, &a->LastMsgNumber);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__CloseSequenceType(struct soap *soap, const char *tag, int id, const struct wsrm__CloseSequenceType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__CloseSequenceType), type))
		return soap->error;
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (soap_out_PointerTounsignedLONG64(soap, "wsrm:LastMsgNumber", -1, &a->LastMsgNumber, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__CloseSequenceType * SOAP_FMAC4 soap_in_wsrm__CloseSequenceType(struct soap *soap, const char *tag, struct wsrm__CloseSequenceType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_LastMsgNumber = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__CloseSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__CloseSequenceType, sizeof(struct wsrm__CloseSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__CloseSequenceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_LastMsgNumber && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "wsrm:LastMsgNumber", &a->LastMsgNumber, "xsd:unsignedLong"))
				{	soap_flag_LastMsgNumber--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__CloseSequenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__CloseSequenceType, 0, sizeof(struct wsrm__CloseSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__CloseSequenceType(struct soap *soap, const struct wsrm__CloseSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__CloseSequenceType);
	if (soap_out_wsrm__CloseSequenceType(soap, tag?tag:"wsrm:CloseSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CloseSequenceType * SOAP_FMAC4 soap_get_wsrm__CloseSequenceType(struct soap *soap, struct wsrm__CloseSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__CloseSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__CloseSequenceType * SOAP_FMAC2 soap_instantiate_wsrm__CloseSequenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__CloseSequenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__CloseSequenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__CloseSequenceType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__CloseSequenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__CloseSequenceType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__CloseSequenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__CloseSequenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__CloseSequenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__CloseSequenceType %p -> %p\n", q, p));
	*(struct wsrm__CloseSequenceType*)p = *(struct wsrm__CloseSequenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__CreateSequenceResponseType(struct soap *soap, struct wsrm__CreateSequenceResponseType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	a->Expires = NULL;
	a->IncompleteSequenceBehavior = NULL;
	a->Accept = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__CreateSequenceResponseType(struct soap *soap, const struct wsrm__CreateSequenceResponseType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_serialize_PointerToxsd__duration(soap, &a->Expires);
	soap_serialize_PointerTowsrm__IncompleteSequenceBehaviorType(soap, &a->IncompleteSequenceBehavior);
	soap_serialize_PointerTowsrm__AcceptType(soap, &a->Accept);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__CreateSequenceResponseType(struct soap *soap, const char *tag, int id, const struct wsrm__CreateSequenceResponseType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__CreateSequenceResponseType), type))
		return soap->error;
	if (a->Identifier)
		soap_element_result(soap, "wsrm:Identifier");
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (soap_out_PointerToxsd__duration(soap, "wsrm:Expires", -1, &a->Expires, ""))
		return soap->error;
	if (soap_out_PointerTowsrm__IncompleteSequenceBehaviorType(soap, "wsrm:IncompleteSequenceBehavior", -1, &a->IncompleteSequenceBehavior, ""))
		return soap->error;
	if (soap_out_PointerTowsrm__AcceptType(soap, "wsrm:Accept", -1, &a->Accept, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__CreateSequenceResponseType * SOAP_FMAC4 soap_in_wsrm__CreateSequenceResponseType(struct soap *soap, const char *tag, struct wsrm__CreateSequenceResponseType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_Expires = 1;
	size_t soap_flag_IncompleteSequenceBehavior = 1;
	size_t soap_flag_Accept = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__CreateSequenceResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__CreateSequenceResponseType, sizeof(struct wsrm__CreateSequenceResponseType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__CreateSequenceResponseType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_Expires && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__duration(soap, "wsrm:Expires", &a->Expires, "xsd:duration"))
				{	soap_flag_Expires--;
					continue;
				}
			if (soap_flag_IncompleteSequenceBehavior && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__IncompleteSequenceBehaviorType(soap, "wsrm:IncompleteSequenceBehavior", &a->IncompleteSequenceBehavior, "wsrm:IncompleteSequenceBehaviorType"))
				{	soap_flag_IncompleteSequenceBehavior--;
					continue;
				}
			if (soap_flag_Accept && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__AcceptType(soap, "wsrm:Accept", &a->Accept, "wsrm:AcceptType"))
				{	soap_flag_Accept--;
					continue;
				}
			soap_check_result(soap, "wsrm:Identifier");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__CreateSequenceResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__CreateSequenceResponseType, 0, sizeof(struct wsrm__CreateSequenceResponseType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__CreateSequenceResponseType(struct soap *soap, const struct wsrm__CreateSequenceResponseType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__CreateSequenceResponseType);
	if (soap_out_wsrm__CreateSequenceResponseType(soap, tag?tag:"wsrm:CreateSequenceResponseType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CreateSequenceResponseType * SOAP_FMAC4 soap_get_wsrm__CreateSequenceResponseType(struct soap *soap, struct wsrm__CreateSequenceResponseType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__CreateSequenceResponseType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__CreateSequenceResponseType * SOAP_FMAC2 soap_instantiate_wsrm__CreateSequenceResponseType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__CreateSequenceResponseType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__CreateSequenceResponseType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__CreateSequenceResponseType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__CreateSequenceResponseType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__CreateSequenceResponseType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__CreateSequenceResponseType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__CreateSequenceResponseType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__CreateSequenceResponseType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__CreateSequenceResponseType %p -> %p\n", q, p));
	*(struct wsrm__CreateSequenceResponseType*)p = *(struct wsrm__CreateSequenceResponseType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__CreateSequenceType(struct soap *soap, struct wsrm__CreateSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_wsa5__EndpointReferenceType(soap, &a->AcksTo);
	a->Expires = NULL;
	a->Offer = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__CreateSequenceType(struct soap *soap, const struct wsrm__CreateSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_wsa5__EndpointReferenceType(soap, &a->AcksTo);
	soap_serialize_PointerToxsd__duration(soap, &a->Expires);
	soap_serialize_PointerTowsrm__OfferType(soap, &a->Offer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__CreateSequenceType(struct soap *soap, const char *tag, int id, const struct wsrm__CreateSequenceType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__CreateSequenceType), type))
		return soap->error;
	if (soap_out_wsa5__EndpointReferenceType(soap, "wsrm:AcksTo", -1, &a->AcksTo, ""))
		return soap->error;
	if (soap_out_PointerToxsd__duration(soap, "wsrm:Expires", -1, &a->Expires, ""))
		return soap->error;
	if (soap_out_PointerTowsrm__OfferType(soap, "wsrm:Offer", -1, &a->Offer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__CreateSequenceType * SOAP_FMAC4 soap_in_wsrm__CreateSequenceType(struct soap *soap, const char *tag, struct wsrm__CreateSequenceType *a, const char *type)
{
	size_t soap_flag_AcksTo = 1;
	size_t soap_flag_Expires = 1;
	size_t soap_flag_Offer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__CreateSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__CreateSequenceType, sizeof(struct wsrm__CreateSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__CreateSequenceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AcksTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_wsa5__EndpointReferenceType(soap, "wsrm:AcksTo", &a->AcksTo, "wsa5:EndpointReferenceType"))
				{	soap_flag_AcksTo--;
					continue;
				}
			if (soap_flag_Expires && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__duration(soap, "wsrm:Expires", &a->Expires, "xsd:duration"))
				{	soap_flag_Expires--;
					continue;
				}
			if (soap_flag_Offer && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__OfferType(soap, "wsrm:Offer", &a->Offer, "wsrm:OfferType"))
				{	soap_flag_Offer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__CreateSequenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__CreateSequenceType, 0, sizeof(struct wsrm__CreateSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AcksTo > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__CreateSequenceType(struct soap *soap, const struct wsrm__CreateSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__CreateSequenceType);
	if (soap_out_wsrm__CreateSequenceType(soap, tag?tag:"wsrm:CreateSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CreateSequenceType * SOAP_FMAC4 soap_get_wsrm__CreateSequenceType(struct soap *soap, struct wsrm__CreateSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__CreateSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__CreateSequenceType * SOAP_FMAC2 soap_instantiate_wsrm__CreateSequenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__CreateSequenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__CreateSequenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__CreateSequenceType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__CreateSequenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__CreateSequenceType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__CreateSequenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__CreateSequenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__CreateSequenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__CreateSequenceType %p -> %p\n", q, p));
	*(struct wsrm__CreateSequenceType*)p = *(struct wsrm__CreateSequenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__SequenceFaultType(struct soap *soap, struct wsrm__SequenceFaultType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_wsrm__FaultCodes(soap, &a->FaultCode);
	a->Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__SequenceFaultType(struct soap *soap, const struct wsrm__SequenceFaultType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__SequenceFaultType(struct soap *soap, const char *tag, int id, const struct wsrm__SequenceFaultType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__SequenceFaultType), type))
		return soap->error;
	if (soap_out_wsrm__FaultCodes(soap, "wsrm:FaultCode", -1, &a->FaultCode, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "wsrm:Detail", -1, &a->Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__SequenceFaultType * SOAP_FMAC4 soap_in_wsrm__SequenceFaultType(struct soap *soap, const char *tag, struct wsrm__SequenceFaultType *a, const char *type)
{
	size_t soap_flag_FaultCode = 1;
	size_t soap_flag_Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__SequenceFaultType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__SequenceFaultType, sizeof(struct wsrm__SequenceFaultType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__SequenceFaultType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_FaultCode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_wsrm__FaultCodes(soap, "wsrm:FaultCode", &a->FaultCode, "wsrm:FaultCodes"))
				{	soap_flag_FaultCode--;
					continue;
				}
			if (soap_flag_Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "wsrm:Detail", &a->Detail, ""))
				{	soap_flag_Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__SequenceFaultType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__SequenceFaultType, 0, sizeof(struct wsrm__SequenceFaultType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_FaultCode > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__SequenceFaultType(struct soap *soap, const struct wsrm__SequenceFaultType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__SequenceFaultType);
	if (soap_out_wsrm__SequenceFaultType(soap, tag?tag:"wsrm:SequenceFaultType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__SequenceFaultType * SOAP_FMAC4 soap_get_wsrm__SequenceFaultType(struct soap *soap, struct wsrm__SequenceFaultType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__SequenceFaultType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__SequenceFaultType * SOAP_FMAC2 soap_instantiate_wsrm__SequenceFaultType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__SequenceFaultType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__SequenceFaultType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__SequenceFaultType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__SequenceFaultType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__SequenceFaultType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__SequenceFaultType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__SequenceFaultType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__SequenceFaultType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__SequenceFaultType %p -> %p\n", q, p));
	*(struct wsrm__SequenceFaultType*)p = *(struct wsrm__SequenceFaultType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__AckRequestedType(struct soap *soap, struct wsrm__AckRequestedType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__AckRequestedType(struct soap *soap, const struct wsrm__AckRequestedType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__AckRequestedType(struct soap *soap, const char *tag, int id, const struct wsrm__AckRequestedType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__AckRequestedType), type))
		return soap->error;
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__AckRequestedType * SOAP_FMAC4 soap_in_wsrm__AckRequestedType(struct soap *soap, const char *tag, struct wsrm__AckRequestedType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__AckRequestedType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__AckRequestedType, sizeof(struct wsrm__AckRequestedType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__AckRequestedType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__AckRequestedType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__AckRequestedType, 0, sizeof(struct wsrm__AckRequestedType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__AckRequestedType(struct soap *soap, const struct wsrm__AckRequestedType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__AckRequestedType);
	if (soap_out_wsrm__AckRequestedType(soap, tag?tag:"wsrm:AckRequestedType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__AckRequestedType * SOAP_FMAC4 soap_get_wsrm__AckRequestedType(struct soap *soap, struct wsrm__AckRequestedType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__AckRequestedType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__AckRequestedType * SOAP_FMAC2 soap_instantiate_wsrm__AckRequestedType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__AckRequestedType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__AckRequestedType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__AckRequestedType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__AckRequestedType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__AckRequestedType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__AckRequestedType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__AckRequestedType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__AckRequestedType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__AckRequestedType %p -> %p\n", q, p));
	*(struct wsrm__AckRequestedType*)p = *(struct wsrm__AckRequestedType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsrm__SequenceType(struct soap *soap, struct wsrm__SequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Identifier);
	soap_default_unsignedLONG64(soap, &a->MessageNumber);
	a->LastMessage = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsrm__SequenceType(struct soap *soap, const struct wsrm__SequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_embedded(soap, &a->MessageNumber, SOAP_TYPE_unsignedLONG64);
	soap_serialize_PointerTo_wsrm__UsesSequenceSSL(soap, &a->LastMessage);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrm__SequenceType(struct soap *soap, const char *tag, int id, const struct wsrm__SequenceType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrm__SequenceType), type))
		return soap->error;
	if (a->Identifier)
	{	if (soap_out_string(soap, "wsrm:Identifier", -1, &a->Identifier, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsrm:Identifier"))
		return soap->error;
	if (soap_out_unsignedLONG64(soap, "wsrm:MessageNumber", -1, &a->MessageNumber, ""))
		return soap->error;
	if (soap_out_PointerTo_wsrm__UsesSequenceSSL(soap, "wsrm:LastMessage", -1, &a->LastMessage, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsrm__SequenceType * SOAP_FMAC4 soap_in_wsrm__SequenceType(struct soap *soap, const char *tag, struct wsrm__SequenceType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_MessageNumber = 1;
	size_t soap_flag_LastMessage = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsrm__SequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsrm__SequenceType, sizeof(struct wsrm__SequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsrm__SequenceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsrm:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_MessageNumber && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedLONG64(soap, "wsrm:MessageNumber", &a->MessageNumber, "xsd:unsignedLong"))
				{	soap_flag_MessageNumber--;
					continue;
				}
			if (soap_flag_LastMessage && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsrm__UsesSequenceSSL(soap, "wsrm:LastMessage", &a->LastMessage, ""))
				{	soap_flag_LastMessage--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsrm__SequenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrm__SequenceType, 0, sizeof(struct wsrm__SequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Identifier > 0 || soap_flag_MessageNumber > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsrm__SequenceType(struct soap *soap, const struct wsrm__SequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsrm__SequenceType);
	if (soap_out_wsrm__SequenceType(soap, tag?tag:"wsrm:SequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__SequenceType * SOAP_FMAC4 soap_get_wsrm__SequenceType(struct soap *soap, struct wsrm__SequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrm__SequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsrm__SequenceType * SOAP_FMAC2 soap_instantiate_wsrm__SequenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrm__SequenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrm__SequenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsrm__SequenceType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsrm__SequenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsrm__SequenceType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsrm__SequenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsrm__SequenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrm__SequenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsrm__SequenceType %p -> %p\n", q, p));
	*(struct wsrm__SequenceType*)p = *(struct wsrm__SequenceType*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Fault, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Reason, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Code, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Detail, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__wsa5__MessageID(soap, &a->wsa5__MessageID);
	a->wsa5__RelatesTo = NULL;
	a->wsa5__From = NULL;
	a->wsa5__ReplyTo = NULL;
	a->wsa5__FaultTo = NULL;
	soap_default__wsa5__To(soap, &a->wsa5__To);
	soap_default__wsa5__Action(soap, &a->wsa5__Action);
	a->wsrm__Sequence = NULL;
	a->__sizeAckRequested = 0;
	a->wsrm__AckRequested = NULL;
	a->__sizeSequenceAcknowledgement = 0;
	a->wsrm__SequenceAcknowledgement = NULL;
	a->wsrm__SequenceFault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__wsa5__MessageID(soap, &a->wsa5__MessageID);
	soap_serialize_PointerTo_wsa5__RelatesTo(soap, &a->wsa5__RelatesTo);
	soap_serialize_PointerTo_wsa5__From(soap, &a->wsa5__From);
	soap_serialize_PointerTo_wsa5__ReplyTo(soap, &a->wsa5__ReplyTo);
	soap_serialize_PointerTo_wsa5__FaultTo(soap, &a->wsa5__FaultTo);
	soap_serialize__wsa5__To(soap, &a->wsa5__To);
	soap_serialize__wsa5__Action(soap, &a->wsa5__Action);
	soap_serialize_PointerTowsrm__SequenceType(soap, &a->wsrm__Sequence);
	if (a->wsrm__AckRequested)
	{	int i;
		for (i = 0; i < a->__sizeAckRequested; i++)
		{
			soap_embedded(soap, a->wsrm__AckRequested + i, SOAP_TYPE_wsrm__AckRequestedType);
			soap_serialize_wsrm__AckRequestedType(soap, a->wsrm__AckRequested + i);
		}
	}
	if (a->wsrm__SequenceAcknowledgement)
	{	int i;
		for (i = 0; i < a->__sizeSequenceAcknowledgement; i++)
		{
			soap_embedded(soap, a->wsrm__SequenceAcknowledgement + i, SOAP_TYPE__wsrm__SequenceAcknowledgement);
			soap_serialize__wsrm__SequenceAcknowledgement(soap, a->wsrm__SequenceAcknowledgement + i);
		}
	}
	soap_serialize_PointerTowsrm__SequenceFaultType(soap, &a->wsrm__SequenceFault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	if (soap_out__wsa5__MessageID(soap, "wsa5:MessageID", -1, &a->wsa5__MessageID, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa5__RelatesTo(soap, "wsa5:RelatesTo", -1, &a->wsa5__RelatesTo, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa5__From(soap, "wsa5:From", -1, &a->wsa5__From, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa5__ReplyTo(soap, "wsa5:ReplyTo", -1, &a->wsa5__ReplyTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa5__FaultTo(soap, "wsa5:FaultTo", -1, &a->wsa5__FaultTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa5__To(soap, "wsa5:To", -1, &a->wsa5__To, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa5__Action(soap, "wsa5:Action", -1, &a->wsa5__Action, ""))
		return soap->error;
	if (soap_out_PointerTowsrm__SequenceType(soap, "wsrm:Sequence", -1, &a->wsrm__Sequence, ""))
		return soap->error;
	if (a->wsrm__AckRequested)
	{	int i;
		for (i = 0; i < a->__sizeAckRequested; i++)
			if (soap_out_wsrm__AckRequestedType(soap, "wsrm:AckRequested", -1, a->wsrm__AckRequested + i, ""))
				return soap->error;
	}
	if (a->wsrm__SequenceAcknowledgement)
	{	int i;
		for (i = 0; i < a->__sizeSequenceAcknowledgement; i++)
			if (soap_out__wsrm__SequenceAcknowledgement(soap, "wsrm:SequenceAcknowledgement", -1, a->wsrm__SequenceAcknowledgement + i, ""))
				return soap->error;
	}
	if (soap_out_PointerTowsrm__SequenceFaultType(soap, "wsrm:SequenceFault", -1, &a->wsrm__SequenceFault, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	size_t soap_flag_wsa5__MessageID = 1;
	size_t soap_flag_wsa5__RelatesTo = 1;
	size_t soap_flag_wsa5__From = 1;
	size_t soap_flag_wsa5__ReplyTo = 1;
	size_t soap_flag_wsa5__FaultTo = 1;
	size_t soap_flag_wsa5__To = 1;
	size_t soap_flag_wsa5__Action = 1;
	size_t soap_flag_wsrm__Sequence = 1;
	struct soap_blist *soap_blist_wsrm__AckRequested = NULL;
	struct soap_blist *soap_blist_wsrm__SequenceAcknowledgement = NULL;
	size_t soap_flag_wsrm__SequenceFault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa5__MessageID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__wsa5__MessageID(soap, "wsa5:MessageID", &a->wsa5__MessageID, ""))
				{	soap_flag_wsa5__MessageID--;
					continue;
				}
			if (soap_flag_wsa5__RelatesTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__RelatesTo(soap, "wsa5:RelatesTo", &a->wsa5__RelatesTo, ""))
				{	soap_flag_wsa5__RelatesTo--;
					continue;
				}
			if (soap_flag_wsa5__From && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__From(soap, "wsa5:From", &a->wsa5__From, ""))
				{	soap_flag_wsa5__From--;
					continue;
				}
			if (soap_flag_wsa5__ReplyTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__ReplyTo(soap, "wsa5:ReplyTo", &a->wsa5__ReplyTo, ""))
				{	soap_flag_wsa5__ReplyTo--;
					continue;
				}
			if (soap_flag_wsa5__FaultTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__FaultTo(soap, "wsa5:FaultTo", &a->wsa5__FaultTo, ""))
				{	soap_flag_wsa5__FaultTo--;
					continue;
				}
			if (soap_flag_wsa5__To && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__wsa5__To(soap, "wsa5:To", &a->wsa5__To, ""))
				{	soap_flag_wsa5__To--;
					continue;
				}
			if (soap_flag_wsa5__Action && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__wsa5__Action(soap, "wsa5:Action", &a->wsa5__Action, ""))
				{	soap_flag_wsa5__Action--;
					continue;
				}
			if (soap_flag_wsrm__Sequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__SequenceType(soap, "wsrm:Sequence", &a->wsrm__Sequence, "wsrm:SequenceType"))
				{	soap_flag_wsrm__Sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "wsrm:AckRequested", 1, NULL))
			{	if (a->wsrm__AckRequested == NULL)
				{	if (soap_blist_wsrm__AckRequested == NULL)
						soap_blist_wsrm__AckRequested = soap_new_block(soap);
					a->wsrm__AckRequested = (struct wsrm__AckRequestedType *)soap_push_block(soap, soap_blist_wsrm__AckRequested, sizeof(struct wsrm__AckRequestedType));
					if (a->wsrm__AckRequested == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->wsrm__AckRequested, struct wsrm__AckRequestedType);
					soap_default_wsrm__AckRequestedType(soap, a->wsrm__AckRequested);
				}
				soap_revert(soap);
				if (soap_in_wsrm__AckRequestedType(soap, "wsrm:AckRequested", a->wsrm__AckRequested, "wsrm:AckRequestedType"))
				{	a->__sizeAckRequested++;
					a->wsrm__AckRequested = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "wsrm:SequenceAcknowledgement", 1, NULL))
			{	if (a->wsrm__SequenceAcknowledgement == NULL)
				{	if (soap_blist_wsrm__SequenceAcknowledgement == NULL)
						soap_blist_wsrm__SequenceAcknowledgement = soap_new_block(soap);
					a->wsrm__SequenceAcknowledgement = (struct _wsrm__SequenceAcknowledgement *)soap_push_block(soap, soap_blist_wsrm__SequenceAcknowledgement, sizeof(struct _wsrm__SequenceAcknowledgement));
					if (a->wsrm__SequenceAcknowledgement == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->wsrm__SequenceAcknowledgement, struct _wsrm__SequenceAcknowledgement);
					soap_default__wsrm__SequenceAcknowledgement(soap, a->wsrm__SequenceAcknowledgement);
				}
				soap_revert(soap);
				if (soap_in__wsrm__SequenceAcknowledgement(soap, "wsrm:SequenceAcknowledgement", a->wsrm__SequenceAcknowledgement, ""))
				{	a->__sizeSequenceAcknowledgement++;
					a->wsrm__SequenceAcknowledgement = NULL;
					continue;
				}
			}
			if (soap_flag_wsrm__SequenceFault && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrm__SequenceFaultType(soap, "wsrm:SequenceFault", &a->wsrm__SequenceFault, "wsrm:SequenceFaultType"))
				{	soap_flag_wsrm__SequenceFault--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->wsrm__AckRequested)
			soap_pop_block(soap, soap_blist_wsrm__AckRequested);
		if (a->__sizeAckRequested)
			a->wsrm__AckRequested = (struct wsrm__AckRequestedType *)soap_save_block(soap, soap_blist_wsrm__AckRequested, NULL, 1);
		else
		{	a->wsrm__AckRequested = NULL;
			if (soap_blist_wsrm__AckRequested)
				soap_end_block(soap, soap_blist_wsrm__AckRequested);
		}
		if (a->wsrm__SequenceAcknowledgement)
			soap_pop_block(soap, soap_blist_wsrm__SequenceAcknowledgement);
		if (a->__sizeSequenceAcknowledgement)
			a->wsrm__SequenceAcknowledgement = (struct _wsrm__SequenceAcknowledgement *)soap_save_block(soap, soap_blist_wsrm__SequenceAcknowledgement, NULL, 1);
		else
		{	a->wsrm__SequenceAcknowledgement = NULL;
			if (soap_blist_wsrm__SequenceAcknowledgement)
				soap_end_block(soap, soap_blist_wsrm__SequenceAcknowledgement);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Header, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__ProblemActionType(struct soap *soap, struct wsa5__ProblemActionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Action);
	soap_default_string(soap, &a->SoapAction);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__ProblemActionType(struct soap *soap, const struct wsa5__ProblemActionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Action);
	soap_serialize_string(soap, &a->SoapAction);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__ProblemActionType(struct soap *soap, const char *tag, int id, const struct wsa5__ProblemActionType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__ProblemActionType), type))
		return soap->error;
	if (soap_out_string(soap, "wsa5:Action", -1, &a->Action, ""))
		return soap->error;
	if (soap_out_string(soap, "wsa5:SoapAction", -1, &a->SoapAction, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__ProblemActionType * SOAP_FMAC4 soap_in_wsa5__ProblemActionType(struct soap *soap, const char *tag, struct wsa5__ProblemActionType *a, const char *type)
{
	size_t soap_flag_Action = 1;
	size_t soap_flag_SoapAction = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__ProblemActionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__ProblemActionType, sizeof(struct wsa5__ProblemActionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__ProblemActionType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Action && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsa5:Action", &a->Action, "xsd:string"))
				{	soap_flag_Action--;
					continue;
				}
			if (soap_flag_SoapAction && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsa5:SoapAction", &a->SoapAction, "xsd:string"))
				{	soap_flag_SoapAction--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__ProblemActionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__ProblemActionType, 0, sizeof(struct wsa5__ProblemActionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__ProblemActionType(struct soap *soap, const struct wsa5__ProblemActionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__ProblemActionType);
	if (soap_out_wsa5__ProblemActionType(soap, tag?tag:"wsa5:ProblemActionType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__ProblemActionType * SOAP_FMAC4 soap_get_wsa5__ProblemActionType(struct soap *soap, struct wsa5__ProblemActionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__ProblemActionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsa5__ProblemActionType * SOAP_FMAC2 soap_instantiate_wsa5__ProblemActionType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsa5__ProblemActionType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsa5__ProblemActionType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsa5__ProblemActionType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsa5__ProblemActionType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsa5__ProblemActionType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsa5__ProblemActionType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsa5__ProblemActionType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsa5__ProblemActionType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsa5__ProblemActionType %p -> %p\n", q, p));
	*(struct wsa5__ProblemActionType*)p = *(struct wsa5__ProblemActionType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__RelatesToType(struct soap *soap, struct wsa5__RelatesToType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_wsa5__RelationshipTypeOpenEnum(soap, &a->RelationshipType);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__RelatesToType(struct soap *soap, const struct wsa5__RelatesToType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__RelatesToType(struct soap *soap, const char *tag, int id, const struct wsa5__RelatesToType *a, const char *type)
{
	if (a->RelationshipType)
		soap_set_attr(soap, "RelationshipType", a->RelationshipType, 1);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa5__RelatesToType * SOAP_FMAC4 soap_in_wsa5__RelatesToType(struct soap *soap, const char *tag, struct wsa5__RelatesToType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa5__RelatesToType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__RelatesToType, sizeof(struct wsa5__RelatesToType), soap->type, soap->arrayType)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa5__RelatesToType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "RelationshipType", 0), &a->RelationshipType, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, 0, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, "wsa5:RelatesToType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__RelatesToType(struct soap *soap, const struct wsa5__RelatesToType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__RelatesToType);
	if (soap_out_wsa5__RelatesToType(soap, tag?tag:"wsa5:RelatesToType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__RelatesToType * SOAP_FMAC4 soap_get_wsa5__RelatesToType(struct soap *soap, struct wsa5__RelatesToType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__RelatesToType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsa5__RelatesToType * SOAP_FMAC2 soap_instantiate_wsa5__RelatesToType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsa5__RelatesToType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsa5__RelatesToType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsa5__RelatesToType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsa5__RelatesToType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsa5__RelatesToType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsa5__RelatesToType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsa5__RelatesToType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsa5__RelatesToType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsa5__RelatesToType %p -> %p\n", q, p));
	*(struct wsa5__RelatesToType*)p = *(struct wsa5__RelatesToType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__MetadataType(struct soap *soap, const struct wsa5__MetadataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__MetadataType(struct soap *soap, const char *tag, int id, const struct wsa5__MetadataType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__MetadataType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__MetadataType * SOAP_FMAC4 soap_in_wsa5__MetadataType(struct soap *soap, const char *tag, struct wsa5__MetadataType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__MetadataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__MetadataType, sizeof(struct wsa5__MetadataType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__MetadataType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__MetadataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__MetadataType, 0, sizeof(struct wsa5__MetadataType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__MetadataType(struct soap *soap, const struct wsa5__MetadataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__MetadataType);
	if (soap_out_wsa5__MetadataType(soap, tag?tag:"wsa5:MetadataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__MetadataType * SOAP_FMAC4 soap_get_wsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__MetadataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsa5__MetadataType * SOAP_FMAC2 soap_instantiate_wsa5__MetadataType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsa5__MetadataType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsa5__MetadataType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsa5__MetadataType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsa5__MetadataType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsa5__MetadataType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsa5__MetadataType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsa5__MetadataType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsa5__MetadataType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsa5__MetadataType %p -> %p\n", q, p));
	*(struct wsa5__MetadataType*)p = *(struct wsa5__MetadataType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__ReferenceParametersType(struct soap *soap, const struct wsa5__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__ReferenceParametersType(struct soap *soap, const char *tag, int id, const struct wsa5__ReferenceParametersType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__ReferenceParametersType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType * SOAP_FMAC4 soap_in_wsa5__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa5__ReferenceParametersType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__ReferenceParametersType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__ReferenceParametersType, sizeof(struct wsa5__ReferenceParametersType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__ReferenceParametersType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__ReferenceParametersType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__ReferenceParametersType, 0, sizeof(struct wsa5__ReferenceParametersType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__ReferenceParametersType(struct soap *soap, const struct wsa5__ReferenceParametersType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__ReferenceParametersType);
	if (soap_out_wsa5__ReferenceParametersType(soap, tag?tag:"wsa5:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType * SOAP_FMAC4 soap_get_wsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsa5__ReferenceParametersType * SOAP_FMAC2 soap_instantiate_wsa5__ReferenceParametersType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsa5__ReferenceParametersType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsa5__ReferenceParametersType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsa5__ReferenceParametersType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsa5__ReferenceParametersType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsa5__ReferenceParametersType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsa5__ReferenceParametersType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsa5__ReferenceParametersType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsa5__ReferenceParametersType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsa5__ReferenceParametersType %p -> %p\n", q, p));
	*(struct wsa5__ReferenceParametersType*)p = *(struct wsa5__ReferenceParametersType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__EndpointReferenceType(struct soap *soap, struct wsa5__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Address);
	a->ReferenceParameters = NULL;
	a->Metadata = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__EndpointReferenceType(struct soap *soap, const struct wsa5__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Address);
	soap_serialize_PointerTowsa5__ReferenceParametersType(soap, &a->ReferenceParameters);
	soap_serialize_PointerTowsa5__MetadataType(soap, &a->Metadata);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__EndpointReferenceType(struct soap *soap, const char *tag, int id, const struct wsa5__EndpointReferenceType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__EndpointReferenceType), type))
		return soap->error;
	if (a->Address)
	{	if (soap_out_string(soap, "wsa5:Address", -1, &a->Address, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "wsa5:Address"))
		return soap->error;
	if (soap_out_PointerTowsa5__ReferenceParametersType(soap, "wsa5:ReferenceParameters", -1, &a->ReferenceParameters, ""))
		return soap->error;
	if (soap_out_PointerTowsa5__MetadataType(soap, "wsa5:Metadata", -1, &a->Metadata, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType * SOAP_FMAC4 soap_in_wsa5__EndpointReferenceType(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType *a, const char *type)
{
	size_t soap_flag_Address = 1;
	size_t soap_flag_ReferenceParameters = 1;
	size_t soap_flag_Metadata = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__EndpointReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__EndpointReferenceType, sizeof(struct wsa5__EndpointReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__EndpointReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsa5:Address", &a->Address, "xsd:string"))
				{	soap_flag_Address--;
					continue;
				}
			if (soap_flag_ReferenceParameters && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa5__ReferenceParametersType(soap, "wsa5:ReferenceParameters", &a->ReferenceParameters, "wsa5:ReferenceParametersType"))
				{	soap_flag_ReferenceParameters--;
					continue;
				}
			if (soap_flag_Metadata && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa5__MetadataType(soap, "wsa5:Metadata", &a->Metadata, "wsa5:MetadataType"))
				{	soap_flag_Metadata--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__EndpointReferenceType, 0, sizeof(struct wsa5__EndpointReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Address > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__EndpointReferenceType(struct soap *soap, const struct wsa5__EndpointReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__EndpointReferenceType);
	if (soap_out_wsa5__EndpointReferenceType(soap, tag?tag:"wsa5:EndpointReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType * SOAP_FMAC4 soap_get_wsa5__EndpointReferenceType(struct soap *soap, struct wsa5__EndpointReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsa5__EndpointReferenceType * SOAP_FMAC2 soap_instantiate_wsa5__EndpointReferenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsa5__EndpointReferenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsa5__EndpointReferenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsa5__EndpointReferenceType);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct wsa5__EndpointReferenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsa5__EndpointReferenceType, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct wsa5__EndpointReferenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct wsa5__EndpointReferenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsa5__EndpointReferenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsa5__EndpointReferenceType %p -> %p\n", q, p));
	*(struct wsa5__EndpointReferenceType*)p = *(struct wsa5__EndpointReferenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Equation(struct soap *soap, struct __tempuri__Equation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__Equation = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Equation(struct soap *soap, const struct __tempuri__Equation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__Equation(soap, &a->mssadh__Equation);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Equation(struct soap *soap, const char *tag, int id, const struct __tempuri__Equation *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__Equation(soap, "mssadh:Equation", -1, &a->mssadh__Equation, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Equation * SOAP_FMAC4 soap_in___tempuri__Equation(struct soap *soap, const char *tag, struct __tempuri__Equation *a, const char *type)
{
	size_t soap_flag_mssadh__Equation = 1;
	short soap_flag;
	a = (struct __tempuri__Equation *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Equation, sizeof(struct __tempuri__Equation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Equation(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__Equation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__Equation(soap, "mssadh:Equation", &a->mssadh__Equation, ""))
				{	soap_flag_mssadh__Equation--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Equation(struct soap *soap, const struct __tempuri__Equation *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Equation(soap, tag?tag:"-tempuri:Equation", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Equation * SOAP_FMAC4 soap_get___tempuri__Equation(struct soap *soap, struct __tempuri__Equation *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Equation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Equation * SOAP_FMAC2 soap_instantiate___tempuri__Equation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Equation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Equation, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Equation);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__Equation);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Equation, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__Equation);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__Equation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Equation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Equation %p -> %p\n", q, p));
	*(struct __tempuri__Equation*)p = *(struct __tempuri__Equation*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Result(struct soap *soap, struct __tempuri__Result *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__Result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Result(struct soap *soap, const struct __tempuri__Result *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__Result(soap, &a->mssadh__Result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Result(struct soap *soap, const char *tag, int id, const struct __tempuri__Result *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__Result(soap, "mssadh:Result", -1, &a->mssadh__Result, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Result * SOAP_FMAC4 soap_in___tempuri__Result(struct soap *soap, const char *tag, struct __tempuri__Result *a, const char *type)
{
	size_t soap_flag_mssadh__Result = 1;
	short soap_flag;
	a = (struct __tempuri__Result *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Result, sizeof(struct __tempuri__Result), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Result(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__Result(soap, "mssadh:Result", &a->mssadh__Result, ""))
				{	soap_flag_mssadh__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Result(struct soap *soap, const struct __tempuri__Result *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Result(soap, tag?tag:"-tempuri:Result", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Result * SOAP_FMAC4 soap_get___tempuri__Result(struct soap *soap, struct __tempuri__Result *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Result(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Result * SOAP_FMAC2 soap_instantiate___tempuri__Result(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Result(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Result, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Result);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__Result);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Result, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__Result);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__Result*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Result(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Result %p -> %p\n", q, p));
	*(struct __tempuri__Result*)p = *(struct __tempuri__Result*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__DivideBy(struct soap *soap, struct __tempuri__DivideBy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__DivideBy = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__DivideBy(struct soap *soap, const struct __tempuri__DivideBy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__DivideBy(soap, &a->mssadh__DivideBy);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__DivideBy(struct soap *soap, const char *tag, int id, const struct __tempuri__DivideBy *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__DivideBy(soap, "mssadh:DivideBy", -1, &a->mssadh__DivideBy, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__DivideBy * SOAP_FMAC4 soap_in___tempuri__DivideBy(struct soap *soap, const char *tag, struct __tempuri__DivideBy *a, const char *type)
{
	size_t soap_flag_mssadh__DivideBy = 1;
	short soap_flag;
	a = (struct __tempuri__DivideBy *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__DivideBy, sizeof(struct __tempuri__DivideBy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__DivideBy(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__DivideBy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__DivideBy(soap, "mssadh:DivideBy", &a->mssadh__DivideBy, ""))
				{	soap_flag_mssadh__DivideBy--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__DivideBy(struct soap *soap, const struct __tempuri__DivideBy *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__DivideBy(soap, tag?tag:"-tempuri:DivideBy", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__DivideBy * SOAP_FMAC4 soap_get___tempuri__DivideBy(struct soap *soap, struct __tempuri__DivideBy *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__DivideBy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__DivideBy * SOAP_FMAC2 soap_instantiate___tempuri__DivideBy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__DivideBy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__DivideBy, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__DivideBy);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__DivideBy);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__DivideBy, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__DivideBy);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__DivideBy*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__DivideBy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__DivideBy %p -> %p\n", q, p));
	*(struct __tempuri__DivideBy*)p = *(struct __tempuri__DivideBy*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__MultiplyBy(struct soap *soap, struct __tempuri__MultiplyBy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__MultiplyBy = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__MultiplyBy(struct soap *soap, const struct __tempuri__MultiplyBy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__MultiplyBy(soap, &a->mssadh__MultiplyBy);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__MultiplyBy(struct soap *soap, const char *tag, int id, const struct __tempuri__MultiplyBy *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__MultiplyBy(soap, "mssadh:MultiplyBy", -1, &a->mssadh__MultiplyBy, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__MultiplyBy * SOAP_FMAC4 soap_in___tempuri__MultiplyBy(struct soap *soap, const char *tag, struct __tempuri__MultiplyBy *a, const char *type)
{
	size_t soap_flag_mssadh__MultiplyBy = 1;
	short soap_flag;
	a = (struct __tempuri__MultiplyBy *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__MultiplyBy, sizeof(struct __tempuri__MultiplyBy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__MultiplyBy(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__MultiplyBy && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__MultiplyBy(soap, "mssadh:MultiplyBy", &a->mssadh__MultiplyBy, ""))
				{	soap_flag_mssadh__MultiplyBy--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__MultiplyBy(struct soap *soap, const struct __tempuri__MultiplyBy *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__MultiplyBy(soap, tag?tag:"-tempuri:MultiplyBy", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__MultiplyBy * SOAP_FMAC4 soap_get___tempuri__MultiplyBy(struct soap *soap, struct __tempuri__MultiplyBy *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__MultiplyBy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__MultiplyBy * SOAP_FMAC2 soap_instantiate___tempuri__MultiplyBy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__MultiplyBy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__MultiplyBy, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__MultiplyBy);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__MultiplyBy);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__MultiplyBy, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__MultiplyBy);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__MultiplyBy*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__MultiplyBy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__MultiplyBy %p -> %p\n", q, p));
	*(struct __tempuri__MultiplyBy*)p = *(struct __tempuri__MultiplyBy*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__SubtractFrom(struct soap *soap, struct __tempuri__SubtractFrom *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__SubtractFrom = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__SubtractFrom(struct soap *soap, const struct __tempuri__SubtractFrom *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__SubtractFrom(soap, &a->mssadh__SubtractFrom);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__SubtractFrom(struct soap *soap, const char *tag, int id, const struct __tempuri__SubtractFrom *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__SubtractFrom(soap, "mssadh:SubtractFrom", -1, &a->mssadh__SubtractFrom, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__SubtractFrom * SOAP_FMAC4 soap_in___tempuri__SubtractFrom(struct soap *soap, const char *tag, struct __tempuri__SubtractFrom *a, const char *type)
{
	size_t soap_flag_mssadh__SubtractFrom = 1;
	short soap_flag;
	a = (struct __tempuri__SubtractFrom *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__SubtractFrom, sizeof(struct __tempuri__SubtractFrom), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__SubtractFrom(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__SubtractFrom && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__SubtractFrom(soap, "mssadh:SubtractFrom", &a->mssadh__SubtractFrom, ""))
				{	soap_flag_mssadh__SubtractFrom--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__SubtractFrom(struct soap *soap, const struct __tempuri__SubtractFrom *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__SubtractFrom(soap, tag?tag:"-tempuri:SubtractFrom", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__SubtractFrom * SOAP_FMAC4 soap_get___tempuri__SubtractFrom(struct soap *soap, struct __tempuri__SubtractFrom *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__SubtractFrom(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__SubtractFrom * SOAP_FMAC2 soap_instantiate___tempuri__SubtractFrom(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__SubtractFrom(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__SubtractFrom, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__SubtractFrom);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__SubtractFrom);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__SubtractFrom, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__SubtractFrom);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__SubtractFrom*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__SubtractFrom(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__SubtractFrom %p -> %p\n", q, p));
	*(struct __tempuri__SubtractFrom*)p = *(struct __tempuri__SubtractFrom*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__AddTo(struct soap *soap, struct __tempuri__AddTo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__AddTo = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__AddTo(struct soap *soap, const struct __tempuri__AddTo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__AddTo(soap, &a->mssadh__AddTo);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__AddTo(struct soap *soap, const char *tag, int id, const struct __tempuri__AddTo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__AddTo(soap, "mssadh:AddTo", -1, &a->mssadh__AddTo, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__AddTo * SOAP_FMAC4 soap_in___tempuri__AddTo(struct soap *soap, const char *tag, struct __tempuri__AddTo *a, const char *type)
{
	size_t soap_flag_mssadh__AddTo = 1;
	short soap_flag;
	a = (struct __tempuri__AddTo *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__AddTo, sizeof(struct __tempuri__AddTo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__AddTo(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__AddTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__AddTo(soap, "mssadh:AddTo", &a->mssadh__AddTo, ""))
				{	soap_flag_mssadh__AddTo--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__AddTo(struct soap *soap, const struct __tempuri__AddTo *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__AddTo(soap, tag?tag:"-tempuri:AddTo", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__AddTo * SOAP_FMAC4 soap_get___tempuri__AddTo(struct soap *soap, struct __tempuri__AddTo *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__AddTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__AddTo * SOAP_FMAC2 soap_instantiate___tempuri__AddTo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__AddTo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__AddTo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__AddTo);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__AddTo);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__AddTo, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__AddTo);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__AddTo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__AddTo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__AddTo %p -> %p\n", q, p));
	*(struct __tempuri__AddTo*)p = *(struct __tempuri__AddTo*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Clear(struct soap *soap, struct __tempuri__Clear *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssadh__Clear = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Clear(struct soap *soap, const struct __tempuri__Clear *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssadh__Clear(soap, &a->mssadh__Clear);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Clear(struct soap *soap, const char *tag, int id, const struct __tempuri__Clear *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssadh__Clear(soap, "mssadh:Clear", -1, &a->mssadh__Clear, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Clear * SOAP_FMAC4 soap_in___tempuri__Clear(struct soap *soap, const char *tag, struct __tempuri__Clear *a, const char *type)
{
	size_t soap_flag_mssadh__Clear = 1;
	short soap_flag;
	a = (struct __tempuri__Clear *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Clear, sizeof(struct __tempuri__Clear), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Clear(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssadh__Clear && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssadh__Clear(soap, "mssadh:Clear", &a->mssadh__Clear, ""))
				{	soap_flag_mssadh__Clear--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Clear(struct soap *soap, const struct __tempuri__Clear *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Clear(soap, tag?tag:"-tempuri:Clear", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Clear * SOAP_FMAC4 soap_get___tempuri__Clear(struct soap *soap, struct __tempuri__Clear *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Clear(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Clear * SOAP_FMAC2 soap_instantiate___tempuri__Clear(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Clear(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Clear, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Clear);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = sizeof(struct __tempuri__Clear);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Clear, n);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __tempuri__Clear);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __tempuri__Clear*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Clear(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Clear %p -> %p\n", q, p));
	*(struct __tempuri__Clear*)p = *(struct __tempuri__Clear*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__TerminateSequenceResponseType(struct soap *soap, struct wsrm__TerminateSequenceResponseType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__TerminateSequenceResponseType))
		soap_serialize_wsrm__TerminateSequenceResponseType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__TerminateSequenceResponseType(struct soap *soap, const char *tag, int id, struct wsrm__TerminateSequenceResponseType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__TerminateSequenceResponseType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__TerminateSequenceResponseType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceResponseType ** SOAP_FMAC4 soap_in_PointerTowsrm__TerminateSequenceResponseType(struct soap *soap, const char *tag, struct wsrm__TerminateSequenceResponseType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__TerminateSequenceResponseType **)soap_malloc(soap, sizeof(struct wsrm__TerminateSequenceResponseType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__TerminateSequenceResponseType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__TerminateSequenceResponseType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__TerminateSequenceResponseType, sizeof(struct wsrm__TerminateSequenceResponseType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__TerminateSequenceResponseType(struct soap *soap, struct wsrm__TerminateSequenceResponseType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__TerminateSequenceResponseType);
	if (soap_out_PointerTowsrm__TerminateSequenceResponseType(soap, tag?tag:"wsrm:TerminateSequenceResponseType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceResponseType ** SOAP_FMAC4 soap_get_PointerTowsrm__TerminateSequenceResponseType(struct soap *soap, struct wsrm__TerminateSequenceResponseType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__TerminateSequenceResponseType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__TerminateSequenceType(struct soap *soap, struct wsrm__TerminateSequenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__TerminateSequenceType))
		soap_serialize_wsrm__TerminateSequenceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__TerminateSequenceType(struct soap *soap, const char *tag, int id, struct wsrm__TerminateSequenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__TerminateSequenceType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__TerminateSequenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceType ** SOAP_FMAC4 soap_in_PointerTowsrm__TerminateSequenceType(struct soap *soap, const char *tag, struct wsrm__TerminateSequenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__TerminateSequenceType **)soap_malloc(soap, sizeof(struct wsrm__TerminateSequenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__TerminateSequenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__TerminateSequenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__TerminateSequenceType, sizeof(struct wsrm__TerminateSequenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__TerminateSequenceType(struct soap *soap, struct wsrm__TerminateSequenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__TerminateSequenceType);
	if (soap_out_PointerTowsrm__TerminateSequenceType(soap, tag?tag:"wsrm:TerminateSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__TerminateSequenceType ** SOAP_FMAC4 soap_get_PointerTowsrm__TerminateSequenceType(struct soap *soap, struct wsrm__TerminateSequenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__TerminateSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__CloseSequenceResponseType(struct soap *soap, struct wsrm__CloseSequenceResponseType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__CloseSequenceResponseType))
		soap_serialize_wsrm__CloseSequenceResponseType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__CloseSequenceResponseType(struct soap *soap, const char *tag, int id, struct wsrm__CloseSequenceResponseType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__CloseSequenceResponseType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__CloseSequenceResponseType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__CloseSequenceResponseType ** SOAP_FMAC4 soap_in_PointerTowsrm__CloseSequenceResponseType(struct soap *soap, const char *tag, struct wsrm__CloseSequenceResponseType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__CloseSequenceResponseType **)soap_malloc(soap, sizeof(struct wsrm__CloseSequenceResponseType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__CloseSequenceResponseType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__CloseSequenceResponseType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__CloseSequenceResponseType, sizeof(struct wsrm__CloseSequenceResponseType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__CloseSequenceResponseType(struct soap *soap, struct wsrm__CloseSequenceResponseType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__CloseSequenceResponseType);
	if (soap_out_PointerTowsrm__CloseSequenceResponseType(soap, tag?tag:"wsrm:CloseSequenceResponseType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CloseSequenceResponseType ** SOAP_FMAC4 soap_get_PointerTowsrm__CloseSequenceResponseType(struct soap *soap, struct wsrm__CloseSequenceResponseType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__CloseSequenceResponseType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__CloseSequenceType(struct soap *soap, struct wsrm__CloseSequenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__CloseSequenceType))
		soap_serialize_wsrm__CloseSequenceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__CloseSequenceType(struct soap *soap, const char *tag, int id, struct wsrm__CloseSequenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__CloseSequenceType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__CloseSequenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__CloseSequenceType ** SOAP_FMAC4 soap_in_PointerTowsrm__CloseSequenceType(struct soap *soap, const char *tag, struct wsrm__CloseSequenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__CloseSequenceType **)soap_malloc(soap, sizeof(struct wsrm__CloseSequenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__CloseSequenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__CloseSequenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__CloseSequenceType, sizeof(struct wsrm__CloseSequenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__CloseSequenceType(struct soap *soap, struct wsrm__CloseSequenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__CloseSequenceType);
	if (soap_out_PointerTowsrm__CloseSequenceType(soap, tag?tag:"wsrm:CloseSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CloseSequenceType ** SOAP_FMAC4 soap_get_PointerTowsrm__CloseSequenceType(struct soap *soap, struct wsrm__CloseSequenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__CloseSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__CreateSequenceResponseType(struct soap *soap, struct wsrm__CreateSequenceResponseType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__CreateSequenceResponseType))
		soap_serialize_wsrm__CreateSequenceResponseType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__CreateSequenceResponseType(struct soap *soap, const char *tag, int id, struct wsrm__CreateSequenceResponseType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__CreateSequenceResponseType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__CreateSequenceResponseType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__CreateSequenceResponseType ** SOAP_FMAC4 soap_in_PointerTowsrm__CreateSequenceResponseType(struct soap *soap, const char *tag, struct wsrm__CreateSequenceResponseType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__CreateSequenceResponseType **)soap_malloc(soap, sizeof(struct wsrm__CreateSequenceResponseType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__CreateSequenceResponseType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__CreateSequenceResponseType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__CreateSequenceResponseType, sizeof(struct wsrm__CreateSequenceResponseType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__CreateSequenceResponseType(struct soap *soap, struct wsrm__CreateSequenceResponseType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__CreateSequenceResponseType);
	if (soap_out_PointerTowsrm__CreateSequenceResponseType(soap, tag?tag:"wsrm:CreateSequenceResponseType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CreateSequenceResponseType ** SOAP_FMAC4 soap_get_PointerTowsrm__CreateSequenceResponseType(struct soap *soap, struct wsrm__CreateSequenceResponseType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__CreateSequenceResponseType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__CreateSequenceType(struct soap *soap, struct wsrm__CreateSequenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__CreateSequenceType))
		soap_serialize_wsrm__CreateSequenceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__CreateSequenceType(struct soap *soap, const char *tag, int id, struct wsrm__CreateSequenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__CreateSequenceType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__CreateSequenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__CreateSequenceType ** SOAP_FMAC4 soap_in_PointerTowsrm__CreateSequenceType(struct soap *soap, const char *tag, struct wsrm__CreateSequenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__CreateSequenceType **)soap_malloc(soap, sizeof(struct wsrm__CreateSequenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__CreateSequenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__CreateSequenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__CreateSequenceType, sizeof(struct wsrm__CreateSequenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__CreateSequenceType(struct soap *soap, struct wsrm__CreateSequenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__CreateSequenceType);
	if (soap_out_PointerTowsrm__CreateSequenceType(soap, tag?tag:"wsrm:CreateSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__CreateSequenceType ** SOAP_FMAC4 soap_get_PointerTowsrm__CreateSequenceType(struct soap *soap, struct wsrm__CreateSequenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__CreateSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__SequenceFaultType(struct soap *soap, struct wsrm__SequenceFaultType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__SequenceFaultType))
		soap_serialize_wsrm__SequenceFaultType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__SequenceFaultType(struct soap *soap, const char *tag, int id, struct wsrm__SequenceFaultType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__SequenceFaultType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__SequenceFaultType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__SequenceFaultType ** SOAP_FMAC4 soap_in_PointerTowsrm__SequenceFaultType(struct soap *soap, const char *tag, struct wsrm__SequenceFaultType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__SequenceFaultType **)soap_malloc(soap, sizeof(struct wsrm__SequenceFaultType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__SequenceFaultType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__SequenceFaultType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__SequenceFaultType, sizeof(struct wsrm__SequenceFaultType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__SequenceFaultType(struct soap *soap, struct wsrm__SequenceFaultType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__SequenceFaultType);
	if (soap_out_PointerTowsrm__SequenceFaultType(soap, tag?tag:"wsrm:SequenceFaultType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__SequenceFaultType ** SOAP_FMAC4 soap_get_PointerTowsrm__SequenceFaultType(struct soap *soap, struct wsrm__SequenceFaultType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__SequenceFaultType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsrm__SequenceAcknowledgement(struct soap *soap, struct _wsrm__SequenceAcknowledgement *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsrm__SequenceAcknowledgement))
		soap_serialize__wsrm__SequenceAcknowledgement(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsrm__SequenceAcknowledgement(struct soap *soap, const char *tag, int id, struct _wsrm__SequenceAcknowledgement *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsrm__SequenceAcknowledgement);
	if (id < 0)
		return soap->error;
	return soap_out__wsrm__SequenceAcknowledgement(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement ** SOAP_FMAC4 soap_in_PointerTo_wsrm__SequenceAcknowledgement(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsrm__SequenceAcknowledgement **)soap_malloc(soap, sizeof(struct _wsrm__SequenceAcknowledgement *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsrm__SequenceAcknowledgement(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsrm__SequenceAcknowledgement, sizeof(struct _wsrm__SequenceAcknowledgement), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsrm__SequenceAcknowledgement(struct soap *soap, struct _wsrm__SequenceAcknowledgement *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement);
	if (soap_out_PointerTo_wsrm__SequenceAcknowledgement(soap, tag?tag:"wsrm:SequenceAcknowledgement", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement ** SOAP_FMAC4 soap_get_PointerTo_wsrm__SequenceAcknowledgement(struct soap *soap, struct _wsrm__SequenceAcknowledgement **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsrm__SequenceAcknowledgement(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__AckRequestedType(struct soap *soap, struct wsrm__AckRequestedType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__AckRequestedType))
		soap_serialize_wsrm__AckRequestedType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__AckRequestedType(struct soap *soap, const char *tag, int id, struct wsrm__AckRequestedType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__AckRequestedType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__AckRequestedType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__AckRequestedType ** SOAP_FMAC4 soap_in_PointerTowsrm__AckRequestedType(struct soap *soap, const char *tag, struct wsrm__AckRequestedType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__AckRequestedType **)soap_malloc(soap, sizeof(struct wsrm__AckRequestedType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__AckRequestedType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__AckRequestedType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__AckRequestedType, sizeof(struct wsrm__AckRequestedType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__AckRequestedType(struct soap *soap, struct wsrm__AckRequestedType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__AckRequestedType);
	if (soap_out_PointerTowsrm__AckRequestedType(soap, tag?tag:"wsrm:AckRequestedType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__AckRequestedType ** SOAP_FMAC4 soap_get_PointerTowsrm__AckRequestedType(struct soap *soap, struct wsrm__AckRequestedType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__AckRequestedType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__SequenceType(struct soap *soap, struct wsrm__SequenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__SequenceType))
		soap_serialize_wsrm__SequenceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__SequenceType(struct soap *soap, const char *tag, int id, struct wsrm__SequenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__SequenceType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__SequenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__SequenceType ** SOAP_FMAC4 soap_in_PointerTowsrm__SequenceType(struct soap *soap, const char *tag, struct wsrm__SequenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__SequenceType **)soap_malloc(soap, sizeof(struct wsrm__SequenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__SequenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__SequenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__SequenceType, sizeof(struct wsrm__SequenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__SequenceType(struct soap *soap, struct wsrm__SequenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__SequenceType);
	if (soap_out_PointerTowsrm__SequenceType(soap, tag?tag:"wsrm:SequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__SequenceType ** SOAP_FMAC4 soap_get_PointerTowsrm__SequenceType(struct soap *soap, struct wsrm__SequenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__SequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_None(struct soap *soap, struct _wsrm__SequenceAcknowledgement_None *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsrm__SequenceAcknowledgement_None))
		soap_serialize__wsrm__SequenceAcknowledgement_None(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsrm__SequenceAcknowledgement_None(struct soap *soap, const char *tag, int id, struct _wsrm__SequenceAcknowledgement_None *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsrm__SequenceAcknowledgement_None);
	if (id < 0)
		return soap->error;
	return soap_out__wsrm__SequenceAcknowledgement_None(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_None ** SOAP_FMAC4 soap_in_PointerTo_wsrm__SequenceAcknowledgement_None(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement_None **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsrm__SequenceAcknowledgement_None **)soap_malloc(soap, sizeof(struct _wsrm__SequenceAcknowledgement_None *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsrm__SequenceAcknowledgement_None(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement_None **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsrm__SequenceAcknowledgement_None, sizeof(struct _wsrm__SequenceAcknowledgement_None), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsrm__SequenceAcknowledgement_None(struct soap *soap, struct _wsrm__SequenceAcknowledgement_None *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_None);
	if (soap_out_PointerTo_wsrm__SequenceAcknowledgement_None(soap, tag?tag:"wsrm:SequenceAcknowledgement-None", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_None ** SOAP_FMAC4 soap_get_PointerTo_wsrm__SequenceAcknowledgement_None(struct soap *soap, struct _wsrm__SequenceAcknowledgement_None **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsrm__SequenceAcknowledgement_None(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange))
		soap_serialize__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, const char *tag, int id, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange);
	if (id < 0)
		return soap->error;
	return soap_out__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_AcknowledgementRange ** SOAP_FMAC4 soap_in_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange **)soap_malloc(soap, sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement_AcknowledgementRange **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsrm__SequenceAcknowledgement_AcknowledgementRange, sizeof(struct _wsrm__SequenceAcknowledgement_AcknowledgementRange), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange);
	if (soap_out_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag?tag:"wsrm:SequenceAcknowledgement-AcknowledgementRange", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_AcknowledgementRange ** SOAP_FMAC4 soap_get_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(struct soap *soap, struct _wsrm__SequenceAcknowledgement_AcknowledgementRange **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsrm__SequenceAcknowledgement_AcknowledgementRange(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsrm__SequenceAcknowledgement_Final(struct soap *soap, struct _wsrm__SequenceAcknowledgement_Final *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final))
		soap_serialize__wsrm__SequenceAcknowledgement_Final(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsrm__SequenceAcknowledgement_Final(struct soap *soap, const char *tag, int id, struct _wsrm__SequenceAcknowledgement_Final *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final);
	if (id < 0)
		return soap->error;
	return soap_out__wsrm__SequenceAcknowledgement_Final(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_Final ** SOAP_FMAC4 soap_in_PointerTo_wsrm__SequenceAcknowledgement_Final(struct soap *soap, const char *tag, struct _wsrm__SequenceAcknowledgement_Final **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsrm__SequenceAcknowledgement_Final **)soap_malloc(soap, sizeof(struct _wsrm__SequenceAcknowledgement_Final *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsrm__SequenceAcknowledgement_Final(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsrm__SequenceAcknowledgement_Final **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsrm__SequenceAcknowledgement_Final, sizeof(struct _wsrm__SequenceAcknowledgement_Final), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsrm__SequenceAcknowledgement_Final(struct soap *soap, struct _wsrm__SequenceAcknowledgement_Final *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsrm__SequenceAcknowledgement_Final);
	if (soap_out_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, tag?tag:"wsrm:SequenceAcknowledgement-Final", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__SequenceAcknowledgement_Final ** SOAP_FMAC4 soap_get_PointerTo_wsrm__SequenceAcknowledgement_Final(struct soap *soap, struct _wsrm__SequenceAcknowledgement_Final **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsrm__SequenceAcknowledgement_Final(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedLONG64(struct soap *soap, ULONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedLONG64(struct soap *soap, const char *tag, int id, ULONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedLONG64);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedLONG64(soap, tag, id, *a, type);
}

SOAP_FMAC3 ULONG64 ** SOAP_FMAC4 soap_in_PointerTounsignedLONG64(struct soap *soap, const char *tag, ULONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ULONG64 **)soap_malloc(soap, sizeof(ULONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedLONG64(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (ULONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedLONG64, sizeof(ULONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedLONG64(struct soap *soap, ULONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedLONG64);
	if (soap_out_PointerTounsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 ** SOAP_FMAC4 soap_get_PointerTounsignedLONG64(struct soap *soap, ULONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__AcceptType(struct soap *soap, struct wsrm__AcceptType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__AcceptType))
		soap_serialize_wsrm__AcceptType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__AcceptType(struct soap *soap, const char *tag, int id, struct wsrm__AcceptType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__AcceptType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__AcceptType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__AcceptType ** SOAP_FMAC4 soap_in_PointerTowsrm__AcceptType(struct soap *soap, const char *tag, struct wsrm__AcceptType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__AcceptType **)soap_malloc(soap, sizeof(struct wsrm__AcceptType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__AcceptType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__AcceptType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__AcceptType, sizeof(struct wsrm__AcceptType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__AcceptType(struct soap *soap, struct wsrm__AcceptType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__AcceptType);
	if (soap_out_PointerTowsrm__AcceptType(soap, tag?tag:"wsrm:AcceptType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__AcceptType ** SOAP_FMAC4 soap_get_PointerTowsrm__AcceptType(struct soap *soap, struct wsrm__AcceptType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__AcceptType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__IncompleteSequenceBehaviorType(struct soap *soap, enum wsrm__IncompleteSequenceBehaviorType *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__IncompleteSequenceBehaviorType(struct soap *soap, const char *tag, int id, enum wsrm__IncompleteSequenceBehaviorType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__IncompleteSequenceBehaviorType(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum wsrm__IncompleteSequenceBehaviorType ** SOAP_FMAC4 soap_in_PointerTowsrm__IncompleteSequenceBehaviorType(struct soap *soap, const char *tag, enum wsrm__IncompleteSequenceBehaviorType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (enum wsrm__IncompleteSequenceBehaviorType **)soap_malloc(soap, sizeof(enum wsrm__IncompleteSequenceBehaviorType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__IncompleteSequenceBehaviorType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum wsrm__IncompleteSequenceBehaviorType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__IncompleteSequenceBehaviorType, sizeof(enum wsrm__IncompleteSequenceBehaviorType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__IncompleteSequenceBehaviorType(struct soap *soap, enum wsrm__IncompleteSequenceBehaviorType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__IncompleteSequenceBehaviorType);
	if (soap_out_PointerTowsrm__IncompleteSequenceBehaviorType(soap, tag?tag:"wsrm:IncompleteSequenceBehaviorType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsrm__IncompleteSequenceBehaviorType ** SOAP_FMAC4 soap_get_PointerTowsrm__IncompleteSequenceBehaviorType(struct soap *soap, enum wsrm__IncompleteSequenceBehaviorType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__IncompleteSequenceBehaviorType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrm__OfferType(struct soap *soap, struct wsrm__OfferType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrm__OfferType))
		soap_serialize_wsrm__OfferType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrm__OfferType(struct soap *soap, const char *tag, int id, struct wsrm__OfferType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrm__OfferType);
	if (id < 0)
		return soap->error;
	return soap_out_wsrm__OfferType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsrm__OfferType ** SOAP_FMAC4 soap_in_PointerTowsrm__OfferType(struct soap *soap, const char *tag, struct wsrm__OfferType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsrm__OfferType **)soap_malloc(soap, sizeof(struct wsrm__OfferType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsrm__OfferType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsrm__OfferType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrm__OfferType, sizeof(struct wsrm__OfferType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrm__OfferType(struct soap *soap, struct wsrm__OfferType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrm__OfferType);
	if (soap_out_PointerTowsrm__OfferType(soap, tag?tag:"wsrm:OfferType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsrm__OfferType ** SOAP_FMAC4 soap_get_PointerTowsrm__OfferType(struct soap *soap, struct wsrm__OfferType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrm__OfferType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__duration(struct soap *soap, LONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xsd__duration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__duration(struct soap *soap, const char *tag, int id, LONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__duration);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__duration(soap, tag, id, *a, type);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_in_PointerToxsd__duration(struct soap *soap, const char *tag, LONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (LONG64 **)soap_malloc(soap, sizeof(LONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__duration(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (LONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__duration, sizeof(LONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__duration(struct soap *soap, LONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__duration);
	if (soap_out_PointerToxsd__duration(soap, tag?tag:"xsd:duration", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_get_PointerToxsd__duration(struct soap *soap, LONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__duration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsrm__UsesSequenceSSL(struct soap *soap, struct _wsrm__UsesSequenceSSL *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsrm__UsesSequenceSSL))
		soap_serialize__wsrm__UsesSequenceSSL(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsrm__UsesSequenceSSL(struct soap *soap, const char *tag, int id, struct _wsrm__UsesSequenceSSL *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsrm__UsesSequenceSSL);
	if (id < 0)
		return soap->error;
	return soap_out__wsrm__UsesSequenceSSL(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsrm__UsesSequenceSSL ** SOAP_FMAC4 soap_in_PointerTo_wsrm__UsesSequenceSSL(struct soap *soap, const char *tag, struct _wsrm__UsesSequenceSSL **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsrm__UsesSequenceSSL **)soap_malloc(soap, sizeof(struct _wsrm__UsesSequenceSSL *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsrm__UsesSequenceSSL(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsrm__UsesSequenceSSL **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsrm__UsesSequenceSSL, sizeof(struct _wsrm__UsesSequenceSSL), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsrm__UsesSequenceSSL(struct soap *soap, struct _wsrm__UsesSequenceSSL *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsrm__UsesSequenceSSL);
	if (soap_out_PointerTo_wsrm__UsesSequenceSSL(soap, tag?tag:"wsrm:UsesSequenceSSL", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsrm__UsesSequenceSSL ** SOAP_FMAC4 soap_get_PointerTo_wsrm__UsesSequenceSSL(struct soap *soap, struct _wsrm__UsesSequenceSSL **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsrm__UsesSequenceSSL(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__FaultTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__FaultTo))
		soap_serialize__wsa5__FaultTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__FaultTo(struct soap *soap, const char *tag, int id, struct wsa5__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__FaultTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__FaultTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__FaultTo(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa5__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__FaultTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__FaultTo, sizeof(struct wsa5__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__FaultTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__FaultTo);
	if (soap_out_PointerTo_wsa5__FaultTo(soap, tag?tag:"wsa5:FaultTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__FaultTo(struct soap *soap, struct wsa5__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__FaultTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__ReplyTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__ReplyTo))
		soap_serialize__wsa5__ReplyTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__ReplyTo(struct soap *soap, const char *tag, int id, struct wsa5__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__ReplyTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__ReplyTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__ReplyTo(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa5__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__ReplyTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__ReplyTo, sizeof(struct wsa5__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__ReplyTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__ReplyTo);
	if (soap_out_PointerTo_wsa5__ReplyTo(soap, tag?tag:"wsa5:ReplyTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__ReplyTo(struct soap *soap, struct wsa5__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__ReplyTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__From(struct soap *soap, struct wsa5__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__From))
		soap_serialize__wsa5__From(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__From(struct soap *soap, const char *tag, int id, struct wsa5__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__From);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__From(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__From(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa5__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__From(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__From, sizeof(struct wsa5__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__From(struct soap *soap, struct wsa5__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__From);
	if (soap_out_PointerTo_wsa5__From(soap, tag?tag:"wsa5:From", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__From(struct soap *soap, struct wsa5__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__From(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__RelatesTo(struct soap *soap, struct wsa5__RelatesToType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__RelatesTo))
		soap_serialize__wsa5__RelatesTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__RelatesTo(struct soap *soap, const char *tag, int id, struct wsa5__RelatesToType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__RelatesTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__RelatesTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__RelatesToType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__RelatesTo(struct soap *soap, const char *tag, struct wsa5__RelatesToType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__RelatesToType **)soap_malloc(soap, sizeof(struct wsa5__RelatesToType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__RelatesTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__RelatesToType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__RelatesTo, sizeof(struct wsa5__RelatesToType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__RelatesTo(struct soap *soap, struct wsa5__RelatesToType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__RelatesTo);
	if (soap_out_PointerTo_wsa5__RelatesTo(soap, tag?tag:"wsa5:RelatesTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__RelatesToType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__RelatesTo(struct soap *soap, struct wsa5__RelatesToType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__RelatesTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsa5__ProblemHeaderQName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wsa5__ProblemHeaderQName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wsa5__ProblemHeaderQName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__wsa5__ProblemHeaderQName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsa5__ProblemHeaderQName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsa5__ProblemHeaderQName);
	if (soap_out__wsa5__ProblemHeaderQName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wsa5__ProblemHeaderQName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wsa5__ProblemHeaderQName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa5__MetadataType))
		soap_serialize_wsa5__MetadataType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa5__MetadataType(struct soap *soap, const char *tag, int id, struct wsa5__MetadataType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa5__MetadataType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa5__MetadataType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__MetadataType ** SOAP_FMAC4 soap_in_PointerTowsa5__MetadataType(struct soap *soap, const char *tag, struct wsa5__MetadataType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__MetadataType **)soap_malloc(soap, sizeof(struct wsa5__MetadataType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa5__MetadataType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__MetadataType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa5__MetadataType, sizeof(struct wsa5__MetadataType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa5__MetadataType);
	if (soap_out_PointerTowsa5__MetadataType(soap, tag?tag:"wsa5:MetadataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__MetadataType ** SOAP_FMAC4 soap_get_PointerTowsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa5__MetadataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa5__ReferenceParametersType))
		soap_serialize_wsa5__ReferenceParametersType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa5__ReferenceParametersType(struct soap *soap, const char *tag, int id, struct wsa5__ReferenceParametersType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa5__ReferenceParametersType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa5__ReferenceParametersType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType ** SOAP_FMAC4 soap_in_PointerTowsa5__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa5__ReferenceParametersType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__ReferenceParametersType **)soap_malloc(soap, sizeof(struct wsa5__ReferenceParametersType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa5__ReferenceParametersType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__ReferenceParametersType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa5__ReferenceParametersType, sizeof(struct wsa5__ReferenceParametersType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa5__ReferenceParametersType);
	if (soap_out_PointerTowsa5__ReferenceParametersType(soap, tag?tag:"wsa5:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType ** SOAP_FMAC4 soap_get_PointerTowsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa5__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__FaultCodesOpenEnumType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsa5__FaultCodesOpenEnumType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsa5__FaultCodesOpenEnumType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_wsa5__FaultCodesOpenEnumType, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__FaultCodesOpenEnumType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__FaultCodesOpenEnumType);
	if (soap_out_wsa5__FaultCodesOpenEnumType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsa5__FaultCodesOpenEnumType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__FaultCodesOpenEnumType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__RelationshipTypeOpenEnum(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsa5__RelationshipTypeOpenEnum);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsa5__RelationshipTypeOpenEnum(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_wsa5__RelationshipTypeOpenEnum, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__RelationshipTypeOpenEnum(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__RelationshipTypeOpenEnum);
	if (soap_out_wsa5__RelationshipTypeOpenEnum(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsa5__RelationshipTypeOpenEnum(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__RelationshipTypeOpenEnum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__Equation(struct soap *soap, _mssadh__Equation *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__Equation))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__Equation(struct soap *soap, const char *tag, int id, _mssadh__Equation *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__Equation);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__Equation ** SOAP_FMAC4 soap_in_PointerTo_mssadh__Equation(struct soap *soap, const char *tag, _mssadh__Equation **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__Equation **)soap_malloc(soap, sizeof(_mssadh__Equation *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__Equation *)soap_instantiate__mssadh__Equation(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__Equation ** p = (_mssadh__Equation **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__Equation, sizeof(_mssadh__Equation), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__Equation(struct soap *soap, _mssadh__Equation *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__Equation);
	if (soap_out_PointerTo_mssadh__Equation(soap, tag?tag:"mssadh:Equation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__Equation ** SOAP_FMAC4 soap_get_PointerTo_mssadh__Equation(struct soap *soap, _mssadh__Equation **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__Equation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__Result(struct soap *soap, _mssadh__Result *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__Result))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__Result(struct soap *soap, const char *tag, int id, _mssadh__Result *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__Result);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__Result ** SOAP_FMAC4 soap_in_PointerTo_mssadh__Result(struct soap *soap, const char *tag, _mssadh__Result **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__Result **)soap_malloc(soap, sizeof(_mssadh__Result *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__Result *)soap_instantiate__mssadh__Result(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__Result ** p = (_mssadh__Result **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__Result, sizeof(_mssadh__Result), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__Result(struct soap *soap, _mssadh__Result *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__Result);
	if (soap_out_PointerTo_mssadh__Result(soap, tag?tag:"mssadh:Result", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__Result ** SOAP_FMAC4 soap_get_PointerTo_mssadh__Result(struct soap *soap, _mssadh__Result **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__Result(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__DivideBy(struct soap *soap, _mssadh__DivideBy *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__DivideBy))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__DivideBy(struct soap *soap, const char *tag, int id, _mssadh__DivideBy *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__DivideBy);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__DivideBy ** SOAP_FMAC4 soap_in_PointerTo_mssadh__DivideBy(struct soap *soap, const char *tag, _mssadh__DivideBy **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__DivideBy **)soap_malloc(soap, sizeof(_mssadh__DivideBy *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__DivideBy *)soap_instantiate__mssadh__DivideBy(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__DivideBy ** p = (_mssadh__DivideBy **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__DivideBy, sizeof(_mssadh__DivideBy), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__DivideBy(struct soap *soap, _mssadh__DivideBy *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__DivideBy);
	if (soap_out_PointerTo_mssadh__DivideBy(soap, tag?tag:"mssadh:DivideBy", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__DivideBy ** SOAP_FMAC4 soap_get_PointerTo_mssadh__DivideBy(struct soap *soap, _mssadh__DivideBy **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__DivideBy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__MultiplyBy(struct soap *soap, _mssadh__MultiplyBy *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__MultiplyBy))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__MultiplyBy(struct soap *soap, const char *tag, int id, _mssadh__MultiplyBy *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__MultiplyBy);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__MultiplyBy ** SOAP_FMAC4 soap_in_PointerTo_mssadh__MultiplyBy(struct soap *soap, const char *tag, _mssadh__MultiplyBy **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__MultiplyBy **)soap_malloc(soap, sizeof(_mssadh__MultiplyBy *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__MultiplyBy *)soap_instantiate__mssadh__MultiplyBy(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__MultiplyBy ** p = (_mssadh__MultiplyBy **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__MultiplyBy, sizeof(_mssadh__MultiplyBy), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__MultiplyBy(struct soap *soap, _mssadh__MultiplyBy *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__MultiplyBy);
	if (soap_out_PointerTo_mssadh__MultiplyBy(soap, tag?tag:"mssadh:MultiplyBy", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__MultiplyBy ** SOAP_FMAC4 soap_get_PointerTo_mssadh__MultiplyBy(struct soap *soap, _mssadh__MultiplyBy **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__MultiplyBy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__SubtractFrom(struct soap *soap, _mssadh__SubtractFrom *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__SubtractFrom))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__SubtractFrom(struct soap *soap, const char *tag, int id, _mssadh__SubtractFrom *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__SubtractFrom);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__SubtractFrom ** SOAP_FMAC4 soap_in_PointerTo_mssadh__SubtractFrom(struct soap *soap, const char *tag, _mssadh__SubtractFrom **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__SubtractFrom **)soap_malloc(soap, sizeof(_mssadh__SubtractFrom *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__SubtractFrom *)soap_instantiate__mssadh__SubtractFrom(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__SubtractFrom ** p = (_mssadh__SubtractFrom **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__SubtractFrom, sizeof(_mssadh__SubtractFrom), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__SubtractFrom(struct soap *soap, _mssadh__SubtractFrom *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__SubtractFrom);
	if (soap_out_PointerTo_mssadh__SubtractFrom(soap, tag?tag:"mssadh:SubtractFrom", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__SubtractFrom ** SOAP_FMAC4 soap_get_PointerTo_mssadh__SubtractFrom(struct soap *soap, _mssadh__SubtractFrom **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__SubtractFrom(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__AddTo(struct soap *soap, _mssadh__AddTo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__AddTo))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__AddTo(struct soap *soap, const char *tag, int id, _mssadh__AddTo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__AddTo);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__AddTo ** SOAP_FMAC4 soap_in_PointerTo_mssadh__AddTo(struct soap *soap, const char *tag, _mssadh__AddTo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__AddTo **)soap_malloc(soap, sizeof(_mssadh__AddTo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__AddTo *)soap_instantiate__mssadh__AddTo(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__AddTo ** p = (_mssadh__AddTo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__AddTo, sizeof(_mssadh__AddTo), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__AddTo(struct soap *soap, _mssadh__AddTo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__AddTo);
	if (soap_out_PointerTo_mssadh__AddTo(soap, tag?tag:"mssadh:AddTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__AddTo ** SOAP_FMAC4 soap_get_PointerTo_mssadh__AddTo(struct soap *soap, _mssadh__AddTo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__AddTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssadh__Clear(struct soap *soap, _mssadh__Clear *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__mssadh__Clear))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssadh__Clear(struct soap *soap, const char *tag, int id, _mssadh__Clear *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssadh__Clear);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssadh__Clear ** SOAP_FMAC4 soap_in_PointerTo_mssadh__Clear(struct soap *soap, const char *tag, _mssadh__Clear **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssadh__Clear **)soap_malloc(soap, sizeof(_mssadh__Clear *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssadh__Clear *)soap_instantiate__mssadh__Clear(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssadh__Clear ** p = (_mssadh__Clear **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssadh__Clear, sizeof(_mssadh__Clear), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssadh__Clear(struct soap *soap, _mssadh__Clear *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssadh__Clear);
	if (soap_out_PointerTo_mssadh__Clear(soap, tag?tag:"mssadh:Clear", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssadh__Clear ** SOAP_FMAC4 soap_get_PointerTo_mssadh__Clear(struct soap *soap, _mssadh__Clear **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssadh__Clear(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__string(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__string))
		soap_serialize_std__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__string(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__string);
	if (id < 0)
		return soap->error;
	return soap_out_std__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTostd__string(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_std__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__string, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__string(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__string);
	if (soap_out_PointerTostd__string(soap, tag?tag:"string", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTostd__string(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap *soap, double *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_double);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap *soap, const char *tag, int id, double *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_double);
	if (id < 0)
		return soap->error;
	return soap_out_double(soap, tag, id, *a, type);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap *soap, const char *tag, double **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (double **)soap_malloc(soap, sizeof(double *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_double(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (double **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_double, sizeof(double), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap *soap, double *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTodouble);
	if (soap_out_PointerTodouble(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap *soap, double **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodouble(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
