---
title: "Downloads"
permalink: /downloads
---

# Downloads

**Note to article writers:** When posting GSmartControl download links, please
link to this page instead of the individual files below. This way the users will always get
the latest version.


## Binary and Distribution-specific Packages

### Linux

Most Linux distributions already include GSmartControl in their repositories.
[Repology](https://repology.org/project/gsmartcontrol/versions) maintains a list
of GSmartControl packages available in each distribution. 

If the package contained in your favourite distribution or repository is not up-to-date yet, our own
[OBS Project Directory](http://download.opensuse.org/repositories/home:/alex_sh:/gsmartcontrol:/stable_latest/)
contains the latest GSmartControl packages for a number of Linux distributions. Please
[select the distribution](https://software.opensuse.org//download.html?project=home%3Aalex_sh%3Agsmartcontrol%3Astable_latest&package=gsmartcontrol)
to install these packages.

### Windows

#### Windows Vista or Later

- 32-bit installer **(use this if unsure)**:
[gsmartcontrol-2.0.0-win32.exe](https://github.com/ashaduri/gsmartcontrol/releases/download/v2.0.0/gsmartcontrol-2.0.0-win32.exe).

- 32-bit zip (portable): [gsmartcontrol-2.0.0-win32.zip](https://github.com/ashaduri/gsmartcontrol/releases/download/v2.0.0/gsmartcontrol-2.0.0-win32.zip).

- 64-bit installer: [gsmartcontrol-2.0.0-win64.exe](https://github.com/ashaduri/gsmartcontrol/releases/download/v2.0.0/gsmartcontrol-2.0.0-win64.exe).

- 64-bit zip (portable): [gsmartcontrol-2.0.0.win64.zip](https://github.com/ashaduri/gsmartcontrol/releases/download/v2.0.0/gsmartcontrol-2.0.0-win64.zip).

#### Outdated: Windows XP, 2000 and 2003

The last version of GSmartControl that supports Windows XP, 2000 and 2003
is **0.9.0**:
- Outdated 32-bit installer: [gsmartcontrol-0.9.0.exe](https://github.com/ashaduri/gsmartcontrol/releases/download/v0.9.0/gsmartcontrol-0.9.0.exe).
- Outdated 32-bit zip (portable): [gsmartcontrol-0.9.0-win32.zip](https://github.com/ashaduri/gsmartcontrol/releases/download/v0.9.0/gsmartcontrol-0.9.0-win32.zip).


### FreeBSD

GSmartControl is [available](http://www.freshports.org/sysutils/gsmartcontrol) in the ports system.
Use `cd /usr/ports/sysutils/gsmartcontrol/ && make install clean` to install the port.
Use `pkg_add -r gsmartcontrol` to add the package.


### macOS / Darwin

- The [Homebrew](https://brew.sh/) project maintains a
[package for GSmartControl](https://formulae.brew.sh/formula/gsmartcontrol).
See the [Usage](usage.md) page for information on how to run it.
- The [MacPorts](https://www.macports.org/) project also maintains a
[package for GSmartControl](https://github.com/macports/macports-ports/blob/master/sysutils/gsmartcontrol/Portfile). 


### Live CD / DVD / USB / ...

- [GParted Live](http://gparted.org/livecd.php) is an excellent bootable distribution
which includes GSmartControl. 


## Source Code

The latest source package:
[gsmartcontrol-2.0.0.tar.bz2](https://github.com/ashaduri/gsmartcontrol/releases/download/v2.0.0/gsmartcontrol-2.0.0.tar.bz2) \
SHA1 sum: 

If you're interested in development, you can check the
[GitHub Project](https://github.com/ashaduri/gsmartcontrol) page.


## Older Versions
Check the [GitHub Releases](https://github.com/ashaduri/gsmartcontrol/releases) page for older releases.
