/* Gnome Smart Card
 * Copyright (C) 2000  Oliver Feiler (kiza@claws-and-paws.com)
 * 
 * callbacks.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <gnome.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "prefs.h"
#include "io.h"

#define GSC_HOME_URL "http://www.lionking.org/~kiza/linux/gsmartcard/"
#define SC_MAX_BYTES 255	/* Maximum number of bytes smartcard can
                                 * handle */


/*********************
 * Handler for menus *
 *********************/

/* Handlers for file menu */

void
on_file_clear_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_editable_delete_text(GTK_EDITABLE(lookup_widget(GTK_WIDGET(menuitem),
						      "card_info")),
			   0, -1);
  gtk_editable_delete_text(GTK_EDITABLE(lookup_widget(GTK_WIDGET(menuitem),
						      "card_content")),
			   0, -1);
}


/* File selection */

GtkWidget *file_selector;
char what_to_do;

void store_filename(GtkFileSelection *selector, gpointer user_data) {
  gchar *selected_filename;
  FILE *file;
  gchar file_content[8192];
  int num_bytes;

  selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));

  if ( what_to_do == 'w' ) {
    file = fopen(selected_filename, "w");
    
    fwrite((gtk_editable_get_chars(GTK_EDITABLE(lookup_widget(GTK_WIDGET(user_data),
							      "card_content")),
				   0, -1)),
	   sizeof(char),
	   strlen((gtk_editable_get_chars(GTK_EDITABLE(lookup_widget(GTK_WIDGET(user_data),
							      "card_content")),
					  0, -1))),
	   file);
    fclose(file);
  } else if ( what_to_do == 'r' ) {
    gtk_editable_delete_text(GTK_EDITABLE(lookup_widget(GTK_WIDGET(user_data),
							"card_content")),
			     0, -1);

    file = fopen(selected_filename, "r");
    num_bytes = fread(file_content, sizeof(char), sizeof(file_content), file);
    
  
    gtk_text_insert(GTK_TEXT(lookup_widget(GTK_WIDGET(user_data), "card_content")),
		  NULL, NULL, NULL, file_content, num_bytes);
    fclose(file);
  } else if ( what_to_do == 'b' ) {
    gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(user_data), "prefs_browse_entry")),
		  selected_filename);
  }
}

void create_file_selection(gpointer user_data) {

  /* Create the selector */
  
  file_selector = gtk_file_selection_new("Please select a file for editing.");
  
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (store_filename), user_data);
  
  /* Ensure that the dialog box is destroyed when the user clicks a button. */
  
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) file_selector);
  
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) file_selector);
  
  /* Display that dialog */

  gtk_window_set_modal(GTK_WINDOW(file_selector), TRUE);
  
  gtk_widget_show (file_selector);
}

void
on_file_open_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_file_selection(menuitem);

  what_to_do = 'r';
}




void
on_file_save_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_file_selection(menuitem);

  what_to_do = 'w';

}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_main_quit();
}

/* End file menu */



/* Edit menu */

void
on_cut_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_copy_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_paste_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_select_all_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_edit_clear_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_find_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_hexedit_card_content_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;
  
  mbox = gnome_message_box_new("Not yet implemented.",
			       GNOME_MESSAGE_BOX_INFO,
			       GNOME_STOCK_BUTTON_OK,
			       NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
}

/* End edit menu */



/* Advanced menu */

void
on_blank_card_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;
  FILE *smartcard;
  
  mbox = gnome_message_box_new("Erase inserted smart card?",
			       GNOME_MESSAGE_BOX_QUESTION,
			       GNOME_STOCK_BUTTON_YES,
			       GNOME_STOCK_BUTTON_NO, NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));

  if ( button == 1)
    return;

  smartcard = popen("smartcard -e", "r");
  fclose(smartcard);

  gnome_appbar_set_status(GNOME_APPBAR(lookup_widget(GTK_WIDGET(menuitem),
						      "appbar1")),
			   "Erasing card finished");
}


void
on_fill_card_with_random_data_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;
  gchar random_bits[SC_MAX_BYTES];
  int i;
  int dev_rand;
 
  /* Generate random bits */

  if (strcmp(prefs_get_value("use_dev_rand"), "1") == 0) {
    dev_rand = open("/dev/urandom", O_RDONLY);
    if ( dev_rand == -1 ) {
      return;
    }
    read(dev_rand, random_bits, SC_MAX_BYTES);
    close(dev_rand);
  } else {
    for ( i = 0; i < SC_MAX_BYTES; ++i )
      random_bits[i] = (1+(int) (255.0*rand()/(RAND_MAX+1.0)));
  }
  
  gtk_editable_delete_text(GTK_EDITABLE(lookup_widget(GTK_WIDGET(menuitem),
						      "card_content")),
			   0, -1);
  
  gtk_text_insert(GTK_TEXT(lookup_widget(GTK_WIDGET(menuitem), "card_content")),
		  NULL, NULL, NULL, random_bits, SC_MAX_BYTES);


  /* Now ask the user if he wants to write the data onto a card */

  mbox = gnome_message_box_new("Please insert a card to write and click OK.\n"
			       "Click Cancel to stop programming.",
			       GNOME_MESSAGE_BOX_QUESTION,
			       GNOME_STOCK_BUTTON_OK,
			       GNOME_STOCK_BUTTON_CANCEL, NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
  
  if ( button == 1)
    return;
  
  io_write_card(GTK_WIDGET(menuitem), user_data);
}


void
on_mass_delete_cards_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;
  FILE *smartcard;
  
  mbox = gnome_message_box_new("Erase inserted smart card?",
			       GNOME_MESSAGE_BOX_QUESTION,
			       GNOME_STOCK_BUTTON_YES,
			       GNOME_STOCK_BUTTON_NO, NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));

  if ( button == 1)
    return;

  smartcard = popen("smartcard -e", "r");
  fclose(smartcard);

  gnome_appbar_set_status(GNOME_APPBAR(lookup_widget(GTK_WIDGET(menuitem),
						      "appbar1")),
			   "Erasing card finished");
  
  while(1) {
    mbox = gnome_message_box_new("Erase another card?",
				 GNOME_MESSAGE_BOX_QUESTION,
				 GNOME_STOCK_BUTTON_YES,
				 GNOME_STOCK_BUTTON_NO, NULL);
    gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
    button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
    
    if ( button == 1)
      return;
    
    smartcard = popen("smartcard -e", "r");
    fclose(smartcard);
    
    gnome_appbar_set_status(GNOME_APPBAR(lookup_widget(GTK_WIDGET(menuitem),
						       "appbar1")),
			    "Erasing card finished");
  }
}


void
on_mass_program_cards_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;

  while(1) {
    mbox = gnome_message_box_new("Please insert a card to write and click OK.\n"
				 "Click Cancel to stop programming.",
				 GNOME_MESSAGE_BOX_QUESTION,
				 GNOME_STOCK_BUTTON_OK,
				 GNOME_STOCK_BUTTON_CANCEL, NULL);
    gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
    button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
    
    if ( button == 1)
      return;
    
    io_write_card(GTK_WIDGET(menuitem), user_data);
  }
}


void
on_mass_copy_cards_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;

  mbox = gnome_message_box_new("Please insert a card to read and click OK.",
			       GNOME_MESSAGE_BOX_QUESTION,
			       GNOME_STOCK_BUTTON_OK,
			       GNOME_STOCK_BUTTON_CANCEL, NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));

  if ( button == 1)
    return;

  io_read_card(GTK_WIDGET(menuitem), user_data);

  while(1) {
    mbox = gnome_message_box_new("Please insert a card to write and click OK.\n"
				 "Click Cancel to stop copying.",
				 GNOME_MESSAGE_BOX_QUESTION,
				 GNOME_STOCK_BUTTON_OK,
				 GNOME_STOCK_BUTTON_CANCEL, NULL);
    gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
    button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
    
    if ( button == 1)
      return;
    
    io_write_card(GTK_WIDGET(menuitem), user_data);
  }
}



void
on_print_md5sum_of_the_card_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button = 0;
  
  mbox = gnome_message_box_new("Not yet implemented.",
			       GNOME_MESSAGE_BOX_INFO,
			       GNOME_STOCK_BUTTON_OK,
			       NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
}

/* End advanced menu */


/* Preferences menu
 * one entry */

void
on_preferences_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *prefs_win;

  prefs_win = create_prefs_win();
  gtk_widget_show_all(prefs_win);
}

/* Preferences menu end */


/* Help menu */

void
on_index_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GnomeHelpMenuEntry index_entry = { "gsmartcard", "index.html" };

  gnome_help_display(0, &index_entry);

}


void
on_gsc_homepage_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gnome_url_show(GSC_HOME_URL);
}

void
on_about_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *about_win;

  about_win = create_about_win();
  gtk_widget_show(about_win);
}

/* End help menu */

/********************
 * End menu handler *
 ********************/


/* Buttons in main program window */

void
on_read_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  io_read_card(GTK_WIDGET(button), user_data);
}


void
on_write_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  io_write_card(GTK_WIDGET(button), user_data);
}

void
on_verify_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint bottun = 0;
  
  mbox = gnome_message_box_new("Not yet implemented.",
			       GNOME_MESSAGE_BOX_INFO,
			       GNOME_STOCK_BUTTON_OK,
			       NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  bottun = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
}


void
on_copy_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *mbox;
  guint button_q = 0;		/* button_q = button question
				"q" is there so it doesn't interfere with
				*button */

  mbox = gnome_message_box_new("Please insert a card to read and click OK.",
			       GNOME_MESSAGE_BOX_QUESTION,
			       GNOME_STOCK_BUTTON_OK,
			       GNOME_STOCK_BUTTON_CANCEL, NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button_q = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));

  if ( button_q == 1)
    return;

  io_read_card(GTK_WIDGET(button), user_data);

  mbox = gnome_message_box_new("Please insert a card to write and click OK.",
			       GNOME_MESSAGE_BOX_QUESTION,
			       GNOME_STOCK_BUTTON_OK,
			       GNOME_STOCK_BUTTON_CANCEL, NULL);
  gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
  button_q = gnome_dialog_run_and_close(GNOME_DIALOG(mbox));

  if ( button_q == 1)
    return;

  io_write_card(GTK_WIDGET(button), user_data);
}

/* End buttons main window */


/* Preferences dialog
 * 5 items; (read/write config), 3 buttons */

void
on_prefs_cancel_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), "prefs_win"));
}


void
on_prefs_win_show                      (GtkWidget       *widget,
                                        gpointer         user_data)
{

  /* Set autoread button according to .gsmartcardrc file */
  if (strcmp(prefs_get_value("card_auto_read"), "1") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "checkbutton_autoread")), TRUE);
  else if (strcmp(prefs_get_value("card_auto_read"), "0") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "checkbutton_autoread")), FALSE);

  /* Set autosave button */
  if (strcmp(prefs_get_value("card_auto_save"), "1") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "checkbutton_autosave")), TRUE);
  else if (strcmp(prefs_get_value("card_auto_save"), "0") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "checkbutton_autosave")), FALSE);

  /* Set up autosave location */
  gtk_entry_set_text(GTK_ENTRY(lookup_widget(widget, "prefs_browse_entry")),
		     prefs_get_value("autosave_file"));

  /* Set dev-rand button */
  if (strcmp(prefs_get_value("use_dev_rand"), "1") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "dev_rand")), TRUE);
  else if (strcmp(prefs_get_value("use_dev_rand"), "0") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "dev_rand")), FALSE);

  /* Set display mode */
  if (strcmp(prefs_get_value("display"), "ascii") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "radio_plain")), TRUE);
  else if (strcmp(prefs_get_value("display"), "hex") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "radio_hex")), TRUE);

  /* Set serial port */
  if (strcmp(prefs_get_value("reader_com_port"), "1") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "com1")), TRUE);
  else if (strcmp(prefs_get_value("reader_com_port"), "2") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "com2")), TRUE);
  else if (strcmp(prefs_get_value("reader_com_port"), "3") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "com3")), TRUE);
  else if (strcmp(prefs_get_value("reader_com_port"), "4") == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "com4")), TRUE);
}


void
on_prefs_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Now get the value for each config option and write it back to the
   * config file. GTK makes this look a bit messy. :-) */

  if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "checkbutton_autoread"))) == TRUE)
    prefs_set_value("card_auto_read", "1");
  else
    prefs_set_value("card_auto_read", "0");

  if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "checkbutton_autosave"))) == TRUE)
    prefs_set_value("card_auto_save", "1");
  else
    prefs_set_value("card_auto_save", "0");

  /* set autosave location */
  prefs_set_value("autosave_file",
		  gtk_entry_get_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "prefs_browse_entry"))));

  if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "radio_plain"))) == TRUE)
    prefs_set_value("display", "ascii");
  else if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "radio_hex"))) == TRUE)
    prefs_set_value("display", "hex");

  if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "dev_rand"))) == TRUE)
    prefs_set_value("use_dev_rand", "1");
  else
    prefs_set_value("use_dev_rand", "0");

  if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "com1"))) == TRUE)
    prefs_set_value("reader_com_port", "1");
  else if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "com2"))) == TRUE)
    prefs_set_value("reader_com_port", "2");
  else if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "com3"))) == TRUE)
    prefs_set_value("reader_com_port", "3");
  else if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(button), "com4"))) == TRUE)
    prefs_set_value("reader_com_port", "4");

  prefs_write_config();
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), "prefs_win"));
}



void
on_prefs_browse_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  create_file_selection(button);

  what_to_do = 'b';

}

/* End preferences dialog */
