#ifndef __AGS_H__
#define __AGS_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

/* lib */
#include <ags/util/ags_id_generator.h>

#include <ags/lib/ags_list.h>
#include <ags/lib/ags_log.h>
#include <ags/lib/ags_parameter.h>
#include <ags/lib/ags_container.h>
#include <ags/lib/ags_combo_box_text.h>

#include <ags/plugin/ags_plugin_factory.h>
#include <ags/plugin/ags_plugin_stock.h>
#include <ags/plugin/ags_ladspa_manager.h>

#include <ags/object/ags_runnable.h>
#include <ags/object/ags_stackable.h>
#include <ags/object/ags_tactable.h>
#include <ags/object/ags_async_queue.h>
#include <ags/object/ags_tree_iterator.h>
#include <ags/object/ags_countable.h>
#include <ags/object/ags_packable.h>
#include <ags/object/ags_dynamic_connectable.h>
#include <ags/object/ags_seekable.h>
#include <ags/object/ags_portlet.h>
#include <ags/object/ags_main_loop.h>
#include <ags/object/ags_concurrent_tree.h>
#include <ags/object/ags_marshal.h>
#include <ags/object/ags_persistable.h>
#include <ags/object/ags_plugin.h>
#include <ags/object/ags_playable.h>
#include <ags/object/ags_applicable.h>
#include <ags/object/ags_mutable.h>
#include <ags/object/ags_effect.h>
#include <ags/object/ags_soundcard.h>

/* thread */
#include <ags/file/ags_file_sound.h>
#include <ags/file/ags_file_gui.h>
#include <ags/file/ags_file_link.h>
#include <ags/file/ags_file_id_ref.h>
#include <ags/file/ags_file_util.h>
#include <ags/file/ags_file.h>
#include <ags/file/ags_file_thread.h>
#include <ags/file/ags_file_stock.h>
#include <ags/file/ags_file_write.h>
#include <ags/file/ags_file_read.h>
#include <ags/file/ags_file_launch.h>
#include <ags/file/ags_file_lookup.h>

/* server */
#include <ags/server/ags_remote_task.h>
#include <ags/server/ags_registry.h>
#include <ags/server/ags_server.h>

/* widget */
#include <ags/widget/ags_menu.h>
#include <ags/widget/ags_expander_set.h>
#include <ags/widget/ags_led.h>
#include <ags/widget/ags_timebar.h>
#include <ags/widget/ags_indicator.h>
#include <ags/widget/ags_hindicator.h>
#include <ags/widget/ags_table.h>
#include <ags/widget/ags_ruler.h>
#include <ags/widget/ags_expander.h>
#include <ags/widget/ags_waveform.h>
#include <ags/widget/ags_option_menu.h>
#include <ags/widget/ags_htimebar.h>
#include <ags/widget/ags_vindicator.h>
#include <ags/widget/ags_cartesian.h>
#include <ags/widget/ags_segment.h>
#include <ags/widget/ags_menu_item.h>
#include <ags/widget/ags_dial.h>

#ifdef AGS_USE_LINUX_THREADS
#include <ags/thread/ags_thread-kthreads.h>
#else
#include <ags/thread/ags_thread-posix.h>
#endif 
#include <ags/thread/ags_thread_pool.h>

#include <ags/thread/ags_recycling_thread_callbacks.h>
#include <ags/thread/ags_single_thread.h>
#include <ags/thread/ags_recycling_thread.h>
#include <ags/thread/ags_gui_thread.h>
#include <ags/thread/ags_audio_loop.h>
#include <ags/thread/ags_returnable_thread.h>
#include <ags/thread/ags_task_completion.h>
#include <ags/thread/ags_audio_thread.h>
#include <ags/thread/ags_devout_thread.h>
#include <ags/thread/ags_mutex_manager.h>
#include <ags/thread/ags_timestamp_thread.h>
#include <ags/thread/ags_export_thread.h>
#include <ags/thread/ags_history.h>
#include <ags/thread/ags_iterator_thread.h>
#include <ags/thread/ags_channel_thread.h>
#include <ags/thread/ags_task_thread.h>
#include <ags/thread/ags_autosave_thread.h>
#include <ags/thread/ags_record_thread.h>

/* audio */
#include <ags/audio/ags_synths.h>
#include <ags/audio/ags_channel_iter.h>
#include <ags/audio/ags_timestamp_factory.h>
#include <ags/audio/ags_pattern.h>
#include <ags/audio/ags_recall_channel_run.h>
#include <ags/audio/ags_recall_ladspa_run.h>
#include <ags/audio/ags_recall_audio_signal.h>
#include <ags/audio/ags_recall.h>
#include <ags/audio/ags_channel.h>
#include <ags/audio/ags_recall_channel.h>
#include <ags/audio/ags_recycling.h>
#include <ags/audio/ags_audio.h>
#include <ags/audio/ags_task.h>
#include <ags/audio/ags_output.h>
#include <ags/audio/ags_notation.h>
#include <ags/audio/ags_input.h>
#include <ags/audio/ags_recall_recycling.h>
#include <ags/audio/ags_recall_audio.h>
#include <ags/audio/ags_recall_channel_run_dummy.h>
#include <ags/audio/ags_recall_factory.h>
#include <ags/audio/ags_port.h>
#include <ags/audio/ags_recycling_container.h>
#include <ags/audio/ags_note.h>
#include <ags/audio/ags_timestamp.h>
#include <ags/audio/ags_effect.h>
#include <ags/audio/ags_recall_recycling_dummy.h>
#include <ags/audio/ags_libao.h>
#include <ags/audio/ags_devout.h>
#include <ags/audio/ags_recall_id.h>
#include <ags/audio/ags_audio_signal.h>
#include <ags/audio/ags_config.h>
#include <ags/audio/ags_recall_dependency.h>
#include <ags/audio/ags_recall_audio_run.h>
#include <ags/audio/ags_recall_ladspa.h>
#include <ags/audio/ags_garbage_collector.h>
#include <ags/audio/ags_recall_container.h>

#include <ags/audio/recall/ags_amplifier.h>
#include <ags/audio/recall/ags_volume_audio_signal.h>
#include <ags/audio/recall/ags_buffer_channel_run.h>
#include <ags/audio/recall/ags_mute_channel_run.h>
#include <ags/audio/recall/ags_copy_recycling.h>
#include <ags/audio/recall/ags_play_audio.h>
#include <ags/audio/recall/ags_mute_audio_signal.h>
#include <ags/audio/recall/ags_peak_channel.h>
#include <ags/audio/recall/ags_clone_channel_run.h>
#include <ags/audio/recall/ags_mute_channel.h>
#include <ags/audio/recall/ags_copy_pattern_audio.h>
#include <ags/audio/recall/ags_down_mix.h>
#include <ags/audio/recall/ags_copy_audio_signal.h>
#include <ags/audio/recall/ags_copy_notation_audio.h>
#include <ags/audio/recall/ags_peak_channel_run.h>
#include <ags/audio/recall/ags_count_beats_audio_run.h>
#include <ags/audio/recall/ags_copy_channel_run.h>
#include <ags/audio/recall/ags_stream_channel_run.h>
#include <ags/audio/recall/ags_copy_pattern_channel.h>
#include <ags/audio/recall/ags_synths.h>
#include <ags/audio/recall/ags_stream_audio_signal.h>
#include <ags/audio/recall/ags_envelope_channel_run.h>
#include <ags/audio/recall/ags_buffer_channel.h>
#include <ags/audio/recall/ags_echo.h>
#include <ags/audio/recall/ags_copy_pattern_channel_run.h>
#include <ags/audio/recall/ags_volume_recycling.h>
#include <ags/audio/recall/ags_loop_channel.h>
#include <ags/audio/recall/ags_buffer_recycling.h>
#include <ags/audio/recall/ags_mute_recycling.h>
#include <ags/audio/recall/ags_envelope_audio_signal.h>
#include <ags/audio/recall/ags_buffer_audio_signal.h>
#include <ags/audio/recall/ags_volume_channel.h>
#include <ags/audio/recall/ags_envelope_recycling.h>
#include <ags/audio/recall/ags_clone_channel.h>
#include <ags/audio/recall/ags_play_channel_run.h>
#include <ags/audio/recall/ags_mute_audio.h>
#include <ags/audio/recall/ags_play_channel_run_master.h>
#include <ags/audio/recall/ags_copy_notation_audio_run.h>
#include <ags/audio/recall/ags_play_audio_file.h>
#include <ags/audio/recall/ags_mute_audio_run.h>
#include <ags/audio/recall/ags_play_note.h>
#include <ags/audio/recall/ags_play_audio_signal.h>
#include <ags/audio/recall/ags_copy_channel.h>
#include <ags/audio/recall/ags_stream_channel.h>
#include <ags/audio/recall/ags_envelope_channel.h>
#include <ags/audio/recall/ags_play_notation_audio.h>
#include <ags/audio/recall/ags_peak_recycling.h>
#include <ags/audio/recall/ags_play_notation_audio_run.h>
#include <ags/audio/recall/ags_volume_channel_run.h>
#include <ags/audio/recall/ags_count_beats_audio.h>
#include <ags/audio/recall/ags_delay_audio.h>
#include <ags/audio/recall/ags_copy_pattern_audio_run.h>
#include <ags/audio/recall/ags_stream_recycling.h>
#include <ags/audio/recall/ags_peak_audio_signal.h>
#include <ags/audio/recall/ags_play_pattern.h>
#include <ags/audio/recall/ags_stream.h>
#include <ags/audio/recall/ags_play_recycling.h>
#include <ags/audio/recall/ags_delay_audio_run.h>
#include <ags/audio/recall/ags_play_channel.h>
#include <ags/audio/recall/ags_loop_channel_run.h>

#include <ags/audio/task/ags_audio_set_recycling.h>
#include <ags/audio/task/ags_add_audio.h>
#include <ags/audio/task/ags_free_selection.h>
#include <ags/audio/task/ags_seek_devout.h>
#include <ags/audio/task/ags_cancel_channel.h>
#include <ags/audio/task/ags_open_file.h>
#include <ags/audio/task/ags_remove_note.h>
#include <ags/audio/task/ags_toggle_led.h>
#include <ags/audio/task/ags_scroll_on_play.h>
#include <ags/audio/task/ags_apply_wavetable.h>
#include <ags/audio/task/ags_start_devout.h>
#include <ags/audio/task/ags_start_read_file.h>
#include <ags/audio/task/ags_set_audio_channels.h>
#include <ags/audio/task/ags_add_recall.h>
#include <ags/audio/task/ags_append_audio_threaded.h>
#include <ags/audio/task/ags_save_file.h>
#include <ags/audio/task/ags_remove_audio_signal.h>
#include <ags/audio/task/ags_append_channel.h>
#include <ags/audio/task/ags_cancel_audio.h>
#include <ags/audio/task/ags_append_audio.h>
#include <ags/audio/task/ags_add_line_member.h>
#include <ags/audio/task/ags_init_channel.h>
#include <ags/audio/task/ags_change_tact.h>
#include <ags/audio/task/ags_remove_region_from_selection.h>
#include <ags/audio/task/ags_export_output.h>
#include <ags/audio/task/ags_display_tact.h>
#include <ags/audio/task/ags_remove_recall.h>
#include <ags/audio/task/ags_init_audio.h>
#include <ags/audio/task/ags_remove_audio.h>
#include <ags/audio/task/ags_remove_recall_container.h>
#include <ags/audio/task/ags_cancel_recall.h>
#include <ags/audio/task/ags_append_recall.h>
#include <ags/audio/task/ags_apply_synth.h>
#include <ags/audio/task/ags_add_point_to_selection.h>
#include <ags/audio/task/ags_add_audio_signal.h>
#include <ags/audio/task/ags_channel_set_recycling.h>
#include <ags/audio/task/ags_open_single_file.h>
#include <ags/audio/task/ags_unref_audio_signal.h>
#include <ags/audio/task/ags_resize_audio.h>
#include <ags/audio/task/ags_set_output_device.h>
#include <ags/audio/task/ags_set_devout_play_flags.h>
#include <ags/audio/task/ags_toggle_pattern_bit.h>
#include <ags/audio/task/ags_add_note.h>
#include <ags/audio/task/ags_add_recall_container.h>
#include <ags/audio/task/ags_set_buffer_size.h>
#include <ags/audio/task/ags_add_region_to_selection.h>
#include <ags/audio/task/ags_blink_cell_pattern_cursor.h>
#include <ags/audio/task/ags_remove_point_from_selection.h>
#include <ags/audio/task/ags_link_channel.h>
#include <ags/audio/task/ags_change_indicator.h>
#include <ags/audio/task/recall/ags_apply_bpm.h>
#include <ags/audio/task/recall/ags_apply_tact.h>
#include <ags/audio/task/recall/ags_apply_sequencer_length.h>
#include <ags/audio/task/recall/ags_set_muted.h>
#include <ags/audio/task/ags_set_samplerate.h>

#include <ags/audio/file/ags_audio_file_xml.h>
#include <ags/audio/file/ags_audio_file.h>
#include <ags/audio/file/ags_ipatch_sf2_reader.h>
#include <ags/audio/file/ags_sndfile.h>
#include <ags/audio/file/ags_ipatch.h>

/* gui */
#include <ags/X/ags_property_collection_editor_callbacks.h>
#include <ags/X/ags_editor_callbacks.h>
#include <ags/X/ags_line_editor.h>
#include <ags/X/ags_audio_preferences_callbacks.h>
#include <ags/X/ags_preferences.h>
#include <ags/X/ags_line.h>
#include <ags/X/ags_property_editor_callbacks.h>
#include <ags/X/ags_machine_editor_callbacks.h>
#include <ags/X/ags_pad_editor_callbacks.h>
#include <ags/X/ags_navigation.h>
#include <ags/X/ags_pad_editor.h>
#include <ags/X/ags_navigation_callbacks.h>
#include <ags/X/ags_window.h>
#include <ags/X/ags_property_editor.h>
#include <ags/X/ags_line_member_callbacks.h>
#include <ags/X/ags_editor.h>
#include <ags/X/ags_listing_editor.h>
#include <ags/X/ags_export_window.h>
#include <ags/X/ags_generic_preferences.h>
#include <ags/X/ags_performance_preferences_callbacks.h>
#include <ags/X/ags_ladspa_browser.h>
#include <ags/X/ags_server_preferences.h>
#include <ags/X/ags_preferences_callbacks.h>
#include <ags/X/ags_link_editor_callbacks.h>
#include <ags/X/ags_audio_preferences.h>

#include <ags/X/ags_performance_preferences.h>
#include <ags/X/ags_window_callbacks.h>
#include <ags/X/ags_property_listing_editor.h>
#include <ags/X/ags_menu_bar.h>
#include <ags/X/ags_property_collection_editor.h>
#include <ags/X/ags_line_editor_callbacks.h>
#include <ags/X/ags_plugin_preferences_callbacks.h>
#include <ags/X/ags_generic_preferences_callbacks.h>
#include <ags/X/ags_pad.h>
#include <ags/X/ags_link_editor.h>
#include <ags/X/ags_plugin_preferences.h>
#include <ags/X/ags_machine_editor.h>
#include <ags/X/ags_machine_callbacks.h>
#include <ags/X/ags_export_window_callbacks.h>
#include <ags/X/ags_line_member_editor_callbacks.h>
#include <ags/X/ags_line_callbacks.h>
#include <ags/X/ags_resize_editor.h>
#include <ags/X/ags_pad_callbacks.h>
#include <ags/X/ags_link_collection_editor_callbacks.h>
#include <ags/X/ags_line_member_editor.h>
#include <ags/X/ags_menu_bar_callbacks.h>
#include <ags/X/ags_server_preferences_callbacks.h>
#include <ags/X/ags_link_collection_editor.h>
#include <ags/X/ags_machine.h>
#include <ags/X/ags_line_member.h>
#include <ags/X/ags_listing_editor_callbacks.h>
#include <ags/X/ags_ladspa_browser_callbacks.h>

#include <ags/X/machine/ags_pattern_box.h>
#include <ags/X/machine/ags_panel_input_line.h>
#include <ags/X/machine/ags_synth_input_pad.h>
#include <ags/X/machine/ags_drum_output_line_callbacks.h>
#include <ags/X/machine/ags_drum.h>
#include <ags/X/machine/ags_synth.h>
#include <ags/X/machine/ags_panel.h>
#include <ags/X/machine/ags_drum_input_line.h>
#include <ags/X/machine/ags_cell_pattern.h>
#include <ags/X/machine/ags_pattern_box_callbacks.h>
#include <ags/X/machine/ags_matrix.h>
#include <ags/X/machine/ags_drum_input_line_callbacks.h>
#include <ags/X/machine/ags_drum_callbacks.h>
#include <ags/X/machine/ags_cell_pattern_callbacks.h>
#include <ags/X/machine/ags_panel_callbacks.h>
#include <ags/X/machine/ags_mixer.h>
#include <ags/X/machine/ags_drum_input_pad_callbacks.h>
#include <ags/X/machine/ags_oscillator.h>
#include <ags/X/machine/ags_synth_input_line.h>
#include <ags/X/machine/ags_mixer_input_pad.h>
#include <ags/X/machine/ags_ffplayer.h>
#include <ags/X/machine/ags_ffplayer_callbacks.h>
#include <ags/X/machine/ags_mixer_callbacks.h>
#include <ags/X/machine/ags_panel_input_pad.h>
#include <ags/X/machine/ags_synth_callbacks.h>
#include <ags/X/machine/ags_drum_output_pad_callbacks.h>
#include <ags/X/machine/ags_drum_input_pad.h>
#include <ags/X/machine/ags_drum_output_pad.h>
#include <ags/X/machine/ags_oscillator_callbacks.h>
#include <ags/X/machine/ags_matrix_callbacks.h>
#include <ags/X/machine/ags_mixer_input_line.h>
#include <ags/X/machine/ags_drum_output_line.h>

#include <ags/X/editor/ags_pattern_edit.h>
#include <ags/X/editor/ags_machine_selector_callbacks.h>
#include <ags/X/editor/ags_meter_callbacks.h>
#include <ags/X/editor/ags_machine_radio_button.h>
#include <ags/X/editor/ags_machine_selection.h>
#include <ags/X/editor/ags_sf2_chooser_callbacks.h>
#include <ags/X/editor/ags_sf2_chooser.h>
#include <ags/X/editor/ags_notebook_callbacks.h>
#include <ags/X/editor/ags_toolbar.h>
#include <ags/X/editor/ags_pattern_edit_callbacks.h>
#include <ags/X/editor/ags_inline_player_callbacks.h>
#include <ags/X/editor/ags_machine_selector.h>
#include <ags/X/editor/ags_file_selection.h>
#include <ags/X/editor/ags_meter.h>
#include <ags/X/editor/ags_notebook.h>
#include <ags/X/editor/ags_file_selection_callbacks.h>
#include <ags/X/editor/ags_note_edit_callbacks.h>
#include <ags/X/editor/ags_toolbar_callbacks.h>
#include <ags/X/editor/ags_toolbar_mode_stock.h>
#include <ags/X/editor/ags_inline_player.h>
#include <ags/X/editor/ags_note_edit.h>

#endif /*__AGS_H__*/
