#!/bin/sh

set -e
set -u

# Run this script from the top-level source directory *after a build*
# to update debian/install and debian/links.  This should be done with
# a new upstream release when a file and/or a component is being
# added/removed and dh_install/dh_missing fail.

base_dir=`pwd`
g_app="debian/grr.app"
GNUSTEP_SYSTEM_APPS="usr/lib/GNUstep/Applications"
usrshare="usr/share/GNUstep"

cat <<EOF >$base_dir/$g_app.install.temp
# Install user command
usr/bin/*

# Install .desktop files
debian/Grr.desktop	/usr/share/applications/

# Install the PNG icon
Grr.png		usr/share/pixmaps/GNUstep

# Install Grr executable
usr/lib/GNUstep/Applications/Grr.app/[!R]*
EOF

rm -f $base_dir/$g_app.links.temp

append1()
{
    cd $base_dir/debian/tmp
    for i in `ls -A -d --color=never $GNUSTEP_SYSTEM_APPS/Grr.app/Resources/$1`
    do
	echo "$i\t/$usrshare/Grr.app/" >>$base_dir/$g_app.install.temp
	echo "$usrshare/Grr.app/`basename $i`\t$i" >>$base_dir/$g_app.links.temp
    done
}

append2()
{
    cd $base_dir/debian/tmp
    for i in `ls -A -d --color=never $GNUSTEP_SYSTEM_APPS/Grr.app/Resources/$1`
    do
	if test -d $base_dir/debian/tmp/$i
	then
	    echo "$i/Resources/*\t/$usrshare/Grr.app/`basename $i`" >>$base_dir/$g_app.install.temp
	    echo "$usrshare/Grr.app/`basename $i`\t$i/Resources" >>$base_dir/$g_app.links.temp
	    for j in ls `ls -A -d --color=never $i/*`
	    do
		if test -f $base_dir/debian/tmp/$j
		then 
		    echo "$j" >>$base_dir/$g_app.install.temp
		fi
	    done
	fi
    done
}

echo "\n# Install Grr.app/Resources TIFF files" >> $base_dir/$g_app.install.temp
echo "# Symlink Grr.app/Resources .TIFF files" >> $base_dir/$g_app.links.temp
append1 *.tiff

echo "\n# Install Grr.app/Resources .plist files" >> $base_dir/$g_app.install.temp
echo "\n# Symlink Grr.app/Resources .plist files" >> $base_dir/$g_app.links.temp
append1 *.plist

echo "\n# Install Grr.app/Resources .lproj dirs" >> $base_dir/$g_app.install.temp
echo "\n# Symlinks Grr.app/Resources .lproj dirs" >> $base_dir/$g_app.links.temp
append1 *.lproj


echo "\n# Install Grr.app/Resources .grrc stuff" >> $base_dir/$g_app.install.temp
echo "\n# Symlinks Grr.app/Resources .grrc dirs" >> $base_dir/$g_app.links.temp
append2 *.grrc


echo "\n# Install Grr.app/Resources .grrdb stuff" >> $base_dir/$g_app.install.temp
echo "\n# Symlinks Grr.app/Resources .grrdb dirs" >> $base_dir/$g_app.links.temp
append2 *.grrdb


mv $base_dir/$g_app.install.temp	$base_dir/debian/install
mv $base_dir/$g_app.links.temp		$base_dir/debian/links
