#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""App for showing some help."""

# Various required variables and locations
from GroundControl.gtkviews  import GtkApp, Window
from GroundControl import __version__, __appname__, __stage__

VERSION = "<i>%s Version: %s (%s)</i>" % (
    __appname__, __version__, __stage__)

class HelpWindow(Window):
    """Show a help file."""
    name = 'help'

    def load(self, page, **kwargs):
        """Load the requesting merge gui."""
        if HelpApp.is_help(page):
            content = HelpApp.help_message[page]
            self.widget('content').set_markup(content)
        self.widget('version').set_markup(VERSION)
        super(HelpWindow, self).load(**kwargs)

    def is_valid(self):
        """return true if the dialog has everything required."""
        return True


class HelpApp(GtkApp):
    """An application to show some help to the user."""
    gtkfile = 'help.glade'
    windows = [ HelpWindow ]
    
    @staticmethod
    def is_help(page):
        return page in HelpApp.help_message

    help_message = {
        'code-commited': 
            _("""Ground Control has committed the changes you have made to your local branch (the current directory).\n\nIf you would like to share your changes with others you will need to upload your branch to Launchpad.\n\nYou will not be able to upload until all changes have been committed to your local branch."""),

        'code-mergereq':
            _("""Ground Control has created a merge request to alert the upstream developers that you wish to incorporate your changes into their branch.\n\nAny subsequent changes you make to this branch will be added to this merge request once you have committed locally and uploaded to Launchpad."""),

        'code-modified': 
            _("""Ground Control has determined that there are new and/or modified files within your local branch.\n\nWhen you commit your changes, you will have the opportunity to describe the changes you have made. The description you enter should be accurate and succinct, as it serves as a history of your branch changes."""),

        'code-uploaded':
            _("""Ground Control has uploaded your changes to a personal branch within your Launchpad account.\n\nYou can now submit a merge request which will inform the project developers of your new hosted branch."""),

        'configure':
            _("""Ground Control needs to access and download information from your Launchpad account to this machine.\n\nYou will have the opportunity to create a Launchpad account if you do not currently have one."""),

        'project':
            _("""You are currently within the project view where you can create local branches of projects hosted on Launchpad.\n\nLocal branches can be uploaded to your Launchpad account and proposed for merging with the project's main development branch."""),

        'projects':
            _("""You are currently within the projects directory. Here you can create local projects (and related branches) based upon those hosted on Launchpad.\n\nIf you wish to delete the project, simply remove the project directory - this will also remove any local branches related to the project."""),
}


