#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""
Launchpad desktop integration libraries for GroundControl
"""

import os
import sys
import gettext
import locale

__stage__ = "DEV"
__appname__ = "groundcontrol"
__version__ = "1.6.5"

BASE_DIR = os.path.abspath( os.path.join(
    os.path.dirname(os.path.realpath(__file__)), '..') )

# This hack brought to you by the lucid build system
# That doesn't seem to want to run install_lib extras
if '/lib/' in BASE_DIR or '/pyshared' in BASE_DIR:
    __stage__ = "LIVE"
    BASE_DIR = '/usr/share/groundcontrol'
else:
    sys.stderr.write("%s %s: %s\n" % (__stage__, __version__, BASE_DIR))

GLADE_DIR  = os.path.join(BASE_DIR, 'glade')
PIXMAP_DIR = os.path.join(BASE_DIR, 'pixmaps')

if __stage__ == "LIVE":
    PO_DIR     = os.path.join(BASE_DIR, '../locale')
else:
    PO_DIR     = os.path.join(BASE_DIR, 'build/mo')

DOC_DIR    = os.path.join(BASE_DIR, 'doc')

# Globally deal with localization (l10n)
gettext.bindtextdomain(__appname__, PO_DIR)
locale.setlocale(locale.LC_ALL, '')
gettext.textdomain(__appname__)
gettext.install(__appname__)

