#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
TAR=../groovy_$2.orig.tar.gz
VERSION=$(echo $2 | sed 's/~beta/-beta-/g')
DIR=groovy-$VERSION

# clean up the upstream tarball
unzip $3
GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.pdf' --exclude '*.class' $DIR
rm -rf $3 $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
