/*
 * groach
 * Command line version main module.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <signal.h>

#include <gnome.h>
#include <gdk/gdkx.h>

#include "groach.h"

#include "types.h"
#include "theme-search.h"

#include <X11/Xatom.h>/* for XA_WINDOW */
#include "vroot.h"/* file is taken from gnome-libs-1.0.54 */


#define APPNAME  "groach-cmd"

/* Private function declarations */
static void sighup_handler(int sig);

int
main(int argc, char *argv[])
{
	GdkWindow *root_win;
	GroController *controller;
	GroTheme *theme;
	ThemeSearch *theme_search;
	char *theme_dirname;
	char **theme_name;
	static int num_gmoves = NUM_GMOVES_DEFAULT;
	static int speed = 0;
	static char *theme_search_paths = NULL;/* theme search paths */
	poptContext ctx;
	static const struct poptOption options[] = {
		{"num", 'n', POPT_ARG_INT, &num_gmoves, 0,
		 N_("Specify the number of groaches"), N_("NUMBER")},
		{"speed", 's', POPT_ARG_INT, &speed, 0,
		 N_("Specify the speed of groaches(milli-second)"), N_("INTERVAL(ms)")},
		{"theme_search_path", 'T', POPT_ARG_STRING, &theme_search_paths, 0,
		 N_("Specify search paths of theme"), N_("PATH:PATH:...")},
		{NULL, '\0', 0, NULL, 0, NULL, NULL}
	};

	srand((int)(getpid() + time(NULL)));
	signal(SIGHUP, sighup_handler);/* ridiculous... see the description below. */
	
	/* Initialize the i18n stuff */
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);
	
	/*
	 * gnome_init() is always called at the beginning of a program.  it
	 * takes care of initializing both Gtk and GNOME.  It also parses
	 * the command-line arguments.
	 */
	gnome_init_with_popt_table(APPNAME, VERSION, argc, argv,
							   options, 0, &ctx);
	theme_name = poptGetArgs(ctx);

	/* For Virtual Root Window handling (see vroot.h),
	   I don't use GDK_ROOT_WINDOW() nor GDK_ROOT_PARENT(). */
	root_win = gdk_window_foreign_new(DefaultRootWindow(GDK_DISPLAY()));
	/* root_win = GDK_ROOT_PARENT();
	   root_win = gdk_window_foreign_new(GDK_ROOT_WINDOW());*/

	controller = gro_controller_new(root_win, NULL);

	/* Look for theme, and attach it to the controller */
	theme_search = theme_search_new(theme_search_paths);
	if (theme_name == NULL || theme_name[0] == NULL) {
		theme_dirname = theme_search_find_path(theme_search, THEME_DEFAULT);
		if (theme_dirname == NULL) {
			g_error(_("Can't find theme: %s\n"), THEME_DEFAULT);
		}
	} else {
		theme_dirname = theme_search_find_path(theme_search, theme_name[0]);
		if (theme_dirname == NULL) {
			g_error(_("Can't find theme: %s\n"), theme_name[0]);
		}
	}
	theme = gro_theme_load(theme_dirname, THEME_LOAD_NORMAL);
	if (theme == NULL) {
		g_error(_("Can't load theme: %s\n"), theme_dirname);
	}
	gro_controller_attach_theme(controller, theme);
	g_free(theme_dirname);
	theme_search_delete(theme_search);
	
	gro_controller_add_gmoves(controller, num_gmoves);
	if (speed != 0)
		gro_controller_change_interval(controller, speed);

	poptFreeContext(ctx);

	gro_controller_run(controller);
	
	gtk_main();

	gro_controller_stop(controller);
	gro_controller_detach_theme(controller);
	gro_controller_delete(controller);

	gdk_window_unref(root_win);

	gtk_exit(0);
	return 0;
}


/**
 * sighup_handler:
 * SIGHUP signal is sent by myself, when all roaches are dead.
 * I could call gtk_main_quit() directly instead of SIGHUP, but I don't.
 * Because I plan to support applet version interface.
 * If I had a better way than SIGHUP, I would like it...
 **/
static void
sighup_handler(int sig)
{
	gtk_main_quit();/* return to after gtk_main() */
}
