/*
 * Drawing window module
 * Refer to growin.h about details.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "growin.h"

GroWindow*
gro_window_new(GdkWindow *window)
{
	GroWindow *gro_win;

	g_return_val_if_fail(window != NULL, NULL);

	gro_win = g_new(GroWindow, 1);

	gro_win->window = window;
	gdk_window_ref(window);

	gro_win->gc = gdk_gc_new(window);
	if (gro_win->gc == NULL)
		g_error("gdk_gc_new\n");/* I have no idea to continue... */

	return gro_win;
}

void
gro_window_delete(GroWindow *gro_win)
{
	gdk_gc_unref(gro_win->gc);
	gdk_window_unref(gro_win->window);
	g_free(gro_win);
}
