#!/usr/bin/python
"""Copyright (C) 2009  Kristof Bamps

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import urllib
import urllib2
import cookielib
import os
import pwd
from xml.sax import make_parser
from xml.sax.handler import ContentHandler 

import time



class GoogleReader:
    def __init__(self):
        os.system('rm -rf /tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
+ '/ > /dev/null')
        os.mkdir('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/')
        self.totalUnread = 0
        self.loadCookies()
        self.feedList = []
        
    #checks if the temporary dir in which we save cookies and data exists
    def checkFilesExist(self):
        if not (os.path.exists('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/')):
            os.mkdir('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/')
            self.loadCookies()
            self.login(self.email, self.passwd)
            
    #used by the login function: loads the cookie module
    def loadCookies(self):
        self.cj = cookielib.LWPCookieJar()
    # This is a subclass of FileCookieJar
    # that has useful load and save methods

        if self.cj is not None:
        # we successfully imported
        # one of the two cookie handling modules
            if os.path.isfile('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/cookies.lwp'):
            # if we have a cookie file already saved
            # then load the cookies into the Cookie Jar
                self.cj.load('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/cookies.lwp')

            # Now we need to get our Cookie Jar
            # installed in the opener;
            # for fetching URLs
            if cookielib is not None:
                # if we use cookielib
                # then we get the HTTPCookieProcessor
                # and install the opener in urllib2
                opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cj))
                urllib2.install_opener(opener)

            else:
                # if we use ClientCookie
                # then we get the HTTPCookieProcessor
                # and install the opener in ClientCookie
                opener = ClientCookie.build_opener(ClientCookie.HTTPCookieProcessor(cj))
                ClientCookie.install_opener(opener)
                
    #login to google reader
    #parameters: the email and password of the user
    #no return value
    def login(self, email, passwd):
        self.checkFilesExist()
        self.email = email
        self.passwd = passwd
        url = 'https://www.google.com/accounts/ServiceLoginAuth'
        user_agent = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)'
        login = {'Email' : email,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
            'Passwd' : passwd}
        data = urllib.urlencode(login)
        txheaders =  {'User-agent' : 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)'}
        # fake a user agent, some websites (like google) don't like automated exploration
        try:
            req = urllib2.Request(url, data, txheaders)
            # create a request object

            handle = urllib2.urlopen(req)
            # and open it to return a handle on the url
            del req

        except IOError, e:
            self.gotCookies = False

        
        if self.cj is None:		
            self.gotCookies = False
        else:
            self.gotCookies = True
            
    #get count of unread items, per feed
    #returns list of feeds
    def getUnreadFeeds(self):
        self.checkFilesExist()
        url = 'https://www.google.com/reader/api/0/unread-count?all=true'
        req = urllib2.Request(url)
        response = urllib2.urlopen(req)
        del req
        testxml = ''
        try:
            testxml = response.read()
        except:
            pass
        del response
        if '<object>' in testxml:
            try:
                fileHandle = open ( '/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/list.xml', 'w' ) 
                fileHandle.write (testxml)
                fileHandle.close()
                parser = make_parser()    
                listparser = listParser()
                
                parser.setContentHandler(listparser)
                parser.parse(open('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/list.xml')) 
                self.unreadList = sorted (listparser.list, self.compare)
                self.totalUnread = listparser.totalUnread
                del parser
                del listparser
                #try to read the feednames from a file, if it fails: get them from the server and try again
                if not self.readFeedNames():
                    self.updateFeedNames()                
                    self.readFeedNames()
                return self.feedList
            except:
                if testxml.strip() == '<object>\n    <number name="max">1000</number>\n    <list name="unreadcounts"/>\n</object>':
                    self.totalUnread = 0
                pass
        return []
            
    #compare function to sort the items by unread count
    #shouldn't be used from outside this class
    def compare(self,a,b):
        return cmp(int(b[0]), int(a[0]))
    
    #read the feed ids and names from a file
    def readFeedNames(self): 
        try:
            self.checkFilesExist()
            parser = make_parser()    
            nameparser = nameParser()
            parser.setContentHandler(nameparser)
            parser.parse(open('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/names.xml')) 
            
            self.feedList = []
            for feed1 in self.unreadList:
                if '/state/com.google/broadcast-friends' in feed1[1]:
                    self.feedList.append(feed(feed1[0],'Friend\'s shared items', feed1[1]))
                else:
                    for feed2 in nameparser.list:
                        if 'feed/' == feed1[1][0:5] and feed1[1] == feed2[1]:
                            self.feedList.append(feed(feed1[0],feed2[0], feed1[1]))
            
            del parser
            del nameparser
            return True
        except:
            return False
    
    #private: get the ids and names of the feeds
    #shouldn't be called from outside this class
    def updateFeedNames(self):
        self.checkFilesExist()
        url = 'http://www.google.com/reader/api/0/subscription/list'
        req = urllib2.Request(url)
        response = urllib2.urlopen(req)
        testxml = response.read()	#read the opened page
        del response
        if '<object>' in testxml:	#if we got a XML file
            fileHandle = open ( '/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/names.xml', 'w' ) 
            fileHandle.write (testxml)
            del testxml
            fileHandle.close
            
    #get the titles, ids and links of all unread items
    #parameter maximum: the maximum number of feedItems you want returned
    #returns list of feedItems
    def getUnreadTitles(self, maximum = 100):
        self.checkFilesExist()
        if len(self.feedList) != 0 and self.totalUnread != 0:
            url = 'http://www.google.com/reader/atom/user/-/state/com.google/reading-list?xt=user/-/state/com.google/read&n=' + str(maximum )

            req = urllib2.Request(url)
            response = urllib2.urlopen(req)
            titles = response.read()
            del response
            
            if '<title>' in titles:
                fileHandle = open ( '/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/titles.xml', 'w' ) 
                fileHandle.write (titles)
                fileHandle.close()
                    
                parser = make_parser()    
                itemparser = itemParser()
                parser.setContentHandler(itemparser)
                parser.parse(open('/tmp/googlereader-' + pwd.getpwuid(os.getuid())[0]
 + '/titles.xml')) 
                    
                self.titles = itemparser.list
                del parser
                del itemparser
                return self.titles
            else:
                return []
            
    #marks all items as read
    #no return value
    def markAllRead(self):  
            self.unreadList = self.getUnreadFeeds()
        
            req = urllib2.Request ('http://www.google.com/reader/api/0/token')
            f = urllib2.urlopen (req)
            token = f.read()

            for i in range (0, len(self.unreadList)):
                data = { 's' : self.unreadList[i].id, 'T' : token, 'ac' : 'subscribe' }
                data = urllib.urlencode (data)
                url = 'http://www.google.com/reader/api/0/mark-all-as-read'
                req = urllib2.Request (url, data)
                f = urllib2.urlopen (req)
             
    #subscribes to a feed
    #parameter: the feed to subscribe to
    #no return value   
    def subscribetoFeed(self, feed):
        req = urllib2.Request ('http://www.google.com/reader/api/0/token')
        f = urllib2.urlopen (req)
        token = f.read()
        
        data = { 's' : 'feed/' + feed, 'T' : token, 'ac' : 'subscribe'}
        data = urllib.urlencode (data)
        url = 'http://www.google.com/reader/api/0/subscription/edit?client=contact:' + self.email
        req = urllib2.Request (url, data)
        f = urllib2.urlopen (req)  
        
#contains the number of unread items for a feed
class feed :
    def __init__ (self, unreadItems, title, id):
        self.title = title
        self.unreadItems = unreadItems
        self.id = id

#contains info about an unread item
class feedItem:
    def __init__ (self, title, id, link, feed):
        self.title = title
        self.id = id
        self.link = link
        self.feed = feed
        
#parses the xml list with unread items per feed
class listParser(ContentHandler):
    def __init__ (self):
        self.object = False
        self.isId, self.isCount, self.isTotalUnread = False, False, False; 
        self.totalUnread = 0
        self.list = []
        
    def startElement(self, name, attrs):
        if name == 'object':
            self.object = True
        if name == 'string' and attrs.get('name',"") == 'id':
            self.isId = True
        elif name == 'number' and attrs.get('name',"") == 'count':
            self.isCount = True
            
    def endElement(self, name):
        if name == 'object' and self.object:
            if not self.isTotalUnread:
                self.list.append((self.count, self.id))
            else:
                self.isTotalUnread = False
        if name == 'object':
            self.object = False
                
    def characters(self, ch):
        if self.isId:
            self.id = ch
            self.isId = False
            if '/state/com.google/reading-list' in ch:
                self.isTotalUnread = True
        elif self.isCount:
            self.count = int(ch)            
            if self.isTotalUnread:
                self.totalUnread = self.count
            self.isCount = False
            
#parses the xml list with feed ids and names
class nameParser(ContentHandler):
    
    def __init__ (self):
        self.object = False
        self.isId, self.isTitle, self.isList = False, False, False; 
        self.list = []
        
    def startElement(self, name, attrs):
        if name == 'list' and attrs.get( 'name', "") == "categories":
            self.isList = True
        if name == 'object':
            self.object = True
        if name == 'string' and attrs.get('name',"") == 'id':
            self.isId = True
        elif name == 'string' and attrs.get('name',"") == 'title':
            self.isTitle = True
            
    def endElement(self, name):
        if name == 'object' and self.object:
            self.list.append((self.title, self.id))
        if name == 'object':
            self.object = False
        if name == 'list':
            self.isList = False
                
    def characters(self, ch):
        if not self.isList:
            if self.isId:
                self.id = ch
                self.isId = False
            elif self.isTitle:
                self.title = ch  
                self.isTitle = False
    

#parses the list with feedItems
class itemParser(ContentHandler):
    
    def __init__ (self):
        self.isTitle, self.isId, self.isSource, self.isFriends= False, False, False, False; 
        self.list = []
        
    def startElement(self, name, attrs):
        try:
            if not self.isSource:
                if name == 'title' and attrs.get('type',"") == 'html':
                    self.isTitle = True
                if name == 'id' and (attrs.get('gr:original-id') or attrs.get('gr:original-id')== '' ):
                    self.isId = True
                if name == 'link' and attrs.get('rel') == 'alternate':
                    self.link = attrs.get('href')
                if name == 'source':
                    self.feed = attrs.get('gr:stream-id')
                    self.isSource = True
                if name == 'category' and '/state/com.google/broadcast-friends' in attrs.get('term'):
                    self.isFriends = True
                    self.friendsFeed = attrs.get('term')
        except:
            pass
            
    def endElement(self, name):
        if name == 'entry' and not self.isFriends:
            self.list.append(feedItem(self.title, self.id, self.link, self.feed))
        elif name == 'entry':
            self.list.append(feedItem(self.title, self.id, self.link, self.friendsFeed))
            self.isFriends = False
        if name == 'source':
            self.isSource = False
                
    def characters(self, ch):
        if self.isTitle:
            self.title = ch  
            self.isTitle = False
        if self.isId:
            self.id = ch  
            self.isId = False

#example usage            
"""if __name__ == "__main__":
    greader = GoogleReader()
    greader.login('user', 'password')
    for feed in greader.getUnreadFeeds():
        print feed.title.encode('utf8') + ' ' + str(feed.unreadItems)
    for feedItem in greader.getUnreadTitles():
        print feedItem.title + ',' + feedItem.id + ',' + feedItem.link + ',' + feedItem.feed
    greader.markAllRead()
    greader.subscribetoFeed('http://www.reddit.com/.rss')"""
