/**
* Copyright 2005-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

/*
 * C Implementation: grib_cmp
 *
 * Description: Binary comparison between two files
 *
 *
 * Author: Enrico Fucile <enrico.fucile@ecmwf.int>
 *
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

void usage(char* progname) {
  printf("\nUsage: %s file file\n",progname);
  exit(1);
}

extern int errno;

int main(int argc, char *argv[]) {
  int err=0,count=0;
  unsigned char a,b;
  char *file1=NULL,*file2=NULL;
  FILE *f1 = NULL;
  FILE *f2 = NULL;

  if (argc != 3) usage(argv[0]);
  file1=argv[1];
  file2=argv[2];

  f1 = fopen(file1,"r");
  f2 = fopen(file2,"r");

  if(!f1) {
    perror(file1);
    exit(1);
  }

  if(!f2) {
    perror(file2);
    exit(1);
  }

  count=1;
  while (!feof(f1) && !feof(f2)) {
     if (fread(&a,1,1,f1) != 1 && !feof(f1)) {
       printf("%s error: %s\n",file1,strerror(errno));
       exit(1);
     }
     if (fread(&b,1,1,f2)!=1 && !feof(f2)) {
       printf("%s error: %s\n",file2,strerror(errno));
       exit(1);
     }
     if (a != b) {
       printf("%s differs from %s at byte %d (0x%.2X != 0x%.2X) \n",file1,file2,count,a,b);
       return 1;
     }
     count++;
  }

  if (!feof(f1) && feof(f2)) {
    printf("%s bigger than %s\n",file1,file2);
    err=1;
  }
  if (!feof(f2) && feof(f1)) {
    printf("%s bigger than %s\n",file2,file1);
    err=1;
  }

  fclose(f1);
  fclose(f2);

  return err;
}

