C Copyright 2005-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C
C
C  Fortran 77 Implementation: set_fortran
C
C  Description: how to set key values.
C
C
C  Author: Enrico Fucile <enrico.fucile@ecmwf.int>
C
C
C
      program set
      implicit none
      include 'grib_api_f77.h'
      integer err
      integer*4 centre
      integer*4 int_value
      character*10 string_value
      character*20 string_centre
      integer len
      integer size
      integer infile,outfile
      integer igrib,iret
      character*256 error

      infile=5
      outfile=6

      call grib_check(grib_open_file(infile
     X,'../../data/regular_latlon_surface.grib1','r'))

      call grib_check(grib_open_file(outfile
     X,'../../data/out.grib1','w'))

C     a new grib message is loaded from file
C     igrib is the grib id to be used in subsequent calls
      call grib_check(grib_new_from_file(infile,igrib))

C     set centre as a long */
      centre=80
      call grib_check(grib_set_int(igrib,'centre',centre))

C     get centre as a integer*4
      call grib_check(grib_get_int(igrib,'centre',int_value))
      write(*,*) 'centre=',int_value

C     get centre as a string
      call grib_check(grib_get_string(igrib,'centre',string_value))
      string_centre='centre='//string_value
      write(*,*) string_centre

C     write modified message to a file
      call grib_check(grib_write(igrib,outfile))

      call grib_check(grib_release(igrib))

      call grib_check(grib_close_file(infile))

      call grib_check(grib_close_file(outfile))

      end
