C Copyright 2005-2007 ECMWF
C
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C
C
C  Fortran 77 Implementation: keys_iterator
C
C  Description:
C  Example on how to use keys_iterator functions and the
C  grib_keys_iterator structure to get all the available
C  keys in a message.
C
C  Author: Enrico Fucile <enrico.fucile@ecmwf.int>
C
C
C
      program keys_iterator
      implicit none
      include 'grib_api_f77.h'
      character*20 name_space
      integer kiter,ifile,igrib,iret
      character*256 key
      character*256 value
      character*512 all
      integer len,strlen
      integer grib_count
      len=256

      ifile=5

      call grib_check(grib_open_file(ifile,
     X'../../data/regular_latlon_surface.grib1','r'))

      grib_count=0
C     Loop on all the messages in a file.
  10  iret=grib_new_from_file(ifile,igrib)
      if (igrib .eq. -1 )  then
        if (iret .ne.0) then
           call grib_check(iret)
        endif
        stop
      endif

      grib_count=grib_count+1
      write(*,'("-- GRIB N.",I4," --")') grib_count

C     valid name_spaces are ls and mars
      name_space='ls'
C     name_space=' ' to get all the keys */
C     name_space=' '

      call grib_check(
     Xgrib_keys_iterator_new(igrib,kiter,name_space))
C     call grib_check(grib_keys_iterator_skip_read_only(kiter))
C     call grib_check(grib_keys_iterator_skip_function(kiter))
C     call grib_check(grib_keys_iterator_skip_not_coded(kiter))

  20  if (grib_keys_iterator_next(kiter) .ne. 1) goto 10

      call grib_check(grib_keys_iterator_get_name(kiter,key))
      call grib_check(grib_get_string(igrib,key,value))
      all='|' // trim(key)//'|' //  ' = ' //'|' //  trim(value) // '|' 
      write(*,*) trim(all)

      goto 20

      call grib_check(grib_keys_iterator_delete(kiter))

      call grib_check(grib_release(igrib))

      call grib_check(grib_close_file(ifile))

      end

