/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCSTRINGLIST_H__
#define __GRDCSTRINGLIST_H__

G_BEGIN_DECLS

#define GRDC_TYPE_STRING_LIST               (grdc_string_list_get_type ())
#define GRDC_STRING_LIST(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_STRING_LIST, GrdcStringList))
#define GRDC_STRING_LIST_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_STRING_LIST, GrdcStringListClass))
#define GRDC_IS_STRING_LIST(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_STRING_LIST))
#define GRDC_IS_STRING_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_STRING_LIST))
#define GRDC_STRING_LIST_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_STRING_LIST, GrdcStringListClass))

typedef gboolean (*GrdcStringListValidationFunc) (const gchar *new_str, gchar **error);

typedef struct _GrdcStringList
{
    GtkTable table;

    GtkListStore *store;
    GtkWidget *list;
    GtkWidget *new_entry;
    GtkWidget *status_label;

    GrdcStringListValidationFunc validation_func;
    gboolean has_error;
} GrdcStringList;

typedef struct _GrdcStringListClass
{
    GtkTableClass parent_class;
} GrdcStringListClass;

GType grdc_string_list_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_string_list_new (void);

void grdc_string_list_set_text (GrdcStringList *gsl, const gchar *text);

void grdc_string_list_set_new_entry_tooltip_text (GrdcStringList *gsl, const gchar *tooltips);

void grdc_string_list_set_validation_func (GrdcStringList *gsl, GrdcStringListValidationFunc func);

/* The returned text is newly allocated */
gchar* grdc_string_list_get_text (GrdcStringList *gsl);

G_END_DECLS

#endif  /* __GRDCSTRINGLIST_H__  */

