/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "grdcpixmaps.h"

static GdkPixbuf *grdc_pixmap_buf[GRDC_N_PIXMAPS];

void
grdc_pixmap_init (void)
{
    grdc_pixmap_buf[GRDC_PIXMAP_TYPE_LOGO] = gdk_pixbuf_new_from_file (GRDC_PIXMAPSDIR "/grdc.png", NULL);
    grdc_pixmap_buf[GRDC_PIXMAP_TYPE_RDP] = gdk_pixbuf_new_from_file (GRDC_PIXMAPSDIR "/grdc-rdp.png", NULL);
    grdc_pixmap_buf[GRDC_PIXMAP_TYPE_RDP_SSH] = gdk_pixbuf_new_from_file (GRDC_PIXMAPSDIR "/grdc-rdp-ssh.png", NULL);
    grdc_pixmap_buf[GRDC_PIXMAP_TYPE_VNC] = gdk_pixbuf_new_from_file (GRDC_PIXMAPSDIR "/grdc-vnc.png", NULL);
    grdc_pixmap_buf[GRDC_PIXMAP_TYPE_VNC_SSH] = gdk_pixbuf_new_from_file (GRDC_PIXMAPSDIR "/grdc-vnc-ssh.png", NULL);
    grdc_pixmap_buf[GRDC_PIXMAP_TYPE_SSH] = gdk_pixbuf_new_from_file (GRDC_PIXMAPSDIR "/grdc-ssh.png", NULL);
}

GdkPixbuf*
grdc_pixmap (GrdcPixmapType type, gint size)
{
    GdkPixbuf *scaled;

    if (size <= 0) return grdc_pixmap_buf[type];
    scaled = gdk_pixbuf_scale_simple (grdc_pixmap_buf[type], size, size, GDK_INTERP_HYPER);
    return scaled;
}

