/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 
#ifndef __GRDCCONNECTIONWINDOW_H__
#define __GRDCCONNECTIONWINDOW_H__

#include "grdcfile.h"

G_BEGIN_DECLS

/* Open a new connection window for a .grdc file */
gboolean grdc_connection_window_open (GtkWindow *parent, const gchar *filename, gboolean quit_when_close);
/* Open a new connection window for a given GrdcFile struct. The struct will be freed after the call */
void grdc_connection_window_open_struct (GtkWindow *parent, GrdcFile *grdcfile, gboolean quit_when_close);
/* Return TRUE if there's any active connections */
gint grdc_connection_window_count (void);
/* Terminate all active connections */
void grdc_connection_window_quit_all (void);



G_END_DECLS

#endif  /* __GRDCCONNECTIONWINDOW_H__  */

