/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPLUG_RDP_H__
#define __GRDCPLUG_RDP_H__

#include "grdcfile.h"
#include "grdcplug.h"

G_BEGIN_DECLS

#define GRDC_TYPE_PLUG_RDP              (grdc_plug_rdp_get_type ())
#define GRDC_PLUG_RDP(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_PLUG_RDP, GrdcPlugRdp))
#define GRDC_PLUG_RDP_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_PLUG_RDP, GrdcPlugRdpClass))
#define GRDC_IS_PLUG_RDP(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_PLUG_RDP))
#define GRDC_IS_PLUG_RDP_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_PLUG_RDP))
#define GRDC_PLUG_RDP_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_PLUG_RDP, GrdcPlugRdpClass))

typedef struct _GrdcPlugRdp
{
    GrdcPlug plug;

    GtkWidget *socket;
    GPid pid;
    gint output_fd;
    gint error_fd;
} GrdcPlugRdp;

typedef struct _GrdcPlugRdpClass
{
    GrdcPlugClass parent_class;
} GrdcPlugRdpClass;

GType grdc_plug_rdp_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_plug_rdp_new (void);

G_END_DECLS

#endif  /* __GRDCPLUG_RDP_H__  */

