/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPLUG_H__
#define __GRDCPLUG_H__

#include "grdcinitdialog.h"
#include "grdcfile.h"

G_BEGIN_DECLS

#define GRDC_TYPE_PLUG                  (grdc_plug_get_type ())
#define GRDC_PLUG(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_PLUG, GrdcPlug))
#define GRDC_PLUG_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_PLUG, GrdcPlugClass))
#define GRDC_IS_PLUG(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_PLUG))
#define GRDC_IS_PLUG_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_PLUG))
#define GRDC_PLUG_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_PLUG, GrdcPlugClass))

#define MAX_ERROR_LENGTH 1000

typedef enum
{
    GRDC_PLUG_FEATURE_PREF,
    GRDC_PLUG_FEATURE_PREF_COLORDEPTH,
    GRDC_PLUG_FEATURE_PREF_QUALITY,
    GRDC_PLUG_FEATURE_PREF_VIEWONLY
} GrdcPlugFeature;

typedef struct _GrdcPlug
{
    GtkFixed fixed;

    GtkWidget *init_dialog;
    gboolean has_error;
    gchar error_message[MAX_ERROR_LENGTH + 1];
} GrdcPlug;

typedef struct _GrdcPlugClass
{
    GtkFixedClass parent_class;

    void (* connect) (GrdcPlug *gp);
    void (* disconnect) (GrdcPlug *gp);

    /* "Virtual" functions have to be implemented in sub-classes */
    gboolean (* open_connection) (GrdcPlug *gp, GrdcFile *grdcfile);
    gboolean (* close_connection) (GrdcPlug *gp);
    gboolean (* query_feature) (GrdcPlug *gp, GrdcPlugFeature feature);
    void (* call_feature) (GrdcPlug *gp, GrdcPlugFeature feature, gpointer data);
} GrdcPlugClass;

GType grdc_plug_get_type (void) G_GNUC_CONST;

gboolean grdc_plug_open_connection (GrdcPlug *gp, GrdcFile *grdcfile);
gboolean grdc_plug_close_connection (GrdcPlug *gp);
gboolean grdc_plug_query_feature (GrdcPlug *gp, GrdcPlugFeature feature);
void grdc_plug_call_feature (GrdcPlug *gp, GrdcPlugFeature feature, gpointer data);
/* Provide thread-safe way to emit signals */
void grdc_plug_emit_signal (GrdcPlug *gp, const gchar *signal);

G_END_DECLS

#endif  /* __GRDCPLUG_H__  */

