/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "grdcinitdialog.h"

static void
grdc_init_dialog_class_init (GrdcInitDialogClass *klass)
{
}

static void
grdc_init_dialog_destroy (GrdcInitDialog *dialog, gpointer data)
{
    g_free (dialog->title);
    g_free (dialog->password);
}

static void
grdc_init_dialog_init (GrdcInitDialog *dialog)
{
    g_signal_connect (G_OBJECT (dialog), "destroy", G_CALLBACK (grdc_init_dialog_destroy), NULL);

    dialog->dialog_content = NULL;
    dialog->mode = GRDC_INIT_MODE_CONNECTING;
    dialog->title = NULL;
    dialog->password = NULL;
    dialog->save_password = FALSE;
}

GType
grdc_init_dialog_get_type (void)
{
    static GType gid_type = 0;

    if (!gid_type)
    {
        static const GTypeInfo gid_info =
        {
            sizeof (GrdcInitDialogClass),
            NULL, /* base_init */
            NULL, /* base_finalize */
            (GClassInitFunc) grdc_init_dialog_class_init,
            NULL, /* class_finalize */
            NULL, /* class_data */
            sizeof (GrdcInitDialog),
            0,    /* n_preallocs */
            (GInstanceInitFunc) grdc_init_dialog_init
        };

        gid_type = g_type_register_static (GTK_TYPE_DIALOG, "GrdcInitDialog", &gid_info, 0);
    }

    return gid_type;
}

static void
grdc_init_dialog_connecting (GrdcInitDialog *dialog)
{
    GtkWidget *table;
    GtkWidget *widget;

    /* Create table */
    table = gtk_table_new (1, 2, FALSE);
    gtk_widget_show (table);
    gtk_table_set_row_spacings (GTK_TABLE (table), 8);
    gtk_table_set_col_spacings (GTK_TABLE (table), 8);
    gtk_container_set_border_width (GTK_CONTAINER (table), 15);

    /* Icon */
    widget = gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG);
    gtk_widget_show (widget);
    gtk_table_attach_defaults (GTK_TABLE (table), widget, 0, 1, 0, 1);

    /* Entries */
    widget = gtk_label_new (dialog->title);
    gtk_widget_show (widget);
    gtk_table_attach_defaults (GTK_TABLE (table), widget, 1, 2, 0, 1);

    if (dialog->dialog_content)
    {
        gtk_container_remove (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), dialog->dialog_content);
    }
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), table, TRUE, TRUE, 0);
    dialog->dialog_content = table;

    gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK, FALSE);

    dialog->mode = GRDC_INIT_MODE_CONNECTING;
}

GtkWidget*
grdc_init_dialog_new (GtkWindow *parent, const gchar *title_format, ...)
{
    GrdcInitDialog *dialog;
    va_list args;

    dialog = GRDC_INIT_DIALOG (g_object_new (GRDC_TYPE_INIT_DIALOG, NULL));

    if (parent)
    {
        gtk_window_set_transient_for (GTK_WINDOW (dialog), parent);
    }

    if (title_format)
    {
        va_start (args, title_format);
        dialog->title = g_strdup_vprintf (title_format, args);
        va_end (args);
    }
    else
    {
        dialog->title = "Connection...";
    }

    gtk_window_set_title (GTK_WINDOW (dialog), dialog->title);
    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    gtk_dialog_add_buttons (GTK_DIALOG (dialog),
        GTK_STOCK_OK, GTK_RESPONSE_OK,
        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
        NULL);

    gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);

    grdc_init_dialog_connecting (dialog);

    return GTK_WIDGET (dialog);
}

gint
grdc_init_dialog_authpwd (GrdcInitDialog *dialog)
{
    GtkWidget *table;
    GtkWidget *password_entry;
    GtkWidget *save_password_check;
    GtkWidget *widget;
    gint ret;

    /* Create table */
    table = gtk_table_new (2, 3, FALSE);
    gtk_widget_show (table);
    gtk_table_set_row_spacings (GTK_TABLE (table), 8);
    gtk_table_set_col_spacings (GTK_TABLE (table), 8);
    gtk_container_set_border_width (GTK_CONTAINER (table), 15);

    /* Icon */
    widget = gtk_image_new_from_stock (GTK_STOCK_DIALOG_AUTHENTICATION, GTK_ICON_SIZE_DIALOG);
    gtk_widget_show (widget);
    gtk_table_attach_defaults (GTK_TABLE (table), widget, 0, 1, 0, 2);

    /* Entries */
    widget = gtk_label_new (_("Password"));
    gtk_widget_show (widget);
    gtk_table_attach_defaults (GTK_TABLE (table), widget, 1, 2, 0, 1);

    password_entry = gtk_entry_new_with_max_length (100);
    gtk_widget_show (password_entry);
    gtk_table_attach_defaults (GTK_TABLE (table), password_entry, 2, 3, 0, 1);
    gtk_entry_set_visibility (GTK_ENTRY (password_entry), FALSE);
    gtk_entry_set_activates_default (GTK_ENTRY (password_entry), TRUE);

    save_password_check = gtk_check_button_new_with_label (_("Save password"));
    gtk_widget_show (save_password_check);
    gtk_table_attach_defaults (GTK_TABLE (table), save_password_check, 1, 3, 1, 2);
    if (dialog->save_password) gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (save_password_check), TRUE);

    /* Pack it into the dialog */
    if (dialog->dialog_content)
    {
        gtk_container_remove (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), dialog->dialog_content);
    }
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), table, TRUE, TRUE, 0);
    dialog->dialog_content = table;

    gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK, TRUE);

    gtk_widget_grab_focus (password_entry);

    dialog->mode = GRDC_INIT_MODE_AUTHPWD;

    /* Now run it */
    ret = gtk_dialog_run (GTK_DIALOG (dialog));
    if (ret == GTK_RESPONSE_OK)
    {
        dialog->password = g_strdup (gtk_entry_get_text (GTK_ENTRY (password_entry)));
        dialog->save_password = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (save_password_check));
    }

    grdc_init_dialog_connecting (dialog);

    return ret;
}

