#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "config.h"
#include "grdcpublic.h"
#include "grdcmain.h"
#include "grdcfilemanager.h"
#include "grdcfileeditor.h"
#include "grdcconnectionwindow.h"
#include "grdcpref.h"

int
main (int argc, char* argv[])
{
    gint ret;

    bindtextdomain (GETTEXT_PACKAGE, GRDC_LOCALEDIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);

#ifdef HAVE_PTHREAD
    g_thread_init (NULL);
    gdk_threads_init ();
#endif

    THREADS_ENTER

    gtk_init (&argc, &argv);

    grdc_file_manager_init ();
    grdc_pref_init ();

    if (argc >= 2 && g_strcmp0 (argv[1], "-q") == 0)
    {
        ret = grdc_file_editor_open_temp (NULL, TRUE);
        if (ret != GTK_RESPONSE_OK) return 0;
    }
    else if (argc >= 3 && g_strcmp0 (argv[1], "-c") == 0)
    {
        if (!grdc_connection_window_open (NULL, argv[2], TRUE)) return 0;
    }
    else
    {
        grdc_main_open ();
    }
    
    gtk_main ();

    THREADS_LEAVE    

    return 0;
}

