/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "grdcpixmaps.h"

static GdkPixbuf*
grdc_pixmap_scale (GdkPixbuf *pixbuf, gint size)
{
    GdkPixbuf *scaled;

    if (size <= 0) return pixbuf;
    scaled = gdk_pixbuf_scale_simple (pixbuf, size, size, GDK_INTERP_HYPER);
    return scaled;
}

static GdkPixbuf *grdc_pixmap_logo_buf = NULL;

GdkPixbuf*
grdc_pixmap_logo (void)
{
    if (grdc_pixmap_logo_buf == NULL)
    {
        grdc_pixmap_logo_buf = gdk_pixbuf_new_from_file (GRDC_GNOME_PIXMAPSDIR "/grdc-applet.png", NULL);
    }
    return grdc_pixmap_logo_buf;
}

static GdkPixbuf *grdc_pixmap_rdp_buf = NULL;

GdkPixbuf*
grdc_pixmap_rdp (gint size)
{
    if (grdc_pixmap_rdp_buf == NULL)
    {
        grdc_pixmap_rdp_buf = gdk_pixbuf_new_from_file (GRDC_GNOME_PIXMAPSDIR "/grdc-applet-rdp.png", NULL);
    }
    return grdc_pixmap_scale (grdc_pixmap_rdp_buf, size);
}

static GdkPixbuf *grdc_pixmap_vnc_buf = NULL;

GdkPixbuf*
grdc_pixmap_vnc (gint size)
{
    if (grdc_pixmap_vnc_buf == NULL)
    {
        grdc_pixmap_vnc_buf = gdk_pixbuf_new_from_file (GRDC_GNOME_PIXMAPSDIR "/grdc-applet-vnc.png", NULL);
    }
    return grdc_pixmap_scale (grdc_pixmap_vnc_buf, size);
}

