# This file is part of the graph-includes package
#
# (c) 2005 Yann Dirson <ydirson@altern.org>
# Distributed under version 2 of the GNU GPL.

package graphincludes::renderer::tulip;

use warnings;
use strict;

use base qw(graphincludes::renderer);

use graphincludes::params;

sub new {
  my $class = shift;
  my $self = {};

  bless ($self, $class);
  return $self;
}

sub printgraph {
  my $self = shift;
  my ($project, $colors, $colorstyles) = @_;

  # give unique numeric IDs to nodes, starting at 1

  my $nodecount = 0;
  my %nodeids;

  foreach my $file (@{$project->{FILES}}) {
    my $label = $project->filelabel($file,1);
    unless (defined $nodeids{$label}) {
      $nodecount++;
      $nodeids{$label} = $nodecount;
    }
  }

  # declare nodes

  print '(nodes';
  for (my $i=1; $i<=$nodecount; $i++) {
    print " ", $i;
  }
  print ")\n";

  # set node labels

  print "(property 0 string \"viewLabel\"\n";
  print " (default \"\" \"\" )\n";
  foreach my $node (keys %nodeids) {
    print " (node $nodeids{$node} \"$node\")\n";
  }
  print ")\n";


  # simple edges

  my $edgecount = 0;

  foreach my $file ($project->get_dep_origins) {
    foreach my $dest ($project->get_dependencies($file)) {
      $edgecount++;
      print "(edge $edgecount ", $nodeids{$file}, ' ', $nodeids{$dest}, ")\n";
    }
  }
}

sub wait {
}

1;
