#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
# Copyright (C) 2008       Brian G. Matherly
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: _MatchesRegexpOf.py 22837 2013-08-09 21:35:05Z nick-h $

#-------------------------------------------------------------------------
#
# Standard Python modules
#
#-------------------------------------------------------------------------
import re
from gen.ggettext import gettext as _

#-------------------------------------------------------------------------
#
# GRAMPS modules
#
#-------------------------------------------------------------------------
from Filters.Rules import Rule

#-------------------------------------------------------------------------
# "Repos having notes that contain a substring"
#-------------------------------------------------------------------------
class MatchesRegexpOf(Rule):

    labels      = [ _('Regular expression:')]
    name        = _('Notes containing <text>')
    description = _("Matches notes that contain text "
                    "which matches a regular expression")
    category    = _('General filters')
    allow_regex = True

    def apply(self, db, note):
        """ Apply the filter """
        text = note.get()
        if self.match_substring(0, text) is not None:
            return True
        return False
