/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.performance.fixture

import org.gradle.performance.measure.DataAmount
import org.gradle.performance.measure.MeasuredOperation

public class MemoryInfoCollector implements DataCollector {
    String outputFileName

    @Override
    List<String> getAdditionalJvmOpts(File workingDir) {
        return Collections.emptyList();
    }

    @Override
    List<String> getAdditionalArgs(File workingDir) {
        return Collections.emptyList();
    }

    public void collect(File testProjectDir, MeasuredOperation operation) {
        def file = new File(testProjectDir, outputFileName).canonicalFile
        if (!file.exists()) {
            throw new RuntimeException("Cannot find $file. Cannot collect memory information if the build hasn't produced one.")
        }
        long bytesConsumed = Long.parseLong(file.text)
        operation.totalMemoryUsed = DataAmount.bytes(bytesConsumed)
    }
}
