/*
 * Copyright 2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.logging.internal;

import org.gradle.logging.TestStyledTextOutput;

class ConsoleStub implements Console {
    private final TextAreaImpl mainArea = new TextAreaImpl();

    public Label getStatusBar() {
        return new Label() {
            public void close() {
            }

            public void setText(String text) {
            }
        };
    }

    @Override
    public void flush() {
    }

    public String getValue() {
        return mainArea.toString();
    }

    public TextArea getMainArea() {
        return mainArea;
    }

    private static class TextAreaImpl extends TestStyledTextOutput implements TextArea {
    }
}
