/*
 * Copyright 2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.util;

public class TextUtil {
    /**
     * The native line separator for the current platform (e.g. \n or \r\n).
     */
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    /**
     * Replaces all line separators (\r, \n, \r\n) in the specified string with
     * the platform's native line separator.
     */
    public static String toNativeLineSeparators(String str) {
        return str.replaceAll("\r\n|\r|\n", LINE_SEPARATOR);
    }
}
