#include "searchMonitor.h"
#include "osl/record/ki2.h"

#include <QLabel>
#include <QTextCodec>

ViewerSearchMonitor::ViewerSearchMonitor(QLabel *l, const osl::NumEffectState& state)
  : label(l), codec(QTextCodec::codecForName("EUC-JP")), root(state),
    node_count(0), elapsed(0)
{
}

void ViewerSearchMonitor::showPV(
  int /*depth*/, size_t node_count, double elapsed, int value,
  osl::Move cur, const osl::Move *first, const osl::Move *last,
  const bool *threatmate_first, const bool *threatmate_last)
{
  pv.clear();
  pv_threatmate.clear();
  if (first == last || cur != *first) {
    pv.push_back(cur);
    pv_threatmate.push_back(false);
  }
  pv.insert(pv.end(), first, last);
  pv_threatmate.insert(pv_threatmate.end(), threatmate_first, threatmate_last);
  pv_value = value * osl::playerToMul(root.turn());
  this->node_count = node_count;
  this->elapsed = elapsed;
  update();
}

void ViewerSearchMonitor::update()
{
  if (! root_move.isNormal())
  {
    return;
  }
  std::string euc_pv = osl::record::ki2::show
    (&*pv.begin(), &*pv.end(), &*pv_threatmate.begin(), &*pv_threatmate.end(), root);
  std::string euc_move = osl::record::ki2::show(root_move, root);
  label->setText(QString::fromUtf8("探索中 %1 節点 %2 %3秒\n%4 %5")
                 .arg(codec->toUnicode(euc_move.c_str(), euc_move.length()))
                 .arg(node_count).arg(elapsed, 0, 'g', 3)
                 .arg(pv_value, 5)
                 .arg(codec->toUnicode(euc_pv.c_str(), euc_pv.length())));
}
