#include "eval/majorPiece.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"

#include "gtest/gtest.h"

using namespace osl;
using namespace osl::state;
using namespace osl::record;

TEST(NumPiecesBetweenBishopAndKingTest, countBetween)
{
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI * -KI * -KE-OU\n"
				 "P2 * -HI *  *  *  *  * -GI-KY\n"
				 "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5-KA *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    ASSERT_EQ(1,
	      gpsshogi::NumPiecesBetweenBishopAndKingAll::countBetween(
		state,
		state.kingSquare<BLACK>(),
		state.pieceAt(Square(9, 5))));
    ASSERT_EQ(0,
	      gpsshogi::NumPiecesBetweenBishopAndKingSelf::countBetween(
		state,
		state.kingSquare<BLACK>(),
		state.pieceAt(Square(9, 5))));
    ASSERT_EQ(1,
	      gpsshogi::NumPiecesBetweenBishopAndKingOpp::countBetween(
		state,
		state.kingSquare<BLACK>(),
		state.pieceAt(Square(9, 5))));
    ASSERT_EQ(3,
	      gpsshogi::NumPiecesBetweenBishopAndKingAll::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 8))));
    ASSERT_EQ(1,
	      gpsshogi::NumPiecesBetweenBishopAndKingSelf::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 8))));
    ASSERT_EQ(2,
	      gpsshogi::NumPiecesBetweenBishopAndKingOpp::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 8))));
  }
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI * -KI * -KE-OU\n"
				 "P2 * -HI *  *  *  *  * -GI-KY\n"
				 "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
				 "P4 * -KA *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 * +KA *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 *  *  *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    ASSERT_EQ(8,
	      gpsshogi::NumPiecesBetweenBishopAndKingAll::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 6))));
    ASSERT_EQ(8,
	      gpsshogi::NumPiecesBetweenBishopAndKingSelf::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 6))));
    ASSERT_EQ(8,
	      gpsshogi::NumPiecesBetweenBishopAndKingOpp::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 6))));
  }
}

TEST(BishopBishopPieceTest, feature)
{
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
				 "P4 *  *  *  *  *  * -FU *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::BishopBishopPiece bbp;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    bbp.featuresOneNonUniq(state, features);
    ASSERT_EQ(1, features.size());
    ASSERT_EQ(bbp.index(osl::newPtypeO(BLACK, PAWN), true, true),
	      features[0].first);
  }
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
				 "P4 *  *  *  *  *  * -FU *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA+GI *  *  *  * +HI * \n"
				 "P9+KY+KE * +KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::BishopBishopPiece bbp;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    bbp.featuresOneNonUniq(state, features);
    ASSERT_EQ(1, features.size());
    ASSERT_EQ(features[0].first,
	      bbp.index(osl::newPtypeO(BLACK, PAWN), false, true));
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
				 "P4 *  *  *  *  *  * -FU *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  * +GI *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE * +KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::BishopBishopPiece bbp;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    bbp.featuresOneNonUniq(state, features);
    ASSERT_EQ(0, features.size());
  }
}

TEST(AttackMajorsInBaseTest, feature)
{
  {
    const NumEffectState state(CsaString(
				 "P1-KY *  *  *  *  * -OU-KE-KY\n"
				 "P2 * -HI *  *  *  * -KI *  * \n"
				 "P3-FU * -KE * -GI * -GI-FU-FU\n"
				 "P4 * -KA+KA * -FU-FU *  *  * \n"
				 "P5 * -FU-FU *  *  *  *  *  * \n"
				 "P6 *  *  * +FU *  *  * +FU * \n"
				 "P7+FU+FU+GI+KI * +FU *  * +FU\n"
				 "P8 *  * +KI *  *  *  * +HI * \n"
				 "P9+KY+KE * +OU *  *  * +KE+KY\n"
				 "P+00KI00FU00FU\n"
				 "P-00GI00FU00FU00FU\n"
				 "+\n").getInitialState());
    gpsshogi::AttackMajorsInBase amib;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    amib.featuresOneNonUniq(state, features);
    ASSERT_EQ(2, features.size());
    ASSERT_EQ(amib.index(ROOK, BISHOP, true, false, false), features[0].first);
    ASSERT_EQ(-1, features[0].second);
    ASSERT_EQ( 0, features[1].first);
    ASSERT_EQ(-1, features[1].second);
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY *  *  *  *  * -OU-KE-KY\n"
				 "P2 *  * -HI *  * -KI-KI *  * \n"
				 "P3-FU * -KE * -GI * -GI-FU-FU\n"
				 "P4 * -KA+KA * -FU-FU *  *  * \n"
				 "P5 * -FU-FU *  *  *  *  *  * \n"
				 "P6 *  *  * +FU *  *  * +FU * \n"
				 "P7+FU+FU+GI+KI * +FU *  * +FU\n"
				 "P8 *  * +KI *  *  *  * +HI * \n"
				 "P9+KY+KE * +OU *  *  * +KE+KY\n"
				 "P+00FU00FU\n"
				 "P-00GI00FU00FU00FU\n"
				 "+\n").getInitialState());
    gpsshogi::AttackMajorsInBase amib;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    amib.featuresOneNonUniq(state, features);
    ASSERT_EQ(2, features.size());
    ASSERT_EQ(amib.index(PTYPE_EMPTY, BISHOP, false, false, false), features[0].first);
    ASSERT_EQ(-1, features[0].second);
    ASSERT_EQ( 0, features[1].first);
    ASSERT_EQ(-1, features[1].second);
  }
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
