TEMPLATE = app
CONFIG += qt thread warn_on
CONFIG += debug

include(../../qt-common-local.pro)
include(../../qt-common.pro)

INCLUDEPATH += . $$OSL_HOME_QT/include ../../include
DEPENDPATH  += . $$OSL_HOME_QT/include ../../include
isEmpty(GPSSHOGIGUI) {
GPSSHOGIGUI = ../../lib/gui
}
isEmpty(GPSSHOGIRECORDDB) {
GPSSHOGIRECORDDB = ../../lib/recorddb
}
isEmpty(GPSSHOGIDBM) {
GPSSHOGIDBM = ../../lib/dbm
}
macx {
  DEFINES += __WORDSIZE=32
} else {
  LIBS += $$RPATH`pwd`/$$GPSSHOGIGUI
  LIBS += $$RPATH`pwd`/$$OSL_HOME_QT/lib/third_party/$$TCMALLOC
}


LIBPATH += $$GPSSHOGIGUI 
LIBS += -lgpsshogigui -lboost_thread$$BOOST_POSTFIX_MT
equals(USE_TOKYO_CABINET,1) {
  LIBPATH += $$GPSSHOGIRECORDDB $$GPSSHOGIDBM 
  LIBS += -lgpsshogirecorddb  -lgpsshogidbm -ltokyocabinet $$OSL_HOME_QT/lib/third_party/$$PROTOBUF/src/.libs/libprotobuf.a $$LIBS
}
LIBS += $$ADDITIONAL_LIBS

qt_version = $$[QT_VERSION]
qt4 = $$find(qt_version, "^4")
CONFIG += debug
count (qt4, 1) {
  QT += qt3support xml network
  RESOURCES = viewer.qrc
  # FIXME
  FORMS += searchdialog4.ui kisendialog4.ui networkdialog4.ui
  HEADERS += httpwindow.h
  SOURCES += httpwindow.cpp
} else {
  IMAGES += images/forward.png images/backward.png images/beginning.png \
          images/close.png images/end.png
  INTERFACES += searchdialog.ui quiescencesearchdialog.ui kisendialog.ui networkdialog.ui
#  Modules that are still not QT4 ready
QT3_ONLY_HEADERS = boardEditor.h
QT3_ONLY_SOURCES = boardEditor.cc
}

# Input
HEADERS += mainwindow.h viewer.h moveList.h analysisViewer.h checkmateViewer.h \
	tabchild.h kifuViewer.h boardTabChild.h \
	moveTree.h boardAndListTabChild.h searchdialogimpl.h piecePair.h \
	piecePairDialog.h moveGeneratorDialog.h quiescenceViewer.h \
	quiescenceTree.h problemAnalyzer.h copyLabel.h \
        kifuAnalyzer.h networkViewer.h dualEvaluationDialog.h \
        network/networkClient.h network/networkBoard.h\
        kifuFile.h boardEditor2.h evalDebug.h clickableLabel.h \
        $$QT3_ONLY_HEADERS
SOURCES += main.cc mainwindow.cc viewer.cc moveList.cc analysisViewer.cc \
	checkmateViewer.cc kifuViewer.cc boardTabChild.cc \
	moveTree.cc boardAndListTabChild.cc searchdialogimpl.cc piecePair.cc \
	piecePairDialog.cc moveGeneratorDialog.cc quiescenceViewer.cc \
	quiescenceTree.cc problemAnalyzer.cc copyLabel.cc \
        kifuAnalyzer.cc networkViewer.cc dualEvaluationDialog.cc \
        network/networkClient.cc network/networkBoard.cc\
        kifuFile.cc boardEditor2.cc evalDebug.cc clickableLabel.cc\
        $$QT3_ONLY_SOURCES
!isEmpty(NTESUKI) {
  FORMS3 += ntesukisearchdialog.ui
  HEADERS += ntesukiViewer.h
  SOURCES += ntesukiViewer.cc
  DEFINES += ENABLE_NTESUKI
}
