#include "eval/minorPiece.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"

#include "gtest/gtest.h"

using namespace osl;
using namespace osl::state;
using namespace osl::record;

typedef osl::FixedCapacityVector<std::pair<int,int>,gpsshogi::MaxActiveWithDuplication> features_t;
class PromotedMinorPiecesTest : public gpsshogi::EvalComponentStages
{
public:
  PromotedMinorPiecesTest() : gpsshogi::EvalComponentStages(new gpsshogi::PromotedMinorPieces)
  {
  }
  void getFeatures(const osl::state::NumEffectState &state,
		   gpsshogi::index_list_t &features) const
  {
    featuresOneNonUniq(state, features);
  }
};

TEST(PromotedMinorPiecesTest, features)
{
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU+TO-FU-FU-FU-FU-FU+TO-FU\n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU-TO+FU+FU+FU+FU+FU-TO+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::index_list_t features;
    PromotedMinorPiecesTest test;
    test.getFeatures(state, features);
    ASSERT_EQ(0, features.size());
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU * +NY-FU-FU+TO\n"
				 "P4 *  *  *  *  * -FU *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 * +FU *  *  *  *  *  *  * \n"
				 "P7+FU-TO+FU+FU+FU+FU+FU-TO+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE * \n"
				 "+\n").getInitialState());
    gpsshogi::index_list_t features;
    PromotedMinorPiecesTest test;
    test.getFeatures(state, features);
    ASSERT_EQ(1, features.size());
    EXPECT_EQ(4, features[0].first);
    EXPECT_EQ(1, features[0].second);
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU+TO-FU-FU+TO-FU-FU-FU+TO\n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU-TO+FU+FU+FU+FU+FU-TO+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::index_list_t features;
    PromotedMinorPiecesTest test;
    test.getFeatures(state, features);
    ASSERT_EQ(2, features.size());
    EXPECT_EQ(3, features[0].first);
    EXPECT_EQ(1, features[0].second);
    EXPECT_EQ(4, features[1].first);
    EXPECT_EQ(1, features[1].second);
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU+TO-FU-FU+TO-FU-FU-FU * \n"
				 "P4 *  *  *  * +TO *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU-TO+FU+FU+FU+FU+FU-TO+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::index_list_t features;
    PromotedMinorPiecesTest test;
    test.getFeatures(state, features);
    ASSERT_EQ(2, features.size());
#ifdef L1BALL_NO_SORT
    EXPECT_EQ(0, features[1].first);
    EXPECT_EQ(1, features[1].second);
#else
    EXPECT_EQ(0, features[0].first);
    EXPECT_EQ(1, features[0].second);
#endif
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU *  * -FU-FU-FU\n"
				 "P4 *  *  *  *  * -FU *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 * -TO *  *  *  *  *  *  * \n"
				 "P7+FU-TO+FU+FU+FU+FU+FU-TO+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::index_list_t features;
    PromotedMinorPiecesTest test;
    test.getFeatures(state, features);
    ASSERT_EQ(1, features.size());
    EXPECT_EQ(3, features[0].first);
    EXPECT_EQ(-1, features[0].second);
  }
}
