/**
 * @file
 * ؽɾؿΥƥȤ򤹤.
 * ꤵ줿̤εͶɽ
 */
#include "kisen_position.h"
#include "analyze_check_result.h"

#include "osl/checkmate/dualCheckmateSearcher.h"
#include "osl/checkmate/dualCheckmateSearcher.tcc"
#include "osl/checkmate/checkmateSearcher.tcc"
#include "osl/checkmate/dominanceTable.h"
#include "osl/checkmate/nullCost.h"
#include "osl/checkmate/nullEstimator.h"
#include "osl/checkmate/analyzer/checkTableAnalyzer.h"
#include "osl/checkmate/h_estimator/effectKing24.h"
#include "osl/checkmate/h_estimator/nearKing24.h"
#include "osl/checkmate/h_estimator/nearKing24Squared.h"

#include "osl/record/csaRecord.h"
#include "osl/hashEffectState.h"
#include "osl/effectUtil.h"
#include "osl/perfmon.h"

#include <boost/scoped_ptr.hpp>
#include <sstream>
#include <string>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <cmath>
#include <unistd.h>

using namespace osl;
using namespace osl::checkmate;
using namespace osl::checkmate::h_estimator;
using record::csa::ICsaRecordStream;

void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " [-H heuristic-type] [-o out] [-l nodelimit] [-k kisen_file_name] "
       << " -w weights " << " -m mapping "
       << endl;
  exit(1);
}

std::ostream *output = 0;
std::string features;

bool verbose = true;
void process_position(KisenFile&, int record_id, int move_id);
size_t limit = 400000;
bool null_mode = false;
bool use_piece_cost = true;
int saturate = 20;

int main(int argc, char **argv)
{
  const char *program_name = argv[0];
  bool error_flag = false;
  const char *kisen_filename = 0;
  const char *output_filename = 0;
  const char *proof = 0, *disproof = 0;

  extern char *optarg;
  extern int optind;
  char c;
  while ((c = getopt(argc, argv, "H:k:l:o:p:d:PS:vh")) != EOF)
  {
    switch(c)
    {
    case 'H':	features = optarg;
      std::cerr << features << " mode\n";
      break;
    case 'k':	kisen_filename = optarg;
      break;
    case 'l':	limit = atoi(optarg);
      assert(limit);
      break;
    case 'o':	output_filename = optarg;
      assert(output_filename);
      break;
    case 'P':	use_piece_cost = false;
      break;
    case 'p':	proof = optarg;
      break;
    case 'd':	disproof = optarg;
      break;
    case 'S':	saturate = atoi(optarg);
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;

  if (error_flag || (! kisen_filename))
    usage(program_name);

  if (proof && disproof)
  {
    assert(features != "");
    if (features == "e")
    {
      EffectKing24::init(proof, disproof);
      EffectKing24::max = saturate;
    }
    else if (features == "n")
    {
      NearKing24::init(proof, disproof);
      EffectKing24::max = saturate;
    }
    else if (features == "n2")
    {
      NearKing24Squared::init(proof, disproof);
      EffectKing24::max = saturate;
    }
    else
    {
      assert(0);
    }
    null_mode = false;
  }
  else
  {
    null_mode = true;
    std::cerr << "null eval mode\n";
  }

  boost::scoped_ptr<std::ostream> os;
  if (output_filename)
  {
    os.reset(new std::ofstream(output_filename));
    output = &*os;
  }
  else
  {
    output = &std::cout;
  }

  try
  {
    nice(20);
    if (kisen_filename)
    {
      KisenFile kisen_file(kisen_filename);
      std::string line;
      while (std::getline(std::cin, line))
      {
	std::istringstream ss(line);
	int record_id, move_id;
	ss >> record_id >> move_id;
	assert(ss);
	process_position(kisen_file, record_id, move_id);
      }
    }
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << "\n";
    return 1;
  }
}

typedef DominanceTable table_t;
void analyze(const table_t& table, const HashKey& key, 
	     const PathEncoding& path, size_t limit, std::ostream& os, 
	     bool is_escape, unsigned long long cycles, size_t node_count)
{
  const CheckHashRecord *record = table.find(key);
  assert(record);

  analyze_check_result(record->proofDisproof().isCheckmateSuccess(),
		       record, path, table.getTwinTable(), limit, os);
  size_t tree_size = 0;
  CheckTableAnalyzer analyzer(table.getTwinTable());
  if (record->proofDisproof().isCheckmateSuccess())
  {
    tree_size = analyzer.proofTreeSize(record, key, path, ! is_escape);
  }
  else if (record->proofDisproof().isCheckmateFail()
	   || record->findLoop(path, table.getTwinTable()))
  {
    tree_size = analyzer.disproofTreeSize(record, key, path, is_escape);
  }
  os << " " << std::setw(7) << tree_size
     << std::setw(9) << table.size()
     << " " << std::setw(14) << cycles
     << " " << std::setw(10) << node_count;
  *output << "\n" << std::flush;
}

template <class H, class Cost>
void search(HashEffectState& state, bool is_escape)
{
  typedef DualCheckmateSearcher<HashEffectState,table_t,H,Cost> searcher_t;
  searcher_t searcher(20000000, false);
  const Player turn = state.getTurn();
  const PathEncoding path(turn);
  clock_start();
  if (is_escape)
  {
    searcher.isLosingStateSlow(limit, state, path);
  }
  else
  {
    // ͤξchangeTurn ϺѤǤϤ
    Move checkmate_move;
    searcher.isWinningStateSlow(limit, state, path, checkmate_move);
  }
  const unsigned long long cycles = clock_stop();
  const Player attacker = (is_escape ? alt(turn) : turn);
  const size_t node_count = searcher.searcher(attacker).getTotalNodeCount();
  const table_t& table = searcher.getTable(attacker);
  analyze(table, state.getHash(), path, limit, *output, is_escape, cycles, node_count);
}


template <class H>
void search(bool use_piece_cost, HashEffectState& state, bool is_escape)
{
  if (use_piece_cost)
    search<H, PieceCost>(state, is_escape);
  else
    search<H, NullCost>(state, is_escape);
}

void process_position(KisenFile& kisen_file, int record_id, int move_id)
{
  const SimpleState sstate = kisen_position(kisen_file, record_id, move_id);

  HashEffectState state(sstate);

  *output << std::setw(7) << record_id << " " 
	  << std::setw(3) << move_id << " ";

  // escape  sokudumi Ƚ̤Ĥʤ
  const Player turn = state.getTurn();
  const bool is_escape = EffectUtil::isKingInCheck(turn, state);

  if (null_mode) 
  {
      search<NullEstimator>(use_piece_cost, state, is_escape);
  }
  else
  {
    if (features == "e")
    {
      search<EffectKing24>(use_piece_cost, state, is_escape);
    }
    else if (features == "n")
    {
      search<NearKing24>(use_piece_cost, state, is_escape);
    }
    else if (features == "n2")
    {
      search<NearKing24Squared>(use_piece_cost, state, is_escape);
    }
    else
    {
      assert(0);
    }
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
