#ifndef GPSSHOGI_GUI_ABSTRACT_BOARD_H
#define GPSSHOGI_GUI_ABSTRACT_BOARD_H
#include <QWidget>
#include <QPixmap>

#include "osl/piece.h"
#include "osl/ptype.h"
#include "osl/player.h"
#include "osl/position.h"

namespace gpsshogi
{
  namespace gui
  {
    class AbstractBoard : public QWidget
    {
      Q_OBJECT
    public:
      AbstractBoard(QWidget *parent = 0);
      QSize sizeHint() const;
    protected:
      virtual void paintEvent(QPaintEvent *);
    signals:
      void statusChanged();
    protected:
      virtual void paintPiece(QPainter *painter, int x, int y, osl::Piece piece);
      virtual osl::Piece getPieceOf(int i) = 0;
      virtual int countPiecesOnStand(osl::Player, osl::Ptype) = 0;
      virtual osl::Piece getPieceAt(osl::Position) = 0;
      virtual osl::Piece getReservePiece(osl::Ptype) = 0;
      virtual osl::Piece getStandPiece(osl::Player, osl::Ptype) = 0;
      virtual bool reversed() const {
	return false;
      }
      const osl::Position getPosition(int x, int y) const;
      const osl::Piece getPiece(int x, int y);
      const QPoint positionToPoint(const osl::Position position) const;
      const QPixmap pieceToImage(osl::Piece) const;
      osl::Piece selectedPiece;
      static const int STAND_SIZE = 80;
      static const int BOX_SIZE = 40;
      static const int BLACK_STAND_X = STAND_SIZE + BOX_SIZE * 9 + 20;
      static const int MARGIN_HEAD = BOX_SIZE;

      bool isOnBoard(int x, int f) const;
    };
  }
}
#endif // GPSSHOGI_GUI_ABSTRACT_BOARD_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
