#!/usr/bin/perl -w
use strict;
use Getopt::Std;
use network::CsaFileSession;
require("ctime.pl");

my %options;
getopts("s:d:",\%options);

my $dir = $options{d} || ".";
my $id = $options{s} || 0;

my $session = new CsaFileSession($dir, $id);

while (<>) {
  chomp;
  if (/^$/) {
    print STDERR "(nop)\n";
    next;
  }
  print STDERR "read $_ " . &ctime(time);
  $session->write($_);
}
