# remove compile directory
rm -rf compile
# remove dist directory
rm -rf dist
# create compile directory
mkdir compile
# compile java
javac -cp /usr/share/java/metadata-extractor.jar -d compile tim/prune/*.java tim/prune/config/*.java tim/prune/correlate/*.java tim/prune/data/*.java tim/prune/jpeg/*.java tim/prune/function/*.java tim/prune/function/browser/*.java tim/prune/function/charts/*.java tim/prune/function/compress/*.java tim/prune/function/distance/*.java tim/prune/function/edit/*.java tim/prune/function/gpsies/*.java tim/prune/function/srtm/*.java tim/prune/gui/*.java tim/prune/gui/map/*.java tim/prune/gui/profile/*.java tim/prune/jpeg/*.java tim/prune/load/*.java tim/prune/load/xml/*.java tim/prune/save/*.java tim/prune/save/xml/*.java tim/prune/threedee/*.java tim/prune/undo/*.java
# add other required resources
cp -r tim/prune/lang compile/tim/prune/
cp -r tim/prune/*.txt compile/tim/prune/
cp -r tim/prune/gui/images compile/tim/prune/gui/
cp tim/prune/function/srtm/srtmtiles.dat compile/tim/prune/function/srtm
# make dist directory
mkdir dist
# build into jar file
jar cfm dist/prune_11.jar MANIFEST.MF -C compile .
# finished!
echo "build complete"
