/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Magnus-swe <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "callbacks.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)



GtkWidget*
create_gproftpd_window (void)
{
  GtkWidget *gproftpd_window;

  /* NOTEBOOK */
  GtkWidget *main_notebook;

  /* TREEVIEWS */
  GtkWidget *servers_treeview, *userlist_treeview;
  GtkWidget *disc_treeview, *files_treeview;

  /* PROGRESSBAR */
  GtkWidget *tls_progressbar;

  /* TOOLBARS */
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *toolbar13, *toolbar14, *toolbar15, *toolbar16, *toolbar17, *toolbar18, *toolbar19;

  /* LABELS (322 is the first middle-spacer) */
  GtkWidget *gproftpd_version_label, *proftpd_version_label;
  GtkWidget *left_label1, *right_label1, *label385, *label10, *label382;
  GtkWidget *info_label1, *info_label2, *info_label3, *status_label;
  GtkWidget *label66, *label67, *label68, *label389, *label44, *label411;
  GtkWidget *label342, *label343, *label344, *label345, *label346;
  GtkWidget *label322, *label425, *label273, *label341, *label413;
  GtkWidget *label60, *label61, *label64, *label275, *label134, *label81;
  GtkWidget *label390, *label426, *label69, *label70, *label419, *label422;
  GtkWidget *label395, *label396, *label397, *label372, *label71, *label72;
  GtkWidget *label212, *label213, *label323, *label423, *label38, *label39;
  GtkWidget *label373, *label15, *label333, *label420, *label418, *label37;
  GtkWidget *label271, *label80, *label330, *label331, *label13, *label383;
  GtkWidget *label410, *label412, *label28, *label137, *label136, *label327;
  GtkWidget *label259, *label53, *label270, *label424, *label155, *label49;
  GtkWidget *label321, *label211, *label7, *label279, *label417, *label179;
  GtkWidget *label111, *label403, *label400, *label409, *label406, *label135;
  GtkWidget *label402, *label401, *label407, *label159, *label399, *label408;
  GtkWidget *label416, *label8, *label20, *label415, *label414, *label47;
  GtkWidget *label180, *label388, *label384, *label181, *label162, *label32;
  GtkWidget *label177, *label387, *label178, *label421, *label326, *label76;
  GtkWidget *label274, *label73, *label74, *label324, *label21, *label386;
  GtkWidget *label110, *label381, *label24, *label369, *label11, *label48;
  GtkWidget *label164, *label165, *label168, *label156, *label85, *label325;
  GtkWidget *label169, *label170, *label167, *label12, *label394, *label82;

  GtkWidget *label430, *label431, *import_label1;

  GtkWidget *tls_label65, *tls_label66, *tls_label67, *tls_label7, *tls_label10;
  GtkWidget *tls_label5, *label328, *tls_label6, *tls_label1, *tls_label17;
  GtkWidget *tls_label2, *tls_label21, *tls_label3, *tls_label11, *tls_label20;
  GtkWidget *tls_label18, *tls_label19, *tls_label13, *tls_label14, *label329;
  GtkWidget *tls_label12, *tls_label15, *tls_label16;

  /* HBOXES */
  GtkWidget *gproftpd_hbox;
  GtkWidget *server_info_hbox, *hbox261;
  GtkWidget *hbox23, *hbox73, *hbox85, *hbox75, *hbox74, *hbox237;
  GtkWidget *hbox233, *hbox90, *hbox259, *combo18;
  GtkWidget *hbox260, *hbox262, *hbox232;
  GtkWidget *hbox235, *hbox236;
  GtkWidget *combo15, *combo16;
  GtkWidget *hbox238, *hbox234;
  GtkWidget *hbox156, *hbox231;
  GtkWidget *hbox257, *hbox245, *hbox96;
  GtkWidget *hbox89, *hbox17;
  GtkWidget *hbox88, *hbox256, *tls_hbox2, *hbox70, *hbox120;
  GtkWidget *hbox54, *hbox93, *tls_hbox4, *hbox10, *hbox72;
  GtkWidget *hbox53, *hbox13, *hbox86, *hbox94, *tls_hbox5;
  GtkWidget *hbox92, *hbox20;
  GtkWidget *hbox258, *hbox97;
  GtkWidget *hbox300, *hbox301;
  GtkWidget *import_hbox1;

  GtkWidget *tls_hbox3, *tls_hbox1, *tls_hbox6;

  /* VBOXES */
  GtkWidget *global_vbox_options, *gproftpd_vbox, *vbox10;
  GtkWidget *vbox32, *vbox33, *vbox70, *vbox22, *vbox42, *vbox69;
  GtkWidget *vbox37, *vbox67, *vbox65, *vbox23, *vbox4, *vbox11;
  GtkWidget *vbox41, *vbox7, *vbox66, *vbox71, *vbox13, *vbox47;
  GtkWidget *vbox6, *vbox9, *vbox34, *vbox38, *vbox2, *vbox40;
  GtkWidget *vbox35, *vbox39, *vbox51, *vbox24, *vbox5, *vbox68;
  GtkWidget *vbox49, *vbox48, *vbox50, *vbox52, *vbox46, *vbox53;

  /* BUTTONS */
  GtkWidget *online_button, *offline_button, *shutdown_button, *reread_button;
  GtkWidget *credits_button, *help_button, *quit_button;
  GtkWidget *add_server_button, *delete_server_button, *apply_server_changes_button;
  GtkWidget *kickban_button, *userdir_button;
  GtkWidget *security_update_button, *syntaxcheck_button;
  GtkWidget *tls_generate_certificate_button, *password_rand_button;
  GtkWidget *useradd_incoming_button, *useradd_incoming_checkbutton, *backup_button;
  GtkWidget *welcome_button, *useradd_button, *kick_button, *disc_update_button;
  GtkWidget *html_button, *files_clear_button, *files_update_button;
  GtkWidget *save_entire_button, *restore_button, *import_users_button;
  GtkWidget *username_rand_button;

  /* ENTRIES */
  GtkWidget *global_useradd_root_path;
  GtkWidget *global_useradd_upload_path;
  GtkWidget *global_html_path;
  GtkWidget *global_welcome_path;
  GtkWidget *global_systemlog_entry;
  GtkWidget *global_server_user;
  GtkWidget *global_server_group;
  GtkWidget *global_fake_user_entry;
  GtkWidget *global_download_bandwidth;
  GtkWidget *global_fake_group_entry;
  GtkWidget *global_server_name;
  GtkWidget *global_masquerade_entry;
  
  GtkWidget *useradd_username_entry, *kick_entry;
  GtkWidget *useradd_directory_entry;
  GtkWidget *useradd_password_entry;
  GtkWidget *total_xfer_entry;
  GtkWidget *total_incoming_entry;
  GtkWidget *html_entry;
  GtkWidget *welcome_entry;
  GtkWidget *useradd_incoming_directory_entry;
  GtkWidget *useradd_shell_entry;
  GtkWidget *total_outgoing_entry;
  GtkWidget *global_show_server_identity;
  GtkWidget *tls_protocols_entry;
  GtkWidget *tls_logfile_entry;
  GtkWidget *tls_rsa_cert_entry;
  GtkWidget *tls_ip_entry, *tls_email_entry;
  GtkWidget *tls_country_entry;
  GtkWidget *tls_state_entry, *tls_city_entry, *tls_org_entry;
  GtkWidget *tls_org_unit_entry, *tls_password_entry;
  GtkWidget *tls_challenge_entry;


  /* COMBOS */
  GtkWidget *combo1;
  GList *combo1_items = NULL;
  GtkWidget *global_show_server_identity_on_off;
  GtkWidget *global_server_admin_email;
  GList *combo18_items = NULL;
  GtkWidget *global_bind_tight_on_off, *combo2;
  GList *combo2_items = NULL;
  GtkWidget *global_ident_lookups, *combo3;
  GList *combo3_items = NULL;
  GtkWidget *global_reverse_lookups, *combo4;
  GList *combo4_items = NULL;
  GtkWidget *combo19;
  GList *combo19_items = NULL;
  GtkWidget *global_rand_case;
  GtkWidget *combo5;
  GList *combo5_items = NULL;
  GtkWidget *global_default_transfer_mode;
  GtkWidget *combo6, *tls_combo1;
  GList *combo6_items = NULL;
  GList *combo15_items = NULL;
  GtkWidget *global_fake_user_combo;
  GList *combo16_items = NULL;
  GtkWidget *global_fake_group_combo;
  GtkWidget *shell_combo;
  GtkWidget *combo14;
  GList *combo14_items = NULL;
  GtkWidget *global_resume_uploads;
  GtkWidget *combo11;
  GList *combo11_items = NULL;
  GtkWidget *global_delete_aborted_stores;
  GtkObject *global_download_bandwidth_adj;
  GtkWidget *combo13;
  GList *combo13_items = NULL;
  GtkWidget *global_resume_downloads;
  GList *tls_combo1_items = NULL;
  GtkWidget *tls_use_combo_entry;
  GtkWidget *tls_combo2;
  GList *tls_combo2_items = NULL;
  GtkWidget *tls_use_encryption_combo_entry;
  GtkWidget *tls_combo3;
  GList *tls_combo3_items = NULL;
  GtkWidget *tls_verify_clients_combo_entry;
  GtkObject *global_rand_username_adj;
  GtkWidget *global_rand_username;
  GtkObject *global_rand_password_adj;
  GtkWidget *global_rand_password;
  GtkWidget *global_allow_fxp;
  GtkWidget *global_time_standard;

  GtkWidget *combo20;
  GList *combo20_items = NULL;
  GtkWidget *global_masquerade_address_on_off;


  /* SPINBUTTONS */
  GtkObject *tls_bits_spinbutton_adj;
  GtkWidget *tls_bits_spinbutton;
  GtkObject *tls_valid_spinbutton_adj;
  GtkWidget *tls_valid_spinbutton;
  GtkObject *global_upload_bandwidth_adj;
  GtkWidget *global_upload_bandwidth;
  GtkObject *global_server_port_adj;
  GtkWidget *global_server_port;

  GtkObject *global_passive_ports_1_spinbutton_adj;
  GtkWidget *global_passive_ports_1_spinbutton;
  GtkObject *global_passive_ports_2_spinbutton_adj;
  GtkWidget *global_passive_ports_2_spinbutton;


  GtkObject *global_max_connect_adj;
  GtkWidget *global_max_connect;
  GtkObject *global_max_login_attempts_adj;
  GtkWidget *global_max_login_attempts;
  GtkObject *global_timeout_login_adj;
  GtkWidget *global_timeout_login;
  GtkObject *global_idle_timeout_adj;
  GtkWidget *global_idle_timeout;

  /* IMAGES */
  GtkWidget *image10, *image20, *image53, *image31, *image40;
  GtkWidget *image39, *image42, *image21, *image7, *image33;
  GtkWidget *image14, *image46, *image43, *image41, *image11;
  GtkWidget *image32, *image38, *image34, *image56, *image54, *image55;
  GtkWidget *import_image1;

  /* TEXTVIEWS */
  GtkWidget *xfer_textview, *entire_textview;
  GtkWidget *security_successful_textview, *security_refused_textview;

  /* SCROLLED WINDOWS */
  GtkWidget *xfer_scrolledwindow, *scrolledwindow6, *scrolledwindow7;
  GtkWidget *scrolledwindow11, *scrolledwindow17, *scrolledwindow9;
  GtkWidget *scrolledwindow12, *scrolledwindow14, *scrolledwindow20;
  GtkWidget *scrolledwindow10;

  /* BUTTONBOXES */
  GtkWidget *hbuttonbox1, *hbuttonbox2, *hbuttonbox4;
  GtkWidget *hbuttonbox5, *hbuttonbox6, *hbuttonbox7;
  GtkWidget *hbuttonbox10, *hbuttonbox15;

  /* VIEWPORTS */  
  GtkWidget *viewport2, *viewport3;

  /* ALIGNMENTS */
  GtkWidget *alignment11, *alignment41, *alignment39;
  GtkWidget *alignment10, *alignment42, *alignment38;
  GtkWidget *alignment32, *alignment14, *alignment46;
  GtkWidget *alignment20, *alignment21, *alignment40;
  GtkWidget *alignment53, *alignment7, *alignment31;
  GtkWidget *alignment43, *alignment34, *alignment33;
  GtkWidget *alignment55, *alignment56, *alignment54;
  GtkWidget *alignment60;

  /* SEPARATORS */
  GtkWidget *hseparator39, *hseparator108, *hseparator106;
  GtkWidget *hseparator107, *hseparator36, *hseparator33;
  GtkWidget *hseparator38, *hseparator104, *hseparator105;
  GtkWidget *hseparator98, *hseparator99, *hseparator71;
  GtkWidget *hseparator1, *hseparator97, *hseparator109;
  GtkWidget *tls_hseparator1;
  GtkWidget *tls_hseparator2;




  /* The main gproftpd interface */
  GtkTooltips *tooltips;
  tooltips = gtk_tooltips_new ();

  gproftpd_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (gproftpd_window, "gproftpd_window");
  gtk_widget_set_size_request (gproftpd_window, -1, 380);

  gchar *gp_window_title = g_strdup_printf("GPROFTPD-%s\n", VERSION);
  gtk_window_set_title (GTK_WINDOW (gproftpd_window), gp_window_title);
  g_free(gp_window_title);
  gtk_window_set_position (GTK_WINDOW (gproftpd_window), GTK_WIN_POS_CENTER);

  gproftpd_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (gproftpd_vbox, "gproftpd_vbox");
  gtk_widget_show (gproftpd_vbox);
  gtk_container_add (GTK_CONTAINER (gproftpd_window), gproftpd_vbox);

  gproftpd_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (gproftpd_hbox, "gproftpd_hbox");
  gtk_widget_show (gproftpd_hbox);
  gtk_box_pack_start (GTK_BOX (gproftpd_vbox), gproftpd_hbox, FALSE, FALSE, 0);

  toolbar13 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar13, "toolbar13");
  gtk_widget_show (toolbar13);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar13, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar13), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-yes", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar13)));
  online_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar13),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("   Online    "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar13)->children)->data))->label), TRUE);
  gtk_widget_set_name (online_button, "online_button");
  gtk_widget_show (online_button);
  gtk_widget_set_size_request (online_button, 81, -1);

  label341 = gtk_label_new ("");
  gtk_widget_set_name (label341, "label341");
  gtk_widget_show (label341);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), label341, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label341), GTK_JUSTIFY_LEFT);

  toolbar14 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar14, "toolbar14");
  gtk_widget_show (toolbar14);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar14, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar14), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-no", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar14)));
  offline_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar14),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("    Offline    "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar14)->children)->data))->label), TRUE);
  gtk_widget_set_name (offline_button, "offline_button");
  gtk_widget_show (offline_button);
  gtk_widget_set_size_request (offline_button, 81, -1);

  label342 = gtk_label_new ("");
  gtk_widget_set_name (label342, "label342");
  gtk_widget_show (label342);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), label342, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label342), GTK_JUSTIFY_LEFT);

  toolbar15 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar15, "toolbar15");
  gtk_widget_show (toolbar15);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar15, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar15), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-stop", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar15)));
  shutdown_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar15),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _(" Shutdown "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar15)->children)->data))->label), TRUE);
  gtk_widget_set_name (shutdown_button, "shutdown_button");
  gtk_widget_show (shutdown_button);
  gtk_widget_set_size_request (shutdown_button, 81, -1);

  label343 = gtk_label_new ("");
  gtk_widget_set_name (label343, "label343");
  gtk_widget_show (label343);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), label343, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label343), GTK_JUSTIFY_LEFT);

  toolbar16 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar16, "toolbar16");
  gtk_widget_show (toolbar16);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar16, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar16), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-refresh", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar16)));
  reread_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar16),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("   ReRead   "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar16)->children)->data))->label), TRUE);
  gtk_widget_set_name (reread_button, "reread_button");
  gtk_widget_show (reread_button);
  gtk_widget_set_size_request (reread_button, 81, -1);

  label344 = gtk_label_new ("");
  gtk_widget_set_name (label344, "label344");
  gtk_widget_show (label344);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), label344, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label344), GTK_JUSTIFY_LEFT);

  toolbar17 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar17, "toolbar17");
  gtk_widget_show (toolbar17);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar17, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar17), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-help", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar17)));
  help_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar17),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("      Help      "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar17)->children)->data))->label), TRUE);
  gtk_widget_set_name (help_button, "help_button");
  gtk_widget_show (help_button);
  gtk_widget_set_size_request (help_button, 81, -1);

  label345 = gtk_label_new ("");
  gtk_widget_set_name (label345, "label345");
  gtk_widget_show (label345);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), label345, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label345), GTK_JUSTIFY_LEFT);

  toolbar18 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar18, "toolbar18");
  gtk_widget_show (toolbar18);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar18, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar18), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-justify-center", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar18)));
  credits_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar18),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("   About   "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar18)->children)->data))->label), TRUE);
  gtk_widget_set_name (credits_button, "credits_button");
  gtk_widget_show (credits_button);
  gtk_widget_set_size_request (credits_button, 81, -1);

  label346 = gtk_label_new ("");
  gtk_widget_set_name (label346, "label346");
  gtk_widget_show (label346);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), label346, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label346), GTK_JUSTIFY_LEFT);

  toolbar19 = gtk_toolbar_new ();
  gtk_widget_set_name (toolbar19, "toolbar19");
  gtk_widget_show (toolbar19);
  gtk_box_pack_start (GTK_BOX (gproftpd_hbox), toolbar19, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar19), GTK_TOOLBAR_BOTH);

  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-quit", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar19)));
  quit_button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar19),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("      Quit      "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar19)->children)->data))->label), TRUE);
  gtk_widget_set_name (quit_button, "quit_button");
  gtk_widget_show (quit_button);
  gtk_widget_set_size_request (quit_button, 81, -1);

  server_info_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (server_info_hbox, "server_info_hbox");
  gtk_widget_show (server_info_hbox);
  gtk_box_pack_start (GTK_BOX (gproftpd_vbox), server_info_hbox, FALSE, TRUE, 0);

  info_label1 = gtk_label_new (_("Information:"));
  gtk_widget_set_name (info_label1, "info_label1");
  gtk_widget_show (info_label1);
  gtk_box_pack_start (GTK_BOX (server_info_hbox), info_label1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (info_label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (info_label1), 5, 0);

  proftpd_version_label = gtk_label_new (_("proftpd -v failed."));
  gtk_widget_set_name (proftpd_version_label, "proftpd_version_label");
  gtk_widget_show (proftpd_version_label);
  gtk_box_pack_start (GTK_BOX (server_info_hbox), proftpd_version_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (proftpd_version_label), GTK_JUSTIFY_LEFT);

  info_label2 = gtk_label_new ("");
  gtk_widget_set_name (info_label2, "info_label2");
  gtk_widget_show (info_label2);
  gtk_box_pack_start (GTK_BOX (server_info_hbox), info_label2, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (info_label2), GTK_JUSTIFY_LEFT);

  info_label3 = gtk_label_new (_("The server is currently:"));
  gtk_widget_set_name (info_label3, "info_label3");
  gtk_widget_show (info_label3);
  gtk_box_pack_start (GTK_BOX (server_info_hbox), info_label3, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (info_label3), GTK_JUSTIFY_LEFT);

  status_label = gtk_label_new (_("Cant determine."));
  gtk_widget_set_name (status_label, "status_label");
  gtk_widget_show (status_label);
  gtk_box_pack_start (GTK_BOX (server_info_hbox), status_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (status_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (status_label), 5, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox2, "vbox2");
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (gproftpd_vbox), vbox2, TRUE, TRUE, 0);

  main_notebook = gtk_notebook_new ();
  gtk_widget_set_name (main_notebook, "main_notebook");
  gtk_widget_show (main_notebook);
  gtk_box_pack_start (GTK_BOX (vbox2), main_notebook, TRUE, TRUE, 0);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (main_notebook), FALSE);

  vbox13 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox13, "vbox13");
  gtk_widget_show (vbox13);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox13);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox13,
                                      TRUE, TRUE, GTK_PACK_START);

  label44 = gtk_label_new (_("This is the configuration for the currently selected server."));
  gtk_widget_set_name (label44, "label44");
  gtk_widget_show (label44);
  gtk_box_pack_start (GTK_BOX (vbox13), label44, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label44), GTK_JUSTIFY_LEFT);

  scrolledwindow14 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow14, "scrolledwindow14");
  gtk_widget_show (scrolledwindow14);
  gtk_box_pack_start (GTK_BOX (vbox13), scrolledwindow14, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow14), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  viewport3 = gtk_viewport_new (NULL, NULL);
  gtk_widget_set_name (viewport3, "viewport3");
  gtk_widget_show (viewport3);
  gtk_container_add (GTK_CONTAINER (scrolledwindow14), viewport3);

  vbox24 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox24, "vbox24");
  gtk_widget_show (vbox24);
  gtk_container_add (GTK_CONTAINER (viewport3), vbox24);
  gtk_widget_set_size_request (vbox24, 120, -1);

  hbox259 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox259, "hbox259");
  gtk_widget_show (hbox259);
  gtk_box_pack_start (GTK_BOX (vbox24), hbox259, TRUE, TRUE, 0);

  label419 = gtk_label_new ("");
  gtk_widget_set_name (label419, "label419");
  gtk_widget_show (label419);
  gtk_box_pack_start (GTK_BOX (hbox259), label419, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label419, 10, -1);
  gtk_label_set_justify (GTK_LABEL (label419), GTK_JUSTIFY_LEFT);

  scrolledwindow20 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow20, "scrolledwindow20");
  gtk_widget_show (scrolledwindow20);
  gtk_box_pack_start (GTK_BOX (hbox259), scrolledwindow20, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow20, -1, 90);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow20), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  servers_treeview = gtk_tree_view_new ();
  gtk_widget_set_name (servers_treeview, "servers_treeview");
  gtk_widget_show (servers_treeview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow20), servers_treeview);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (servers_treeview), TRUE);

  label420 = gtk_label_new ("");
  gtk_widget_set_name (label420, "label420");
  gtk_widget_show (label420);
  gtk_box_pack_start (GTK_BOX (hbox259), label420, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label420, 10, -1);
  gtk_label_set_justify (GTK_LABEL (label420), GTK_JUSTIFY_LEFT);

  label418 = gtk_label_new ("");
  gtk_widget_set_name (label418, "label418");
  gtk_widget_show (label418);
  gtk_box_pack_start (GTK_BOX (vbox24), label418, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label418, -1, 5);
  gtk_label_set_justify (GTK_LABEL (label418), GTK_JUSTIFY_LEFT);

  hbuttonbox15 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox15, "hbuttonbox15");
  gtk_widget_show (hbuttonbox15);
  gtk_box_pack_start (GTK_BOX (vbox24), hbuttonbox15, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox15), GTK_BUTTONBOX_SPREAD);


  /* Import users button */
  import_users_button = gtk_button_new ();
  gtk_widget_set_name (import_users_button, "import_users_button");
  gtk_widget_show (import_users_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), import_users_button);
  GTK_WIDGET_SET_FLAGS (import_users_button, GTK_CAN_DEFAULT);

  alignment60 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment60, "alignment60");
  gtk_widget_show (alignment60);
  gtk_container_add (GTK_CONTAINER (import_users_button), alignment60);

  import_hbox1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (import_hbox1, "import_hbox2");
  gtk_widget_show (import_hbox1);
  gtk_container_add (GTK_CONTAINER (alignment60), import_hbox1);

  import_image1 = gtk_image_new_from_stock ("gtk-convert", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (import_image1, "import_image1");
  gtk_widget_show (import_image1);
  gtk_box_pack_start (GTK_BOX (import_hbox1), import_image1, FALSE, FALSE, 0);

  import_label1 = gtk_label_new_with_mnemonic (_("Import"));
  gtk_widget_set_name (import_label1, "import_label1");
  gtk_widget_show (import_label1);
  gtk_box_pack_start (GTK_BOX (import_hbox1), import_label1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (import_label1), GTK_JUSTIFY_LEFT);


  add_server_button = gtk_button_new ();
  gtk_widget_set_name (add_server_button, "add_server_button");
  gtk_widget_show (add_server_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), add_server_button);
  GTK_WIDGET_SET_FLAGS (add_server_button, GTK_CAN_DEFAULT);

  alignment54 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment54, "alignment54");
  gtk_widget_show (alignment54);
  gtk_container_add (GTK_CONTAINER (add_server_button), alignment54);

  hbox260 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox260, "hbox260");
  gtk_widget_show (hbox260);
  gtk_container_add (GTK_CONTAINER (alignment54), hbox260);

  image54 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image54, "image54");
  gtk_widget_show (image54);
  gtk_box_pack_start (GTK_BOX (hbox260), image54, FALSE, FALSE, 0);

  label421 = gtk_label_new_with_mnemonic (_("Add Server"));
  gtk_widget_set_name (label421, "label421");
  gtk_widget_show (label421);
  gtk_box_pack_start (GTK_BOX (hbox260), label421, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label421), GTK_JUSTIFY_LEFT);


  delete_server_button = gtk_button_new ();
  gtk_widget_set_name (delete_server_button, "delete_server_button");
  gtk_widget_show (delete_server_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), delete_server_button);
  GTK_WIDGET_SET_FLAGS (delete_server_button, GTK_CAN_DEFAULT);

  alignment55 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment55, "alignment55");
  gtk_widget_show (alignment55);
  gtk_container_add (GTK_CONTAINER (delete_server_button), alignment55);

  hbox261 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox261, "hbox261");
  gtk_widget_show (hbox261);
  gtk_container_add (GTK_CONTAINER (alignment55), hbox261);

  image55 = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image55, "image55");
  gtk_widget_show (image55);
  gtk_box_pack_start (GTK_BOX (hbox261), image55, FALSE, FALSE, 0);

  label422 = gtk_label_new_with_mnemonic (_("Delete server"));
  gtk_widget_set_name (label422, "label422");
  gtk_widget_show (label422);
  gtk_box_pack_start (GTK_BOX (hbox261), label422, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label422), GTK_JUSTIFY_LEFT);

  apply_server_changes_button = gtk_button_new ();
  gtk_widget_set_name (apply_server_changes_button, "apply_server_changes_button");
  gtk_widget_show (apply_server_changes_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), apply_server_changes_button);
  GTK_WIDGET_SET_FLAGS (apply_server_changes_button, GTK_CAN_DEFAULT);

  alignment56 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment56, "alignment56");
  gtk_widget_show (alignment56);
  gtk_container_add (GTK_CONTAINER (apply_server_changes_button), alignment56);

  hbox262 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox262, "hbox262");
  gtk_widget_show (hbox262);
  gtk_container_add (GTK_CONTAINER (alignment56), hbox262);

  image56 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image56, "image56");
  gtk_widget_show (image56);
  gtk_box_pack_start (GTK_BOX (hbox262), image56, FALSE, FALSE, 0);

  label423 = gtk_label_new_with_mnemonic (_("Apply"));
  gtk_widget_set_name (label423, "label423");
  gtk_widget_show (label423);
  gtk_box_pack_start (GTK_BOX (hbox262), label423, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label423), GTK_JUSTIFY_LEFT);

  hseparator109 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator109, "hseparator109");
  gtk_widget_show (hseparator109);
  gtk_box_pack_start (GTK_BOX (vbox24), hseparator109, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator109, -1, 10);

  global_vbox_options = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (global_vbox_options, "global_vbox_options");
  gtk_widget_show (global_vbox_options);
  gtk_box_pack_start (GTK_BOX (vbox24), global_vbox_options, FALSE, FALSE, 0);

  hbox156 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox156, "hbox156");
  gtk_widget_show (hbox156);
  gtk_box_pack_start (GTK_BOX (global_vbox_options), hbox156, TRUE, TRUE, 0);

  left_label1 = gtk_label_new ("");
  gtk_widget_set_name (left_label1, "left_label1");
  gtk_widget_show (left_label1);
  gtk_box_pack_start (GTK_BOX (hbox156), left_label1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (left_label1, 10, -1);
  gtk_label_set_justify (GTK_LABEL (left_label1), GTK_JUSTIFY_LEFT);

  vbox22 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox22, "vbox22");
  gtk_widget_show (vbox22);
  gtk_box_pack_start (GTK_BOX (hbox156), vbox22, TRUE, TRUE, 0);

  hbox231 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox231, "hbox231");
  gtk_widget_show (hbox231);
  gtk_box_pack_start (GTK_BOX (vbox22), hbox231, TRUE, TRUE, 0);

  vbox32 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox32, "vbox32");
  gtk_widget_show (vbox32);
  gtk_box_pack_start (GTK_BOX (hbox231), vbox32, FALSE, FALSE, 0);

  label259 = gtk_label_new (_("DNS name or ip address of the server:"));
  gtk_widget_set_name (label259, "label259");
  gtk_widget_show (label259);
  gtk_box_pack_start (GTK_BOX (vbox32), label259, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label259), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label259), 0, 0.5);

  label53 = gtk_label_new (_("Show alternate server identity:"));
  gtk_widget_set_name (label53, "label53");
  gtk_widget_show (label53);
  gtk_box_pack_start (GTK_BOX (vbox32), label53, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label53), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label53), 0, 0.5);



  label431 = gtk_label_new(_("NAT gateway address:"));
  gtk_widget_set_name (label431, "label431");
  gtk_widget_show (label431);
  gtk_box_pack_start (GTK_BOX (vbox32), label431, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label431), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label431), 0, 0.5);



  label270 = gtk_label_new (_("The administrators email address:"));
  gtk_widget_set_name (label270, "label270");
  gtk_widget_show (label270);
  gtk_box_pack_start (GTK_BOX (vbox32), label270, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label270), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label270), 0, 0.5);

  label321 = gtk_label_new ("");
  gtk_widget_set_name (label321, "label321");
  gtk_widget_show (label321);
  gtk_box_pack_start (GTK_BOX (hbox231), label321, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label321, 20, -1);
  gtk_label_set_justify (GTK_LABEL (label321), GTK_JUSTIFY_LEFT);

  vbox33 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox33, "vbox33");
  gtk_widget_show (vbox33);
  gtk_box_pack_start (GTK_BOX (hbox231), vbox33, TRUE, TRUE, 0);

  global_server_name = gtk_entry_new ();
  gtk_widget_set_name (global_server_name, "global_server_name");
  gtk_widget_show (global_server_name);
  gtk_box_pack_start (GTK_BOX (vbox33), global_server_name, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, global_server_name, _("To listen on all interfaces 0.0.0.0 can be used"), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (global_server_name), 1000);



  /* Alternate Server Ident */
  hbox232 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox232, "hbox232");
  gtk_widget_show (hbox232);
  gtk_box_pack_start (GTK_BOX (vbox33), hbox232, FALSE, FALSE, 0);

  global_show_server_identity = gtk_entry_new ();
  gtk_widget_set_name (global_show_server_identity, "global_show_server_identity");
  gtk_widget_show (global_show_server_identity);
  gtk_box_pack_start (GTK_BOX (hbox232), global_show_server_identity, TRUE, TRUE, 0);
  gtk_widget_set_size_request (global_show_server_identity, 286, -1);
  gtk_entry_set_max_length (GTK_ENTRY (global_show_server_identity), 1000);

  /* alt server identity */
  combo1 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo1)->popwin),
                     "GladeParentKey", combo1);
  gtk_widget_set_name (combo1, "combo1");
  gtk_widget_show (combo1);

  gtk_box_pack_start (GTK_BOX (hbox232), combo1, TRUE, TRUE, 0);

  gtk_widget_set_size_request (combo1, 178, -1);
  combo1_items = g_list_append (combo1_items, (gpointer) _("on"));
  combo1_items = g_list_append (combo1_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo1), combo1_items);
  g_list_free (combo1_items);

  global_show_server_identity_on_off = GTK_COMBO (combo1)->entry;
  gtk_widget_set_name (global_show_server_identity_on_off, "global_show_server_identity_on_off");
  gtk_widget_show (global_show_server_identity_on_off);
  gtk_widget_set_sensitive (global_show_server_identity_on_off, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_show_server_identity_on_off), FALSE);

  /* Masquerade address */  
  hbox301 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox301, "hbox301");
  gtk_widget_show (hbox301);
  gtk_box_pack_start (GTK_BOX (vbox33), hbox301, FALSE, FALSE, 0);

  global_masquerade_entry = gtk_entry_new ();
  gtk_widget_set_name (global_masquerade_entry, "global_masquerade_entry");
  gtk_widget_show(global_masquerade_entry);
  gtk_box_pack_start (GTK_BOX (hbox301), global_masquerade_entry, TRUE, TRUE, 0);
  gtk_widget_set_size_request (global_masquerade_entry, 286, -1);
  gtk_tooltips_set_tip(tooltips, global_masquerade_entry, _("Only use this if you are behind a NAT gateway"), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (global_masquerade_entry), 1000);

  combo20 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo20)->popwin),
                     "GladeParentKey", combo20);
  gtk_widget_set_name (combo20, "combo20");
  gtk_widget_show (combo20);
  gtk_box_pack_start (GTK_BOX (hbox301), combo20, TRUE, TRUE, 0);

  gtk_widget_set_size_request (combo20, 178, -1);
  combo20_items = g_list_append (combo20_items, (gpointer) _("on"));
  combo20_items = g_list_append (combo20_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo20), combo20_items);
  g_list_free (combo20_items);

  global_masquerade_address_on_off = GTK_COMBO (combo20)->entry;
  gtk_widget_set_name (global_masquerade_address_on_off, "global_masquerade_address_on_off");
  gtk_widget_show (global_masquerade_address_on_off);
  gtk_widget_set_sensitive (global_masquerade_address_on_off, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_masquerade_address_on_off), FALSE);


  /* Admin Email  */
  global_server_admin_email = gtk_entry_new ();
  gtk_widget_set_name (global_server_admin_email, "global_server_admin_email");
  gtk_widget_show (global_server_admin_email);
  gtk_box_pack_start (GTK_BOX (vbox33), global_server_admin_email, TRUE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_server_admin_email), 1000);

  hbox233 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox233, "hbox233");
  gtk_widget_show (hbox233);
  gtk_box_pack_start (GTK_BOX (vbox22), hbox233, FALSE, FALSE, 0);

  vbox34 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox34, "vbox34");
  gtk_widget_show (vbox34);
  gtk_box_pack_start (GTK_BOX (hbox233), vbox34, FALSE, FALSE, 0);

  label425 = gtk_label_new (_("Bind servers to their addresses:"));
  gtk_widget_set_name (label425, "label425");
  gtk_widget_show (label425);
  gtk_box_pack_start (GTK_BOX (vbox34), label425, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label425), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label425), 0, 0.5);

  label273 = gtk_label_new (_("Identity lookups:"));
  gtk_widget_set_name (label273, "label273");
  gtk_widget_show (label273);
  gtk_box_pack_start (GTK_BOX (vbox34), label273, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label273), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label273), 0, 0.5);

  label60 = gtk_label_new (_("Reverse lookups:"));
  gtk_widget_set_name (label60, "label60");
  gtk_widget_show (label60);
  gtk_box_pack_start (GTK_BOX (vbox34), label60, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label60), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label60), 0, 0.5);

  label61 = gtk_label_new (_("Timestandard:"));
  gtk_widget_set_name (label61, "label61");
  gtk_widget_show (label61);
  gtk_box_pack_start (GTK_BOX (vbox34), label61, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label61), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label61), 0, 0.5);

  label64 = gtk_label_new (_("The port the server listens on:"));
  gtk_widget_set_name (label64, "label64");
  gtk_widget_show (label64);
  gtk_box_pack_start (GTK_BOX (vbox34), label64, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label64), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label64), 0, 0.5);

  label430 = gtk_label_new(_("Passive ports range:"));
  gtk_widget_set_name (label430, "label430");
  gtk_widget_show (label430);
  gtk_box_pack_start (GTK_BOX (vbox34), label430, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label430), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label430), 0, 0.5);

  label275 = gtk_label_new (_("Maximum connections for each server:"));
  gtk_widget_set_name (label275, "label275");
  gtk_widget_show (label275);
  gtk_box_pack_start (GTK_BOX (vbox34), label275, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label275), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label275), 0, 0.5);

  label66 = gtk_label_new (_("Max login attempts before disconnected:"));
  gtk_widget_set_name (label66, "label66");
  gtk_widget_show (label66);
  gtk_box_pack_start (GTK_BOX (vbox34), label66, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label66), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label66), 0, 0.5);

  label67 = gtk_label_new (_("Login timeout:"));
  gtk_widget_set_name (label67, "label67");
  gtk_widget_show (label67);
  gtk_box_pack_start (GTK_BOX (vbox34), label67, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label67), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label67), 0, 0.5);

  label68 = gtk_label_new (_("Idle timeout:"));
  gtk_widget_set_name (label68, "label68");
  gtk_widget_show (label68);
  gtk_box_pack_start (GTK_BOX (vbox34), label68, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label68), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label68), 0, 0.5);

  label389 = gtk_label_new (_("Randomized username length:"));
  gtk_widget_set_name (label389, "label389");
  gtk_widget_show (label389);
  gtk_box_pack_start (GTK_BOX (vbox34), label389, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label389), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label389), 0, 0.5);

  label390 = gtk_label_new (_("Randomized password length:"));
  gtk_widget_set_name (label390, "label390");
  gtk_widget_show (label390);
  gtk_box_pack_start (GTK_BOX (vbox34), label390, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label390), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label390), 0, 0.5);

  label426 = gtk_label_new (_("Randomize to upper or lower case:"));
  gtk_widget_set_name (label426, "label426");
  gtk_widget_show (label426);
  gtk_box_pack_start (GTK_BOX (vbox34), label426, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label426), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label426), 0, 0.5);

  label69 = gtk_label_new (_("Default transfermode:"));
  gtk_widget_set_name (label69, "label69");
  gtk_widget_show (label69);
  gtk_box_pack_start (GTK_BOX (vbox34), label69, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label69), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label69), 0, 0.5);

  label70 = gtk_label_new (_("FXP transfers:"));
  gtk_widget_set_name (label70, "label70");
  gtk_widget_show (label70);
  gtk_box_pack_start (GTK_BOX (vbox34), label70, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label70), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label70), 0, 0.5);

  label322 = gtk_label_new ("");
  gtk_widget_set_name (label322, "label322");
  gtk_widget_show (label322);
  gtk_box_pack_start (GTK_BOX (hbox233), label322, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label322, 180, -1);
  gtk_label_set_justify (GTK_LABEL (label322), GTK_JUSTIFY_LEFT);

  vbox35 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox35, "vbox35");
  gtk_widget_show (vbox35);
  gtk_box_pack_start (GTK_BOX (hbox233), vbox35, TRUE, TRUE, 0);

  combo18 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo18)->popwin),
                     "GladeParentKey", combo18);
  gtk_widget_set_name (combo18, "combo18");
  gtk_widget_show (combo18);
  gtk_box_pack_start (GTK_BOX (vbox35), combo18, FALSE, FALSE, 0);
  combo18_items = g_list_append (combo18_items, (gpointer) _("on"));
  combo18_items = g_list_append (combo18_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo18), combo18_items);
  g_list_free (combo18_items);

  global_bind_tight_on_off = GTK_COMBO (combo18)->entry;
  gtk_widget_set_name (global_bind_tight_on_off, "global_bind_tight_on_off");
  gtk_widget_show (global_bind_tight_on_off);
  gtk_widget_set_sensitive (global_bind_tight_on_off, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_bind_tight_on_off), FALSE);

  combo2 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo2)->popwin),
                     "GladeParentKey", combo2);
  gtk_widget_set_name (combo2, "combo2");
  gtk_widget_show (combo2);
  gtk_box_pack_start (GTK_BOX (vbox35), combo2, FALSE, FALSE, 0);
  combo2_items = g_list_append (combo2_items, (gpointer) _("on"));
  combo2_items = g_list_append (combo2_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo2), combo2_items);
  g_list_free (combo2_items);

  global_ident_lookups = GTK_COMBO (combo2)->entry;
  gtk_widget_set_name (global_ident_lookups, "global_ident_lookups");
  gtk_widget_show (global_ident_lookups);
  gtk_widget_set_sensitive (global_ident_lookups, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_ident_lookups), FALSE);

  combo3 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo3)->popwin),
                     "GladeParentKey", combo3);
  gtk_widget_set_name (combo3, "combo3");
  gtk_widget_show (combo3);
  gtk_box_pack_start (GTK_BOX (vbox35), combo3, FALSE, FALSE, 0);
  combo3_items = g_list_append (combo3_items, (gpointer) _("on"));
  combo3_items = g_list_append (combo3_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo3), combo3_items);
  g_list_free (combo3_items);

  global_reverse_lookups = GTK_COMBO (combo3)->entry;
  gtk_widget_set_name (global_reverse_lookups, "global_reverse_lookups");
  gtk_widget_show (global_reverse_lookups);
  gtk_widget_set_sensitive (global_reverse_lookups, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_reverse_lookups), FALSE);

  combo4 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo4)->popwin),
                     "GladeParentKey", combo4);
  gtk_widget_set_name (combo4, "combo4");
  gtk_widget_show (combo4);
  gtk_box_pack_start (GTK_BOX (vbox35), combo4, FALSE, FALSE, 0);
  combo4_items = g_list_append (combo4_items, (gpointer) _("gmt"));
  combo4_items = g_list_append (combo4_items, (gpointer) _("local time"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo4), combo4_items);
  g_list_free (combo4_items);

  global_time_standard = GTK_COMBO (combo4)->entry;
  gtk_widget_set_name (global_time_standard, "global_time_standard");
  gtk_widget_show (global_time_standard);
  gtk_widget_set_size_request (global_time_standard, 10, -1);
  gtk_widget_set_sensitive (global_time_standard, FALSE);
//  gtk_tooltips_set_tip (tooltips, global_time_standard, _("Off is local time"), NULL);
  gtk_editable_set_editable (GTK_EDITABLE (global_time_standard), FALSE);

  global_server_port_adj = gtk_adjustment_new (0, 0, 65535, 1, 10, 10);
  global_server_port = gtk_spin_button_new (GTK_ADJUSTMENT (global_server_port_adj), 1, 0);
  gtk_widget_set_name (global_server_port, "global_server_port");
  gtk_widget_show (global_server_port);
  gtk_box_pack_start (GTK_BOX (vbox35), global_server_port, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, global_server_port, _("0 is offline"), NULL);

  /* PassivePorts */
  hbox300 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox300, "hbox300");
  gtk_widget_show (hbox300);
  gtk_box_pack_start (GTK_BOX (vbox35), hbox300, TRUE, TRUE, 0);

  global_passive_ports_1_spinbutton_adj = gtk_adjustment_new (0, 1024, 65535, 1, 10, 10);
  global_passive_ports_1_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (global_passive_ports_1_spinbutton_adj), 1, 0);
  gtk_widget_set_name(global_passive_ports_1_spinbutton, "global_passive_ports_1_spinbutton");
  gtk_widget_show (global_passive_ports_1_spinbutton);
  gtk_box_pack_start (GTK_BOX(hbox300), global_passive_ports_1_spinbutton, TRUE, TRUE, 0);

  global_passive_ports_2_spinbutton_adj = gtk_adjustment_new (0, 1024, 65535, 1, 10, 10);
  global_passive_ports_2_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (global_passive_ports_2_spinbutton_adj), 1, 0);
  gtk_widget_set_name(global_passive_ports_2_spinbutton, "global_passive_ports_2_spinbutton");
  gtk_widget_show (global_passive_ports_2_spinbutton);
  gtk_box_pack_start (GTK_BOX(hbox300), global_passive_ports_2_spinbutton, TRUE, TRUE, 0);


  global_max_connect_adj = gtk_adjustment_new (1, 0, 999999, 1, 10, 10);
  global_max_connect = gtk_spin_button_new (GTK_ADJUSTMENT (global_max_connect_adj), 1, 0);
  gtk_widget_set_name (global_max_connect, "global_max_connect");
  gtk_widget_show (global_max_connect);
  gtk_box_pack_start (GTK_BOX (vbox35), global_max_connect, FALSE, FALSE, 0);

  global_max_login_attempts_adj = gtk_adjustment_new (1, 0, 999999, 1, 10, 10);
  global_max_login_attempts = gtk_spin_button_new (GTK_ADJUSTMENT (global_max_login_attempts_adj), 1, 0);
  gtk_widget_set_name (global_max_login_attempts, "global_max_login_attempts");
  gtk_widget_show (global_max_login_attempts);
  gtk_box_pack_start (GTK_BOX (vbox35), global_max_login_attempts, FALSE, FALSE, 0);

  global_timeout_login_adj = gtk_adjustment_new (1, 0, 999999, 1, 10, 10);
  global_timeout_login = gtk_spin_button_new (GTK_ADJUSTMENT (global_timeout_login_adj), 1, 0);
  gtk_widget_set_name (global_timeout_login, "global_timeout_login");
  gtk_widget_show (global_timeout_login);
  gtk_box_pack_start (GTK_BOX (vbox35), global_timeout_login, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, global_timeout_login, _("Seconds"), NULL);

  global_idle_timeout_adj = gtk_adjustment_new (0, 0, 999999, 1, 10, 10);
  global_idle_timeout = gtk_spin_button_new (GTK_ADJUSTMENT (global_idle_timeout_adj), 1, 0);
  gtk_widget_set_name (global_idle_timeout, "global_idle_timeout");
  gtk_widget_show (global_idle_timeout);
  gtk_box_pack_start (GTK_BOX (vbox35), global_idle_timeout, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, global_idle_timeout, _("Seconds"), NULL);

  global_rand_username_adj = gtk_adjustment_new (6, 6, 128, 1, 10, 10);
  global_rand_username = gtk_spin_button_new (GTK_ADJUSTMENT (global_rand_username_adj), 1, 0);
  gtk_widget_set_name (global_rand_username, "global_rand_username");
  gtk_widget_show (global_rand_username);
  gtk_box_pack_start (GTK_BOX (vbox35), global_rand_username, FALSE, FALSE, 0);

  global_rand_password_adj = gtk_adjustment_new (6, 6, 128, 1, 10, 10);
  global_rand_password = gtk_spin_button_new (GTK_ADJUSTMENT (global_rand_password_adj), 1, 0);
  gtk_widget_set_name (global_rand_password, "global_rand_password");
  gtk_widget_show (global_rand_password);
  gtk_box_pack_start (GTK_BOX (vbox35), global_rand_password, FALSE, FALSE, 0);

  combo19 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo19)->popwin),
                     "GladeParentKey", combo19);
  gtk_widget_set_name (combo19, "combo19");
  gtk_widget_show (combo19);
  gtk_box_pack_start (GTK_BOX (vbox35), combo19, FALSE, FALSE, 0);
  combo19_items = g_list_append (combo19_items, (gpointer) _("upper"));
  combo19_items = g_list_append (combo19_items, (gpointer) _("lower"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo19), combo19_items);
  g_list_free (combo19_items);

  global_rand_case = GTK_COMBO (combo19)->entry;
  gtk_widget_set_name (global_rand_case, "global_rand_case");
  gtk_widget_show (global_rand_case);
  gtk_widget_set_sensitive (global_rand_case, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_rand_case), FALSE);

  combo5 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo5)->popwin),
                     "GladeParentKey", combo5);
  gtk_widget_set_name (combo5, "combo5");
  gtk_widget_show (combo5);
  gtk_box_pack_start (GTK_BOX (vbox35), combo5, FALSE, FALSE, 0);
  gtk_widget_set_size_request (combo5, 110, -1);
  combo5_items = g_list_append (combo5_items, (gpointer) _("binary"));
  combo5_items = g_list_append (combo5_items, (gpointer) _("ascii"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo5), combo5_items);
  g_list_free (combo5_items);

  global_default_transfer_mode = GTK_COMBO (combo5)->entry;
  gtk_widget_set_name (global_default_transfer_mode, "global_default_transfer_mode");
  gtk_widget_show (global_default_transfer_mode);
  gtk_widget_set_sensitive (global_default_transfer_mode, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_default_transfer_mode), FALSE);

  combo6 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo6)->popwin),
                     "GladeParentKey", combo6);
  gtk_widget_set_name (combo6, "combo6");
  gtk_widget_show (combo6);
  gtk_box_pack_start (GTK_BOX (vbox35), combo6, FALSE, FALSE, 0);
  gtk_widget_set_size_request (combo6, 110, -1);
  combo6_items = g_list_append (combo6_items, (gpointer) _("on"));
  combo6_items = g_list_append (combo6_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo6), combo6_items);
  g_list_free (combo6_items);

  global_allow_fxp = GTK_COMBO (combo6)->entry;
  gtk_widget_set_name (global_allow_fxp, "global_allow_fxp");
  gtk_widget_show (global_allow_fxp);
  gtk_widget_set_sensitive (global_allow_fxp, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_allow_fxp), FALSE);

  hbox234 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox234, "hbox234");
  gtk_widget_show (hbox234);
  gtk_box_pack_start (GTK_BOX (vbox22), hbox234, FALSE, FALSE, 0);

  vbox37 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox37, "vbox37");
  gtk_widget_show (vbox37);
  gtk_box_pack_start (GTK_BOX (hbox234), vbox37, FALSE, FALSE, 0);

  label394 = gtk_label_new (_("Useradds default root directory path:"));
  gtk_widget_set_name (label394, "label394");
  gtk_widget_show (label394);
  gtk_box_pack_start (GTK_BOX (vbox37), label394, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label394), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label394), 0, 0.5);

  label395 = gtk_label_new (_("Useradds default upload directory:"));
  gtk_widget_set_name (label395, "label395");
  gtk_widget_show (label395);
  gtk_box_pack_start (GTK_BOX (vbox37), label395, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label395), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label395), 0, 0.5);

  label396 = gtk_label_new (_("Statistics default html path:"));
  gtk_widget_set_name (label396, "label396");
  gtk_widget_show (label396);
  gtk_box_pack_start (GTK_BOX (vbox37), label396, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label396), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label396), 0, 0.5);

  label397 = gtk_label_new (_("Statistics default welcome name:"));
  gtk_widget_set_name (label397, "label397");
  gtk_widget_show (label397);
  gtk_box_pack_start (GTK_BOX (vbox37), label397, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label397), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label397), 0, 0.5);

  label372 = gtk_label_new (_("The systems logfile:"));
  gtk_widget_set_name (label372, "label372");
  gtk_widget_show (label372);
  gtk_box_pack_start (GTK_BOX (vbox37), label372, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label372), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label372), 0, 0.5);

  label71 = gtk_label_new (_("The server runs as this user:"));
  gtk_widget_set_name (label71, "label71");
  gtk_widget_show (label71);
  gtk_box_pack_start (GTK_BOX (vbox37), label71, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label71), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label71), 0, 0.5);

  label72 = gtk_label_new (_("The server runs as this group:"));
  gtk_widget_set_name (label72, "label72");
  gtk_widget_show (label72);
  gtk_box_pack_start (GTK_BOX (vbox37), label72, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label72), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label72), 0, 0.5);

  label212 = gtk_label_new (_("This fake user owns all files:"));
  gtk_widget_set_name (label212, "label212");
  gtk_widget_show (label212);
  gtk_box_pack_start (GTK_BOX (vbox37), label212, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label212), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label212), 0, 0.5);

  label213 = gtk_label_new (_("This fake group owns all files:"));
  gtk_widget_set_name (label213, "label213");
  gtk_widget_show (label213);
  gtk_box_pack_start (GTK_BOX (vbox37), label213, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label213), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label213), 0, 0.5);

  label323 = gtk_label_new ("");
  gtk_widget_set_name (label323, "label323");
  gtk_widget_show (label323);
  gtk_box_pack_start (GTK_BOX (hbox234), label323, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label323, 50, -1);
  gtk_label_set_justify (GTK_LABEL (label323), GTK_JUSTIFY_LEFT);

  vbox38 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox38, "vbox38");
  gtk_widget_show (vbox38);
  gtk_box_pack_start (GTK_BOX (hbox234), vbox38, TRUE, TRUE, 0);

  global_useradd_root_path = gtk_entry_new ();
  gtk_widget_set_name (global_useradd_root_path, "global_useradd_root_path");
  gtk_widget_show (global_useradd_root_path);
  gtk_box_pack_start (GTK_BOX (vbox38), global_useradd_root_path, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_useradd_root_path), 7000);

  global_useradd_upload_path = gtk_entry_new ();
  gtk_widget_set_name (global_useradd_upload_path, "global_useradd_upload_path");
  gtk_widget_show (global_useradd_upload_path);
  gtk_box_pack_start (GTK_BOX (vbox38), global_useradd_upload_path, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_useradd_upload_path), 7000);

  global_html_path = gtk_entry_new ();
  gtk_widget_set_name (global_html_path, "global_html_path");
  gtk_widget_show (global_html_path);
  gtk_box_pack_start (GTK_BOX (vbox38), global_html_path, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_html_path), 7000);

  global_welcome_path = gtk_entry_new ();
  gtk_widget_set_name (global_welcome_path, "global_welcome_path");
  gtk_widget_show (global_welcome_path);
  gtk_box_pack_start (GTK_BOX (vbox38), global_welcome_path, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_welcome_path), 7000);

  global_systemlog_entry = gtk_entry_new ();
  gtk_widget_set_name (global_systemlog_entry, "global_systemlog_entry");
  gtk_widget_show (global_systemlog_entry);
  gtk_box_pack_start (GTK_BOX (vbox38), global_systemlog_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_systemlog_entry), 7000);

  global_server_user = gtk_entry_new ();
  gtk_widget_set_name (global_server_user, "global_server_user");
  gtk_widget_show (global_server_user);
  gtk_box_pack_start (GTK_BOX (vbox38), global_server_user, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_server_user), 128);

  global_server_group = gtk_entry_new ();
  gtk_widget_set_name (global_server_group, "global_server_group");
  gtk_widget_show (global_server_group);
  gtk_box_pack_start (GTK_BOX (vbox38), global_server_group, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (global_server_group), 128);

  hbox235 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox235, "hbox235");
  gtk_widget_show (hbox235);
  gtk_box_pack_start (GTK_BOX (vbox38), hbox235, TRUE, TRUE, 0);

  global_fake_user_entry = gtk_entry_new ();
  gtk_widget_set_name (global_fake_user_entry, "global_fake_user_entry");
  gtk_widget_show (global_fake_user_entry);
  gtk_box_pack_start (GTK_BOX (hbox235), global_fake_user_entry, TRUE, TRUE, 0);
  gtk_widget_set_size_request (global_fake_user_entry, 205, -1);
  gtk_entry_set_max_length (GTK_ENTRY (global_fake_user_entry), 128);

  combo15 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo15)->popwin),
                     "GladeParentKey", combo15);
  gtk_widget_set_name (combo15, "combo15");
  gtk_widget_show (combo15);
  gtk_box_pack_start (GTK_BOX (hbox235), combo15, TRUE, TRUE, 0);
  gtk_widget_set_size_request (combo15, 130, -1);
  combo15_items = g_list_append (combo15_items, (gpointer) _("on"));
  combo15_items = g_list_append (combo15_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo15), combo15_items);
  g_list_free (combo15_items);

  global_fake_user_combo = GTK_COMBO (combo15)->entry;
  gtk_widget_set_name (global_fake_user_combo, "global_fake_user_combo");
  gtk_widget_show (global_fake_user_combo);
  gtk_widget_set_sensitive (global_fake_user_combo, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_fake_user_combo), FALSE);

  hbox236 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox236, "hbox236");
  gtk_widget_show (hbox236);
  gtk_box_pack_start (GTK_BOX (vbox38), hbox236, TRUE, TRUE, 0);

  global_fake_group_entry = gtk_entry_new ();
  gtk_widget_set_name (global_fake_group_entry, "global_fake_group_entry");
  gtk_widget_show (global_fake_group_entry);
  gtk_box_pack_start (GTK_BOX (hbox236), global_fake_group_entry, TRUE, TRUE, 0);
  gtk_widget_set_size_request (global_fake_group_entry, 205, -1);
  gtk_entry_set_max_length (GTK_ENTRY (global_fake_group_entry), 128);

  combo16 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo16)->popwin),
                     "GladeParentKey", combo16);
  gtk_widget_set_name (combo16, "combo16");
  gtk_widget_show (combo16);
  gtk_box_pack_start (GTK_BOX (hbox236), combo16, TRUE, TRUE, 0);
  gtk_widget_set_size_request (combo16, 130, -1);
  combo16_items = g_list_append (combo16_items, (gpointer) _("on"));
  combo16_items = g_list_append (combo16_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo16), combo16_items);
  g_list_free (combo16_items);

  global_fake_group_combo = GTK_COMBO (combo16)->entry;
  gtk_widget_set_name (global_fake_group_combo, "global_fake_group_combo");
  gtk_widget_show (global_fake_group_combo);
  gtk_widget_set_sensitive (global_fake_group_combo, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_fake_group_combo), FALSE);

  label271 = gtk_label_new ("");
  gtk_widget_set_name (label271, "label271");
  gtk_widget_show (label271);
  gtk_box_pack_start (GTK_BOX (vbox22), label271, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label271, -1, 20);
  gtk_label_set_justify (GTK_LABEL (label271), GTK_JUSTIFY_LEFT);

  label80 = gtk_label_new (_("Upload settings:"));
  gtk_widget_set_name (label80, "label80");
  gtk_widget_show (label80);
  gtk_box_pack_start (GTK_BOX (vbox22), label80, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label80), GTK_JUSTIFY_LEFT);

  hseparator97 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator97, "hseparator97");
  gtk_widget_show (hseparator97);
  gtk_box_pack_start (GTK_BOX (vbox22), hseparator97, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator97, -1, 5);

  hbox238 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox238, "hbox238");
  gtk_widget_show (hbox238);
  gtk_box_pack_start (GTK_BOX (vbox22), hbox238, TRUE, TRUE, 0);

  vbox41 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox41, "vbox41");
  gtk_widget_show (vbox41);
  gtk_box_pack_start (GTK_BOX (hbox238), vbox41, FALSE, FALSE, 0);

  label82 = gtk_label_new (_("Upload bandwidth:"));
  gtk_widget_set_name (label82, "label82");
  gtk_widget_show (label82);
  gtk_box_pack_start (GTK_BOX (vbox41), label82, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label82), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label82), 0, 0.5);

  label81 = gtk_label_new (_("Resume broken uploads:"));
  gtk_widget_set_name (label81, "label81");
  gtk_widget_show (label81);
  gtk_box_pack_start (GTK_BOX (vbox41), label81, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label81), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label81), 0, 0.5);

  label85 = gtk_label_new (_("Automatically delete aborted uploads:"));
  gtk_widget_set_name (label85, "label85");
  gtk_widget_show (label85);
  gtk_box_pack_start (GTK_BOX (vbox41), label85, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label85), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label85), 0, 0.5);

  label325 = gtk_label_new ("");
  gtk_widget_set_name (label325, "label325");
  gtk_widget_show (label325);
  gtk_box_pack_start (GTK_BOX (hbox238), label325, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label325, 201, -1);
  gtk_label_set_justify (GTK_LABEL (label325), GTK_JUSTIFY_LEFT);

  vbox42 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox42, "vbox42");
  gtk_widget_show (vbox42);
  gtk_box_pack_start (GTK_BOX (hbox238), vbox42, TRUE, TRUE, 0);

  global_upload_bandwidth_adj = gtk_adjustment_new (1, 0, 999999, 1, 10, 10);
  global_upload_bandwidth = gtk_spin_button_new (GTK_ADJUSTMENT (global_upload_bandwidth_adj), 1, 0);
  gtk_widget_set_name (global_upload_bandwidth, "global_upload_bandwidth");
  gtk_widget_show (global_upload_bandwidth);
  gtk_box_pack_start (GTK_BOX (vbox42), global_upload_bandwidth, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, global_upload_bandwidth, _("KB/Sec"), NULL);

  combo14 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo14)->popwin),
                     "GladeParentKey", combo14);
  gtk_widget_set_name (combo14, "combo14");
  gtk_widget_show (combo14);
  gtk_box_pack_start (GTK_BOX (vbox42), combo14, FALSE, FALSE, 0);
  gtk_widget_set_size_request (combo14, 110, -1);
  combo14_items = g_list_append (combo14_items, (gpointer) _("on"));
  combo14_items = g_list_append (combo14_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo14), combo14_items);
  g_list_free (combo14_items);

  global_resume_uploads = GTK_COMBO (combo14)->entry;
  gtk_widget_set_name (global_resume_uploads, "global_resume_uploads");
  gtk_widget_show (global_resume_uploads);
  gtk_widget_set_sensitive (global_resume_uploads, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_resume_uploads), FALSE);

  combo11 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo11)->popwin),
                     "GladeParentKey", combo11);
  gtk_widget_set_name (combo11, "combo11");
  gtk_widget_show (combo11);
  gtk_box_pack_start (GTK_BOX (vbox42), combo11, FALSE, FALSE, 0);
  gtk_widget_set_size_request (combo11, 110, -1);
  combo11_items = g_list_append (combo11_items, (gpointer) _("on"));
  combo11_items = g_list_append (combo11_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo11), combo11_items);
  g_list_free (combo11_items);

  global_delete_aborted_stores = GTK_COMBO (combo11)->entry;
  gtk_widget_set_name (global_delete_aborted_stores, "global_delete_aborted_stores");
  gtk_widget_show (global_delete_aborted_stores);
  gtk_widget_set_sensitive (global_delete_aborted_stores, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_delete_aborted_stores), FALSE);

  hseparator99 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator99, "hseparator99");
  gtk_widget_show (hseparator99);
  gtk_box_pack_start (GTK_BOX (vbox22), hseparator99, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator99, -1, 5);

  label326 = gtk_label_new ("");
  gtk_widget_set_name (label326, "label326");
  gtk_widget_show (label326);
  gtk_box_pack_start (GTK_BOX (vbox22), label326, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label326, -1, 20);
  gtk_label_set_justify (GTK_LABEL (label326), GTK_JUSTIFY_LEFT);

  label76 = gtk_label_new (_("Download settings:"));
  gtk_widget_set_name (label76, "label76");
  gtk_widget_show (label76);
  gtk_box_pack_start (GTK_BOX (vbox22), label76, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label76), GTK_JUSTIFY_LEFT);

  hseparator98 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator98, "hseparator98");
  gtk_widget_show (hseparator98);
  gtk_box_pack_start (GTK_BOX (vbox22), hseparator98, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator98, -1, 5);

  hbox237 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox237, "hbox237");
  gtk_widget_show (hbox237);
  gtk_box_pack_start (GTK_BOX (vbox22), hbox237, TRUE, TRUE, 0);

  vbox39 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox39, "vbox39");
  gtk_widget_show (vbox39);
  gtk_box_pack_start (GTK_BOX (hbox237), vbox39, FALSE, FALSE, 0);

  label73 = gtk_label_new (_("Download bandwidth:"));
  gtk_widget_set_name (label73, "label73");
  gtk_widget_show (label73);
  gtk_box_pack_start (GTK_BOX (vbox39), label73, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label73), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label73), 0, 0.5);

  label74 = gtk_label_new (_("Resume broken downloads:"));
  gtk_widget_set_name (label74, "label74");
  gtk_widget_show (label74);
  gtk_box_pack_start (GTK_BOX (vbox39), label74, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label74), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label74), 0, 0.5);

  label324 = gtk_label_new ("");
  gtk_widget_set_name (label324, "label324");
  gtk_widget_show (label324);
  gtk_box_pack_start (GTK_BOX (hbox237), label324, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label324, 258, -1);
  gtk_label_set_justify (GTK_LABEL (label324), GTK_JUSTIFY_LEFT);

  vbox40 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox40, "vbox40");
  gtk_widget_show (vbox40);
  gtk_box_pack_start (GTK_BOX (hbox237), vbox40, TRUE, TRUE, 0);

  global_download_bandwidth_adj = gtk_adjustment_new (1, 0, 999999, 1, 10, 10);
  global_download_bandwidth = gtk_spin_button_new (GTK_ADJUSTMENT (global_download_bandwidth_adj), 1, 0);
  gtk_widget_set_name (global_download_bandwidth, "global_download_bandwidth");
  gtk_widget_show (global_download_bandwidth);
  gtk_box_pack_start (GTK_BOX (vbox40), global_download_bandwidth, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, global_download_bandwidth, _("KB/sec"), NULL);

  combo13 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo13)->popwin),
                     "GladeParentKey", combo13);
  gtk_widget_set_name (combo13, "combo13");
  gtk_widget_show (combo13);
  gtk_box_pack_start (GTK_BOX (vbox40), combo13, FALSE, FALSE, 0);
  gtk_widget_set_size_request (combo13, 110, -1);
  combo13_items = g_list_append (combo13_items, (gpointer) _("on"));
  combo13_items = g_list_append (combo13_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo13), combo13_items);
  g_list_free (combo13_items);

  global_resume_downloads = GTK_COMBO (combo13)->entry;
  gtk_widget_set_name (global_resume_downloads, "global_resume_downloads");
  gtk_widget_show (global_resume_downloads);
  gtk_widget_set_sensitive (global_resume_downloads, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (global_resume_downloads), FALSE);

  hseparator71 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator71, "hseparator71");
  gtk_widget_show (hseparator71);
  gtk_box_pack_start (GTK_BOX (vbox22), hseparator71, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator71, -1, 5);

  label274 = gtk_label_new ("");
  gtk_widget_set_name (label274, "label274");
  gtk_widget_show (label274);
  gtk_box_pack_start (GTK_BOX (vbox22), label274, TRUE, TRUE, 0);
  gtk_widget_set_size_request (label274, -1, 20);
  gtk_label_set_justify (GTK_LABEL (label274), GTK_JUSTIFY_LEFT);

  tls_label1 = gtk_label_new (_("FTP-TLS secure communications:"));
  gtk_widget_set_name (tls_label1, "tls_label1");
  gtk_widget_show (tls_label1);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_label1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label1), GTK_JUSTIFY_LEFT);

  tls_hseparator1 = gtk_hseparator_new ();
  gtk_widget_set_name (tls_hseparator1, "tls_hseparator1");
  gtk_widget_show (tls_hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hseparator1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (tls_hseparator1, -1, 5);

  tls_hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (tls_hbox1, "tls_hbox1");
  gtk_widget_show (tls_hbox1);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hbox1, TRUE, TRUE, 0);

  vbox46 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox46, "vbox46");
  gtk_widget_show (vbox46);
  gtk_box_pack_start (GTK_BOX (tls_hbox1), vbox46, FALSE, FALSE, 0);

  tls_label65 = gtk_label_new (_("Use FTP-TLS:"));
  gtk_widget_set_name (tls_label65, "tls_label65");
  gtk_widget_show (tls_label65);
  gtk_box_pack_start (GTK_BOX (vbox46), tls_label65, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label65), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label65), 0, 0.5);

  tls_label66 = gtk_label_new (_("Require encrytion on channels:"));
  gtk_widget_set_name (tls_label66, "tls_label66");
  gtk_widget_show (tls_label66);
  gtk_box_pack_start (GTK_BOX (vbox46), tls_label66, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label66), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label66), 0, 0.5);

  tls_label67 = gtk_label_new (_("Verify clients:"));
  gtk_widget_set_name (tls_label67, "tls_label67");
  gtk_widget_show (tls_label67);
  gtk_box_pack_start (GTK_BOX (vbox46), tls_label67, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label67), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label67), 0, 0.5);

  label327 = gtk_label_new ("");
  gtk_widget_set_name (label327, "label327");
  gtk_widget_show (label327);
  gtk_box_pack_start (GTK_BOX (tls_hbox1), label327, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label327, 238, -1);
  gtk_label_set_justify (GTK_LABEL (label327), GTK_JUSTIFY_LEFT);

  vbox47 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox47, "vbox47");
  gtk_widget_show (vbox47);
  gtk_box_pack_start (GTK_BOX (tls_hbox1), vbox47, TRUE, TRUE, 0);

  tls_combo1 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (tls_combo1)->popwin),
                     "GladeParentKey", tls_combo1);
  gtk_widget_set_name (tls_combo1, "tls_combo1");
  gtk_widget_show (tls_combo1);
  gtk_box_pack_start (GTK_BOX (vbox47), tls_combo1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (tls_combo1, 32, 24);
  tls_combo1_items = g_list_append (tls_combo1_items, (gpointer) _("on"));
  tls_combo1_items = g_list_append (tls_combo1_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (tls_combo1), tls_combo1_items);
  g_list_free (tls_combo1_items);

  tls_use_combo_entry = GTK_COMBO (tls_combo1)->entry;
  gtk_widget_set_name (tls_use_combo_entry, "tls_use_combo_entry");
  gtk_widget_show (tls_use_combo_entry);
  gtk_widget_set_size_request (tls_use_combo_entry, 10, -1);
  gtk_widget_set_sensitive (tls_use_combo_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (tls_use_combo_entry), FALSE);

  tls_combo2 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (tls_combo2)->popwin),
                     "GladeParentKey", tls_combo2);
  gtk_widget_set_name (tls_combo2, "tls_combo2");
  gtk_widget_show (tls_combo2);
  gtk_box_pack_start (GTK_BOX (vbox47), tls_combo2, FALSE, FALSE, 0);
  gtk_widget_set_size_request (tls_combo2, 3, 24);
  tls_combo2_items = g_list_append (tls_combo2_items, (gpointer) _("both"));
  tls_combo2_items = g_list_append (tls_combo2_items, (gpointer) _("data"));
  tls_combo2_items = g_list_append (tls_combo2_items, (gpointer) _("control"));
  tls_combo2_items = g_list_append (tls_combo2_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (tls_combo2), tls_combo2_items);
  g_list_free (tls_combo2_items);

  tls_use_encryption_combo_entry = GTK_COMBO (tls_combo2)->entry;
  gtk_widget_set_name (tls_use_encryption_combo_entry, "tls_use_encryption_combo_entry");
  gtk_widget_show (tls_use_encryption_combo_entry);
  gtk_widget_set_size_request (tls_use_encryption_combo_entry, 10, -1);
  gtk_widget_set_sensitive (tls_use_encryption_combo_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (tls_use_encryption_combo_entry), FALSE);

  tls_combo3 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (tls_combo3)->popwin),
                     "GladeParentKey", tls_combo3);
  gtk_widget_set_name (tls_combo3, "tls_combo3");
  gtk_widget_show (tls_combo3);
  gtk_box_pack_start (GTK_BOX (vbox47), tls_combo3, FALSE, FALSE, 0);
  gtk_widget_set_size_request (tls_combo3, 31, 24);
  tls_combo3_items = g_list_append (tls_combo3_items, (gpointer) _("on"));
  tls_combo3_items = g_list_append (tls_combo3_items, (gpointer) _("off"));
  gtk_combo_set_popdown_strings (GTK_COMBO (tls_combo3), tls_combo3_items);
  g_list_free (tls_combo3_items);

  tls_verify_clients_combo_entry = GTK_COMBO (tls_combo3)->entry;
  gtk_widget_set_name (tls_verify_clients_combo_entry, "tls_verify_clients_combo_entry");
  gtk_widget_show (tls_verify_clients_combo_entry);
  gtk_widget_set_size_request (tls_verify_clients_combo_entry, 10, -1);
  gtk_widget_set_sensitive (tls_verify_clients_combo_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (tls_verify_clients_combo_entry), FALSE);

  tls_hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (tls_hbox2, "tls_hbox2");
  gtk_widget_show (tls_hbox2);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hbox2, TRUE, TRUE, 0);

  vbox48 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox48, "vbox48");
  gtk_widget_show (vbox48);
  gtk_box_pack_start (GTK_BOX (tls_hbox2), vbox48, FALSE, FALSE, 0);

  tls_label5 = gtk_label_new (_("Use these protocols:"));
  gtk_widget_set_name (tls_label5, "tls_label5");
  gtk_widget_show (tls_label5);
  gtk_box_pack_start (GTK_BOX (vbox48), tls_label5, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label5), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label5), 0, 0.5);

  tls_label6 = gtk_label_new (_("TLS Logfile"));
  gtk_widget_set_name (tls_label6, "tls_label6");
  gtk_widget_show (tls_label6);
  gtk_box_pack_start (GTK_BOX (vbox48), tls_label6, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label6), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label6), 0, 0.5);

  tls_label7 = gtk_label_new (_("RSA certificate file:"));
  gtk_widget_set_name (tls_label7, "tls_label7");
  gtk_widget_show (tls_label7);
  gtk_box_pack_start (GTK_BOX (vbox48), tls_label7, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label7), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label7), 0, 0.5);

  label328 = gtk_label_new ("");
  gtk_widget_set_name (label328, "label328");
  gtk_widget_show (label328);
  gtk_box_pack_start (GTK_BOX (tls_hbox2), label328, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label328, 142, -1);
  gtk_label_set_justify (GTK_LABEL (label328), GTK_JUSTIFY_LEFT);

  vbox49 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox49, "vbox49");
  gtk_widget_show (vbox49);
  gtk_box_pack_start (GTK_BOX (tls_hbox2), vbox49, TRUE, TRUE, 0);

  tls_protocols_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_protocols_entry, "tls_protocols_entry");
  gtk_widget_show (tls_protocols_entry);
  gtk_box_pack_start (GTK_BOX (vbox49), tls_protocols_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_protocols_entry), 1000);

  tls_logfile_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_logfile_entry, "tls_logfile_entry");
  gtk_widget_show (tls_logfile_entry);
  gtk_box_pack_start (GTK_BOX (vbox49), tls_logfile_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_logfile_entry), 1000);

  tls_rsa_cert_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_rsa_cert_entry, "tls_rsa_cert_entry");
  gtk_widget_show (tls_rsa_cert_entry);
  gtk_box_pack_start (GTK_BOX (vbox49), tls_rsa_cert_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_rsa_cert_entry), 1000);

  tls_label2 = gtk_label_new ("");
  gtk_widget_set_name (tls_label2, "tls_label2");
  gtk_widget_show (tls_label2);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_label2, FALSE, FALSE, 0);
  gtk_widget_set_size_request (tls_label2, -1, 16);
  gtk_label_set_justify (GTK_LABEL (tls_label2), GTK_JUSTIFY_LEFT);

  tls_label3 = gtk_label_new (_("Create a new selfsigned certificate:"));
  gtk_widget_set_name (tls_label3, "tls_label3");
  gtk_widget_show (tls_label3);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_label3, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label3), GTK_JUSTIFY_LEFT);

  tls_hseparator2 = gtk_hseparator_new ();
  gtk_widget_set_name (tls_hseparator2, "tls_hseparator2");
  gtk_widget_show (tls_hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hseparator2, TRUE, TRUE, 0);
  gtk_widget_set_size_request (tls_hseparator2, -1, 5);

  tls_hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (tls_hbox3, "tls_hbox3");
  gtk_widget_show (tls_hbox3);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hbox3, TRUE, TRUE, 0);

  vbox50 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox50, "vbox50");
  gtk_widget_show (vbox50);
  gtk_box_pack_start (GTK_BOX (tls_hbox3), vbox50, FALSE, FALSE, 0);

  tls_label10 = gtk_label_new (_("DNS name or IP-address of this server:"));
  gtk_widget_set_name (tls_label10, "tls_label10");
  gtk_widget_show (tls_label10);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label10, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label10), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label10), 0, 0.5);

  tls_label11 = gtk_label_new (_("Email address:"));
  gtk_widget_set_name (tls_label11, "tls_label11");
  gtk_widget_show (tls_label11);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label11, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label11), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label11), 0, 0.5);

  tls_label17 = gtk_label_new (_("State or province:"));
  gtk_widget_set_name (tls_label17, "tls_label17");
  gtk_widget_show (tls_label17);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label17, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label17), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label17), 0, 0.5);

  tls_label18 = gtk_label_new (_("City or town:"));
  gtk_widget_set_name (tls_label18, "tls_label18");
  gtk_widget_show (tls_label18);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label18, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label18), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label18), 0, 0.5);

  tls_label19 = gtk_label_new (_("Organization:"));
  gtk_widget_set_name (tls_label19, "tls_label19");
  gtk_widget_show (tls_label19);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label19, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label19), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label19), 0, 0.5);

  tls_label20 = gtk_label_new (_("Organizational unit:"));
  gtk_widget_set_name (tls_label20, "tls_label20");
  gtk_widget_show (tls_label20);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label20, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label20), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label20), 0, 0.5);

  tls_label13 = gtk_label_new (_("Password:"));
  gtk_widget_set_name (tls_label13, "tls_label13");
  gtk_widget_show (tls_label13);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label13, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label13), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label13), 0, 0.5);

  tls_label14 = gtk_label_new (_("Challenge password:"));
  gtk_widget_set_name (tls_label14, "tls_label14");
  gtk_widget_show (tls_label14);
  gtk_box_pack_start (GTK_BOX (vbox50), tls_label14, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label14), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label14), 0, 0.5);

  label329 = gtk_label_new ("");
  gtk_widget_set_name (label329, "label329");
  gtk_widget_show (label329);
  gtk_box_pack_start (GTK_BOX (tls_hbox3), label329, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label329, 35, -1);
  gtk_label_set_justify (GTK_LABEL (label329), GTK_JUSTIFY_LEFT);

  vbox51 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox51, "vbox51");
  gtk_widget_show (vbox51);
  gtk_box_pack_start (GTK_BOX (tls_hbox3), vbox51, TRUE, TRUE, 0);

  tls_ip_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_ip_entry, "tls_ip_entry");
  gtk_widget_show (tls_ip_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_ip_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_ip_entry), 1000);

  tls_email_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_email_entry, "tls_email_entry");
  gtk_widget_show (tls_email_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_email_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_email_entry), 1000);

  tls_state_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_state_entry, "tls_state_entry");
  gtk_widget_show (tls_state_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_state_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_state_entry), 1000);

  tls_city_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_city_entry, "tls_city_entry");
  gtk_widget_show (tls_city_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_city_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_city_entry), 1000);

  tls_org_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_org_entry, "tls_org_entry");
  gtk_widget_show (tls_org_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_org_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_org_entry), 1000);

  tls_org_unit_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_org_unit_entry, "tls_org_unit_entry");
  gtk_widget_show (tls_org_unit_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_org_unit_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_org_unit_entry), 1000);

  tls_password_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_password_entry, "tls_password_entry");
  gtk_widget_show (tls_password_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_password_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_password_entry), 1000);

  tls_challenge_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_challenge_entry, "tls_challenge_entry");
  gtk_widget_show (tls_challenge_entry);
  gtk_box_pack_start (GTK_BOX (vbox51), tls_challenge_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_challenge_entry), 1000);

  tls_hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (tls_hbox4, "tls_hbox4");
  gtk_widget_show (tls_hbox4);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hbox4, TRUE, TRUE, 0);

  vbox52 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox52, "vbox52");
  gtk_widget_show (vbox52);
  gtk_box_pack_start (GTK_BOX (tls_hbox4), vbox52, FALSE, FALSE, 0);

  tls_label12 = gtk_label_new (_("Number of bits:"));
  gtk_widget_set_name (tls_label12, "tls_label12");
  gtk_widget_show (tls_label12);
  gtk_box_pack_start (GTK_BOX (vbox52), tls_label12, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label12), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label12), 0, 0.5);

  tls_label15 = gtk_label_new (_("Number of days the certificate is valid:"));
  gtk_widget_set_name (tls_label15, "tls_label15");
  gtk_widget_show (tls_label15);
  gtk_box_pack_start (GTK_BOX (vbox52), tls_label15, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label15), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label15), 0, 0.5);

  tls_label16 = gtk_label_new (_("Countrycode IE: SV, DK, US etc:"));
  gtk_widget_set_name (tls_label16, "tls_label16");
  gtk_widget_show (tls_label16);
  gtk_box_pack_start (GTK_BOX (vbox52), tls_label16, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label16), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label16), 0, 0.5);

  label330 = gtk_label_new ("");
  gtk_widget_set_name (label330, "label330");
  gtk_widget_show (label330);
  gtk_box_pack_start (GTK_BOX (tls_hbox4), label330, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label330, 190, -1);
  gtk_label_set_justify (GTK_LABEL (label330), GTK_JUSTIFY_LEFT);

  vbox53 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox53, "vbox53");
  gtk_widget_show (vbox53);
  gtk_box_pack_start (GTK_BOX (tls_hbox4), vbox53, TRUE, TRUE, 0);

  tls_bits_spinbutton_adj = gtk_adjustment_new (384, 384, 999999, 1, 10, 10);
  tls_bits_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (tls_bits_spinbutton_adj), 1, 0);
  gtk_widget_set_name (tls_bits_spinbutton, "tls_bits_spinbutton");
  gtk_widget_show (tls_bits_spinbutton);
  gtk_box_pack_start (GTK_BOX (vbox53), tls_bits_spinbutton, FALSE, FALSE, 0);

  tls_valid_spinbutton_adj = gtk_adjustment_new (365, 1, 999999, 1, 10, 10);
  tls_valid_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (tls_valid_spinbutton_adj), 1, 0);
  gtk_widget_set_name (tls_valid_spinbutton, "tls_valid_spinbutton");
  gtk_widget_show (tls_valid_spinbutton);
  gtk_box_pack_start (GTK_BOX (vbox53), tls_valid_spinbutton, FALSE, FALSE, 0);

  tls_country_entry = gtk_entry_new ();
  gtk_widget_set_name (tls_country_entry, "tls_country_entry");
  gtk_widget_show (tls_country_entry);
  gtk_box_pack_start (GTK_BOX (vbox53), tls_country_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (tls_country_entry), 2);

  tls_hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (tls_hbox5, "tls_hbox5");
  gtk_widget_show (tls_hbox5);
  gtk_box_pack_start (GTK_BOX (vbox22), tls_hbox5, TRUE, TRUE, 0);

  tls_label21 = gtk_label_new (_("Generate certificate:"));
  gtk_widget_set_name (tls_label21, "tls_label21");
  gtk_widget_show (tls_label21);
  gtk_box_pack_start (GTK_BOX (tls_hbox5), tls_label21, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (tls_label21), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tls_label21), 0, 0.5);

  label331 = gtk_label_new ("");
  gtk_widget_set_name (label331, "label331");
  gtk_widget_show (label331);
  gtk_box_pack_start (GTK_BOX (tls_hbox5), label331, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label331, 83, -1);
  gtk_label_set_justify (GTK_LABEL (label331), GTK_JUSTIFY_LEFT);

  hbox245 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox245, "hbox245");
  gtk_widget_show (hbox245);
  gtk_box_pack_start (GTK_BOX (tls_hbox5), hbox245, TRUE, TRUE, 0);

  tls_generate_certificate_button = gtk_button_new ();
  gtk_widget_set_name (tls_generate_certificate_button, "tls_generate_certificate_button");
  gtk_widget_show (tls_generate_certificate_button);
  gtk_box_pack_start (GTK_BOX (hbox245), tls_generate_certificate_button, FALSE, FALSE, 0);

  alignment46 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment46, "alignment46");
  gtk_widget_show (alignment46);
  gtk_container_add (GTK_CONTAINER (tls_generate_certificate_button), alignment46);

  hbox120 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox120, "hbox120");
  gtk_widget_show (hbox120);
  gtk_container_add (GTK_CONTAINER (alignment46), hbox120);

  image46 = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image46, "image46");
  gtk_widget_show (image46);
  gtk_box_pack_start (GTK_BOX (hbox120), image46, FALSE, FALSE, 0);

  label211 = gtk_label_new_with_mnemonic (_("Generate"));
  gtk_widget_set_name (label211, "label211");
  gtk_widget_show (label211);
  gtk_box_pack_start (GTK_BOX (hbox120), label211, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label211), GTK_JUSTIFY_LEFT);

  tls_progressbar = gtk_progress_bar_new ();
  gtk_widget_set_name (tls_progressbar, "tls_progressbar");
  gtk_widget_show (tls_progressbar);
  gtk_box_pack_start (GTK_BOX (hbox245), tls_progressbar, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (tls_progressbar, FALSE);
  gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (tls_progressbar), 1);

  right_label1 = gtk_label_new ("");
  gtk_widget_set_name (right_label1, "right_label1");
  gtk_widget_show (right_label1);
  gtk_box_pack_start (GTK_BOX (hbox156), right_label1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (right_label1, 10, -1);
  gtk_label_set_justify (GTK_LABEL (right_label1), GTK_JUSTIFY_LEFT);

  tls_hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (tls_hbox6, "tls_hbox6");
  gtk_widget_show (tls_hbox6);
  gtk_box_pack_start (GTK_BOX (vbox24), tls_hbox6, TRUE, TRUE, 0);

  vbox23 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox23, "vbox23");
  gtk_widget_show (vbox23);
  gtk_box_pack_start (GTK_BOX (tls_hbox6), vbox23, TRUE, TRUE, 0);

  label279 = gtk_label_new ("");
  gtk_widget_set_name (label279, "label279");
  gtk_widget_show (label279);
  gtk_box_pack_start (GTK_BOX (vbox23), label279, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label279, -1, 16);
  gtk_label_set_justify (GTK_LABEL (label279), GTK_JUSTIFY_LEFT);

  label7 = gtk_label_new (_("Servers"));
  gtk_widget_set_name (label7, "label7");
  gtk_widget_show (label7);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 0), label7);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox7, "vbox7");
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox7);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox7,
                                      TRUE, TRUE, GTK_PACK_START);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator1, "hseparator1");
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox7), hseparator1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator1, -1, 5);

  label424 = gtk_label_new (_("Add delete or make changes to users in the currently selected server."));
  gtk_widget_set_name (label424, "label424");
  gtk_widget_show (label424);
  gtk_box_pack_start (GTK_BOX (vbox7), label424, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label424), GTK_JUSTIFY_LEFT);

  hbox257 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox257, "hbox257");
  gtk_widget_show (hbox257);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox257, FALSE, FALSE, 0);

  label417 = gtk_label_new ("");
  gtk_widget_set_name (label417, "label417");
  gtk_widget_show (label417);
  gtk_box_pack_start (GTK_BOX (hbox257), label417, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label417, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label417), GTK_JUSTIFY_LEFT);

  vbox65 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox65, "vbox65");
  gtk_widget_show (vbox65);
  gtk_box_pack_start (GTK_BOX (hbox257), vbox65, FALSE, FALSE, 0);

  username_rand_button = gtk_button_new ();
  gtk_widget_set_name (username_rand_button, "username_rand_button");
  gtk_widget_show (username_rand_button);
  gtk_box_pack_start (GTK_BOX (vbox65), username_rand_button, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, username_rand_button, _("Make a random username"), NULL);

  alignment20 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment20, "alignment20");
  gtk_widget_show (alignment20);
  gtk_container_add (GTK_CONTAINER (username_rand_button), alignment20);

  hbox53 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox53, "hbox53");
  gtk_widget_show (hbox53);
  gtk_container_add (GTK_CONTAINER (alignment20), hbox53);

  image20 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image20, "image20");
  gtk_widget_show (image20);
  gtk_box_pack_start (GTK_BOX (hbox53), image20, FALSE, FALSE, 0);

  label110 = gtk_label_new_with_mnemonic (_("Username:"));
  gtk_widget_set_name (label110, "label110");
  gtk_widget_show (label110);
  gtk_box_pack_start (GTK_BOX (hbox53), label110, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label110), GTK_JUSTIFY_LEFT);

  label402 = gtk_label_new ("");
  gtk_widget_set_name (label402, "label402");
  gtk_widget_show (label402);
  gtk_box_pack_start (GTK_BOX (vbox65), label402, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label402, -1, 5);
  gtk_label_set_justify (GTK_LABEL (label402), GTK_JUSTIFY_LEFT);

  userdir_button = gtk_button_new ();
  gtk_widget_set_name (userdir_button, "userdir_button");
  gtk_widget_show (userdir_button);
  gtk_box_pack_start (GTK_BOX (vbox65), userdir_button, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, userdir_button, _("Select the users root directory"), NULL);

  alignment40 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment40, "alignment40");
  gtk_widget_show (alignment40);
  gtk_container_add (GTK_CONTAINER (userdir_button), alignment40);

  hbox88 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox88, "hbox88");
  gtk_widget_show (hbox88);
  gtk_container_add (GTK_CONTAINER (alignment40), hbox88);

  image40 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image40, "image40");
  gtk_widget_show (image40);
  gtk_box_pack_start (GTK_BOX (hbox88), image40, FALSE, FALSE, 0);

  label159 = gtk_label_new_with_mnemonic (_("Root directory:"));
  gtk_widget_set_name (label159, "label159");
  gtk_widget_show (label159);
  gtk_box_pack_start (GTK_BOX (hbox88), label159, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label159), GTK_JUSTIFY_LEFT);

  label399 = gtk_label_new ("");
  gtk_widget_set_name (label399, "label399");
  gtk_widget_show (label399);
  gtk_box_pack_start (GTK_BOX (hbox257), label399, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label399, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label399), GTK_JUSTIFY_LEFT);

  vbox66 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox66, "vbox66");
  gtk_widget_show (vbox66);
  gtk_box_pack_start (GTK_BOX (hbox257), vbox66, TRUE, TRUE, 0);

  label407 = gtk_label_new ("");
  gtk_widget_set_name (label407, "label407");
  gtk_widget_show (label407);
  gtk_box_pack_start (GTK_BOX (vbox66), label407, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label407, -1, 3);
  gtk_label_set_justify (GTK_LABEL (label407), GTK_JUSTIFY_LEFT);

  useradd_username_entry = gtk_entry_new ();
  gtk_widget_set_name (useradd_username_entry, "useradd_username_entry");
  gtk_widget_show (useradd_username_entry);
  gtk_box_pack_start (GTK_BOX (vbox66), useradd_username_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (useradd_username_entry, 30, -1);
  GTK_WIDGET_SET_FLAGS (useradd_username_entry, GTK_CAN_DEFAULT);
  gtk_entry_set_max_length (GTK_ENTRY (useradd_username_entry), 128);

  label401 = gtk_label_new ("");
  gtk_widget_set_name (label401, "label401");
  gtk_widget_show (label401);
  gtk_box_pack_start (GTK_BOX (vbox66), label401, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label401, -1, 10);
  gtk_label_set_justify (GTK_LABEL (label401), GTK_JUSTIFY_LEFT);

  useradd_directory_entry = gtk_entry_new ();
  gtk_widget_set_name (useradd_directory_entry, "useradd_directory_entry");
  gtk_widget_show (useradd_directory_entry);
  gtk_box_pack_start (GTK_BOX (vbox66), useradd_directory_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (useradd_directory_entry, 90, -1);
  gtk_entry_set_max_length (GTK_ENTRY (useradd_directory_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (useradd_directory_entry), "/home/ftp");

  label400 = gtk_label_new ("");
  gtk_widget_set_name (label400, "label400");
  gtk_widget_show (label400);
  gtk_box_pack_start (GTK_BOX (hbox257), label400, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label400, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label400), GTK_JUSTIFY_LEFT);

  vbox67 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox67, "vbox67");
  gtk_widget_show (vbox67);
  gtk_box_pack_start (GTK_BOX (hbox257), vbox67, FALSE, FALSE, 0);

  password_rand_button = gtk_button_new ();
  gtk_widget_set_name (password_rand_button, "password_rand_button");
  gtk_widget_show (password_rand_button);
  gtk_box_pack_start (GTK_BOX (vbox67), password_rand_button, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, password_rand_button, _("Make a random password"), NULL);

  alignment21 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment21, "alignment21");
  gtk_widget_show (alignment21);
  gtk_container_add (GTK_CONTAINER (password_rand_button), alignment21);

  hbox54 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox54, "hbox54");
  gtk_widget_show (hbox54);
  gtk_container_add (GTK_CONTAINER (alignment21), hbox54);

  image21 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image21, "image21");
  gtk_widget_show (image21);
  gtk_box_pack_start (GTK_BOX (hbox54), image21, FALSE, FALSE, 0);

  label111 = gtk_label_new_with_mnemonic (_("Password:"));
  gtk_widget_set_name (label111, "label111");
  gtk_widget_show (label111);
  gtk_box_pack_start (GTK_BOX (hbox54), label111, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label111), GTK_JUSTIFY_LEFT);

  label403 = gtk_label_new ("");
  gtk_widget_set_name (label403, "label403");
  gtk_widget_show (label403);
  gtk_box_pack_start (GTK_BOX (vbox67), label403, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label403, -1, 5);
  gtk_label_set_justify (GTK_LABEL (label403), GTK_JUSTIFY_LEFT);

  useradd_incoming_button = gtk_button_new ();
  gtk_widget_set_name (useradd_incoming_button, "useradd_incoming_button");
  gtk_widget_show (useradd_incoming_button);
  gtk_box_pack_start (GTK_BOX (vbox67), useradd_incoming_button, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, useradd_incoming_button, _("Select an upload directory below the users root directory"), NULL);

  alignment41 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment41, "alignment41");
  gtk_widget_show (alignment41);
  gtk_container_add (GTK_CONTAINER (useradd_incoming_button), alignment41);

  hbox89 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox89, "hbox89");
  gtk_widget_show (hbox89);
  gtk_container_add (GTK_CONTAINER (alignment41), hbox89);

  image41 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image41, "image41");
  gtk_widget_show (image41);
  gtk_box_pack_start (GTK_BOX (hbox89), image41, FALSE, FALSE, 0);

  label162 = gtk_label_new_with_mnemonic (_("Upload:"));
  gtk_widget_set_name (label162, "label162");
  gtk_widget_show (label162);
  gtk_box_pack_start (GTK_BOX (hbox89), label162, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label162), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label162), 8, 0);

  label406 = gtk_label_new ("");
  gtk_widget_set_name (label406, "label406");
  gtk_widget_show (label406);
  gtk_box_pack_start (GTK_BOX (hbox257), label406, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label406, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label406), GTK_JUSTIFY_LEFT);

  vbox69 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox69, "vbox69");
  gtk_widget_show (vbox69);
  gtk_box_pack_start (GTK_BOX (hbox257), vbox69, TRUE, TRUE, 0);

  label409 = gtk_label_new ("");
  gtk_widget_set_name (label409, "label409");
  gtk_widget_show (label409);
  gtk_box_pack_start (GTK_BOX (vbox69), label409, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label409, -1, 3);
  gtk_label_set_justify (GTK_LABEL (label409), GTK_JUSTIFY_LEFT);

  useradd_password_entry = gtk_entry_new ();
  gtk_widget_set_name (useradd_password_entry, "useradd_password_entry");
  gtk_widget_show (useradd_password_entry);
  gtk_box_pack_start (GTK_BOX (vbox69), useradd_password_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (useradd_password_entry, 30, -1);
  gtk_entry_set_max_length (GTK_ENTRY (useradd_password_entry), 128);

  label408 = gtk_label_new ("");
  gtk_widget_set_name (label408, "label408");
  gtk_widget_show (label408);
  gtk_box_pack_start (GTK_BOX (vbox69), label408, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label408, -1, 10);
  gtk_label_set_justify (GTK_LABEL (label408), GTK_JUSTIFY_LEFT);

  useradd_incoming_directory_entry = gtk_entry_new ();
  gtk_widget_set_name (useradd_incoming_directory_entry, "useradd_incoming_directory_entry");
  gtk_widget_show (useradd_incoming_directory_entry);
  gtk_box_pack_start (GTK_BOX (vbox69), useradd_incoming_directory_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (useradd_incoming_directory_entry, 70, -1);
  gtk_entry_set_max_length (GTK_ENTRY (useradd_incoming_directory_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (useradd_incoming_directory_entry), "/upload");

  label410 = gtk_label_new ("");
  gtk_widget_set_name (label410, "label410");
  gtk_widget_show (label410);
  gtk_box_pack_start (GTK_BOX (hbox257), label410, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label410, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label410), GTK_JUSTIFY_LEFT);

  vbox70 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox70, "vbox70");
  gtk_widget_show (vbox70);
  gtk_box_pack_start (GTK_BOX (hbox257), vbox70, FALSE, FALSE, 0);

  label412 = gtk_label_new ("");
  gtk_widget_set_name (label412, "label412");
  gtk_widget_show (label412);
  gtk_box_pack_start (GTK_BOX (vbox70), label412, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label412, -1, 7);
  gtk_label_set_justify (GTK_LABEL (label412), GTK_JUSTIFY_LEFT);

  label28 = gtk_label_new (_("Shell: "));
  gtk_widget_set_name (label28, "label28");
  gtk_widget_show (label28);
  gtk_box_pack_start (GTK_BOX (vbox70), label28, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label28), GTK_JUSTIFY_LEFT);

  label411 = gtk_label_new ("");
  gtk_widget_set_name (label411, "label411");
  gtk_widget_show (label411);
  gtk_box_pack_start (GTK_BOX (vbox70), label411, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label411, -1, 17);
  gtk_label_set_justify (GTK_LABEL (label411), GTK_JUSTIFY_LEFT);

  useradd_incoming_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (useradd_incoming_checkbutton, "useradd_incoming_checkbutton");
  gtk_widget_show (useradd_incoming_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox70), useradd_incoming_checkbutton, FALSE, FALSE, 0);
  gtk_widget_set_size_request (useradd_incoming_checkbutton, 22, -1);
  gtk_tooltips_set_tip (tooltips, useradd_incoming_checkbutton, _("Create this upload directory"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (useradd_incoming_checkbutton), TRUE);

  vbox71 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox71, "vbox71");
  gtk_widget_show (vbox71);
  gtk_box_pack_start (GTK_BOX (hbox257), vbox71, TRUE, TRUE, 0);

  label416 = gtk_label_new ("");
  gtk_widget_set_name (label416, "label416");
  gtk_widget_show (label416);
  gtk_box_pack_start (GTK_BOX (vbox71), label416, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label416, -1, 3);
  gtk_label_set_justify (GTK_LABEL (label416), GTK_JUSTIFY_LEFT);

  shell_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (shell_combo)->popwin),
                     "GladeParentKey", shell_combo);
  gtk_widget_set_name (shell_combo, "shell_combo");
  gtk_widget_show (shell_combo);
  gtk_box_pack_start (GTK_BOX (vbox71), shell_combo, FALSE, FALSE, 0);
  gtk_widget_set_size_request (shell_combo, 27, -1);

  useradd_shell_entry = GTK_COMBO (shell_combo)->entry;
  gtk_widget_set_name (useradd_shell_entry, "useradd_shell_entry");
  gtk_widget_show (useradd_shell_entry);
  gtk_widget_set_sensitive (useradd_shell_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (useradd_shell_entry), FALSE);

  label415 = gtk_label_new ("");
  gtk_widget_set_name (label415, "label415");
  gtk_widget_show (label415);
  gtk_box_pack_start (GTK_BOX (vbox71), label415, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label415, -1, 10);
  gtk_label_set_justify (GTK_LABEL (label415), GTK_JUSTIFY_LEFT);

  hbox258 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox258, "hbox258");
  gtk_widget_show (hbox258);
  gtk_box_pack_start (GTK_BOX (vbox71), hbox258, TRUE, TRUE, 0);

  label414 = gtk_label_new ("");
  gtk_widget_set_name (label414, "label414");
  gtk_widget_show (label414);
  gtk_box_pack_start (GTK_BOX (hbox258), label414, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label414, 10, -1);
  gtk_label_set_justify (GTK_LABEL (label414), GTK_JUSTIFY_LEFT);

  useradd_button = gtk_button_new ();
  gtk_widget_set_name (useradd_button, "useradd_button");
  gtk_widget_show (useradd_button);
  gtk_box_pack_start (GTK_BOX (hbox258), useradd_button, TRUE, TRUE, 0);

  alignment11 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment11, "alignment11");
  gtk_widget_show (alignment11);
  gtk_container_add (GTK_CONTAINER (useradd_button), alignment11);

  hbox17 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox17, "hbox17");
  gtk_widget_show (hbox17);
  gtk_container_add (GTK_CONTAINER (alignment11), hbox17);

  image11 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image11, "image11");
  gtk_widget_show (image11);
  gtk_box_pack_start (GTK_BOX (hbox17), image11, FALSE, FALSE, 0);

  label32 = gtk_label_new_with_mnemonic (_("Add"));
  gtk_widget_set_name (label32, "label32");
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox17), label32, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label32), GTK_JUSTIFY_LEFT);

  label413 = gtk_label_new ("");
  gtk_widget_set_name (label413, "label413");
  gtk_widget_show (label413);
  gtk_box_pack_start (GTK_BOX (hbox257), label413, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label413, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label413), GTK_JUSTIFY_LEFT);

  vbox68 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox68, "vbox68");
  gtk_widget_show (vbox68);
  gtk_box_pack_start (GTK_BOX (vbox7), vbox68, FALSE, FALSE, 0);

  hseparator106 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator106, "hseparator106");
  gtk_widget_show (hseparator106);
  gtk_box_pack_start (GTK_BOX (vbox68), hseparator106, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator106, -1, 5);

  scrolledwindow7 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow7, "scrolledwindow7");
  gtk_widget_show (scrolledwindow7);
  gtk_box_pack_start (GTK_BOX (vbox7), scrolledwindow7, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow7), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  userlist_treeview = gtk_tree_view_new ();
  gtk_widget_set_name (userlist_treeview, "userlist_treeview");
  gtk_widget_show (userlist_treeview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow7), userlist_treeview);
  gtk_tooltips_set_tip (tooltips, userlist_treeview, _("Doubleclick to make changes to a user"), NULL);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (userlist_treeview), TRUE);

  label8 = gtk_label_new (_("Users"));
  gtk_widget_set_name (label8, "label8");
  gtk_widget_show (label8);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 1), label8);
  gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox4, "vbox4");
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox4);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox4,
                                      TRUE, TRUE, GTK_PACK_START);

  label47 = gtk_label_new (_("Current usage, transferrates and terminating connections."));
  gtk_widget_set_name (label47, "label47");
  gtk_widget_show (label47);
  gtk_box_pack_start (GTK_BOX (vbox4), label47, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label47), GTK_JUSTIFY_LEFT);

  hseparator105 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator105, "hseparator105");
  gtk_widget_show (hseparator105);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator105, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator105, -1, 5);

  hbox97 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox97, "hbox97");
  gtk_widget_show (hbox97);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox97, FALSE, FALSE, 0);

  label180 = gtk_label_new (_("Total bandwidth: "));
  gtk_widget_set_name (label180, "label180");
  gtk_widget_show (label180);
  gtk_box_pack_start (GTK_BOX (hbox97), label180, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label180), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label180), 5, 0);

  label388 = gtk_label_new ("");
  gtk_widget_set_name (label388, "label388");
  gtk_widget_show (label388);
  gtk_box_pack_start (GTK_BOX (hbox97), label388, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label388, 5, -1);
  gtk_label_set_justify (GTK_LABEL (label388), GTK_JUSTIFY_LEFT);

  total_xfer_entry = gtk_entry_new ();
  gtk_widget_set_name (total_xfer_entry, "total_xfer_entry");
  gtk_widget_show (total_xfer_entry);
  gtk_box_pack_start (GTK_BOX (hbox97), total_xfer_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (total_xfer_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (total_xfer_entry), FALSE);

  label181 = gtk_label_new ("");
  gtk_widget_set_name (label181, "label181");
  gtk_widget_show (label181);
  gtk_box_pack_start (GTK_BOX (hbox97), label181, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label181, 20, -1);
  gtk_label_set_justify (GTK_LABEL (label181), GTK_JUSTIFY_LEFT);

  hseparator104 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator104, "hseparator104");
  gtk_widget_show (hseparator104);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator104, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator104, -1, 5);

  hbox96 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox96, "hbox96");
  gtk_widget_show (hbox96);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox96, FALSE, FALSE, 0);

  label177 = gtk_label_new (_("Total incoming: "));
  gtk_widget_set_name (label177, "label177");
  gtk_widget_show (label177);
  gtk_box_pack_start (GTK_BOX (hbox96), label177, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label177), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label177), 5, 0);

  label387 = gtk_label_new ("");
  gtk_widget_set_name (label387, "label387");
  gtk_widget_show (label387);
  gtk_box_pack_start (GTK_BOX (hbox96), label387, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label387, 11, -1);
  gtk_label_set_justify (GTK_LABEL (label387), GTK_JUSTIFY_LEFT);

  total_incoming_entry = gtk_entry_new ();
  gtk_widget_set_name (total_incoming_entry, "total_incoming_entry");
  gtk_widget_show (total_incoming_entry);
  gtk_box_pack_start (GTK_BOX (hbox96), total_incoming_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (total_incoming_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (total_incoming_entry), FALSE);

  label178 = gtk_label_new (_(" Total outgoing: "));
  gtk_widget_set_name (label178, "label178");
  gtk_widget_show (label178);
  gtk_box_pack_start (GTK_BOX (hbox96), label178, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label178), GTK_JUSTIFY_LEFT);

  total_outgoing_entry = gtk_entry_new ();
  gtk_widget_set_name (total_outgoing_entry, "total_outgoing_entry");
  gtk_widget_show (total_outgoing_entry);
  gtk_box_pack_start (GTK_BOX (hbox96), total_outgoing_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (total_outgoing_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (total_outgoing_entry), FALSE);

  label179 = gtk_label_new ("");
  gtk_widget_set_name (label179, "label179");
  gtk_widget_show (label179);
  gtk_box_pack_start (GTK_BOX (hbox96), label179, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label179, 20, -1);
  gtk_label_set_justify (GTK_LABEL (label179), GTK_JUSTIFY_LEFT);

  hseparator38 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator38, "hseparator38");
  gtk_widget_show (hseparator38);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator38, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator38, -1, 5);

  hbox23 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox23, "hbox23");
  gtk_widget_show (hbox23);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox23, FALSE, TRUE, 0);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox1, "hbuttonbox1");
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (hbox23), hbuttonbox1, FALSE, FALSE, 0);

  label20 = gtk_label_new (_("Username or PID:"));
  gtk_widget_set_name (label20, "label20");
  gtk_widget_show (label20);
  gtk_box_pack_start (GTK_BOX (hbox23), label20, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label20), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label20), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label20), 5, 0);

  kick_entry = gtk_entry_new ();
  gtk_widget_set_name (kick_entry, "kick_entry");
  gtk_widget_show (kick_entry);
  gtk_box_pack_start (GTK_BOX (hbox23), kick_entry, TRUE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (kick_entry), 128);

  label384 = gtk_label_new ("");
  gtk_widget_set_name (label384, "label384");
  gtk_widget_show (label384);
  gtk_box_pack_start (GTK_BOX (hbox23), label384, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label384, 10, -1);
  gtk_label_set_justify (GTK_LABEL (label384), GTK_JUSTIFY_LEFT);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox2, "hbuttonbox2");
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (hbox23), hbuttonbox2, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_SPREAD);

  kick_button = gtk_button_new ();
  gtk_widget_set_name (kick_button, "kick_button");
  gtk_widget_show (kick_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), kick_button);
  GTK_WIDGET_SET_FLAGS (kick_button, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, kick_button, _("Kicks the first matching username or the matching process number"), NULL);

  alignment53 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment53, "alignment53");
  gtk_widget_show (alignment53);
  gtk_container_add (GTK_CONTAINER (kick_button), alignment53);

  hbox256 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox256, "hbox256");
  gtk_widget_show (hbox256);
  gtk_container_add (GTK_CONTAINER (alignment53), hbox256);

  image53 = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image53, "image53");
  gtk_widget_show (image53);
  gtk_box_pack_start (GTK_BOX (hbox256), image53, FALSE, FALSE, 0);

  label381 = gtk_label_new_with_mnemonic (_("Kick"));
  gtk_widget_set_name (label381, "label381");
  gtk_widget_show (label381);
  gtk_box_pack_start (GTK_BOX (hbox256), label381, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label381), GTK_JUSTIFY_LEFT);

  label385 = gtk_label_new ("");
  gtk_widget_set_name (label385, "label385");
  gtk_widget_show (label385);
  gtk_box_pack_start (GTK_BOX (hbox23), label385, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label385, 10, -1);
  gtk_label_set_justify (GTK_LABEL (label385), GTK_JUSTIFY_LEFT);

  kickban_button = gtk_button_new ();
  gtk_widget_set_name (kickban_button, "kickban_button");
  gtk_widget_show (kickban_button);
  gtk_box_pack_start (GTK_BOX (hbox23), kickban_button, FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (kickban_button, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, kickban_button, _("Kickbans the first matching username or the matching process number"), NULL);

  alignment7 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment7, "alignment7");
  gtk_widget_show (alignment7);
  gtk_container_add (GTK_CONTAINER (kickban_button), alignment7);

  hbox10 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox10, "hbox10");
  gtk_widget_show (hbox10);
  gtk_container_add (GTK_CONTAINER (alignment7), hbox10);

  image7 = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image7, "image7");
  gtk_widget_show (image7);
  gtk_box_pack_start (GTK_BOX (hbox10), image7, FALSE, FALSE, 0);

  label21 = gtk_label_new_with_mnemonic (_("Kickban"));
  gtk_widget_set_name (label21, "label21");
  gtk_widget_show (label21);
  gtk_box_pack_start (GTK_BOX (hbox10), label21, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label21), GTK_JUSTIFY_LEFT);

  label386 = gtk_label_new ("");
  gtk_widget_set_name (label386, "label386");
  gtk_widget_show (label386);
  gtk_box_pack_start (GTK_BOX (hbox23), label386, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label386, 20, -1);
  gtk_label_set_justify (GTK_LABEL (label386), GTK_JUSTIFY_LEFT);

  hseparator39 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator39, "hseparator39");
  gtk_widget_show (hseparator39);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator39, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator39, -1, 5);

  xfer_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (xfer_scrolledwindow, "xfer_scrolledwindow");
  gtk_widget_show (xfer_scrolledwindow);
  gtk_box_pack_start (GTK_BOX (vbox4), xfer_scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (xfer_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  xfer_textview = gtk_text_view_new ();
  gtk_widget_set_name (xfer_textview, "xfer_textview");
  gtk_widget_show (xfer_textview);
  gtk_container_add (GTK_CONTAINER (xfer_scrolledwindow), xfer_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (xfer_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (xfer_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (xfer_textview), 5);

  label10 = gtk_label_new (_("Transfers"));
  gtk_widget_set_name (label10, "label10");
  gtk_widget_show (label10);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 2), label10);
  gtk_label_set_justify (GTK_LABEL (label10), GTK_JUSTIFY_LEFT);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox6, "vbox6");
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox6);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox6,
                                      TRUE, TRUE, GTK_PACK_START);

  label382 = gtk_label_new (_("Information about mounted devices."));
  gtk_widget_set_name (label382, "label382");
  gtk_widget_show (label382);
  gtk_box_pack_start (GTK_BOX (vbox6), label382, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label382), GTK_JUSTIFY_LEFT);

  disc_update_button = gtk_button_new ();
  gtk_widget_set_name (disc_update_button, "disc_update_button");
  gtk_widget_show (disc_update_button);
  gtk_box_pack_start (GTK_BOX (vbox6), disc_update_button, FALSE, TRUE, 0);

  alignment10 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment10, "alignment10");
  gtk_widget_show (alignment10);
  gtk_container_add (GTK_CONTAINER (disc_update_button), alignment10);

  hbox13 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox13, "hbox13");
  gtk_widget_show (hbox13);
  gtk_container_add (GTK_CONTAINER (alignment10), hbox13);

  image10 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image10, "image10");
  gtk_widget_show (image10);
  gtk_box_pack_start (GTK_BOX (hbox13), image10, TRUE, FALSE, 0);

  label24 = gtk_label_new_with_mnemonic (_("Update"));
  gtk_widget_set_name (label24, "label24");
  gtk_widget_show (label24);
  gtk_box_pack_start (GTK_BOX (hbox13), label24, TRUE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label24), GTK_JUSTIFY_LEFT);

  scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow6, "scrolledwindow6");
  gtk_widget_show (scrolledwindow6);
  gtk_box_pack_start (GTK_BOX (vbox6), scrolledwindow6, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  disc_treeview = gtk_tree_view_new ();
  gtk_widget_set_name (disc_treeview, "disc_treeview");
  gtk_widget_show (disc_treeview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow6), disc_treeview);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (disc_treeview), TRUE);

  label11 = gtk_label_new (_("Disk"));
  gtk_widget_set_name (label11, "label11");
  gtk_widget_show (label11);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 3), label11);
  gtk_label_set_justify (GTK_LABEL (label11), GTK_JUSTIFY_LEFT);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox5, "vbox5");
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox5);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox5,
                                      TRUE, TRUE, GTK_PACK_START);

  label48 = gtk_label_new (_("Transferred files and statistics generation."));
  gtk_widget_set_name (label48, "label48");
  gtk_widget_show (label48);
  gtk_box_pack_start (GTK_BOX (vbox5), label48, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label48), GTK_JUSTIFY_LEFT);

  hseparator108 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator108, "hseparator108");
  gtk_widget_show (hseparator108);
  gtk_box_pack_start (GTK_BOX (vbox5), hseparator108, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator108, -1, 5);

  hbox92 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox92, "hbox92");
  gtk_widget_show (hbox92);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox92, FALSE, TRUE, 0);

  label369 = gtk_label_new (_("Generate:"));
  gtk_widget_set_name (label369, "label369");
  gtk_widget_show (label369);
  gtk_box_pack_start (GTK_BOX (hbox92), label369, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label369), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label369), 5, 0);

  html_button = gtk_button_new ();
  gtk_widget_set_name (html_button, "html_button");
  gtk_widget_show (html_button);
  gtk_box_pack_start (GTK_BOX (hbox92), html_button, FALSE, FALSE, 0);

  alignment42 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment42, "alignment42");
  gtk_widget_show (alignment42);
  gtk_container_add (GTK_CONTAINER (html_button), alignment42);

  hbox93 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox93, "hbox93");
  gtk_widget_show (hbox93);
  gtk_container_add (GTK_CONTAINER (alignment42), hbox93);

  image42 = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image42, "image42");
  gtk_widget_show (image42);
  gtk_box_pack_start (GTK_BOX (hbox93), image42, FALSE, FALSE, 0);

  label168 = gtk_label_new_with_mnemonic ("HTML");
  gtk_widget_set_name (label168, "label168");
  gtk_widget_show (label168);
  gtk_box_pack_start (GTK_BOX (hbox93), label168, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label168), GTK_JUSTIFY_LEFT);

  label164 = gtk_label_new ("");
  gtk_widget_set_name (label164, "label164");
  gtk_widget_show (label164);
  gtk_box_pack_start (GTK_BOX (hbox92), label164, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label164, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label164), GTK_JUSTIFY_LEFT);

  html_entry = gtk_entry_new ();
  gtk_widget_set_name (html_entry, "html_entry");
  gtk_widget_show (html_entry);
  gtk_box_pack_start (GTK_BOX (hbox92), html_entry, TRUE, TRUE, 0);
  gtk_widget_set_size_request (html_entry, 136, -1);
  gtk_entry_set_max_length (GTK_ENTRY (html_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (html_entry), "/var/www/html/ftp.html");

  label165 = gtk_label_new ("");
  gtk_widget_set_name (label165, "label165");
  gtk_widget_show (label165);
  gtk_box_pack_start (GTK_BOX (hbox92), label165, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label165, 10, -1);
  gtk_label_set_justify (GTK_LABEL (label165), GTK_JUSTIFY_LEFT);

  welcome_button = gtk_button_new ();
  gtk_widget_set_name (welcome_button, "welcome_button");
  gtk_widget_show (welcome_button);
  gtk_box_pack_start (GTK_BOX (hbox92), welcome_button, FALSE, FALSE, 0);

  alignment43 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment43, "alignment43");
  gtk_widget_show (alignment43);
  gtk_container_add (GTK_CONTAINER (welcome_button), alignment43);

  hbox94 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox94, "hbox94");
  gtk_widget_show (hbox94);
  gtk_container_add (GTK_CONTAINER (alignment43), hbox94);

  image43 = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image43, "image43");
  gtk_widget_show (image43);
  gtk_box_pack_start (GTK_BOX (hbox94), image43, FALSE, FALSE, 0);

  label169 = gtk_label_new_with_mnemonic (_("Welcome"));
  gtk_widget_set_name (label169, "label169");
  gtk_widget_show (label169);
  gtk_box_pack_start (GTK_BOX (hbox94), label169, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label169), GTK_JUSTIFY_LEFT);

  label170 = gtk_label_new ("");
  gtk_widget_set_name (label170, "label170");
  gtk_widget_show (label170);
  gtk_box_pack_start (GTK_BOX (hbox92), label170, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label170, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label170), GTK_JUSTIFY_LEFT);

  welcome_entry = gtk_entry_new ();
  gtk_widget_set_name (welcome_entry, "welcome_entry");
  gtk_widget_show (welcome_entry);
  gtk_box_pack_start (GTK_BOX (hbox92), welcome_entry, TRUE, TRUE, 0);
  gtk_widget_set_size_request (welcome_entry, 85, -1);
  gtk_entry_set_max_length (GTK_ENTRY (welcome_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (welcome_entry), "welcome.msg");

  label167 = gtk_label_new ("");
  gtk_widget_set_name (label167, "label167");
  gtk_widget_show (label167);
  gtk_box_pack_start (GTK_BOX (hbox92), label167, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label167, 3, -1);
  gtk_label_set_justify (GTK_LABEL (label167), GTK_JUSTIFY_LEFT);

  hseparator107 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator107, "hseparator107");
  gtk_widget_show (hseparator107);
  gtk_box_pack_start (GTK_BOX (vbox5), hseparator107, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator107, -1, 10);

  hbuttonbox10 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox10, "hbuttonbox10");
  gtk_widget_show (hbuttonbox10);
  gtk_box_pack_start (GTK_BOX (vbox5), hbuttonbox10, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox10), GTK_BUTTONBOX_SPREAD);

  files_clear_button = gtk_button_new ();
  gtk_widget_set_name (files_clear_button, "files_clear_button");
  gtk_widget_show (files_clear_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox10), files_clear_button);
  GTK_WIDGET_SET_FLAGS (files_clear_button, GTK_CAN_DEFAULT);

  alignment39 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment39, "alignment39");
  gtk_widget_show (alignment39);
  gtk_container_add (GTK_CONTAINER (files_clear_button), alignment39);

  hbox86 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox86, "hbox86");
  gtk_widget_show (hbox86);
  gtk_container_add (GTK_CONTAINER (alignment39), hbox86);

  image39 = gtk_image_new_from_stock ("gtk-clear", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image39, "image39");
  gtk_widget_show (image39);
  gtk_box_pack_start (GTK_BOX (hbox86), image39, FALSE, FALSE, 0);

  label156 = gtk_label_new_with_mnemonic (_("Clear"));
  gtk_widget_set_name (label156, "label156");
  gtk_widget_show (label156);
  gtk_box_pack_start (GTK_BOX (hbox86), label156, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label156), GTK_JUSTIFY_LEFT);

  files_update_button = gtk_button_new ();
  gtk_widget_set_name (files_update_button, "files_update_button");
  gtk_widget_show (files_update_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox10), files_update_button);
  GTK_WIDGET_SET_FLAGS (files_update_button, GTK_CAN_DEFAULT);

  alignment38 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment38, "alignment38");
  gtk_widget_show (alignment38);
  gtk_container_add (GTK_CONTAINER (files_update_button), alignment38);

  hbox85 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox85, "hbox85");
  gtk_widget_show (hbox85);
  gtk_container_add (GTK_CONTAINER (alignment38), hbox85);

  image38 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image38, "image38");
  gtk_widget_show (image38);
  gtk_box_pack_start (GTK_BOX (hbox85), image38, FALSE, FALSE, 0);

  label155 = gtk_label_new_with_mnemonic (_("Update"));
  gtk_widget_set_name (label155, "label155");
  gtk_widget_show (label155);
  gtk_box_pack_start (GTK_BOX (hbox85), label155, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label155), GTK_JUSTIFY_LEFT);

  hseparator36 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator36, "hseparator36");
  gtk_widget_show (hseparator36);
  gtk_box_pack_start (GTK_BOX (vbox5), hseparator36, FALSE, TRUE, 0);
  gtk_widget_set_size_request (hseparator36, -1, 3);

  scrolledwindow17 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow17, "scrolledwindow17");
  gtk_widget_show (scrolledwindow17);
  gtk_box_pack_start (GTK_BOX (vbox5), scrolledwindow17, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow17), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  files_treeview = gtk_tree_view_new ();
  gtk_widget_set_name (files_treeview, "files_treeview");
  gtk_widget_show (files_treeview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow17), files_treeview);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (files_treeview), TRUE);

  label12 = gtk_label_new (_("Files"));
  gtk_widget_set_name (label12, "label12");
  gtk_widget_show (label12);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 4), label12);
  gtk_label_set_justify (GTK_LABEL (label12), GTK_JUSTIFY_LEFT);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox9, "vbox9");
  gtk_widget_show (vbox9);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox9);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox9,
                                      TRUE, TRUE, GTK_PACK_START);

  label49 = gtk_label_new (_("This is the entire proftpd configuration."));
  gtk_widget_set_name (label49, "label49");
  gtk_widget_show (label49);
  gtk_box_pack_start (GTK_BOX (vbox9), label49, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label49), GTK_JUSTIFY_LEFT);


  hbox70 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox70, "hbox70");
  gtk_widget_show (hbox70);
  gtk_box_pack_start (GTK_BOX (vbox9), hbox70, FALSE, TRUE, 0);


  hbuttonbox4 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox4, "hbuttonbox4");
  gtk_widget_show (hbuttonbox4);
  gtk_box_pack_start (GTK_BOX (hbox70), hbuttonbox4, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox4), GTK_BUTTONBOX_SPREAD);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox4), 2);

  restore_button = gtk_button_new ();
  gtk_widget_set_name (restore_button, "restore_button");
  gtk_widget_show (restore_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox4), restore_button);
  GTK_WIDGET_SET_FLAGS (restore_button, GTK_CAN_DEFAULT);

  alignment32 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment32, "alignment32");
  gtk_widget_show (alignment32);
  gtk_container_add (GTK_CONTAINER (restore_button), alignment32);

  hbox73 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox73, "hbox73");
  gtk_widget_show (hbox73);
  gtk_container_add (GTK_CONTAINER (alignment32), hbox73);

  image32 = gtk_image_new_from_stock ("gtk-undelete", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image32, "image32");
  gtk_widget_show (image32);
  gtk_box_pack_start (GTK_BOX (hbox73), image32, FALSE, FALSE, 0);

  label135 = gtk_label_new_with_mnemonic (_("Restore"));
  gtk_widget_set_name (label135, "label135");
  gtk_widget_show (label135);
  gtk_box_pack_start (GTK_BOX (hbox73), label135, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label135), GTK_JUSTIFY_LEFT);

  /* Backup button */
  hbuttonbox5 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox5, "hbuttonbox5");
  gtk_widget_show (hbuttonbox5);
  gtk_box_pack_start (GTK_BOX (hbox70), hbuttonbox5, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox5), GTK_BUTTONBOX_SPREAD);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox5), 2);

  backup_button = gtk_button_new ();
  gtk_widget_set_name (backup_button, "backup_button");
  gtk_widget_show (backup_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox5), backup_button);
  GTK_WIDGET_SET_FLAGS (backup_button, GTK_CAN_DEFAULT);

  alignment31 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment31, "alignment31");
  gtk_widget_show (alignment31);
  gtk_container_add (GTK_CONTAINER (backup_button), alignment31);

  hbox72 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox72, "hbox72");
  gtk_widget_show (hbox72);
  gtk_container_add (GTK_CONTAINER (alignment31), hbox72);

  image31 = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image31, "image31");
  gtk_widget_show (image31);
  gtk_box_pack_start (GTK_BOX (hbox72), image31, FALSE, FALSE, 0);

  label134 = gtk_label_new_with_mnemonic (_("Backup"));
  gtk_widget_set_name (label134, "label134");
  gtk_widget_show (label134);
  gtk_box_pack_start (GTK_BOX (hbox72), label134, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label134), GTK_JUSTIFY_LEFT);

  /* Syntaxcheck button*/
  hbuttonbox6 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox6, "hbuttonbox6");
  gtk_widget_show (hbuttonbox6);
  gtk_box_pack_start (GTK_BOX (hbox70), hbuttonbox6, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox6), GTK_BUTTONBOX_SPREAD);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox6), 2);

  syntaxcheck_button = gtk_button_new ();
  gtk_widget_set_name (syntaxcheck_button, "syntaxcheck_button");
  gtk_widget_show (syntaxcheck_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), syntaxcheck_button);
  GTK_WIDGET_SET_FLAGS (syntaxcheck_button, GTK_CAN_DEFAULT);

  alignment33 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment33, "alignment33");
  gtk_widget_show (alignment33);
  gtk_container_add (GTK_CONTAINER (syntaxcheck_button), alignment33);

  hbox74 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox74, "hbox74");
  gtk_widget_show (hbox74);
  gtk_container_add (GTK_CONTAINER (alignment33), hbox74);

  image33 = gtk_image_new_from_stock ("gtk-find", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image33, "image33");
  gtk_widget_show (image33);
  gtk_box_pack_start (GTK_BOX (hbox74), image33, FALSE, FALSE, 0);

  label136 = gtk_label_new_with_mnemonic (_("Check syntax"));
  gtk_widget_set_name (label136, "label136");
  gtk_widget_show (label136);
  gtk_box_pack_start (GTK_BOX (hbox74), label136, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label136), GTK_JUSTIFY_LEFT);

  /* Save entire button */
  hbuttonbox7 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox7, "hbuttonbox7");
  gtk_widget_show (hbuttonbox7);
  gtk_box_pack_start (GTK_BOX (hbox70), hbuttonbox7, TRUE, TRUE, 2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox7), GTK_BUTTONBOX_SPREAD);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox7), 2);

  save_entire_button = gtk_button_new ();
  gtk_widget_set_name (save_entire_button, "save_entire_button");
  gtk_widget_show (save_entire_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), save_entire_button);
  GTK_WIDGET_SET_FLAGS (save_entire_button, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, save_entire_button, _("The server will not reread its configuration"), NULL);

  alignment34 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment34, "alignment34");
  gtk_widget_show (alignment34);
  gtk_container_add (GTK_CONTAINER (save_entire_button), alignment34);

  hbox75 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox75, "hbox75");
  gtk_widget_show (hbox75);
  gtk_container_add (GTK_CONTAINER (alignment34), hbox75);

  image34 = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image34, "image34");
  gtk_widget_show (image34);
  gtk_box_pack_start (GTK_BOX (hbox75), image34, FALSE, FALSE, 0);

  label137 = gtk_label_new_with_mnemonic (_("Save"));
  gtk_widget_set_name (label137, "label137");
  gtk_widget_show (label137);
  gtk_box_pack_start (GTK_BOX (hbox75), label137, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label137), GTK_JUSTIFY_LEFT);

  hseparator33 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator33, "hseparator33");
  gtk_widget_show (hseparator33);
  gtk_box_pack_start (GTK_BOX (vbox9), hseparator33, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator33, -1, 5);

  scrolledwindow9 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow9, "scrolledwindow9");
  gtk_widget_show (scrolledwindow9);
  gtk_box_pack_start (GTK_BOX (vbox9), scrolledwindow9, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow9), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  entire_textview = gtk_text_view_new ();
  gtk_widget_set_name (entire_textview, "entire_textview");
  gtk_widget_show (entire_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow9), entire_textview);
  gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (entire_textview), 5);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (entire_textview), 5);

  label13 = gtk_label_new (_("Conf"));
  gtk_widget_set_name (label13, "label13");
  gtk_widget_show (label13);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 5), label13);
  gtk_label_set_justify (GTK_LABEL (label13), GTK_JUSTIFY_LEFT);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox10, "vbox10");
  gtk_widget_show (vbox10);
  gtk_container_add (GTK_CONTAINER (main_notebook), vbox10);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (main_notebook), vbox10,
                                      TRUE, TRUE, GTK_PACK_START);

  label383 = gtk_label_new (_("Server security information."));
  gtk_widget_set_name (label383, "label383");
  gtk_widget_show (label383);
  gtk_box_pack_start (GTK_BOX (vbox10), label383, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label383), GTK_JUSTIFY_LEFT);

  security_update_button = gtk_button_new ();
  gtk_widget_set_name (security_update_button, "security_update_button");
  gtk_widget_show (security_update_button);
  gtk_box_pack_start (GTK_BOX (vbox10), security_update_button, FALSE, FALSE, 0);

  alignment14 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment14, "alignment14");
  gtk_widget_show (alignment14);
  gtk_container_add (GTK_CONTAINER (security_update_button), alignment14);

  hbox20 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox20, "hbox20");
  gtk_widget_show (hbox20);
  gtk_container_add (GTK_CONTAINER (alignment14), hbox20);

  image14 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image14, "image14");
  gtk_widget_show (image14);
  gtk_box_pack_start (GTK_BOX (hbox20), image14, FALSE, FALSE, 0);

  label37 = gtk_label_new_with_mnemonic (_("Update"));
  gtk_widget_set_name (label37, "label37");
  gtk_widget_show (label37);
  gtk_box_pack_start (GTK_BOX (hbox20), label37, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label37), GTK_JUSTIFY_LEFT);

  scrolledwindow10 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow10, "scrolledwindow10");
  gtk_widget_show (scrolledwindow10);
  gtk_box_pack_start (GTK_BOX (vbox10), scrolledwindow10, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow10), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  viewport2 = gtk_viewport_new (NULL, NULL);
  gtk_widget_set_name (viewport2, "viewport2");
  gtk_widget_show (viewport2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow10), viewport2);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox11, "vbox11");
  gtk_widget_show (vbox11);
  gtk_container_add (GTK_CONTAINER (viewport2), vbox11);

  label38 = gtk_label_new (_("Successful logins"));
  gtk_widget_set_name (label38, "label38");
  gtk_widget_show (label38);
  gtk_box_pack_start (GTK_BOX (vbox11), label38, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label38), GTK_JUSTIFY_LEFT);

  scrolledwindow11 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow11, "scrolledwindow11");
  gtk_widget_show (scrolledwindow11);
  gtk_box_pack_start (GTK_BOX (vbox11), scrolledwindow11, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow11, -1, 180);

  security_successful_textview = gtk_text_view_new ();
  gtk_widget_set_name (security_successful_textview, "security_successful_textview");
  gtk_widget_show (security_successful_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow11), security_successful_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (security_successful_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (security_successful_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (security_successful_textview), 5);

  label39 = gtk_label_new (_("Refused logins"));
  gtk_widget_set_name (label39, "label39");
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (vbox11), label39, FALSE, FALSE, 5);
  gtk_label_set_justify (GTK_LABEL (label39), GTK_JUSTIFY_LEFT);

  scrolledwindow12 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow12, "scrolledwindow12");
  gtk_widget_show (scrolledwindow12);
  gtk_box_pack_start (GTK_BOX (vbox11), scrolledwindow12, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow12, -1, 180);

  security_refused_textview = gtk_text_view_new ();
  gtk_widget_set_name (security_refused_textview, "security_refused_textview");
  gtk_widget_show (security_refused_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow12), security_refused_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (security_refused_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (security_refused_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (security_refused_textview), 5);

  label373 = gtk_label_new ("");
  gtk_widget_set_name (label373, "label373");
  gtk_widget_show (label373);
  gtk_box_pack_start (GTK_BOX (vbox11), label373, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label373, -1, 10);
  gtk_label_set_justify (GTK_LABEL (label373), GTK_JUSTIFY_LEFT);

  label15 = gtk_label_new (_("Security"));
  gtk_widget_set_name (label15, "label15");
  gtk_widget_show (label15);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (main_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (main_notebook), 6), label15);
  gtk_label_set_justify (GTK_LABEL (label15), GTK_JUSTIFY_LEFT);

  hbox90 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox90, "hbox90");
  gtk_widget_show (hbox90);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox90, FALSE, TRUE, 0);

  label333 = gtk_label_new ("Http://mange.dynalias.org/linux.html");
  gtk_widget_set_name (label333, "label333");
  gtk_widget_show (label333);
  gtk_box_pack_start (GTK_BOX (hbox90), label333, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label333), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label333), 0.02, 0.5);
  gtk_misc_set_padding (GTK_MISC (label333), 0, 3);

  gproftpd_version_label = gtk_label_new ("");
  gtk_widget_set_name (gproftpd_version_label, "gproftpd_version_label");
  gtk_widget_show (gproftpd_version_label);
  gtk_box_pack_start (GTK_BOX (hbox90), gproftpd_version_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (gproftpd_version_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (gproftpd_version_label), 6, 3);

  g_signal_connect ((gpointer) gproftpd_window, "map",
                    G_CALLBACK (on_gproftpd_window_map),
                    NULL);
  g_signal_connect ((gpointer) online_button, "clicked",
                    G_CALLBACK (on_online_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) offline_button, "clicked",
                    G_CALLBACK (on_offline_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) shutdown_button, "clicked",
                    G_CALLBACK (on_shutdown_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) reread_button, "clicked",
                    G_CALLBACK (on_reread_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) help_button, "clicked",
                    G_CALLBACK (on_help_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) credits_button, "clicked",
                    G_CALLBACK (on_credits_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) quit_button, "clicked",
                    G_CALLBACK (gtk_main_quit),
                    NULL);
  g_signal_connect ((gpointer) servers_treeview, "button_press_event",
                    G_CALLBACK (on_servers_treeview_row_clicked),
		    NULL);
  g_signal_connect ((gpointer) add_server_button, "clicked",
                    G_CALLBACK (on_add_server_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) delete_server_button, "clicked",
                    G_CALLBACK (on_delete_server_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) apply_server_changes_button, "clicked",
                    G_CALLBACK (on_apply_server_changes_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) tls_generate_certificate_button, "clicked",
                    G_CALLBACK (on_tls_generate_certificate_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) username_rand_button, "clicked",
                    G_CALLBACK (on_username_rand_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) userdir_button, "clicked",
                    G_CALLBACK (on_userdir_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) password_rand_button, "clicked",
                    G_CALLBACK (on_password_rand_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) useradd_incoming_button, "clicked",
                    G_CALLBACK (on_useradd_incoming_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) useradd_button, "clicked",
                    G_CALLBACK (on_useradd_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) userlist_treeview, "row_activated",
                    G_CALLBACK (on_userlist_treeview_row_activated),
                    NULL);
  g_signal_connect ((gpointer) kick_button, "clicked",
                    G_CALLBACK (on_kick_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) kickban_button, "clicked",
                    G_CALLBACK (on_kickban_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) disc_update_button, "clicked",
                    G_CALLBACK (on_disc_update_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) html_button, "clicked",
                    G_CALLBACK (on_html_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) welcome_button, "clicked",
                    G_CALLBACK (on_welcome_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) files_clear_button, "clicked",
                    G_CALLBACK (on_files_clear_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) files_update_button, "clicked",
                    G_CALLBACK (on_files_update_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) restore_button, "clicked",
                    G_CALLBACK (on_restore_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) backup_button, "clicked",
                    G_CALLBACK (on_backup_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) syntaxcheck_button, "clicked",
                    G_CALLBACK (on_syntaxcheck_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) save_entire_button, "clicked",
                    G_CALLBACK (on_save_entire_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) security_update_button, "clicked",
                    G_CALLBACK (on_security_update_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) import_users_button, "clicked",
                    G_CALLBACK (on_import_users_button_clicked),
                    NULL);

  GLADE_HOOKUP_OBJECT_NO_REF (gproftpd_window, gproftpd_window, "gproftpd_window");
  GLADE_HOOKUP_OBJECT (gproftpd_window, online_button, "online_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, offline_button, "offline_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, shutdown_button, "shutdown_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, reread_button, "reread_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, help_button, "help_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, credits_button, "credits_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, quit_button, "quit_button");
//  GLADE_HOOKUP_OBJECT (gproftpd_window, server_info_hbox, "server_info_hbox");
  GLADE_HOOKUP_OBJECT (gproftpd_window, info_label1, "info_label1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, proftpd_version_label, "proftpd_version_label");
  GLADE_HOOKUP_OBJECT (gproftpd_window, status_label, "status_label");
  GLADE_HOOKUP_OBJECT (gproftpd_window, servers_treeview, "servers_treeview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, add_server_button, "add_server_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, delete_server_button, "delete_server_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, apply_server_changes_button, "apply_server_changes_button");
//  GLADE_HOOKUP_OBJECT (gproftpd_window, global_vbox_options, "global_vbox_options");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_server_name, "global_server_name");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_show_server_identity, "global_show_server_identity");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_show_server_identity_on_off, "global_show_server_identity_on_off");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_server_admin_email, "global_server_admin_email");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_bind_tight_on_off, "global_bind_tight_on_off");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_ident_lookups, "global_ident_lookups");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_reverse_lookups, "global_reverse_lookups");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_time_standard, "global_time_standard");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_server_port, "global_server_port");

  GLADE_HOOKUP_OBJECT (gproftpd_window, global_passive_ports_1_spinbutton, "global_passive_ports_1_spinbutton");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_passive_ports_2_spinbutton, "global_passive_ports_2_spinbutton");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_masquerade_entry, "global_masquerade_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_masquerade_address_on_off, "global_masquerade_address_on_off");

  GLADE_HOOKUP_OBJECT (gproftpd_window, import_users_button, "import_users_button");

  GLADE_HOOKUP_OBJECT (gproftpd_window, global_max_connect, "global_max_connect");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_max_login_attempts, "global_max_login_attempts");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_timeout_login, "global_timeout_login");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_idle_timeout, "global_idle_timeout");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_rand_username, "global_rand_username");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_rand_password, "global_rand_password");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_rand_case, "global_rand_case");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_default_transfer_mode, "global_default_transfer_mode");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_allow_fxp, "global_allow_fxp");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_useradd_root_path, "global_useradd_root_path");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_useradd_upload_path, "global_useradd_upload_path");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_html_path, "global_html_path");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_welcome_path, "global_welcome_path");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_systemlog_entry, "global_systemlog_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_server_user, "global_server_user");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_server_group, "global_server_group");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_fake_user_entry, "global_fake_user_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_fake_user_combo, "global_fake_user_combo");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_fake_group_entry, "global_fake_group_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_fake_group_combo, "global_fake_group_combo");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_upload_bandwidth, "global_upload_bandwidth");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_resume_uploads, "global_resume_uploads");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_delete_aborted_stores, "global_delete_aborted_stores");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_download_bandwidth, "global_download_bandwidth");
  GLADE_HOOKUP_OBJECT (gproftpd_window, global_resume_downloads, "global_resume_downloads");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label1, "tls_label1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hseparator1, "tls_hseparator1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hbox1, "tls_hbox1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label65, "tls_label65");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label66, "tls_label66");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label67, "tls_label67");
  GLADE_HOOKUP_OBJECT (gproftpd_window, label327, "label327");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_combo1, "tls_combo1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_use_combo_entry, "tls_use_combo_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_combo2, "tls_combo2");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_use_encryption_combo_entry, "tls_use_encryption_combo_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_combo3, "tls_combo3");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_verify_clients_combo_entry, "tls_verify_clients_combo_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hbox2, "tls_hbox2");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label5, "tls_label5");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label6, "tls_label6");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label7, "tls_label7");
  GLADE_HOOKUP_OBJECT (gproftpd_window, label328, "label328");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_protocols_entry, "tls_protocols_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_logfile_entry, "tls_logfile_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_rsa_cert_entry, "tls_rsa_cert_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label2, "tls_label2");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label3, "tls_label3");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hseparator2, "tls_hseparator2");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hbox3, "tls_hbox3");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label10, "tls_label10");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label11, "tls_label11");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label17, "tls_label17");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label18, "tls_label18");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label19, "tls_label19");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label20, "tls_label20");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label13, "tls_label13");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label14, "tls_label14");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_ip_entry, "tls_ip_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_email_entry, "tls_email_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_state_entry, "tls_state_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_city_entry, "tls_city_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_org_entry, "tls_org_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_org_unit_entry, "tls_org_unit_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_password_entry, "tls_password_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_challenge_entry, "tls_challenge_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hbox4, "tls_hbox4");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label12, "tls_label12");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label15, "tls_label15");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label16, "tls_label16");
  GLADE_HOOKUP_OBJECT (gproftpd_window, label330, "label330");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_bits_spinbutton, "tls_bits_spinbutton");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_valid_spinbutton, "tls_valid_spinbutton");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_country_entry, "tls_country_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hbox5, "tls_hbox5");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_label21, "tls_label21");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_generate_certificate_button, "tls_generate_certificate_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_progressbar, "tls_progressbar");
  GLADE_HOOKUP_OBJECT (gproftpd_window, right_label1, "right_label1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, tls_hbox6, "tls_hbox6");
  GLADE_HOOKUP_OBJECT (gproftpd_window, username_rand_button, "username_rand_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, userdir_button, "userdir_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_username_entry, "useradd_username_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_directory_entry, "useradd_directory_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, password_rand_button, "password_rand_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_incoming_button, "useradd_incoming_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_password_entry, "useradd_password_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_incoming_directory_entry, "useradd_incoming_directory_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_incoming_checkbutton, "useradd_incoming_checkbutton");
  GLADE_HOOKUP_OBJECT (gproftpd_window, shell_combo, "shell_combo");

  /* tls_combos are hooked up above */
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo1, "combo1");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo2, "combo2");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo3, "combo3");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo4, "combo4");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo5, "combo5");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo6, "combo6");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo11, "combo11");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo13, "combo13");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo14, "combo14");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo15, "combo15");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo16, "combo16");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo18, "combo18");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo19, "combo19");
  GLADE_HOOKUP_OBJECT (gproftpd_window, combo20, "combo20");
  
  
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_shell_entry, "useradd_shell_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, useradd_button, "useradd_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, userlist_treeview, "userlist_treeview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, total_xfer_entry, "total_xfer_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, total_incoming_entry, "total_incoming_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, total_outgoing_entry, "total_outgoing_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, kick_entry, "kick_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, kick_button, "kick_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, kickban_button, "kickban_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, xfer_scrolledwindow, "xfer_scrolledwindow");
  GLADE_HOOKUP_OBJECT (gproftpd_window, xfer_textview, "xfer_textview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, disc_update_button, "disc_update_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, disc_treeview, "disc_treeview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, html_button, "html_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, html_entry, "html_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, welcome_button, "welcome_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, welcome_entry, "welcome_entry");
  GLADE_HOOKUP_OBJECT (gproftpd_window, files_clear_button, "files_clear_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, files_update_button, "files_update_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, files_treeview, "files_treeview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, restore_button, "restore_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, backup_button, "backup_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, syntaxcheck_button, "syntaxcheck_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, save_entire_button, "save_entire_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, entire_textview, "entire_textview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, security_update_button, "security_update_button");
  GLADE_HOOKUP_OBJECT (gproftpd_window, security_successful_textview, "security_successful_textview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, security_refused_textview, "security_refused_textview");
  GLADE_HOOKUP_OBJECT (gproftpd_window, gproftpd_version_label, "gproftpd_version_label");
  GLADE_HOOKUP_OBJECT_NO_REF (gproftpd_window, tooltips, "tooltips");

  gtk_widget_grab_focus (useradd_username_entry);
  gtk_widget_grab_default (useradd_username_entry);
  return gproftpd_window;
}
