/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Magnus-swe <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "../config.h"
#include <gtk/gtk.h>
#include "callbacks.h"
#include "functions.h"
#include "import_functions.h"
#include "import_window.h"
#include "dialogs.h"
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <memory.h>
#include "allocate.h"

/* Several defines for different OSes 
 * GProftpdNoDir is deleted so the ftp
 * directory isnt full of skelfiles.
 * Checking defaults to Linux macros.
 */

#ifdef USE_LINUX
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/bin/false"
  #define USERSHOME "/home/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#elif defined USE_SUNOS
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/bin/false"
  #define USERSHOME "/opt/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#elif defined USE_FREEBSD
  #define NOBODY "nobody"
  #define ADDUSER "pw useradd"
  #define ADDGROUP "pw groupadd"
  #define DELUSER "pw userdel"
  #define BINFALSE "/usr/bin/false"
  #define USERSHOME "/usr/home/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#elif defined USE_OPENBSD  
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/sbin/nologin"
  #define USERSHOME "/usr/home/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#elif defined USE_NETBSD
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/usr/bin/false"
  #define USERSHOME "/usr/home/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#elif defined USE_DARWIN
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/usr/bin/false"
  #define USERSHOME "/Users/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
  #include "osx_functions.c"
#elif defined USE_AIX
  #define NOBODY "nobody"
  #define ADDUSER "useradd" /* mkgroup -A usr1 .. mkuser usr1 home=/var/ftp/usr1 shell=/bin/false */
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/bin/false"
  #define USERSHOME "/home/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#elif defined USE_HPUX
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define BINFALSE "/bin/false"
  #define USERSHOME "/home/"
  #define MASTERDIR USERSHOME"ftp/GProftpdNoDir"
  #define ADDPARAMS "-c ftp-master -d "MASTERDIR" -s"
  #define DISC_USAGE "df -hP |grep /"
#endif

/* Max popen output to read in (for ftpwho proftpd -l and df) */ 
#define MAX_READ_POPEN 65535

GtkWidget *userlist_treeview;
GtkWidget *useradd_directory_entry;
GtkWidget *useradd_incoming_directory_entry;
char info_buffer[4096]="";      /* The contents of the info window */
int global_username_randlen=8;  /* The default length of the randomized username */
int global_password_randlen=8;  /* The default length of the randomized password */
char gp_useradd_root_path[8192]=""; /* Remember paths for the randomizer and the app */
char gp_useradd_upload_path[8192]="";

/* This is the selected server/vhost, if SocketBindTight is set it changes to that ip */
char selected_server_address[8192]="All interfaces";
char selected_server_port[128]="";
char selected_server_type[128]="Default server";
char selected_directory[8192]="Rootdir"; /* This is the selected directory */
int offline_pressed=0;          /* Used to determine if some other server is running on this port */
int online=0;
int use_tls=0;                  /* Dont show widgets for tls if we dont have that module */



void
on_info_window_map  (GtkWidget       *widget,
                     gpointer         user_data)
{
    /* Show a popup window with information */
    GtkWidget *info_window;
    GtkWidget *info_textview;
    GtkTextBuffer *info_text_buffer;
    gchar *utf8=NULL;
    info_window = lookup_widget (GTK_WIDGET (widget), "info_window");
    info_textview = lookup_widget (GTK_WIDGET (widget), "info_textview");
    info_text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(info_textview));
    utf8 = g_locale_to_utf8(info_buffer, strlen(info_buffer), NULL, NULL, NULL);
    gtk_text_buffer_set_text(info_text_buffer, utf8, strlen(utf8));
    strcpy(info_buffer, "");
    if(utf8 !=NULL)
    g_free(utf8);
}


int
user_exists(G_CONST_RETURN gchar *username)
{
    /* Checks if the system user already exists */
    FILE *fp;
    long size_buffer;
    int x, user_exists=0;
    char tempname[4096]="";
    char *check_buffer;
    GtkWidget *info_window;

    /* Checks if the user exists in passwd */
    if((fp=fopen(GP_PASSWD,"r"))==NULL)
    {
    	strcpy(info_buffer, _("Error reading passwd here:\n"));
    	strcat(info_buffer, GP_PASSWD);
    	strcat(info_buffer, _("\nNot installed correctly ?.\n"));
    	info_window = create_info_window();
    	gtk_widget_show(info_window);
    	return(0);
    }
    else
      {
	    fseek(fp, 0, SEEK_END);
	    size_buffer = ftell(fp);
	    rewind(fp);
	    check_buffer = allocate(size_buffer);
	    while(fgets(check_buffer, size_buffer, fp)!=NULL)
	    {
		for(x=0; check_buffer[x]; x++)
		{
		    if(check_buffer[x]==':')
		    {
			sprintf(tempname, check_buffer);
			tempname[x]='\0';
			if( ! strcmp(username, tempname) )
			{
			    user_exists=1;
			    break;
			}
		    }
		    if( check_buffer[x]=='\0' || check_buffer[x]=='\n' )
		    break;
		}
	    }
	    free(check_buffer);
	    fclose(fp);
      }

    /* Checks if the user exists in shadow */
    if((fp = fopen(GP_SHADOW,"r"))==NULL)
    {
	/* Dont show anything */
    }
    else
      {
	    fseek(fp, 0, SEEK_END);
	    size_buffer = ftell(fp);
	    rewind(fp);
	    check_buffer = allocate(size_buffer);
	    while(fgets(check_buffer, size_buffer, fp)!=NULL)
	    {
		for(x=0; check_buffer[x]; x++)
		{
		    if(check_buffer[x]==':')
		    {
			sprintf(tempname, check_buffer);
			tempname[x]='\0';
			if( strstr(username, tempname) && strlen(username)==strlen(tempname) )
			{
			    user_exists=1;
			    break;
			}
		    }
		    if( check_buffer[x]=='\0' || check_buffer[x]=='\n' )
		    break;
		}
	    }
	    free(check_buffer);
	    fclose(fp);
      }
    return user_exists;
}


int
group_exists(G_CONST_RETURN gchar *groupname)
{
    /* Checks if the system group already exists */
    FILE *fp;
    long size_buffer;
    int x, group_exists=0;
    char tempname[4096]="";
    char *check_buffer;
    GtkWidget *info_window;

    /* Checks if the group exists in group */
    if((fp=fopen(GP_GROUP,"r"))==NULL)
    {
    	strcpy(info_buffer, _("Error reading group here:\n"));
    	strcat(info_buffer, GP_GROUP);
    	strcat(info_buffer, _("\nNot installed correctly ?.\n"));
    	info_window = create_info_window();
    	gtk_widget_show(info_window);
    	return(0);
    }
    else
      {
	    fseek(fp, 0, SEEK_END);
	    size_buffer = ftell(fp);
	    rewind(fp);
	    check_buffer = allocate(size_buffer);
	    while(fgets(check_buffer, size_buffer, fp)!=NULL)
	    {
		for(x=0; check_buffer[x]; x++)
		{
		    if(check_buffer[x]==':')
		    {
			sprintf(tempname, check_buffer);
			tempname[x]='\0';
			if( ! strcmp(groupname, tempname) )
			{
			    group_exists=1;
			    break;
			}
		    }
		    if( check_buffer[x]=='\0' || check_buffer[x]=='\n' )
		    break;
		}
	    }
	    free(check_buffer);
	    fclose(fp);
      }

    /* Checks if the group exists in gshadow */
    if((fp = fopen(GP_GSHADOW,"r"))==NULL)
    {
	/* Dont show anything */
    }
    else
      {
	    fseek(fp, 0, SEEK_END);
	    size_buffer = ftell(fp);
	    rewind(fp);
	    check_buffer = allocate(size_buffer);
	    while(fgets(check_buffer, size_buffer, fp)!=NULL)
	    {
		for(x=0; check_buffer[x]; x++)
		{
		    if(check_buffer[x]==':')
		    {
			sprintf(tempname, check_buffer);
			tempname[x]='\0';
			if( strstr(groupname, tempname) && strlen(groupname)==strlen(tempname) )
			{
			    group_exists=1;
			    break;
			}
		    }
		    if( check_buffer[x]=='\0' || check_buffer[x]=='\n' )
		    break;
		}
	    }
	    free(check_buffer);
	    fclose(fp);
      }
    return group_exists;
}


void
password_user(G_CONST_RETURN gchar *username, G_CONST_RETURN gchar *password)
{
    FILE *fp;
    GtkWidget *info_window;
    char *user_pass, *encrypted_pass;

    if( ! user_exists(username) )
    {
	sprintf(info_buffer, _("User: %s could not be found in passwd or shadow.\n"), username);
	strcat(info_buffer, _("The password was not changed.\n"));
    	info_window=create_info_window();
    	gtk_widget_show(info_window);
	return;
    }

    user_pass = allocate(8192);

    /* Crypt return a static pointer to a static buffer _DO_NOT_ free it DOH ! */
    encrypted_pass=encrypt_password(password);

    if( encrypted_pass==NULL )
    {
	printf("Crypt error: using the chpass(wd) program instead\n");

#if defined USE_LINUX
	sprintf(user_pass, "echo %s:%s | chpasswd", username, password);
#endif


#if defined USE_OPENBSD || USE_NETBSD || USE_FREEBSD
	sprintf(user_pass, "echo %s:%s | chpass", username, password);
#endif


#if defined USE_DARWIN
	/* Someone who knows what can be used .. niutil lines ? */
	printf("Darwin functions are defined in osx_functions, this is a bug\n");
	sprintf(user_pass, "echo passwd/username %s:%s", username, password);
#endif

    }
    else
      {

#if defined USE_LINUX
	sprintf(user_pass, "usermod -p '%s' %s", encrypted_pass, username);
#endif

#if defined USE_OPENSBD || USE_NETBSD || USE_FREEBSD || USE_AIX || USE_HPUX
	sprintf(user_pass, "pw usermod -p '%s' %s", encrypted_pass, username);
#endif

#if defined USE_DARWIN
	sprintf(user_pass, "echo manually change the password: passwd/username '%s' %s", encrypted_pass, username);
#endif

      }	


    /* Now have the correct password changing string, change it */

    if((fp=popen(user_pass,"w"))==NULL)
    {
        perror("popen");
	sprintf(info_buffer, _("Error changing password for user: %s\n"), username);
    	info_window=create_info_window();
    	gtk_widget_show(info_window);
    }
    else
      pclose(fp);

#if defined USE_DARWIN
    printf("Send me a mail describing what programs\n");
    printf("can be used to change the password for a user and how.\n");
    printf("Then ill fix it.\n");
#endif

    free(user_pass);
}


void
on_add_systemuser_yes_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    FILE *fp;
    char *username, *groupname, *user_add, *group_add;
    GtkWidget *add_systemuser_question_window;
    GtkWidget *info_window;
    gchar *utf8=NULL;
    add_systemuser_question_window = lookup_widget(GTK_WIDGET(button), "add_systemuser_question_window");
    username = allocate(4096);
    strcpy(username, NOBODY);

    if( ! user_exists(username) )
    {
	/* Make the NOBODY ftp-master system user then delete its directory GProftpdNoDir */
	user_add = allocate(8192);
	sprintf(user_add, "%s %s %s %s", ADDUSER, NOBODY, ADDPARAMS, BINFALSE);
	if((fp=popen(user_add,"w"))==NULL)
	{
	    sprintf(info_buffer, _("Cant add the master ftpuser with this command: %s\n"), user_add);
	    info_window = create_info_window();
	    gtk_widget_show(info_window);
	    free(user_add);
	    free(username);
	    if( utf8!=NULL )
    	      g_free(utf8);    
    	    return;
	}
	pclose(fp);

	if( strlen(MASTERDIR)>2 )
	{
	    sprintf(user_add, "rm -rf %s", MASTERDIR);			
	    system(user_add);
	}
	free(user_add);
	sprintf(info_buffer, _("The user: %s\nhas been added to your system with a /bin/false shell\nand put in ftpusers, no password was set.\n"), NOBODY);
	info_window = create_info_window();
	gtk_widget_show(info_window);
    }


    groupname = allocate(4096);
    strcpy(groupname, NOBODY);

    if( ! group_exists(groupname) )
    {
	/* Make the NOBODY ftp-master system group */
	group_add = allocate(8192);
	sprintf(group_add, "%s %s", ADDGROUP, NOBODY);
	if((fp=popen(group_add,"w"))==NULL)
	{
	    sprintf(info_buffer, _("Cant add the master ftp group with this command: %s\n"), group_add);
	    info_window = create_info_window();
	    gtk_widget_show(info_window);
	    free(group_add);
	    free(groupname);
	    free(username);
	    if( utf8!=NULL )
    	      g_free(utf8);    
    	    return;
	}
	pclose(fp);
	free(group_add);
	free(groupname);
	sprintf(info_buffer, _("The group: %s\nhas been added to your system.\n"), NOBODY);
	info_window = create_info_window();
	gtk_widget_show(info_window);
    }


    /* Ban the user if its not banned already */
    if( ! is_banned(username) )
    {
        if((fp=fopen(GP_FTPUSERS, "a"))==NULL)
        {
	    sprintf(info_buffer, "%s %s %s", _("Cant write to ftpusers here:\n"), GP_FTPUSERS, _("\nRun GProFTPD as root.\n"));
	    info_window = create_info_window();
    	    gtk_widget_show(info_window);
	    free(username);
	    if( utf8!=NULL )
    	      g_free(utf8);    
	    return;
	}
	fputs("\n", fp);
	fputs(NOBODY, fp);
	fputs("\n", fp);
	fclose(fp);	
    }

    free(username);

    if( utf8!=NULL )
      g_free(utf8);    
    gtk_widget_destroy(add_systemuser_question_window);
}


void
on_add_systemuser_question_window_map  (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget *add_systemuser_entry;
    gchar *utf8=NULL;
    char *username;
    add_systemuser_entry = lookup_widget(GTK_WIDGET(widget), "add_systemuser_entry");
    username = allocate(8192);
    sprintf(username, "%s", NOBODY);
    utf8 = g_locale_to_utf8(username, strlen(username), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(add_systemuser_entry), utf8);
    free(username);
    if( utf8!=NULL )
      g_free(utf8);    
}


int
xfer_update(GtkWidget *widget, gpointer user_data)
{
    /* Timed update for ftpwho, on/offline status and total xferrates */
    FILE *ftpwho, *configuration;
    GtkWidget *xfer_textview;
    GtkWidget *xfer_scrolledwindow;    
    GtkWidget *status_label;
    GtkTextBuffer *xfer_textbuffer;
    GtkWidget *total_xfer_entry;
    GtkWidget *total_incoming_entry;
    GtkWidget *total_outgoing_entry;
    GtkWidget *info_window;
    GtkTextMark *mark;
    gchar *mark_name=NULL;
    GtkTextIter xfer_iter;

    char *xfer_port_buffer, *bw_buf, *xfer_buffer, *get_buffer, *xlatez;

    struct sockaddr_in myaddr;
    int mastersd=0, reuse=0, port=0, port_found=0, incoming=0, outgoing=0;
    long size_port=0, in_val=0, out_val=0, inxfer=0, outxfer=0, totalxfer=0;
    gchar *utf8_text=NULL;
    xfer_textview = lookup_widget (GTK_WIDGET (widget), "xfer_textview");
    xfer_scrolledwindow = lookup_widget (GTK_WIDGET (widget), "xfer_scrolledwindow");
    status_label = lookup_widget (GTK_WIDGET (widget), "status_label");
    total_xfer_entry = lookup_widget (GTK_WIDGET (widget), "total_xfer_entry");
    total_incoming_entry = lookup_widget (GTK_WIDGET (widget), "total_incoming_entry");
    total_outgoing_entry = lookup_widget (GTK_WIDGET (widget), "total_outgoing_entry");

    /* On - offline checker */
    /* Get the first port thats not 0 and the server listens to */
    if((configuration=fopen(GP_CONF, "r"))==NULL)
    {
        utf8_text = g_locale_to_utf8("Configuration not found", 14, NULL, NULL, NULL);
        gtk_label_set_text(GTK_LABEL(status_label), utf8_text);
	online=0;
	return(TRUE);
    }
    else
	{
	    fseek(configuration, 0, SEEK_END);
	    size_port=ftell(configuration);
	    rewind(configuration);

	    xfer_port_buffer = allocate(size_port);
	    bw_buf = allocate(15);

	    while(fgets(xfer_port_buffer, size_port, configuration)!=NULL)
	    {   									
		if( strstr(xfer_port_buffer, "Port") && ! strstr(xfer_port_buffer, "Passive") && strlen(xfer_port_buffer) < 15 )
		{
		    sscanf(xfer_port_buffer, "%*s %s", bw_buf);
		    if( bw_buf[strlen(bw_buf)-1]=='\n' || bw_buf[strlen(bw_buf)-1]=='\r' )
		      bw_buf[strlen(bw_buf)-1]='\0';

		    if( is_digitz(bw_buf) && strlen(bw_buf) <= 6 && ! strstr(bw_buf, "#") )
		    {
			port=atoi(bw_buf);
			if( port > 0 )
			{ 
		    	    port_found=1;
			    break;
			}
		    }
		}
	    }
	    fclose(configuration);
	    free(xfer_port_buffer);
	    free(bw_buf);
	}

    if( port_found )
    {
	if((mastersd=socket(AF_INET, SOCK_STREAM, 0))==-1) 
        {
	    perror("socket");
	}
	else
	  if(setsockopt(mastersd, SOL_SOCKET, SO_REUSEADDR, &reuse, sizeof(int))==-1) 
	  {
	     perror("setsockopt");
	  }
	  else
	    {
		myaddr.sin_family = AF_INET;
		myaddr.sin_addr.s_addr = INADDR_ANY;
		myaddr.sin_port = htons(port);
		memset(&(myaddr.sin_zero), 0, sizeof(myaddr.sin_zero));

		xlatez = allocate(1024);

		if(bind(mastersd, (struct sockaddr *)&myaddr, sizeof(myaddr))==-1)
		{
		    sprintf(xlatez, _("Online"));
    		    utf8_text = g_locale_to_utf8(xlatez, strlen(xlatez), NULL, NULL, NULL);
    		    gtk_label_set_text(GTK_LABEL(status_label), utf8_text);
		    close(mastersd);
		    online=1;
		}
		else
		  {
		      sprintf(xlatez, _("Offline"));
		      utf8_text = g_locale_to_utf8(xlatez, strlen(xlatez), NULL, NULL, NULL);
		      gtk_label_set_text(GTK_LABEL(status_label), utf8_text);
		      close(mastersd);
		      online=0;
		  }
		free(xlatez);
	    }
    }

    get_buffer = allocate(MAX_READ_POPEN+1);
    
    if( online )
    {
	/* FTP who update and total xferrates */
	if((ftpwho=popen("ftpwho -v", "r"))==NULL)
	{
	    return(TRUE);
	}
	fflush(ftpwho);

	xfer_buffer = allocate(MAX_READ_POPEN+1);

	while(fgets(xfer_buffer, MAX_READ_POPEN, ftpwho)!=NULL)
	{	
    	    strcat(get_buffer, xfer_buffer);
	    /* Total Xferrates incoming/outgoing/total bandwidth usage */
	    /* Assumes that the ftpwho output shows stor retr appe and on the next line KB/s */
		
	    /* incoming */	
	    if( strstr(xfer_buffer, "KB/s: ") && incoming==1 && ! strstr(xfer_buffer, "inf") && ! strstr(xfer_buffer, "nan") )
	    {
		if( is_digitz(&xfer_buffer[7]) )
		  sscanf(xfer_buffer, "%*s %li", &in_val);
		if( in_val > 0 )
		{
		    inxfer=inxfer+in_val;
		    totalxfer=totalxfer+in_val;
		}
	    }
	    if( strstr(xfer_buffer, " STOR ") || strstr(xfer_buffer, " APPE ") )
	    {
		incoming++;
	    }
	    else
		incoming=0;
	
	    /* Outgoing */
	    if( strstr(xfer_buffer, "KB/s: ") && outgoing==1 && ! strstr(xfer_buffer, "inf") && ! strstr(xfer_buffer, "nan") )
	    {
		if( is_digitz(&xfer_buffer[7]) )
		  sscanf(xfer_buffer, "%*s %li", &out_val);
		if( out_val > 0 )
		{
		    outxfer=outxfer+out_val;
		    totalxfer=totalxfer+out_val;
		}
	    }
	    if( strstr(xfer_buffer, " RETR ") )
	    {
		outgoing++;
	    }
	    else
		outgoing=0;
	}
	free(xfer_buffer);
	pclose(ftpwho);


	bw_buf = allocate(1024);
    
	/* Total bandwidth usage */
	if( totalxfer >= 0 )
	{
	    sprintf(bw_buf, "%li %s", totalxfer, "KB/s");
	    utf8_text = g_locale_to_utf8(bw_buf, strlen(bw_buf), NULL, NULL, NULL);
    	    gtk_entry_set_text(GTK_ENTRY (total_xfer_entry), utf8_text);
	}

	/* Total incoming xfers */
	if( inxfer >= 0 )
	{    
	    sprintf(bw_buf, "%li %s", inxfer, "KB/s");
	    utf8_text = g_locale_to_utf8(bw_buf, strlen(bw_buf), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY (total_incoming_entry), utf8_text);
	}

	/* Total outgoing xfers */
	if( outxfer >= 0 )
	{
	    sprintf(bw_buf, "%li %s", outxfer, "KB/s");
	    utf8_text = g_locale_to_utf8(bw_buf, strlen(bw_buf), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY (total_outgoing_entry), utf8_text);
	}
	free(bw_buf);

	/* Tell the user if something else is running on this port */
	if( offline_pressed > 0 && online )
	{
	    offline_pressed++;
	    /* Wait about 3 seconds before we can be sure */
	    if( offline_pressed==3 )
	    {
		offline_pressed=0;
		strcpy(info_buffer, _("\nThe server could not be turned off.\n\n"));
		strcat(info_buffer, _("Do you have another server running on this port ?\n"));
		strcat(info_buffer, _("This could be a server running from inetd/xinetd.\n"));
    		info_window = create_info_window ();
    		gtk_widget_show (info_window);
	    }
	}
    }   /* if online */
    
    if( ! online )
    {
	strcpy(get_buffer, _("The server is offline.\n"));
    }
    
    /* Show ftp usage */    
    utf8_text = g_locale_to_utf8(get_buffer, strlen(get_buffer), NULL, NULL, NULL);

    free(get_buffer);

    xfer_textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(xfer_textview));
    gtk_text_buffer_set_text(xfer_textbuffer, utf8_text, strlen(utf8_text));
    /* Get the start iter from the buffer */
    gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(xfer_textbuffer), &xfer_iter);
    /* Create a mark at the start of the buffer specified by xfer_iter */
    mark = gtk_text_buffer_create_mark(GTK_TEXT_BUFFER(xfer_textbuffer), mark_name, &xfer_iter, FALSE);
    /* Move the mark on screen then scroll to it */
    gtk_text_view_move_mark_onscreen(GTK_TEXT_VIEW(xfer_textview), mark);
    gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(xfer_textview), mark, 0.4, TRUE, 0.0, 0.0);
    gtk_text_buffer_delete_mark(GTK_TEXT_BUFFER(xfer_textbuffer), mark);


    if( utf8_text!=NULL )
      g_free(utf8_text);
    return(TRUE);
}


void
list_server_values(GtkWidget *widget, gpointer user_data)
{
    /* Lists the values for the selected server in the server tab */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *global_server_name;
    GtkWidget *global_bind_tight_on_off;
    GtkWidget *global_server_admin_email;
    GtkWidget *global_server_port;
    GtkWidget *global_passive_ports_1_spinbutton;
    GtkWidget *global_passive_ports_2_spinbutton;
    GtkWidget *global_masquerade_entry;
    GtkWidget *global_masquerade_address_on_off;
    GtkWidget *global_max_connect;
    GtkWidget *global_idle_timeout;
    GtkWidget *global_resume_uploads;
    GtkWidget *global_resume_downloads;
    GtkWidget *global_download_bandwidth;
    GtkWidget *global_upload_bandwidth;
    GtkWidget *global_delete_aborted_stores;
    GtkWidget *global_allow_fxp;
    GtkWidget *global_show_server_identity;
    GtkWidget *global_show_server_identity_on_off;
    GtkWidget *global_reverse_lookups;
    GtkWidget *global_default_transfer_mode;
    GtkWidget *global_ident_lookups;
    GtkWidget *global_server_user;
    GtkWidget *global_server_group;
    GtkWidget *global_fake_user_entry;
    GtkWidget *global_fake_group_entry;
    GtkWidget *global_fake_user_combo;
    GtkWidget *global_fake_group_combo;
    GtkWidget *global_time_standard;
    GtkWidget *global_max_login_attempts;
    GtkWidget *global_timeout_login;
    GtkWidget *global_systemlog_entry;
    GtkWidget *global_rand_username;
    GtkWidget *global_rand_password;
    GtkWidget *global_rand_case;
    GtkWidget *global_useradd_root_path;
    GtkWidget *global_useradd_upload_path;
    GtkWidget *global_html_path;
    GtkWidget *global_welcome_path;
    GtkWidget *useradd_directory_entry;
    GtkWidget *useradd_incoming_directory_entry;
    GtkWidget *html_entry;
    GtkWidget *welcome_entry;
    GtkWidget *tls_use_combo_entry, *tls_use_encryption_combo_entry;
    GtkWidget *tls_verify_clients_combo_entry, *tls_protocols_entry;
    GtkWidget *tls_rsa_cert_entry, *tls_logfile_entry;
    GtkWidget *tls_ip_entry, *tls_email_entry, *tls_bits_spinbutton;
    GtkWidget *tls_password_entry, *tls_challenge_entry, *tls_valid_spinbutton;
    GtkWidget *tls_country_entry, *tls_state_entry, *tls_city_entry;
    GtkWidget *tls_org_entry, *tls_org_unit_entry;
    char *new_buffer, *old_buffer, *address_buffer, *port_buffer, *gprotls_conf, *translate;
    long size_buffer;
    gchar *utf8=NULL;
    int global_int=0, x=0, found=0;
    tls_use_combo_entry = lookup_widget (GTK_WIDGET (widget), "tls_use_combo_entry");
    tls_use_encryption_combo_entry = lookup_widget (GTK_WIDGET (widget), "tls_use_encryption_combo_entry");
    tls_verify_clients_combo_entry = lookup_widget (GTK_WIDGET (widget), "tls_verify_clients_combo_entry");
    tls_protocols_entry = lookup_widget (GTK_WIDGET (widget), "tls_protocols_entry");
    tls_rsa_cert_entry = lookup_widget (GTK_WIDGET (widget), "tls_rsa_cert_entry");
    tls_logfile_entry = lookup_widget (GTK_WIDGET (widget), "tls_logfile_entry");
    tls_ip_entry = lookup_widget (GTK_WIDGET (widget), "tls_ip_entry");
    tls_email_entry = lookup_widget (GTK_WIDGET (widget), "tls_email_entry");
    tls_bits_spinbutton = lookup_widget (GTK_WIDGET (widget), "tls_bits_spinbutton");
    tls_valid_spinbutton = lookup_widget (GTK_WIDGET (widget), "tls_valid_spinbutton");
    tls_password_entry = lookup_widget (GTK_WIDGET (widget), "tls_password_entry");
    tls_challenge_entry = lookup_widget (GTK_WIDGET (widget), "tls_challenge_entry");
    tls_country_entry = lookup_widget (GTK_WIDGET (widget), "tls_country_entry");
    tls_state_entry = lookup_widget (GTK_WIDGET (widget), "tls_state_entry");
    tls_city_entry = lookup_widget (GTK_WIDGET (widget), "tls_city_entry");
    tls_org_entry = lookup_widget (GTK_WIDGET (widget), "tls_org_entry");
    tls_org_unit_entry = lookup_widget (GTK_WIDGET (widget), "tls_org_unit_entry");
    global_server_name = lookup_widget (GTK_WIDGET (widget), "global_server_name");
    global_bind_tight_on_off = lookup_widget (GTK_WIDGET (widget), "global_bind_tight_on_off");
    global_server_admin_email = lookup_widget (GTK_WIDGET (widget), "global_server_admin_email");
    global_server_port = lookup_widget (GTK_WIDGET (widget), "global_server_port");
    global_passive_ports_1_spinbutton = lookup_widget (GTK_WIDGET (widget), "global_passive_ports_1_spinbutton");
    global_passive_ports_2_spinbutton = lookup_widget (GTK_WIDGET (widget), "global_passive_ports_2_spinbutton");
    global_masquerade_entry = lookup_widget (GTK_WIDGET (widget), "global_masquerade_entry");
    global_masquerade_address_on_off = lookup_widget (GTK_WIDGET (widget), "global_masquerade_address_on_off");
    global_max_connect = lookup_widget (GTK_WIDGET (widget), "global_max_connect");
    global_idle_timeout = lookup_widget (GTK_WIDGET (widget), "global_idle_timeout");
    global_resume_uploads = lookup_widget (GTK_WIDGET (widget), "global_resume_uploads");
    global_resume_downloads = lookup_widget (GTK_WIDGET (widget), "global_resume_downloads");
    global_download_bandwidth = lookup_widget (GTK_WIDGET (widget), "global_download_bandwidth");
    global_upload_bandwidth = lookup_widget (GTK_WIDGET (widget), "global_upload_bandwidth");
    global_show_server_identity = lookup_widget (GTK_WIDGET (widget), "global_show_server_identity");
    global_show_server_identity_on_off = lookup_widget (GTK_WIDGET (widget), "global_show_server_identity_on_off");
    global_reverse_lookups = lookup_widget (GTK_WIDGET (widget), "global_reverse_lookups");
    global_default_transfer_mode = lookup_widget (GTK_WIDGET (widget), "global_default_transfer_mode");
    global_ident_lookups = lookup_widget (GTK_WIDGET (widget), "global_ident_lookups");
    global_allow_fxp = lookup_widget (GTK_WIDGET (widget), "global_allow_fxp");
    global_server_user = lookup_widget (GTK_WIDGET (widget), "global_server_user");
    global_server_group = lookup_widget (GTK_WIDGET (widget), "global_server_group");
    global_fake_user_entry = lookup_widget (GTK_WIDGET (widget), "global_fake_user_entry");
    global_fake_user_combo = lookup_widget (GTK_WIDGET (widget), "global_fake_user_combo");
    global_fake_group_entry = lookup_widget (GTK_WIDGET (widget), "global_fake_group_entry");
    global_fake_group_combo = lookup_widget (GTK_WIDGET (widget), "global_fake_group_combo");
    global_time_standard = lookup_widget (GTK_WIDGET (widget), "global_time_standard");
    global_max_login_attempts = lookup_widget (GTK_WIDGET (widget), "global_max_login_attempts");
    global_timeout_login = lookup_widget (GTK_WIDGET (widget), "global_timeout_login");
    global_delete_aborted_stores = lookup_widget (GTK_WIDGET (widget), "global_delete_aborted_stores");
    global_systemlog_entry = lookup_widget (GTK_WIDGET (widget), "global_systemlog_entry");
    global_rand_username = lookup_widget (GTK_WIDGET (widget), "global_rand_username");
    global_rand_password = lookup_widget (GTK_WIDGET (widget), "global_rand_password");
    global_rand_case = lookup_widget (GTK_WIDGET (widget), "global_rand_case");
    global_useradd_root_path = lookup_widget (GTK_WIDGET (widget), "global_useradd_root_path");
    global_useradd_upload_path = lookup_widget (GTK_WIDGET (widget), "global_useradd_upload_path");
    global_html_path = lookup_widget (GTK_WIDGET (widget), "global_html_path");
    global_welcome_path = lookup_widget (GTK_WIDGET (widget), "global_welcome_path");
    useradd_directory_entry = lookup_widget(GTK_WIDGET(widget), "useradd_directory_entry");
    useradd_incoming_directory_entry = lookup_widget(GTK_WIDGET(widget), "useradd_incoming_directory_entry");
    html_entry = lookup_widget(GTK_WIDGET(widget), "html_entry");
    welcome_entry = lookup_widget(GTK_WIDGET(widget), "welcome_entry");


    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
	/* We just show this popup here too many windows looks bad */
	sprintf(info_buffer, "%s %s", _("List server: Cant open proftpd.conf here:\n"), GP_CONF);
        info_window = create_info_window ();
        gtk_widget_show (info_window);
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer);
    new_buffer = allocate(size_buffer);               
    address_buffer = allocate(8192+15);
    translate = allocate(1024);

    if( strstr(selected_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>", selected_server_address);
    }
    else
       sprintf(address_buffer, selected_server_address);
     
      port_buffer = allocate(8192+3);               

      sprintf(port_buffer, "Port %s", selected_server_port);

      if( ! strstr((char *)selected_server_type, "Virtualhost") )
        found=1;


    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {                                 
	if( strlen(old_buffer) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    	    info_window=create_info_window();
    	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(old_buffer);
	    free(new_buffer);
            free(address_buffer);
	    free(port_buffer);
	    free(translate);
	    return;
	}

	
	/* We have all the values for the selected default server */
	if( strstr(old_buffer, "<Anonymous") && strstr((char *)selected_server_type, "Default server") )
	  break;           


        /* We have a virtualhost with the same address as the selected server */
        if( strstr("Virtualhost", (char *)selected_server_type) && ! found
	&&  strstr(old_buffer, address_buffer) )
	{
	    /* Lets see if its the same port as the selected one */

	    /* If this server has the same port its the correct server .. the end. */
	    while(fgets(old_buffer, size_buffer, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		{
		    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    		    info_window=create_info_window();
    		    gtk_widget_show(info_window);
		    fclose(fp);
		    free(old_buffer);
		    free(new_buffer);
	    	    free(address_buffer);
		    free(port_buffer);
		    free(translate);
		    return;
		}
	    
		/* This will expect the servers port on the second line ! 
		 * else itll miss some vaules .. */
		if( strstr(old_buffer, "Port") && strstr(old_buffer, port_buffer) )
		{
		    found=1;
		    break;
		}
		
		if( strstr(old_buffer, "</Virtualhost>") )
		  break;
	    }    
	}

	

	/* Continue until we find the selected server */
	if( ! found )
	  continue;


	/* Read and insert the selected servers values in the servers tab */

	/* If its the default server we stop listing the values when a vhost or anonymous is found */
	if( ! strstr("Virtualhost", (char *)selected_server_type)
	&& ( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") ) )
	   break;

	/* In any case after listing the correct vhost and anon user we break */
	if( strstr(old_buffer, "<Anonymous") && found )
	   break;

	/* In any case after listing the correct vhost we break */
	if( strstr(old_buffer, "</VirtualHost") && found )
	   break;


   	if( strstr(old_buffer, "ServerName") )
	{   
	    for(x=0; old_buffer[x]!='\0'; x++)
	    {
	        if( old_buffer[x]=='"' )
		  break;
	    }
	    x++;
	    if( old_buffer[x]!='\0' )
	      sprintf(new_buffer, &old_buffer[x]);
	    for(x=0; new_buffer[x]!='\0'; x++)
	    {
	        if( new_buffer[x]=='"' )
	        {
		    new_buffer[x]='\0';
		    break;
		}
	    }
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY (global_server_name), utf8);
	}
   	if( strstr(old_buffer, "ServerAdmin") )
	{   
	    sprintf(new_buffer, &old_buffer[12]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY (global_server_admin_email), utf8);
	}
	if( strstr(old_buffer, "ServerIdent") )
	{
	    for(x=0; old_buffer[x]!='\0'; x++)
	    {
	        if( old_buffer[x]=='"' )
		  break;
	    }
	    x++;
	    if( old_buffer[x]!='\0' )
	      sprintf(new_buffer, &old_buffer[x]);
	    for(x=0; new_buffer[x]!='\0'; x++)
	    {
	        if( new_buffer[x]=='"' || new_buffer[x]=='\n' )
	        {
		    new_buffer[x]='\0';
		    break;
		}
	    }
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_entry_set_text(GTK_ENTRY(global_show_server_identity), utf8);

	    if( strstr(old_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(global_show_server_identity_on_off), utf8);
	}
	if( strstr(old_buffer, "MasqueradeAddress") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( strlen(new_buffer) > 3 )
	    {
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	          new_buffer[strlen(new_buffer)-1]='\0';
        	utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(global_masquerade_entry), utf8);
	    }
	    if( ! strstr(old_buffer, "#") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(global_masquerade_address_on_off), utf8);
	}
        if( strstr(old_buffer, "SocketBindTight") )
        {
	    if( strstr(old_buffer, "SocketBindTight on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(global_bind_tight_on_off), utf8);
	}
	
	/* Dont match passiveports */
  	if( strstr(old_buffer, "Port") && old_buffer[4]==' ' && ! strstr(old_buffer, "PassivePorts") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_server_port), global_int);
	    }
	}
  	if( strstr(old_buffer, "PassivePorts")  )
        {
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( is_digitz(new_buffer) )
	    {
               global_int=atoi(new_buffer);
               gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_passive_ports_1_spinbutton), global_int);
	    }

	    new_buffer[0]='\0';
    	    sscanf(old_buffer, "%*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( is_digitz(new_buffer))
	    {
               global_int=atoi(new_buffer);
               gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_passive_ports_2_spinbutton), global_int);
	    }
	}
	if( strstr(old_buffer, "MaxInstances") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_max_connect), global_int);
	    }
	}
	if( strstr(old_buffer, "TimeoutNoTransfer") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_idle_timeout), global_int);
	    }
	}
	if( strstr(old_buffer, "AllowStoreRestart") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( strstr(old_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_resume_uploads), utf8);
	}
	if( strstr(old_buffer, "AllowRetrieveRestart") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    if( strstr(old_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_resume_downloads), utf8);
	}
	if( strstr(old_buffer, "TransferRate RETR") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_download_bandwidth), global_int);
	    }
	}
	if( strstr(old_buffer, "TransferRate STOR") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_upload_bandwidth), global_int);
	    }
	}
        if( strstr(old_buffer, "UseReverseDNS") )
	{
	    if( strstr(old_buffer, "UseReverseDNS on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

            utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_reverse_lookups), utf8);    
	}
	
	if( strstr(old_buffer, "IdentLookups") )
	{
	    if( strstr(old_buffer, "IdentLookups on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

            utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
    	    gtk_entry_set_text(GTK_ENTRY(global_ident_lookups), utf8);
	}
	
	if( strstr(old_buffer, "DefaultTransferMode") )
	{
	    if( strstr(old_buffer, "binary") )
	      sprintf(translate, _("binary"));
	    else
	      sprintf(translate, _("ascii"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_default_transfer_mode), utf8);
	}
	if( strstr(old_buffer, "User") && old_buffer[4]==' ' )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_server_user), utf8);
	}
	if( strstr(old_buffer, "Group") && old_buffer[5]==' ' )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_server_group), utf8);
	}
	if( strstr(old_buffer, "DirFakeUser") )
	{
	    /* Show the fake username */
	    sscanf(old_buffer, "%*s %*s %s", new_buffer); 
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_fake_user_entry), utf8);

	    /* Show fake user on - off */
	    sscanf(old_buffer, "%*s %s", new_buffer); 
	    if( strstr(new_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

    	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_fake_user_combo), utf8);
	}
	if( strstr(old_buffer, "DirFakeGroup") )
	{
	    /* Show the fake groupname */
	    sscanf(old_buffer, "%*s %*s %s", new_buffer); 
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_fake_group_entry), utf8);

	    /* Show fake group on - off */
	    sscanf(old_buffer, "%*s %s", new_buffer); 
	    if( strstr(new_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

    	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_fake_group_combo), utf8);
	}
	if( strstr(old_buffer, "AllowForeignAddress") )
	{
	    if( strstr(old_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_allow_fxp), utf8);
	}
	if( strstr(old_buffer, "TimesGMT") )
	{
	    if( strstr(old_buffer, "on") )
	      sprintf(translate, _("GMT"));
	    else
	      sprintf(translate, _("local time"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_time_standard), utf8);
	}
	if( strstr(old_buffer, "MaxLoginAttempts") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_max_login_attempts), global_int);
	    }
	}
	if( strstr(old_buffer, "TimeoutLogin") )
	{
	    new_buffer[0]='\0';
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_timeout_login), global_int);
	    }
	}
	if( strstr(old_buffer, "DeleteAbortedStores") )
	{
	    if( strstr(old_buffer, "on") )
	      sprintf(translate, _("on"));
	    else
	      sprintf(translate, _("off"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text (GTK_ENTRY (global_delete_aborted_stores), utf8);
	}
	if( strstr(old_buffer, "SystemLog") )
	{
	    sprintf(new_buffer, &old_buffer[10]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(global_systemlog_entry), utf8);
	}
	if( strstr(old_buffer, "gp_random_username_length") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_rand_username), global_int);
		/* Also change the default value */
		global_username_randlen=global_int;
	    }
	}
	if( strstr(old_buffer, "gp_random_password_length") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( is_digitz(new_buffer) )
	    {
        	global_int=atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(global_rand_password), global_int);
		/* Also change the default value */
		global_password_randlen=global_int;
	    }
	}
	if( strstr(old_buffer, "gp_randomize_case") )
	{
	    if( strstr(old_buffer, "upper") )
	      sprintf(translate, _("upper"));
	    else
	      sprintf(translate, _("lower"));

	    utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(global_rand_case), utf8);
	}

	if( strstr(old_buffer, "gp_useradd_root_path") )
	{
	    sprintf(new_buffer, &old_buffer[22]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);

            gtk_entry_set_text(GTK_ENTRY(global_useradd_root_path), utf8);

	    /* Add the path to the useradd root directory box and remember the path */
	    sprintf(gp_useradd_root_path, "%s", new_buffer);
            gtk_entry_set_text(GTK_ENTRY(useradd_directory_entry), utf8);
	}

	if( strstr(old_buffer, "gp_useradd_upload_path") )
	{
	    sprintf(new_buffer, &old_buffer[24]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);

            gtk_entry_set_text(GTK_ENTRY(global_useradd_upload_path), utf8);

	    /* Add the path to the useradd upload directory box and remember the path */
	    sprintf(gp_useradd_upload_path, "%s", new_buffer);
            gtk_entry_set_text(GTK_ENTRY(useradd_incoming_directory_entry), utf8);
	}
	if( strstr(old_buffer, "gp_html_path") )
	{
	    sprintf(new_buffer, &old_buffer[14]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(global_html_path), utf8);
            gtk_entry_set_text(GTK_ENTRY(html_entry), utf8);
	}
	if( strstr(old_buffer, "gp_welcome_name") )
	{
	    sprintf(new_buffer, &old_buffer[17]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(global_welcome_path), utf8);
            gtk_entry_set_text(GTK_ENTRY(welcome_entry), utf8);
	}

	

	if( use_tls )
	{
	    if( strstr(old_buffer, "TLSEngine") )
	    {
		if( strstr(old_buffer, "on") )
	          sprintf(translate, _("on"));
		else
	          sprintf(translate, _("off"));

		utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
        	gtk_entry_set_text(GTK_ENTRY(tls_use_combo_entry), utf8);
	    }
	    if( strstr(old_buffer, "TLSRequired") )
	    {
		if( strstr(old_buffer, "on") )
	          sprintf(translate, _("both"));
		if( strstr(old_buffer, "off") )
	          sprintf(translate, _("off"));
		if( strstr(old_buffer, "data") )
	          sprintf(translate, _("data"));
		if( strstr(old_buffer, "ctrl") )
	          sprintf(translate, _("control"));

		utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
        	gtk_entry_set_text (GTK_ENTRY (tls_use_encryption_combo_entry), utf8);
	    }
	    if( strstr(old_buffer, "TLSVerifyClient") )
	    {
		if( strstr(old_buffer, "on") )
	          sprintf(translate, _("on"));
		else
	          sprintf(translate, _("off"));

		utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
        	gtk_entry_set_text (GTK_ENTRY (tls_verify_clients_combo_entry), utf8);
	    }
	    if( strstr(old_buffer, "TLSProtocol") )
	    {
		sprintf(new_buffer, "%s", &old_buffer[12]);
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	    	  new_buffer[strlen(new_buffer)-1]='\0';
		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	gtk_entry_set_text (GTK_ENTRY (tls_protocols_entry), utf8);
	    }
	    if( strstr(old_buffer, "TLSLog") )
	    {
		sprintf(new_buffer, &old_buffer[7]); 
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	    	  new_buffer[strlen(new_buffer)-1]='\0';
		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	gtk_entry_set_text (GTK_ENTRY (tls_logfile_entry), utf8);
	    }
	    if( strstr(old_buffer, "TLSRSACertificateFile") )
	    {
		sprintf(new_buffer, &old_buffer[22]); 
		if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	    	  new_buffer[strlen(new_buffer)-1]='\0';
		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	gtk_entry_set_text (GTK_ENTRY (tls_rsa_cert_entry), utf8);
	    }
	}
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    free(address_buffer);
    free(port_buffer);


    /* If we have the TLS module then list the values for it. */
    if( use_tls )
    {
	/* If we have a gprotls.conf then list the certificate values */
	gprotls_conf = allocate(strlen(GP_APPCONFDIR)+14);
	sprintf(gprotls_conf, "%s%s", GP_APPCONFDIR, "/gprotls.conf");
	if((fp=fopen(gprotls_conf, "r"))==NULL)
	{
	}
	else
	    {
	        fseek(fp, 0, SEEK_END);
	        size_buffer = ftell(fp);
	        rewind(fp);
	        old_buffer = allocate(size_buffer);
	        new_buffer = allocate(size_buffer);
	        while(fgets((char *)old_buffer, size_buffer, fp)!=NULL)
	        {
		    if( strstr(old_buffer, "default_bits") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
    			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
        			global_int = atoi(new_buffer);
        			gtk_spin_button_set_value(GTK_SPIN_BUTTON(tls_bits_spinbutton), global_int);
			    }
			}
        	    }
    		    if( strstr(old_buffer, "default_days") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
        			global_int = atoi(new_buffer);
        			gtk_spin_button_set_value(GTK_SPIN_BUTTON(tls_valid_spinbutton), global_int);
			    }
			}
        	    }
		    if( strstr(old_buffer, "C ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_country_entry), utf8);
			    }
			}
		    }
		    if( strstr(old_buffer, "ST ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_state_entry), utf8);
			    }
			}
		    }
		    if( strstr(old_buffer, "L ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_city_entry), utf8);
			    }
			}
		    }
		    if( strstr(old_buffer, "O ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_org_entry), utf8);
			    }
			}
		    }
		    if( strstr(old_buffer, "OU ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_org_unit_entry), utf8);
			    }
			}
		    }
		    if( strstr(old_buffer, "CN ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_ip_entry), utf8);
			    }
			}
		    }
		    if( strstr(old_buffer, "emailAddress ") )
		    {
			for(x=0; old_buffer[x]; x++)
			{
			    if( old_buffer[x-2]=='=' )
			    {
				snprintf(new_buffer, old_buffer[x]+x, old_buffer+x);
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
				gtk_entry_set_text (GTK_ENTRY (tls_email_entry), utf8);
			    }
			}
		    }
		}
		free(gprotls_conf);
		free(new_buffer);
		free(old_buffer);
		fclose(fp);
	    }
    }

    free(translate);

    if( utf8!=NULL )
    g_free(utf8);
}


void on_servers_treeview_row_clicked(GtkTreeView *treeview, 
				     GdkEventButton *event,
				     gpointer data)
{
    gchar *server_address;
    gchar *server_port;
    gchar *server_type;
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeModel *list_store;
    GtkTreeSelection *selection;

    /* The left button is pressed */
    if( ! event->type == GDK_BUTTON_PRESS || ! event->button == 1 )
      return;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));

    if( gtk_tree_selection_count_selected_rows(selection) <= 1 )
    {
	/* Get the treepath for the row that was clicked */
         if( gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(treeview), event->x, event->y,
				                                    &path, NULL, NULL, NULL))
         {
            gtk_tree_selection_unselect_all(selection);
    	    gtk_tree_selection_select_path(selection, path);

	    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
	    gtk_tree_model_get_iter(list_store, &iter, path);

	    gtk_tree_model_get(list_store, &iter, 0, &server_address, -1);
	    gtk_tree_model_get(list_store, &iter, 1, &server_port, -1);
	    gtk_tree_model_get(list_store, &iter, 3, &server_type, -1);

	    if( strlen(server_address) > 8000 )
	    {
		printf("Server address exceeds 8000 chars, aborting selection\n");
		return;
	    }
	    if( strlen(server_port) > 8000 )
	    {
		printf("Server port exceeds 8000 chars, aborting selection\n");
		return;
	    }
	    if( strlen(server_address)==0 )
	    {
		printf("Server address is 0 chars, aborting selection\n");
		return;
	    }
	    if( strlen(server_port)==0 )
	    {
		printf("Server port length is 0, aborting selection\n");
		return;
	    }
	    if( strlen(server_type)==0 )
	    {
		printf("Server type length is 0, aborting selection\n");
		return;
	    }
	    strcpy(selected_server_address, server_address);
	    strcpy(selected_server_port, server_port);
	    strcpy(selected_server_type, server_type);

	    list_users(userlist_treeview, NULL);
	    list_server_values(userlist_treeview, NULL);

	    g_free(server_address);
	    g_free(server_port);
	    g_free(server_type);
            gtk_tree_path_free(path);
	}
    }
}


void
list_entire  (GtkWidget       *widget,
              gpointer         user_data)
{
    /* Entire configuration text */
    FILE *fp;
    GtkTextBuffer *entire_text_buffer;
    GtkWidget *entire_textview;
    GtkWidget *info_window;
    gchar *utf8=NULL;
    long size_buffer;
    char *buffer, *get_buffer;
    entire_textview = lookup_widget (GTK_WIDGET (widget), "entire_textview");
    
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
	/* No popup, we dont need to show this several times */
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);
    buffer = allocate(size_buffer);
    get_buffer = allocate(size_buffer+1024);
    while(fgets(buffer, size_buffer, fp)!=NULL)
    {
	if( strlen(buffer) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    	    info_window=create_info_window();
    	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(buffer);
	    free(get_buffer);
	    return;
	}

	strcat(get_buffer, buffer);
    }
    utf8 = g_locale_to_utf8(get_buffer, strlen(get_buffer), NULL, NULL, NULL);
    entire_text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(entire_textview));
    gtk_text_buffer_set_text(entire_text_buffer, utf8, strlen(utf8));
    fclose(fp);
    if(utf8 !=NULL)
    g_free(utf8);
    free(buffer);
    free(get_buffer);
}


int
is_banned(char *user)
{
    /* Is this user banned */
    FILE *fp;
    char *old_buffer, *user_buffer;
    int ret=0, i=0;
    long size_buffer;
    if((fp=fopen(GP_FTPUSERS, "r"))==NULL)
    {
	/* if there is no xferlog the user isnt banned */
        return 0;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer=ftell(fp);
    rewind(fp);
    user_buffer = allocate(8192);
    old_buffer = allocate(size_buffer);
    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strstr(old_buffer, user) )
	{
	    sscanf(old_buffer, "%s", user_buffer);
	    for(i=0; user_buffer[i]!='\0'; i++)
	    {
		if( user_buffer[i]=='\n' || user_buffer[i]=='\r' )
		  user_buffer[i]='\0';
	    }
	    if( ! strcmp(user_buffer, user) )
	    {
		ret=1;
		break;
	    }
	}
    }
    free(old_buffer);
    free(user_buffer);
    fclose(fp);
    return ret;
}


void
list_users(GtkWidget *widget, gpointer user_data)
{
    FILE *fp;
    GtkListStore *model;
    GtkCellRenderer *cell;
    GtkTreeIter iter;
    GtkTreePath *path;
    char *old_buffer, *new_buffer, *address_buffer, *port_buffer, *translate;
    long size_buffer;
    gboolean edit=0;
    int found=0, found_server=0;
    gchar *utf8=NULL;
    GtkTreeViewColumn *user_column, *group_column, *maxclients_column, *require_column, *banned_column, *maximum_column;
    userlist_treeview = lookup_widget (GTK_WIDGET (widget), "userlist_treeview");
    model = gtk_list_store_new(6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_MODEL (model));
    cell = gtk_cell_renderer_text_new();
    user_column = gtk_tree_view_column_new_with_attributes(_("User"), cell, "text", 0, NULL);
    group_column = gtk_tree_view_column_new_with_attributes(_("Group"), cell, "text", 1, NULL);
    maxclients_column = gtk_tree_view_column_new_with_attributes(_("Root directory"), cell, "text", 2, NULL);
    require_column = gtk_tree_view_column_new_with_attributes(_("Require password"), cell, "text", 3, NULL);
    banned_column = gtk_tree_view_column_new_with_attributes(_("Banned"), cell, "text", 4, NULL);
    maximum_column = gtk_tree_view_column_new_with_attributes(_("Maximum connections"), cell, "text", 5, NULL);
    gtk_list_store_clear(model);

    /* Populate the userlist */
    if((fp = fopen(GP_CONF, "r"))==NULL)
    {
	/* Dont show a popup */
	printf("Error opening: [%s] for listing users\n", GP_CONF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer);

    new_buffer = allocate(size_buffer+8192);

    address_buffer = allocate(8192+15);

    port_buffer = allocate(8192+3);               

    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>\n", selected_server_address);
    }
    else
       sprintf(address_buffer, selected_server_address);

    sprintf(port_buffer, "Port %s\n", selected_server_port);


    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
	while(fgets(old_buffer, size_buffer, fp)!=NULL)
	{
	    /* If its the correct address */
	    if( ! strcmp(old_buffer, address_buffer) )
	    {
	       while(fgets(old_buffer, size_buffer, fp)!=NULL)
	       {
		  /* List only one Vhost */
		  if( strstr(old_buffer, "</VirtualHost>") )
		    break;
		 
		  if( ! strcmp(old_buffer, port_buffer) )
		  {
		     found_server=1;

		     /* Scroll past some stuff to </Limit */
		     while(fgets(old_buffer, size_buffer, fp)!=NULL)
		     {
		       if( strstr(old_buffer, "</Limit") )
		         break;
		     }
		     
		     if( found_server )
		       break;
	          }
	       }
	    }

	    if( found_server )
	      break;
	}
    }


    /* We have found the correct server, list the users in this server */
    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	/* break if the selected server is a vhost and the next vhost is found */
	if( strstr((char *)selected_server_type, "Virtualhost") && strstr(old_buffer, "</VirtualHost") )
	  break;
	
	/* break if the selected server is the default server and a vhost is found */
	if( ! strstr((char *)selected_server_type, "Virtualhost") && strstr(old_buffer, "<VirtualHost") )
	  break;

	if( strstr(old_buffer, "<Anonymous ") )
	{
	    sscanf(old_buffer, "%*s %s", new_buffer);
	    new_buffer[strlen(new_buffer)-1]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_append(GTK_LIST_STORE(model), &iter);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
    	    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    	    {
    		if( strstr(old_buffer, "User ") && ! strstr(old_buffer, "DirFakeUser") )
    		{
		    sscanf(old_buffer, "%*s %s", new_buffer);
    		    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, utf8, -1);

		    translate = allocate(4096);

		    if( is_banned(new_buffer) )
		    {
			sprintf(translate, _("yes"));
    	    		utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
    	    		gtk_list_store_set(GTK_LIST_STORE(model), &iter, 4, utf8, -1);
		    }
		    else
	              {
			 sprintf(translate, _("no"));
    		         utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
    		         gtk_list_store_set(GTK_LIST_STORE(model), &iter, 4, utf8, -1);
	              }	
		    free(translate);

		}
    		if( strstr(old_buffer, "Group ") && ! strstr(old_buffer, "DirFakeGroup") )
    		{   
		    sscanf(old_buffer, "%*s %s", new_buffer);
    		    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 1, utf8, -1);
    		}
    		if( strstr(old_buffer, "AnonRequirePassword ") )
    		{   
		    sscanf(old_buffer, "%*s %s", new_buffer);

		    translate = allocate(4096);

		    if( strstr(new_buffer, "on") )
		    {

			sprintf(translate, _("yes"));
    	    		utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
    			gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);
		    }
		    else
	              {
			 sprintf(translate, _("no"));
    		         utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
    		         gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);
	    	      }
		    free(translate);
    		}
    		if( strstr(old_buffer, "MaxClients ") )
    		{   
		    sscanf(old_buffer, "%*s %s", new_buffer);
    		    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 5, utf8, -1);
        	}

	        if( strstr(old_buffer, "</Anonymous>") )
	          break;
    	    }
	} 
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    free(address_buffer);
    free(port_buffer);


    if( utf8 !=NULL )
      g_free(utf8);

    /* Unref the model */
    g_object_unref(model);

    /* Cant set treepath if there arent any users/rows, then itll crash */
    if( ! found )
      return;

    path=gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(userlist_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}


void
list_servers(GtkWidget *widget, gpointer user_data)
{
    /* Lists all the servers in the serverlist */
    FILE *fp;
    GtkWidget *servers_treeview;
    GtkWidget *info_window;
    GtkListStore *model;
    GtkCellRenderer *cell;
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeViewColumn *servers_ip_column, *servers_port_column, *servers_name_column, *servers_type_column;
    char *old_buffer, *new_buffer;
    long size_buffer;
    gboolean edit=0;
    int found=0, one_popup=0;
    gchar *utf8=NULL;
    servers_treeview = lookup_widget(GTK_WIDGET(widget), "servers_treeview");
    model = gtk_list_store_new(4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(servers_treeview), GTK_TREE_MODEL(model));
    cell = gtk_cell_renderer_text_new();
    /* username direction filename Bytes start host */
    servers_ip_column = gtk_tree_view_column_new_with_attributes(_("Address"), cell, "text", 0, NULL);
    servers_port_column = gtk_tree_view_column_new_with_attributes(_("Port"), cell, "text", 1, NULL);
    servers_name_column = gtk_tree_view_column_new_with_attributes(_("Name"), cell, "text", 2, NULL);
    servers_type_column = gtk_tree_view_column_new_with_attributes(_("Type"), cell, "text", 3, NULL);
    gtk_list_store_clear(model);


    /* Populate the serverlist */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
	/* Dont show annoying popup */
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer=ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer);

    new_buffer = allocate(size_buffer);

    /* Insert an address of "All interfaces" for the default server.
     * This will be shown if nothing else that specifies a specific address is found for this server.
     */

    /* Add a row */
    gtk_list_store_append(GTK_LIST_STORE(model), &iter);

    /* If no bindaddress is found itll use this server description */
    utf8 = g_locale_to_utf8("All interfaces", 14, NULL, NULL, NULL);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, utf8, -1);



    /* List the default server first */

    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strstr(old_buffer, "<VirtualHost ") || strstr(old_buffer, "<Anonymous "))
	  break;
	
	new_buffer[0]='\0';

	/* Handle buffer overruns */
	if( strlen(old_buffer) > 8000 )
	{
	    if( ! one_popup )
	    {
		sprintf(info_buffer, _("An entry in: %s\n is too long, please correct it.\n"), GP_CONF);
    		info_window=create_info_window();
    		gtk_widget_show(info_window);
		one_popup=1;
	    }
	    continue;
	}


	/* SocketBindTight on or off will offline the default server */
	/* The default server binds to a specific address, show this address */
	if( strstr(old_buffer, "Bind ") && ! strstr(old_buffer, "SocketBindTight ") )
	{
	    sprintf(new_buffer, "%s", &old_buffer[6]);
	    new_buffer[strlen(new_buffer)-2]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, utf8, -1);
	}
	
	if( strstr(old_buffer, "Port ") && ! strstr(old_buffer, "PassivePorts ") && ! strstr(old_buffer, "standard") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[5]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    
	    /* Add the port to the global variable selected_server_port */
	    strcpy(selected_server_port, new_buffer);
	    
	    /* Insert the port */
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 1, utf8, -1);
	    
	    /* Insert the type */
    	    utf8 = g_locale_to_utf8("Default server", 14, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);
	}
	if( strstr(old_buffer, "ServerName ") || strstr(old_buffer, "ServerIdent on ") )
	{
    	    utf8 = g_locale_to_utf8("Default server", 14, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);

    	    if( strstr(old_buffer, "ServerIdent on ") )
	    {
		sprintf(new_buffer, "%s", &old_buffer[16]);
		new_buffer[strlen(new_buffer)-2]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
	    }
	    if( strstr(old_buffer, "ServerName ") )
	    {
		sprintf(new_buffer, "%s", &old_buffer[12]);
		new_buffer[strlen(new_buffer)-2]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
	    }
	}
    }		    
    /* End of listing the default server */


    /* List the VirtualHosts */
    found=0;
    rewind(fp);
    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strstr(old_buffer, "<VirtualHost ") )
	{
	    /* Add a row */
    	    gtk_list_store_append(GTK_LIST_STORE(model), &iter);

	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[13]);
	    new_buffer[strlen(new_buffer)-2]='\0';

    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, utf8, -1);

    	    utf8 = g_locale_to_utf8("Virtualhost", 11, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);
	    found=1;
	}    

	if( ! found )
	  continue;

	if( strstr(old_buffer, "Port ") && ! strstr(old_buffer, "PassivePorts ") && ! strstr(old_buffer, "standard ") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[5]);
	    new_buffer[strlen(new_buffer)-1]='\0';

    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 1, utf8, -1);
	}    

	if( strstr(old_buffer, "ServerName ") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[12]);
	    new_buffer[strlen(new_buffer)-2]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
	}    

	if( strstr(old_buffer, "ServerIdent on ") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[16]);
	    new_buffer[strlen(new_buffer)-2]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
	}    
	/* We cannot have Bind here since the servername is detected 
	   by <VirtualHost Address> and there is no need to since itll
	   set Bind to the servername's "address" anyhow if Bind is used.
	 */
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    if( utf8 !=NULL )
      g_free(utf8);

    /* Unref the model */
    g_object_unref(model);

    /* Cant set treepath if there arent any servers/rows, then itll crash */
    if( ! found )
      return;

    path=gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(servers_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}


void
list_disc(GtkWidget *widget, gpointer user_data)
{
    /* Update the disc tab */
    FILE *fp;
    GtkWidget *disc_treeview;
    GtkListStore *model;
    GtkTreeIter iter;
    GtkCellRenderer *cell;
    GtkTreeViewColumn *mount_column, *free_column, *used_column, *total_column, *percent_column, *device_column;
    gchar *utf8=NULL;
    char buf[MAX_READ_POPEN]="";
    char mount[8192]="", free[1024]="", used[1024]="", total[1024]="", percent[1024]="", device[8192]="";
    disc_treeview = lookup_widget (GTK_WIDGET (widget), "disc_treeview");
    model = gtk_list_store_new(6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(disc_treeview), GTK_TREE_MODEL (model));
    cell = gtk_cell_renderer_text_new();
    gtk_list_store_clear(model);
    mount_column = gtk_tree_view_column_new_with_attributes(_("Mounted on"), cell, "text", 0, NULL);
    free_column = gtk_tree_view_column_new_with_attributes(_("Free space"), cell, "text", 1, NULL);
    used_column = gtk_tree_view_column_new_with_attributes(_("Used space"), cell, "text", 2, NULL);
    total_column = gtk_tree_view_column_new_with_attributes(_("Total space"), cell, "text", 3, NULL);
    percent_column = gtk_tree_view_column_new_with_attributes(_("Percent used"), cell, "text", 4, NULL);
    device_column = gtk_tree_view_column_new_with_attributes(_("Device"), cell, "text", 5, NULL);

    if((fp=popen(DISC_USAGE, "r"))==NULL)
    {
        printf("\nError running %s\n", DISC_USAGE);
        return;
    }
    fflush(fp);

    while(fgets(buf, MAX_READ_POPEN, fp)!=NULL)
    {
        sscanf(buf, "%s %s %s %s %s %s", device, total, used, free, percent, mount);
        gtk_list_store_append(GTK_LIST_STORE(model), &iter);
        utf8 = g_locale_to_utf8(mount, strlen(mount), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, utf8, -1);
        utf8 = g_locale_to_utf8(free, strlen(free), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(model), &iter, 1, utf8, -1);
        utf8 = g_locale_to_utf8(used, strlen(used), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
        utf8 = g_locale_to_utf8(total, strlen(total), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);
        utf8 = g_locale_to_utf8(percent, strlen(percent), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(model), &iter, 4, utf8, -1);
        utf8 = g_locale_to_utf8(device, strlen(device), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(model), &iter, 5, utf8, -1);
    }
    pclose(fp);
   
    /* Unref the model */
    g_object_unref(model);
   
    if(utf8 !=NULL)
    g_free(utf8);
}


void
list_secure(GtkWidget *widget, gpointer user_data)
{
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *security_successful_textview;
    GtkWidget *security_refused_textview;
    long sizebuffer;
    char *s_buf;
    char *get_s_buf;
    gchar *utf8=NULL;
    GtkTextBuffer *security_text_buffer;

    if((fp=fopen(GP_SECURE, "r"))==NULL) 
    {
        sprintf(info_buffer, "%s %s", _("Cant open the securitylog here:\n"), GP_SECURE);
	info_window = create_info_window();
	gtk_widget_show(info_window);
        return;
    }
    security_successful_textview = lookup_widget (GTK_WIDGET (widget), "security_successful_textview");
    security_refused_textview = lookup_widget (GTK_WIDGET (widget), "security_refused_textview");
    fseek(fp, 0, SEEK_END);
    sizebuffer = ftell(fp);
    rewind(fp);

    s_buf = allocate(sizebuffer);

    get_s_buf = allocate(sizebuffer+1024);

    while(fgets(s_buf, sizebuffer, fp)!=NULL)
    {
	if( strlen(s_buf) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_SECURE);
    	    info_window=create_info_window();
    	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(s_buf);
	    free(get_s_buf);
	    if( utf8!=NULL)
	      g_free(utf8);
	    return;
	}

        if( strstr(s_buf, "Login successful") )
        {
           strcat(get_s_buf, s_buf);
        }
    }
    security_text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(security_successful_textview));
    utf8 = g_locale_to_utf8(get_s_buf, strlen(get_s_buf), NULL, NULL, NULL);
    gtk_text_buffer_set_text(security_text_buffer, utf8, strlen(utf8));
    fclose(fp);

    if((fp=fopen(GP_SECURE, "r"))==NULL) 
    {
        /* No need to notify, done at startup */
	free(s_buf);
	free(get_s_buf);
        if( utf8!=NULL)
          g_free(utf8);
        return;
    }

    /* Its still the same size */
    memset(s_buf, 0, sizebuffer);   
    memset(get_s_buf, 0, sizebuffer+1024);   

    while(fgets(s_buf, sizebuffer, fp)!=NULL)
    {
	if( ! strstr(s_buf, "proftpd") )
	  continue;

	if( strlen(s_buf) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_SECURE);
    	    info_window=create_info_window();
    	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(s_buf);
	    free(get_s_buf);
	    if( utf8!=NULL)
	      g_free(utf8);
	    return;
	}
        if( strstr(s_buf, "Login failed") )
        {
            strcat(get_s_buf, s_buf);
        }
        if( strstr(s_buf, "refused") )
        {
            strcat(get_s_buf, s_buf);
        }
        if( strstr(s_buf, "no such user") )
        {
            strcat(get_s_buf, s_buf);
        }
        if( strstr(s_buf, "Maximum login attempts") )
        {
            strcat(get_s_buf, s_buf);
        }

        if( strstr(s_buf, "SECURITY VIOLATION") )
        {
            strcat(get_s_buf, s_buf);
        }
    }
    security_text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(security_refused_textview));
    utf8 = g_locale_to_utf8(get_s_buf, strlen(get_s_buf), NULL, NULL, NULL);
    gtk_text_buffer_set_text(security_text_buffer, utf8, strlen(utf8));
    fclose(fp);
    if(utf8!=NULL)
      g_free(utf8);
    free(s_buf);
    free(get_s_buf);
}


void
list_files(GtkWidget *widget, gpointer user_data)
{
    FILE *fp;
    GtkWidget *files_treeview;
    GtkWidget *info_window;
    GtkListStore *model;
    GtkCellRenderer *cell;
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeViewColumn *files_username_column, *files_action_column, *files_name_column, *files_size_column;
    GtkTreeViewColumn *files_start_column, *files_host_column;
    char *old_buffer, *new_buffer;
    long size_buffer;
    gboolean edit=0;
    int begin=0, end=0, i=0, count=0, found=0, one_popup=0; 
    int max_line_len=1024, max_username_len=40;
    gchar *utf8=NULL;
    files_treeview = lookup_widget(GTK_WIDGET(widget), "files_treeview");
    model = gtk_list_store_new(6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(files_treeview), GTK_TREE_MODEL (model));
    cell = gtk_cell_renderer_text_new();
    /* username direction filename Bytes start host */
    files_username_column = gtk_tree_view_column_new_with_attributes(_("Username"), cell, "text", 0, NULL);
    files_action_column = gtk_tree_view_column_new_with_attributes(_("Action"), cell, "text", 1, NULL);
    files_name_column = gtk_tree_view_column_new_with_attributes(_("Filename"), cell, "text", 2, NULL);
    files_size_column = gtk_tree_view_column_new_with_attributes(_("Bytes"), cell, "text", 3, NULL);
    files_start_column = gtk_tree_view_column_new_with_attributes(_("Start of transfer"), cell, "text", 4, NULL);
    files_host_column = gtk_tree_view_column_new_with_attributes(_("Remote host"), cell, "text", 5, NULL);
    gtk_list_store_clear(model);

    /* Populate the filelist */
    if((fp=fopen(GP_XFERLOG, "r"))==NULL)
    {
	/* Dont show another annoying popup */
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer=ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer);

    /* Min allocate + 1024 */
    new_buffer = allocate(max_line_len+1024);

    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strlen(old_buffer) < 10 )
	  continue;

	/* Add a row */
    	gtk_list_store_append(GTK_LIST_STORE(model), &iter);


	/* So the user doesnt wonder why its slow if alot of files with very long names are uploaded */
	if( !one_popup && strlen(old_buffer) > max_line_len )
	{
	   sprintf(info_buffer, _("An entry in: %s\n is too long and has been shortened.\n"), GP_XFERLOG);
	   strcat(info_buffer, _("Alot of these extremely long filnames will decrease startup speed.\n"));
    	   info_window=create_info_window();
    	   gtk_widget_show(info_window);
	   one_popup=1;
	}


/* ------------- FILES ------------ */
	/* If we find a / then heres where the filepath begins 8 spaces from the start */
	for(i=0; old_buffer[i]!='\0'; i++)
	{
	    if( old_buffer[i]=='/' )
	    {
	        begin=i;
	        break;
	    }
	}
        /* The file end is 9 spaces from the end */
        count=0;
        for(i=strlen(old_buffer)-1; old_buffer[i]!='\0'; i--)
        {
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	      count++;
	    
	    if( count==9 )
	    {
	        end=i;
	        break;
	    }
	}	

	memset(new_buffer, 0, max_line_len+1024);
	
	if( end-begin > max_line_len )
	{
	    while( end-begin > max_line_len )
	      end--;
	    strncat(new_buffer, &old_buffer[begin], end);
	}
	else
	  strncat(new_buffer, &old_buffer[begin], end);

	if( new_buffer[strlen(new_buffer)-1]!='\0' )
	  new_buffer[strlen(new_buffer)-1]='\0';

    	utf8 = g_locale_to_utf8(new_buffer, end-begin, NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(model), &iter, 2, utf8, -1);
/* ------------- FILES END ------------ */



/* ------------- Start Date ----------- */
	count=0;
	for(i=0; old_buffer[i]!='\0'; i++)
	{
			   /* Day can be " 2" or "20" etc */
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	    {
	        count++;
	        end=i;
	    }
	    if( count==5 )
	      break;
	}
	
	if( end <= max_line_len )
	{
    	    utf8 = g_locale_to_utf8(old_buffer, end, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 4, utf8, -1);
	}
/* ------------- Start Date End ----------- */



/* ------------- Host ----------- */
	count=0;
	for(i=0; old_buffer[i]!='\0'; i++)
	{
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	    {
	        count++;
	        begin=i;
	    }
	    if( count==6 )
	      break;
	}

	count=0;
	for(i=begin+1; old_buffer[i]!='\0'; i++)
	{
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	    {
	        end=i;
		break;
	    }
	}
	
	memset(new_buffer, 0, max_line_len+1024);

	if( end-begin > max_line_len )
	{
	    while( end-begin > max_line_len )
	      end--;
	    strncat(new_buffer, &old_buffer[begin], end);
	}
	else
	  strncat(new_buffer, &old_buffer[begin], end);

	if( new_buffer[strlen(new_buffer)-1]!='\0' )
	  new_buffer[strlen(new_buffer)-1]='\0';

    	utf8 = g_locale_to_utf8(new_buffer, end-begin, NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(model), &iter, 5, utf8, -1);
/* ------------- Host End ----------- */



/* ------------- Bytes ----------- */
	count=0;
	for(i=0; old_buffer[i]!='\0'; i++)
	{
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	    {
	        count++;
	        begin=i;
	    }
	    if( count==7 )
	      break;
	}

	count=0;
	for(i=begin+1; old_buffer[i]!='\0'; i++)
	{
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	    {
	        end=i;
		break;
	    }
	}

	memset(new_buffer, 0, max_line_len+1024);

	if( end-begin > max_line_len )
	{
	    while( end-begin > max_line_len )
	      end--;
	    strncat(new_buffer, &old_buffer[begin], end);
	}
	else
	  strncat(new_buffer, &old_buffer[begin], end);

	if( new_buffer[strlen(new_buffer)-1]!='\0' )
	  new_buffer[strlen(new_buffer)-1]='\0';

	utf8 = g_locale_to_utf8(new_buffer, end-begin, NULL, NULL, NULL);
	gtk_list_store_set(GTK_LIST_STORE(model), &iter, 3, utf8, -1);
/* ------------- Bytes End ----------- */



/* ------------- Username ----------- */
        count=0; begin=0; end=0;
        for(i=strlen(old_buffer)-1; old_buffer[i]!='\0'; i--)
        {
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	      count++;
	    
	    if( count==5 )
	    {
	        begin=i;
	        break;
	    }
	}	

        for(i=begin+1; old_buffer[i]!='\0'; i++)
        {
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	    {
	        end=i;
	        break;
	    }
	}	
	
	memset(new_buffer, 0, max_line_len+1024);

	if( end-begin > max_username_len )
	{
	    while( end-begin > max_username_len )
	      end--;
	    strncat(new_buffer, &old_buffer[begin], end);
	}
	else
	  strncat(new_buffer, &old_buffer[begin], end);

	if( new_buffer[strlen(new_buffer)-1]!='\0' )
	  new_buffer[strlen(new_buffer)-1]='\0';

    	utf8 = g_locale_to_utf8(new_buffer, end-begin, NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, utf8, -1);
/* ------------- Username End ----------- */



/* ------------- Action (upload/download/delete) ----------------- */
        count=0; begin=0; end=0;
        for(i=strlen(old_buffer)-1; old_buffer[i]!='\0'; i--)
        {
	    if( old_buffer[i]==' ' && old_buffer[i+1]!=' ')
	      count++;
	    
	    if( count==7 )
	    {
	        begin=i+1;
	        break;
	    }
	}	

	end=begin+1;

	memset(new_buffer, 0, max_line_len+1024);

	/* The legth is always 1 */
	strncat(new_buffer, &old_buffer[begin], end);

	if( new_buffer[strlen(new_buffer)-1]!='\0' )
	  new_buffer[strlen(new_buffer)-1]='\0';

        if( strstr(new_buffer, "i") )
          sprintf(new_buffer, "%s", _("uploaded"));
        else
        if( strstr(new_buffer, "o") )
          sprintf(new_buffer, "%s", _("downloaded"));
        else
        if( strstr(new_buffer, "d") )
          sprintf(new_buffer, "%s", _("deleted"));
    
        utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	gtk_list_store_set(GTK_LIST_STORE(model), &iter, 1, utf8, -1);
/* ------------- Action End ------------- */
	    
	found=1;	    
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    if( utf8 !=NULL )
      g_free(utf8);

    /* Unref the model */
    g_object_unref(model);

    /* Cant set treepath if there arent any users/rows, then itll crash */
    if( ! found )
      return;

    path=gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(files_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}


void
on_yes_default_question_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
    /* This adds the default configuration */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *default_question_window;
    char *default_buffer;
    default_question_window=lookup_widget(GTK_WIDGET(button), "default_question_window");

    /* Add the default configuration */
    if((fp=fopen(GP_CONF, "w+"))==NULL)
    {
	sprintf(info_buffer, "%s %s %s", _("Cant write the new proftpd.conf here:\n"), GP_CONF, _("\nRun GProFTPD as root\n"));
    	info_window=create_info_window();
    	gtk_widget_show(info_window);
	return;
    }
    else
      {
	    default_buffer = allocate(16384);
	    if( default_buffer==NULL )
	    {
		sprintf(info_buffer, _("Cant allocate enough memory for the default values\n"));
    		info_window=create_info_window();
    		gtk_widget_show(info_window);
	        fclose(fp);
		return;
	    }

	    /* These first 3 are not in the global tab, add inetd functions ? */
	    strcpy(default_buffer, "ServerType standalone\n");
	    strcat(default_buffer, "DefaultServer on\n");
	    strcat(default_buffer, "Umask 022\n");

	    /* Default configuration list */
	    strcat(default_buffer, "ServerName \"0.0.0.0\"\n");
	    strcat(default_buffer, "ServerIdent on \"My FTPD\"\n");
	    /* Ask TJ about possible implications */
	    strcat(default_buffer, "Bind \"0.0.0.0\"\n");
	    strcat(default_buffer, "ServerAdmin Admin@this.domain.topdomain\n");
	    strcat(default_buffer, "IdentLookups off\n");
	    strcat(default_buffer, "UseReverseDNS off\n");
	    strcat(default_buffer, "Port 21\n");

	    /* The IANA-registered ephemeral port range */
	    strcat(default_buffer, "PassivePorts 49152 65534\n");
	    strcat(default_buffer, "#MasqueradeAddress None\n");
	    strcat(default_buffer, "TimesGMT off\n");
	    strcat(default_buffer, "MaxInstances 30\n");
	    strcat(default_buffer, "MaxLoginAttempts 3\n");
	    strcat(default_buffer, "TimeoutLogin 300\n");
	    strcat(default_buffer, "TimeoutNoTransfer 120\n");
	    strcat(default_buffer, "TimeoutIdle 120\n");
	    strcat(default_buffer, "User ");
	    strcat(default_buffer, NOBODY);
	    strcat(default_buffer, "\nGroup ");
	    strcat(default_buffer, NOBODY);
	    strcat(default_buffer, "\nDirFakeUser off ");
	    strcat(default_buffer, NOBODY);
	    strcat(default_buffer, "\nDirFakeGroup off ");
	    strcat(default_buffer, NOBODY);
	    strcat(default_buffer, "\nDefaultTransferMode binary\n");
	    strcat(default_buffer, "AllowForeignAddress on\n");
	    strcat(default_buffer, "AllowRetrieveRestart on\n");
	    strcat(default_buffer, "AllowStoreRestart on\n");
	    strcat(default_buffer, "DeleteAbortedStores off\n");
	    strcat(default_buffer, "TransferRate RETR 30\n");
	    strcat(default_buffer, "TransferRate STOR 40\n");
	    strcat(default_buffer, "TransferRate STOU 40\n");
	    strcat(default_buffer, "TransferRate APPE 40\n");
	    strcat(default_buffer, "SystemLog ");
	    strcat(default_buffer, GP_VARDIR);
	    strcat(default_buffer, "/log/secure\n");
	    strcat(default_buffer, "#gp_random_username_length 6\n");
	    strcat(default_buffer, "#gp_random_password_length 6\n");
	    strcat(default_buffer, "#gp_randomize_case lower\n");
	    strcat(default_buffer, "#gp_useradd_root_path ");
	    strcat(default_buffer, USERSHOME);
	    strcat(default_buffer, "ftp\n");
	    strcat(default_buffer, "#gp_useradd_upload_path /upload\n");
	    strcat(default_buffer, "#gp_html_path ");
	    strcat(default_buffer, GP_VARDIR);
	    strcat(default_buffer, "/www/ftp.html\n");
	    strcat(default_buffer, "#gp_welcome_name welcome.msg\n");


	    /* By default TLS is off even if the module is compiled in */ 
	    strcat(default_buffer, "<IfModule mod_tls.c>\n");
	    strcat(default_buffer, "TLSEngine off\n");
	    strcat(default_buffer, "TLSRequired off\n");
	    strcat(default_buffer, "TLSVerifyClient off\n");
	    strcat(default_buffer, "TLSProtocol TLSv1\n");
	    strcat(default_buffer, "TLSLog ");
	    strcat(default_buffer, GP_VARDIR);
	    strcat(default_buffer, "/log/proftpd_tls.log\n");
	    strcat(default_buffer, "TLSRSACertificateFile ");
	    strcat(default_buffer, GP_APPCONFDIR); 
	    strcat(default_buffer, "/gproftpd.pem\n");
//	    strcat(default_buffer, "#CA the server trusts\n");
//	    strcat(default_buffer, "#TLSCACertificateFile /home/certs/root.cert.pem\n");
	    strcat(default_buffer, "</IfModule>\n");

//	    strcat(default_buffer, "<Global>\n");  for 8.1.1
	    strcat(default_buffer, "<Limit LOGIN>\n");
	    /* All added users gets an AllowUser UserName here */
	    strcat(default_buffer, "  DenyALL\n");
	    strcat(default_buffer, "</Limit>\n");
//	    strcat(default_buffer, "</Global>\n"); both for 8.1.1
//	    strcat(default_buffer, "#--End of the main configuration--#\n\n");
	    
	    fputs(default_buffer, fp);
	    fclose(fp);
	    free(default_buffer);

	    list_server_values(userlist_treeview, NULL);
	    list_entire(userlist_treeview, NULL);
	    list_users(userlist_treeview, NULL);

	    list_servers(userlist_treeview, NULL);
	    
        }
        gtk_widget_destroy(default_question_window);
}


void
on_no_default_question_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    /* The user might want to use his/her own conf */
    GtkWidget *default_question_window;
    list_server_values(userlist_treeview, NULL);
    list_entire(userlist_treeview, NULL);
    list_users(userlist_treeview, NULL);
    default_question_window=lookup_widget(GTK_WIDGET(button), "default_question_window");
    gtk_widget_destroy(default_question_window);
}


void
on_gproftpd_window_map                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
    /* This takes care of populating all the relevant widgets 
     * and making sure the environment is sane at startup.
     */
    FILE *fp;
    GtkWidget *gproftpd_window;
    GtkWidget *info_window;
    GtkWidget *files_treeview;
    GtkWidget *servers_treeview;
    GtkWidget *default_question_window;
    GtkWidget *add_systemuser_question_window;
    GtkWidget *xfer_textview;
    GtkWidget *xfer_scrolledwindow;
    GtkWidget *total_incoming_entry;
    GtkWidget *total_outgoing_entry;
    GtkWidget *disc_treeview;
    GtkWidget *proftpd_version_label;
    GtkWidget *gproftpd_version_label;
    GtkWidget *status_label;
    GtkWidget *shell_combo; 

    /* take away later.. only for upgrades to version 8.1.0 */
    GtkWidget *global_useradd_root_path;
    GtkWidget *global_useradd_upload_path;
    
    GtkWidget *tls_hbox1;
    GtkWidget *tls_hbox2;
    GtkWidget *tls_hbox3;
    GtkWidget *tls_hbox4;
    GtkWidget *tls_hbox5;
    GtkWidget *tls_hbox6;
    GtkWidget *tls_label1;
    GtkWidget *tls_label2;
    GtkWidget *tls_label3;
    GtkWidget *tls_hseparator1;
    GtkWidget *tls_hseparator2;
    GdkPixbuf *main_window_pixbuf;
    GtkCellRenderer *pixmap_cell;
    GtkTreeViewColumn *user_column, *group_column, *maxclients_column, *require_column, *banned_column,*maximum_column;
    GtkTreeViewColumn *mount_column, *free_column, *used_column, *total_column, *percent_column, *device_column;
    GtkTreeViewColumn *files_username_column, *files_action_column, *files_name_column, *files_size_column;
    GtkTreeViewColumn *files_start_column, *files_host_column;
    GtkTreeViewColumn *servers_ip_column, *servers_port_column, *servers_name_column, *servers_type_column;
    char *versionbuffer, *get_buffer, *buffer;
    char *new_buffer, *shell, *username;
    char tempo[4096]="";
    GtkListStore *user_model, *disc_model, *files_model, *servers_model;
    GtkCellRenderer *cell;
    long size_buffer;
    GList *items = NULL;
    gchar *utf8=NULL;            
    int found_conf=0, found_shell=0;

    disc_treeview = lookup_widget(GTK_WIDGET(widget), "disc_treeview");
    files_treeview = lookup_widget(GTK_WIDGET(widget), "files_treeview");
    servers_treeview = lookup_widget(GTK_WIDGET(widget), "servers_treeview");

    /* Globals */
    userlist_treeview = lookup_widget(GTK_WIDGET(widget), "userlist_treeview");
    useradd_directory_entry = lookup_widget(GTK_WIDGET(widget), "useradd_directory_entry");
    useradd_incoming_directory_entry = lookup_widget(GTK_WIDGET(widget), "useradd_incoming_directory_entry");


    /* Take away later, make sure we have some paths for upgrading users, version 8.1.0  */
    global_useradd_root_path = lookup_widget(GTK_WIDGET(widget), "global_useradd_root_path");
    global_useradd_upload_path = lookup_widget(GTK_WIDGET(widget), "global_useradd_upload_path");
    useradd_directory_entry = lookup_widget(GTK_WIDGET(widget), "useradd_directory_entry");
    useradd_incoming_directory_entry = lookup_widget(GTK_WIDGET(widget), "useradd_incoming_directory_entry");
    sprintf(gp_useradd_root_path, "%sftp", USERSHOME);
    utf8 = g_locale_to_utf8(gp_useradd_root_path, strlen(gp_useradd_root_path), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(global_useradd_root_path), utf8);
    gtk_entry_set_text(GTK_ENTRY(useradd_directory_entry), utf8);
    sprintf(gp_useradd_upload_path, "/upload");
    utf8 = g_locale_to_utf8(gp_useradd_upload_path, strlen(gp_useradd_upload_path), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(global_useradd_upload_path), utf8);
    gtk_entry_set_text(GTK_ENTRY(useradd_incoming_directory_entry), utf8);

    tls_hbox1 = lookup_widget (GTK_WIDGET (widget), "tls_hbox1");
    tls_hbox2 = lookup_widget (GTK_WIDGET (widget), "tls_hbox2");
    tls_hbox3 = lookup_widget (GTK_WIDGET (widget), "tls_hbox3");
    tls_hbox4 = lookup_widget (GTK_WIDGET (widget), "tls_hbox4");
    tls_hbox5 = lookup_widget (GTK_WIDGET (widget), "tls_hbox5");
    tls_hbox6 = lookup_widget (GTK_WIDGET (widget), "tls_hbox6");
    tls_label1 = lookup_widget (GTK_WIDGET (widget), "tls_label1");
    tls_label2 = lookup_widget (GTK_WIDGET (widget), "tls_label2");
    tls_label3 = lookup_widget (GTK_WIDGET (widget), "tls_label3");
    tls_hseparator1 = lookup_widget (GTK_WIDGET (widget), "tls_hseparator1");
    tls_hseparator2 = lookup_widget (GTK_WIDGET (widget), "tls_hseparator2");

    /* Setup the main window icon */
    pixmap_cell = gtk_cell_renderer_pixbuf_new();
    main_window_pixbuf=create_pixbuf("gproftpd.png");
    g_object_set(pixmap_cell, "pixbuf", main_window_pixbuf, NULL);
    gproftpd_window = lookup_widget (GTK_WIDGET (widget), "gproftpd_window");
    gtk_window_set_icon (GTK_WINDOW (gproftpd_window), main_window_pixbuf);
    gdk_pixbuf_unref(main_window_pixbuf);


    /* Check if proftpd.conf exists */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
	/* Report nothing */
    }
    else
      {
    	 /* We have found a conf but is it gproftpd's configuration */
         found_conf=1;
         /* Check if this is the default basic proftpd.conf */
    	 fseek(fp, 0, SEEK_END);
         size_buffer = ftell(fp);
	 rewind(fp);
         buffer = allocate(size_buffer);          
	 if( buffer==NULL )
	 {
	    printf("Cant allocate enough memory for the configuration.\n");
    	    sprintf(info_buffer, _("Cant allocate enough memory for the configuration.\n"));
    	    info_window = create_info_window ();
    	    gtk_widget_show (info_window);
	    fclose(fp);
	    return;
	 }

         while(fgets(buffer, size_buffer, fp)!=NULL) 
         {
	    if( strstr(buffer, "Port 21 is the standard") )
	    {
	       /* If the user has this conf most things wont work as intended */
	       found_conf=0;
	       break;
	    }
	 }
         fclose(fp);
	 free(buffer);
      }


    /* If the NOBODY user the server runs as doesnt exist, add it 
     * and also add the SHELL if that doesnt exist.
     */
    username = allocate(8192);
    sprintf(username, "%s", NOBODY);
    
    if( ! user_exists(username) )
    {
	add_systemuser_question_window=create_add_systemuser_question_window();
	gtk_widget_show(add_systemuser_question_window);
    }

    free(username);


    /* Set proftpd version in the proftpd version entry */
    versionbuffer = allocate(8192);  
    if((fp=popen("proftpd -v 2>&1 |awk '{print $4}' |tr -d \"\r\n\"", "r"))==NULL)
    {
        sprintf(info_buffer, "%s %s", _("Cant get version from: \"proftpd -v\"\n"), _("ProFTPD must be installed and be in your path.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
    }
    else
      {
	 fflush(fp);
	 while((fgets(versionbuffer, 8192, fp)!=NULL))
	 {
	 }
	 if( strlen(versionbuffer) < 30 && strlen(versionbuffer) > 0 )
	 {
            buffer = allocate(8192);
	    sprintf(buffer, _("Proftpd version: %s"), versionbuffer);
	    sprintf(versionbuffer, buffer);
	    utf8 = g_locale_to_utf8(versionbuffer, strlen(versionbuffer), NULL, NULL, NULL);
    	    proftpd_version_label = lookup_widget (GTK_WIDGET (widget), "proftpd_version_label");
	    gtk_label_set_text(GTK_LABEL(proftpd_version_label), utf8);
	    free(buffer);
	    /* gtk_label_set_markup(GTK_LABEL(info_label3), "<span background=\"white\">hejhoppz</span>"); */
	 }
	 pclose(fp);
      }

    /* Set GProftpd version from configure.in in the GProftpd version entry */
    if( strlen(VERSION) < 30 && strlen(VERSION) > 0 )
    {
	sprintf(versionbuffer, _("GProftpd version: %s"), VERSION);
	utf8 = g_locale_to_utf8(versionbuffer, strlen(versionbuffer), NULL, NULL, NULL);
        gproftpd_version_label = lookup_widget (GTK_WIDGET (widget), "gproftpd_version_label");
	gtk_label_set_text(GTK_LABEL(gproftpd_version_label), utf8);
    }
    else
      {
	  sprintf(versionbuffer, _("No version found"));
	  utf8 = g_locale_to_utf8(versionbuffer, strlen(versionbuffer), NULL, NULL, NULL);
          gproftpd_version_label = lookup_widget (GTK_WIDGET (widget), "gproftpd_version_label");
	  gtk_label_set_text(GTK_LABEL(gproftpd_version_label), utf8);
      }

    free(versionbuffer);

    /* Setup the server list */
    servers_model = gtk_list_store_new(4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(servers_treeview), GTK_TREE_MODEL(servers_model));
    cell = gtk_cell_renderer_text_new();
    servers_ip_column = gtk_tree_view_column_new_with_attributes(_("Address"), cell, "text", 0, NULL);
    servers_port_column = gtk_tree_view_column_new_with_attributes(_("Port"), cell, "text", 1, NULL);
    servers_name_column = gtk_tree_view_column_new_with_attributes(_("Servername"), cell, "text", 2, NULL);
    servers_type_column = gtk_tree_view_column_new_with_attributes(_("Server type"), cell, "text", 3, NULL);
    gtk_list_store_clear(servers_model);
    gtk_tree_view_append_column(GTK_TREE_VIEW(servers_treeview), GTK_TREE_VIEW_COLUMN(servers_ip_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(servers_treeview), GTK_TREE_VIEW_COLUMN(servers_port_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(servers_treeview), GTK_TREE_VIEW_COLUMN(servers_name_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(servers_treeview), GTK_TREE_VIEW_COLUMN(servers_type_column));

    /* Setup the userlist */
    user_model = gtk_list_store_new(6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_MODEL (user_model));
    cell = gtk_cell_renderer_text_new();
    user_column = gtk_tree_view_column_new_with_attributes(_("User"), cell, "text", 0, NULL);
    group_column = gtk_tree_view_column_new_with_attributes(_("Group"), cell, "text", 1, NULL);
    maxclients_column = gtk_tree_view_column_new_with_attributes(_("Root directory"), cell, "text", 2, NULL);
    require_column = gtk_tree_view_column_new_with_attributes(_("Require password"), cell, "text", 3, NULL);
    banned_column = gtk_tree_view_column_new_with_attributes(_("Banned"), cell, "text", 4, NULL);
    maximum_column = gtk_tree_view_column_new_with_attributes(_("Maximum connections"), cell, "text", 5, NULL);
    gtk_list_store_clear(user_model);
    gtk_tree_view_append_column(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_VIEW_COLUMN(user_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_VIEW_COLUMN(group_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_VIEW_COLUMN(maxclients_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_VIEW_COLUMN(require_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_VIEW_COLUMN(banned_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(userlist_treeview), GTK_TREE_VIEW_COLUMN(maximum_column));

    /* Setup the files list */
    files_model = gtk_list_store_new(7, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(files_treeview), GTK_TREE_MODEL (files_model));
    cell = gtk_cell_renderer_text_new();
    files_username_column = gtk_tree_view_column_new_with_attributes(_("Username"), cell, "text", 0, NULL);
    files_action_column = gtk_tree_view_column_new_with_attributes(_("Action"), cell, "text", 1, NULL);
    files_name_column = gtk_tree_view_column_new_with_attributes(_("Filename"), cell, "text", 2, NULL);
    files_size_column = gtk_tree_view_column_new_with_attributes(_("Bytes"), cell, "text", 3, NULL);
    files_start_column = gtk_tree_view_column_new_with_attributes(_("Start of transfer"), cell, "text", 4, NULL);
    files_host_column = gtk_tree_view_column_new_with_attributes(_("Remote host"), cell, "text", 5, NULL);
    gtk_list_store_clear(files_model);
    gtk_tree_view_append_column(GTK_TREE_VIEW(files_treeview), GTK_TREE_VIEW_COLUMN(files_username_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(files_treeview), GTK_TREE_VIEW_COLUMN(files_action_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(files_treeview), GTK_TREE_VIEW_COLUMN(files_name_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(files_treeview), GTK_TREE_VIEW_COLUMN(files_size_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(files_treeview), GTK_TREE_VIEW_COLUMN(files_start_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(files_treeview), GTK_TREE_VIEW_COLUMN(files_host_column));

    /* Setup the disc tab */
    disc_model = gtk_list_store_new(6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(disc_treeview), GTK_TREE_MODEL (disc_model));
    cell = gtk_cell_renderer_text_new();
    gtk_list_store_clear(disc_model);
    mount_column = gtk_tree_view_column_new_with_attributes(_("Mounted on"), cell, "text", 0, NULL);
    free_column = gtk_tree_view_column_new_with_attributes(_("Free space"), cell, "text", 1, NULL);
    used_column = gtk_tree_view_column_new_with_attributes(_("Used space"), cell, "text", 2, NULL);
    total_column = gtk_tree_view_column_new_with_attributes(_("Total space"), cell, "text", 3, NULL);
    percent_column = gtk_tree_view_column_new_with_attributes(_("Percent used"), cell, "text", 4, NULL);
    device_column = gtk_tree_view_column_new_with_attributes(_("Device"), cell, "text", 5, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(disc_treeview), GTK_TREE_VIEW_COLUMN(mount_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(disc_treeview), GTK_TREE_VIEW_COLUMN(free_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(disc_treeview), GTK_TREE_VIEW_COLUMN(used_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(disc_treeview), GTK_TREE_VIEW_COLUMN(total_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(disc_treeview), GTK_TREE_VIEW_COLUMN(percent_column));
    gtk_tree_view_append_column(GTK_TREE_VIEW(disc_treeview), GTK_TREE_VIEW_COLUMN(device_column));


    /* Add all available shells to the loginshell combo */
    shell_combo = lookup_widget(GTK_WIDGET (widget), "shell_combo");
    if((fp=fopen(GP_SHELLS, "r"))==NULL)
    {
        sprintf(info_buffer, "%s %s %s", _("Cant open shells for reading here:\n"), GP_SHELLS, "\n");
        info_window = create_info_window();
        gtk_widget_show(info_window);
    }
    else
      {   
         fseek(fp, 0, SEEK_END);
         size_buffer = ftell(fp);
         rewind(fp);
         shell = allocate(size_buffer);
         new_buffer = allocate(size_buffer);
         utf8=g_locale_to_utf8(BINFALSE, strlen (BINFALSE), NULL, NULL, NULL);
         items = g_list_append (items, utf8);
         while(fgets(shell, size_buffer, fp)!=NULL) 
         {
            if( strstr(shell, "/") && ! strstr(shell, "#") && ! strstr(shell, BINFALSE) )
            {
                sscanf(shell, "%s", new_buffer);
                utf8=g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
                items = g_list_append (items, utf8);
            }
	    /* Check for a /bin/false shell */
            if( strstr(shell, BINFALSE) && ! strstr(shell, "#") )
            {
		found_shell=1;
	    }
         }
         fclose(fp);
         free(shell);
         free(new_buffer);
         gtk_combo_set_popdown_strings(GTK_COMBO(shell_combo), items);
    }

    /* Add a /bin/false shell if it wasnt there already */
    if( ! found_shell )
    {
	if((fp=fopen(GP_SHELLS, "a"))==NULL)
	{
    	    sprintf(info_buffer, "%s %s %s", _("Cant open shells for writing /bin/false here:\n"), GP_SHELLS, "\n");
    	    info_window = create_info_window();
    	    gtk_widget_show(info_window);
	}
	else
    	  {
	     fputs("\n", fp);
	     fputs(BINFALSE, fp);
	     fputs("\n", fp);
	     fclose(fp);
	  }	    
    }

    /* If there is no ftpusers one is created and all existing users put there (security). */
    if((fp=fopen(GP_FTPUSERS, "r"))==NULL)
    {
	strcpy(info_buffer, _("Couldnt find ftpusers here:\n"));
	strcat(info_buffer, GP_FTPUSERS);
        strcat(info_buffer, _("\nso GProftpd made that file and added all users\n"));
        strcat(info_buffer, _("on the system to it. They are now banned from using the ftp server.\n"));
        strcat(info_buffer, _("This in an auto-security feature.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	strcpy(tempo, "cat ");
	strcat(tempo, GP_PASSWD);
	strcat(tempo, " |cut -f1 -d\":\" > ");
	strcat(tempo, GP_FTPUSERS);
        system(tempo);
    }
    else
      fclose(fp);
    
    total_incoming_entry = lookup_widget (GTK_WIDGET (widget), "total_incoming_entry");
    total_outgoing_entry = lookup_widget (GTK_WIDGET (widget), "total_outgoing_entry");
    status_label = lookup_widget (GTK_WIDGET (widget), "status_label");

    /* Start the timer */
    xfer_textview = lookup_widget (GTK_WIDGET (widget), "xfer_textview");
    xfer_scrolledwindow = lookup_widget (GTK_WIDGET (widget), "xfer_scrolledwindow");

    gtk_timeout_add(1000, (GtkFunction) xfer_update, xfer_textview);
    /* g_idle_add((GtkFunction)xfer_update, xfer_textview); */


    /* Dont show TLS options if we dont have the module */
    if((fp=popen("proftpd -l","r"))==NULL)
    {
	/* Locale trouble could be one cause so add TLS options */
	use_tls=1;
    }
    else
      {	
	 get_buffer = allocate(MAX_READ_POPEN+1);
	 while(fgets(get_buffer, MAX_READ_POPEN, fp)!=NULL)
	 {
	    if( strstr(get_buffer, "mod_tls") )
	    {
	        use_tls=1;
	        break;
	    }
	 }
	 free(get_buffer);
         pclose(fp);
      }

    /* For testing */
    /* use_tls=0;  */

    if( ! use_tls )
    {
        gtk_widget_destroy(tls_hbox1);
        gtk_widget_destroy(tls_hbox2);
        gtk_widget_destroy(tls_hbox3);
        gtk_widget_destroy(tls_hbox4);
        gtk_widget_destroy(tls_hbox5);
        gtk_widget_destroy(tls_hbox6);
        gtk_widget_destroy(tls_label1);
        gtk_widget_destroy(tls_label2);
        gtk_widget_destroy(tls_label3);
        gtk_widget_destroy(tls_hseparator1);
        gtk_widget_destroy(tls_hseparator2);
    }

    /* Update the relevant tabs */
    if( found_conf )
    {
	list_server_values(status_label, NULL);
	list_entire(status_label, NULL);
	list_servers(userlist_treeview, NULL); 
	list_users(userlist_treeview, NULL);
    }
    else
      {
         /* Show a choise to load the default configuration */
	 default_question_window = create_default_question_window();
	 gtk_widget_show(default_question_window);
	 status_label=lookup_widget(GTK_WIDGET(widget), "status_label");
      }

    /* Unref the models */
    g_object_unref(user_model);
    g_object_unref(disc_model);
    g_object_unref(files_model);

    list_files(userlist_treeview, NULL);
    list_secure(userlist_treeview, NULL);
    list_disc(userlist_treeview, NULL);

    if( utf8!=NULL )
      g_free(utf8);
}


void
on_online_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    char start[8192]="";
    strcpy(start, "rm -f ");
    strcat(start, GP_SHUTMSG);
    system(start);
    if( online )
      return;
    strcpy(start, "proftpd -c ");
    strcat(start, GP_CONF);
    system(start);
    offline_pressed=0;
}


void
on_offline_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    if( online )	
      system("killall -15 proftpd");
    /* For checking if inetd/xinetd is running an ftpd */
    offline_pressed=1;
}


void
on_reread_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    if( online )
      system("killall -1 proftpd");
}


void
on_shutdown_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *shutdown_window;
    shutdown_window=create_shutdown_window();
    gtk_widget_show(shutdown_window);
}


void
on_help_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *help_window;
    help_window=create_help_window();
    gtk_widget_show(help_window);
}


void
on_credits_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *credits_window;
    credits_window=create_credits_window();
    gtk_widget_show(credits_window);
}


void
on_change_password_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *password_question_window;
    GtkWidget *password_change_username_entry;
    GtkWidget *password_change_password_entry;
    G_CONST_RETURN gchar *username;
    G_CONST_RETURN gchar *password;
    password_question_window = lookup_widget (GTK_WIDGET (button), "password_question_window");
    password_change_password_entry = lookup_widget (GTK_WIDGET (button), "password_change_password_entry");
    password_change_username_entry = lookup_widget (GTK_WIDGET (button), "password_change_username_entry");
    username = gtk_entry_get_text(GTK_ENTRY(password_change_username_entry));
    password = gtk_entry_get_text(GTK_ENTRY(password_change_password_entry));
    password_user(username, password);
    gtk_widget_destroy(password_question_window);
}


void
on_useradd_button_clicked  (GtkButton       *button,
                            gpointer         user_data)
{
    /* Adds a new user to the selected server */
    FILE *fp;
    long size_buffer;
    GtkWidget *info_window;
    GtkWidget *userlist_treeview;
    GtkWidget *entire_textview;
    GtkWidget *password_question_window;
    GtkWidget *useradd_username_entry;
    GtkWidget *useradd_password_entry;
    GtkWidget *password_change_username_entry;
    GtkWidget *password_change_password_entry;
    GtkWidget *useradd_directory_entry;
    GtkWidget *useradd_incoming_directory_entry;
    GtkWidget *useradd_incoming_checkbutton;
    GtkWidget *useradd_shell_entry;
    G_CONST_RETURN gchar *username;
    G_CONST_RETURN gchar *password;
    G_CONST_RETURN gchar *shell;
    G_CONST_RETURN gchar *dir;
    G_CONST_RETURN gchar *incoming;
    char *user_settings, *user_check, *old_buffer=NULL, *new_buffer=NULL, *address_buffer, *port_buffer;
    char useradd_command[4096]="";
    char fixdir[4096]="";
    char *root_dir, *incoming_dir;
    int length=0, limit_access=0, user_added=0, found_server=0;
    useradd_username_entry = lookup_widget (GTK_WIDGET (button), "useradd_username_entry");
    useradd_password_entry = lookup_widget (GTK_WIDGET (button), "useradd_password_entry");
    useradd_shell_entry = lookup_widget (GTK_WIDGET (button), "useradd_shell_entry");
    useradd_directory_entry = lookup_widget (GTK_WIDGET (button), "useradd_directory_entry");
    useradd_incoming_directory_entry = lookup_widget (GTK_WIDGET (button), "useradd_incoming_directory_entry");
    useradd_incoming_checkbutton = lookup_widget (GTK_WIDGET (button), "useradd_incoming_checkbutton");
    username = gtk_entry_get_text(GTK_ENTRY(useradd_username_entry));
    password = gtk_entry_get_text(GTK_ENTRY(useradd_password_entry));

/*    username = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(useradd_username_entry)), -1, NULL, NULL, NULL); */
/*    password = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(useradd_password_entry)), -1, NULL, NULL, NULL); */

    shell = gtk_entry_get_text(GTK_ENTRY(useradd_shell_entry));
    dir = gtk_entry_get_text(GTK_ENTRY(useradd_directory_entry));
    incoming = gtk_entry_get_text(GTK_ENTRY(useradd_incoming_directory_entry));

    /* If the shell is false it will add the users directory as MASTERDIR 
     * then delete it so the ftp directory doesnt contain skeleton files.
     */
     
    /* If the shell is real it will add the users directory to /USERSHOME/username 
     * and the ftp directory where specified in the application.
     */

    /* If the username field is empty inform that this cant be done. */
    length = strlen(username = gtk_entry_get_text(GTK_ENTRY(useradd_username_entry)));
    if( length == 0 ) 
    {
    	strcpy(info_buffer, _("You must specify a username.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    if( username[0]=='0'||username[0]=='1'||username[0]=='2'||username[0]=='3'||username[0]=='4' 
    ||username[0]=='5'||username[0]=='6'||username[0]=='7'||username[0]=='8'||username[0]=='9') 
    {
    	strcpy(info_buffer, _("Usernames are not allowed to begin with a number.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    if( username[0]=='r' && username[1]=='o' && username[2]=='o' && username[3]=='t' && strlen(username)==4 ) 
    {
    	strcpy(info_buffer, _("Refusing to add user root.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    if( strstr((char *)username, "<") || strstr((char *)username, ">") ) 
    {
    	strcpy(info_buffer, _("A username containing < or > is not allowed.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    /* If the password field has less then 6 chars we inform that this cant be done */
    length = strlen(password = gtk_entry_get_text(GTK_ENTRY(useradd_password_entry)));
    if ( length < 6 ) 
    {
    	strcpy(info_buffer, _("The minimum password length is 6 chars.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    /* If the shell field has less then 3 chars we inform that this cant be done */
    length = strlen(shell = gtk_entry_get_text(GTK_ENTRY(useradd_shell_entry)));
    if ( length < 3 )
    {
    	strcpy(info_buffer, _("The minimum shell length is 3 chars.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    /* If the directory field has 0 chars we inform that this cant be done */
    length = strlen(dir = gtk_entry_get_text(GTK_ENTRY(useradd_directory_entry)));
    if ( length==0 ) 
    {
    	strcpy(info_buffer, _("Mimimum directory path length is 1 char.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    address_buffer = allocate(8192+15);

    port_buffer = allocate(8192+3);               

    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>\n", selected_server_address);
    }
    else
       sprintf(address_buffer, selected_server_address);
     
    sprintf(port_buffer, "Port %s\n", selected_server_port);



    /* Checks if the user exists in proftpd.conf if so just show a popup */
    if((fp=fopen(GP_CONF,"r"))==NULL)
    {
    	strcpy(info_buffer, _("Error reading configuration:\n"));
    	strcat(info_buffer, GP_CONF);
    	strcat(info_buffer, _("\nRun gproftpd as root, not installed correctly ?.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
    	return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer);

    user_check = allocate(4096);
    strcpy(user_check, "User ");
    strcat(user_check, username);
    strcat(user_check, "\n"); /* Similar user confusion */


    /* Standard server selected, start checking users directly */
    if( ! strstr((char *)selected_server_type, "Virtualhost") )
      found_server=1;


    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strlen(old_buffer) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
	    info_window=create_info_window();
	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(old_buffer);
    	    free(address_buffer);
	    free(port_buffer);
	    return;
	}


        if( strstr("Virtualhost", (char *)selected_server_type) && ! found_server
	&&  ! strcmp(old_buffer, address_buffer) ) 
	{
	    /* Lets see if its the same port as the selected one */
	    /* If this server has the same port its the correct server .. the end. */

	    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		{
		    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    		    info_window=create_info_window();
    		    gtk_widget_show(info_window);
		    fclose(fp);
		    free(old_buffer);
	    	    free(address_buffer);
		    free(port_buffer);
		    return;
		}
	    
		/* This will expect the servers port on the second line ! 
		 * else itll miss some vaules .. */
		if( strstr(old_buffer, "Port") && ! strcmp(old_buffer, port_buffer) )
		{
		    found_server=1;
		    break;
		}

		
		if( strstr(old_buffer, "</VirtualHost>") )
		  break;
	    }    
	}


	
	/* Continue until we find the selected server */
	if( ! found_server )
	  continue;

	if( found_server )
	  break;


	/* Dont change Allow From... */
	if( strstr(old_buffer, "<Anonymous") )
	  break;
    }


    /* Check user exist in this server.... */

    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
    {
	if( strlen(old_buffer) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
	    info_window=create_info_window();
	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(old_buffer);
	    free(address_buffer);
	    free(port_buffer);
	    free(user_check);
	    return;
	}

	/* Does this user exist in this server... */
	if( ! strcmp(old_buffer, user_check) && ! strstr(old_buffer, "AllowUser") )
	{
	    strcpy(info_buffer, _("That user already exists in this server in proftpd.conf.\n"));
	    strcat(info_buffer, _("Nothing was changed.\n"));
	    info_window = create_info_window();
	    gtk_widget_show (info_window);
	    free(user_check);
	    free(old_buffer);
	    free(address_buffer);
	    free(port_buffer);
	    fclose(fp);
	    return;
	}

	/* Dont match users in vhosts for the defualt server */
	if( ! strstr((char *)selected_server_type, "Virtualhost") )
	{
	    if( strstr(old_buffer, "<VirtualHost") )
	      break;
	}

	if( strstr(old_buffer, "</VirtualHost>") )
	  break;
    }
    free(user_check);
    free(old_buffer);
    fclose(fp);





    /* If the selected shell is false ... */
    if( strstr(shell, "nologin") || strstr(shell, "false") || strstr(shell, "dev/null") )
    {
	/* All supported systems but darwin */
#ifndef USE_DARWIN
        if( ! user_exists(username) )
        {
    	    /* Create a false user and delete its directory */
	    sprintf(useradd_command, "mkdir -p %s", MASTERDIR);
	    system(useradd_command);
	    sprintf(useradd_command, "%s %s -d %s -c ftp-user -s %s", ADDUSER, username, MASTERDIR, shell);
	    if((fp=popen(useradd_command,"r"))==NULL)
	    {
		perror("popen");
		printf("Errno useradd 1 set to: %d\n", errno);
    	        strcpy(info_buffer, _("Error adding the fake user with this command:\n"));
    	        strcat(info_buffer, useradd_command);
    	        strcat(info_buffer, _("\nadd it in a terminal\n"));
    	        info_window = create_info_window ();
    	        gtk_widget_show (info_window);
	    }
	    else
		{
	           pclose(fp);
		   user_added=1;
		}
		if( strlen(MASTERDIR)>2 )
		{
		    strcpy(fixdir, "rm -rf ");
		    strcat(fixdir, MASTERDIR);
		    system(fixdir);
		}
	}

#elif USE_DARWIN
	/* Add the false user using darwins niutil commands */
	if( ! niutil_user_exists(username) )    
	{
    	    /* Create a false user and delete its directory */
	    sprintf(useradd_command, "mkdir -p %s", MASTERDIR);
	    system(useradd_command);

	    if( ! niutil_useradd(username, shell) )
	    {
	        printf("Error adding the fake darwin user: %s\n", username);
    		strcpy(info_buffer, _("Error adding the fake darwin user, add it manually.\n"));
    	        info_window = create_info_window ();
    	        gtk_widget_show (info_window);
	    }
	    else
	        user_added=1;

		if( strlen(MASTERDIR)>2 )
		{
		    strcpy(fixdir, "rm -rf ");
		    strcat(fixdir, MASTERDIR);
		    system(fixdir);
		}
	}
#endif
    }
    else 	
      {
         /* The selected shell is not false and the user doesnt exist */


	/* All supported systems but darwin */
#ifndef USE_DARWIN
         if( ! user_exists(username) )
	 {
	    /* Create a real user in /USERSHOME/UserName with skel files */
	    sprintf(useradd_command, "%s %s -d %s%s -c ftp-user -m -s %s", ADDUSER, username, USERSHOME, username, shell);
	    if((fp=popen(useradd_command,"r"))==NULL)
	    {
		perror("popen");
		printf("Errno useradd 2 set to: %d\n", errno);
    		strcpy(info_buffer, _("Error adding the real user with this command:\n"));
    		strcat(info_buffer, useradd_command);
    		strcat(info_buffer, _("\nadd it in a terminal\n"));
    		info_window=create_info_window();
    		gtk_widget_show(info_window);
	    }
	    else
	      {
	        pclose(fp);
		user_added=1;
	      }
	 }

#elif USE_DARWIN
	 /* Add a real darwin user using the niutil commands */
	 if( ! niutil_user_exists(username) )    
	 {
    	     /* Create a false user and delete its directory */
	     sprintf(useradd_command, "mkdir -p %s", MASTERDIR);
	     system(useradd_command);

	     if( ! niutil_useradd(username, shell) )
	     {
	         printf("Error adding the fake darwin user: %s\n", username);
    		 strcpy(info_buffer, _("Error adding the fake darwin user, add it manually.\n"));
    	         info_window = create_info_window ();
    	         gtk_widget_show (info_window);
	     }
	     else
	       user_added=1;

	     if( strlen(MASTERDIR)>2 )
	     {
	         strcpy(fixdir, "rm -rf ");
		 strcat(fixdir, MASTERDIR);
		 system(fixdir);
	     }
	 }
#endif
    }


    /* Dont add anything if we couldnt add the system user */
#ifndef USE_DARWIN
    if( ! user_exists(username) )
#elif USE_DARWIN
    if( ! niutil_user_exists(username) )
#endif
    {
	strcpy(info_buffer, _("The system user was not added because uppercase\n"));
	strcat(info_buffer, _("or language specific letters arent allowed.\n"));
    	info_window=create_info_window();
    	gtk_widget_show(info_window);
	free(address_buffer);
	free(port_buffer);
	return;
    }


    /* Check that slashes in directory path combinations have slashes in the right place */
    root_dir = allocate(4096);
    incoming_dir = allocate(4096);

    strcpy(root_dir, dir);
    strcpy(incoming_dir, incoming);

    fix_path(root_dir);
    fix_path(incoming_dir);

    /* Make the users ftp root directory and chmod it to 0755 */
    strcpy(fixdir, root_dir);
    make_directory(fixdir, "0755");


    /* Make the usersettings with the specified ftp root directory */
    user_settings = allocate(8192);

    strcpy(user_settings, "\n<Anonymous ");
    strcat(user_settings, root_dir);
    strcat(user_settings, ">\n");
    strcat(user_settings, "User ");
    strcat(user_settings, username);
    strcat(user_settings, "\nGroup ");
    strcat(user_settings, username);
    strcat(user_settings, "\n");
    strcat(user_settings, "AnonRequirePassword on\n");
    strcat(user_settings, "MaxClients 3 \"The server is full, hosting %m users\"\n");
    strcat(user_settings, "DisplayLogin welcome.msg\n");
    strcat(user_settings, "DisplayFirstChdir .msg\n");
    strcat(user_settings, "AllowOverwrite off\n");
    strcat(user_settings, "<Limit LOGIN>\n");
    strcat(user_settings, " Allow from all\n");
    strcat(user_settings, " Deny from all\n");
    strcat(user_settings, "</Limit>\n");
    strcat(user_settings, "<Limit ROOT_DIR_ALLOW RETR LIST NLST MDTM SIZE STAT CWD XCWD PWD XPWD CDUP XCUP>\n");
    strcat(user_settings, " AllowAll\n");
    strcat(user_settings, "</Limit>\n");
    strcat(user_settings, "<Limit ROOT_DIR_DENY DELE APPE STOR STOU SITE_CHMOD SITE_CHGRP RNFR RNTO MKD XMKD RMD XRMD>\n");
    strcat(user_settings, " DenyAll\n");
    strcat(user_settings, "</Limit>\n");

    /* Add upload directory is checked, add the upload settings section and make the incoming directory */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(useradd_incoming_checkbutton)) ) 
    {
	/* Make the users settings with the specified incoming directory */
	strcat(user_settings, "<Directory ");
	strcat(user_settings, root_dir);
	strcat(user_settings, incoming_dir);
	strcat(user_settings, "/*>\n");
	strcat(user_settings, "AllowOverwrite on\n");
	strcat(user_settings, "<Limit UPLOAD_DIR_ALLOW LIST NLST MDTM SIZE SITE STAT APPE RETR STOR STOU MKD XMKD CWD XCWD PWD XPWD CDUP XCUP>\n");
	strcat(user_settings, " AllowAll\n");
	strcat(user_settings, "</Limit>\n");
	strcat(user_settings, "<Limit UPLOAD_DIR_DENY DELE SITE_CHMOD SITE_CHGRP RMD XRMD RNFR RNTO>\n");
	strcat(user_settings, " DenyAll\n");
	strcat(user_settings, "</Limit>\n");
	strcat(user_settings, "</Directory>\n");
	strcat(user_settings, "</Anonymous>\n");

	/* Make the incoming directory under the users ftp root directory */
	strcpy(fixdir, root_dir);
	strcat(fixdir, incoming_dir);
	make_directory(fixdir, "0777");
    }
    else
      {
	 strcat(user_settings, "</Anonymous>\n");
      }
      free(root_dir);
      free(incoming_dir);


    /* Add the new user_settings to the conf and to the right server 
     * and also add allow user to this server
     */
    
    
    found_server=0;

    /* Standard server selected, start adding users directly */
    if( ! strstr((char *)selected_server_type, "Virtualhost") )
      found_server=1;


    /* Add AllowUser UserName to proftpd.conf to the right server */
    if((fp=fopen(GP_CONF,"r"))==NULL)
    {
	strcpy(info_buffer, _("Could not read AllowUser here:\n"));
    	strcat(info_buffer, GP_CONF);
    	strcat(info_buffer, _("\nRun gproftpd as root\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
	free(user_settings);
    	return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);

    rewind(fp);

    old_buffer = allocate(size_buffer);

    new_buffer = allocate(size_buffer+8192);

    /* Add the new user to the new conf */
    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strlen(old_buffer) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
	    info_window=create_info_window();
	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(old_buffer);
    	    free(address_buffer);
	    free(port_buffer);
	    free(new_buffer);
	    free(user_settings);
	    return;
	}


	strcat(new_buffer, old_buffer);


        if( strstr("Virtualhost", (char *)selected_server_type) && ! found_server
	&&  ! strcmp(old_buffer, address_buffer) )
	{
	    /* Lets see if its the same port as the selected one */
	    /* If this server has the same port its the correct server .. the end. */
	    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		{
		    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    		    info_window=create_info_window();
    		    gtk_widget_show(info_window);
		    fclose(fp);
		    free(old_buffer);
		    free(new_buffer);
	    	    free(address_buffer);
		    free(port_buffer);
		    free(user_settings);
		    return;
		}

		strcat(new_buffer, old_buffer);

	    
		/* This will expect the servers port on the second line ! 
		 * else itll miss some vaules .. */
		if( strstr(old_buffer, "Port") && ! strcmp(old_buffer, port_buffer) )
		{
		    found_server=1;
		    break;
		}
		
		if( strstr(old_buffer, "</Virtualhost>") )
		  break;
	    }    

	}

	
	/* Continue until we find the selected server */
	if( ! found_server )
	  continue;


	/* Add AllowUSer Username .. to this server only */
	if( strstr(old_buffer, "<Limit LOGIN>") && found_server && ! limit_access )
	{
	    strcat(new_buffer, "  AllowUser ");
	    strcat(new_buffer, username);
	    strcat(new_buffer, "\n");
	    limit_access=1; /* just incase so we just change the first occurance */
	    
	    /* Add the user after </Limit> */
	    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
	    {
	       strcat(new_buffer, old_buffer);
	       if( strstr(old_buffer, "</Limit>") && limit_access==1 )
	       {
		    /* Only add it once */
		    limit_access=2;
		    strcat(new_buffer, user_settings);
	       }
	    }
	}
	
	/* Add the new user_settings if we have another user (once) */
	if( strstr(old_buffer, "</Anonymous") && limit_access==1 )
	{
	   /* Only add it once */
	   limit_access=2;
	   strcat(new_buffer, user_settings);
	}
    }
    fclose(fp);
    free(old_buffer);      
    free(address_buffer);
    free(port_buffer);
    free(user_settings);


    /* Write the new configuration */
    if((fp=fopen(GP_CONF,"w+"))==NULL)
    {
	strcpy(info_buffer, _("Could not write the new userinformation to:\n"));
    	strcat(info_buffer, GP_CONF);
    	strcat(info_buffer, _("\nRun gproftpd as root\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
	free(new_buffer);
        return;
    }
    else
      {
	 fputs(new_buffer, fp);
	 fclose(fp);
      }

    free(new_buffer);      


    /* The systemuser existed, change password for this user question */
    if( ! user_added )
    {
	password_question_window=create_password_question_window();
	gtk_widget_show(password_question_window);
	/* Insert username and password */
	password_question_window = lookup_widget (GTK_WIDGET (password_question_window), "password_question_window");
	password_change_username_entry = lookup_widget (GTK_WIDGET (password_question_window), "password_change_username_entry");
	password_change_password_entry = lookup_widget (GTK_WIDGET (password_question_window), "password_change_password_entry");
	gtk_entry_set_text(GTK_ENTRY(password_change_username_entry), username);
	gtk_entry_set_text(GTK_ENTRY(password_change_password_entry), password);
    }
    else
      {
#ifndef USE_DARWIN
         password_user(username, password);
#elif USE_DARWIN
	 niutil_password_user(username, password);
#endif
      }

    /* Update the userlist and the entire tab. */
    userlist_treeview = lookup_widget (GTK_WIDGET (button), "userlist_treeview");
    entire_textview = lookup_widget (GTK_WIDGET (button), "entire_textview");

    fix_newlines_in_conf();

    list_users(userlist_treeview, NULL);
    list_entire(entire_textview, NULL);

    /* ReRead */
    if( online )
      system("killall -1 proftpd"); 
}


void
on_question_userdel_delete_button_clicked (GtkButton       *button,
                                           gpointer         user_data)
{
    /* Deletes the selected system user */

#ifndef USE_DARWIN
    FILE *fp;
    char *userdel_buf;
#endif
    GtkWidget *info_window;
    GtkWidget *userdel_question_window;
    GtkWidget *userdel_question_entry;
    G_CONST_RETURN gchar *username;
    userdel_question_window = lookup_widget(GTK_WIDGET(button), "userdel_question_window");
    userdel_question_entry = lookup_widget(GTK_WIDGET(button), "userdel_question_entry");
    username = gtk_entry_get_text(GTK_ENTRY(userdel_question_entry));

#ifndef USE_DARWIN
    if( user_exists(username) )
    {
	userdel_buf = allocate(4096);
	strcpy(userdel_buf, DELUSER);
	strcat(userdel_buf, " ");
	strcat(userdel_buf, username);
	if((fp=popen(userdel_buf, "r"))==NULL)
	{
    	    perror("popen");
    	    strcpy(info_buffer, _("Manually delete that user,\n"));
	    strcat(info_buffer, _("could not delete it.\n"));
    	    info_window=create_info_window();
	    gtk_widget_show(info_window);
	}
	else
	  pclose(fp);
	
	free(userdel_buf);
    }
#elif USE_DARWIN
    if( niutil_user_exists(username) )
    {
	if( ! niutil_userdel(username) )
	{
    	    strcpy(info_buffer, _("Manually delete that user,\n"));
	    strcat(info_buffer, _("could not delete it.\n"));
    	    info_window=create_info_window();
	    gtk_widget_show(info_window);
	}
    }
#endif

    gtk_widget_destroy(userdel_question_window);
}


void
on_user_settings_delete_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
    /*  Deletes the user in the selected server from the user settings */
    FILE *fp;
    GtkWidget *userdel_question_window;
    GtkWidget *userdel_question_entry;
    GtkWidget *info_window;
    GtkWidget *settings_username_entry;
    GtkWidget *user_settings_window;
    long size_buffer;
    G_CONST_RETURN gchar *username;
    char *user_settings;
    char *UserUsername, *AllowuserName;
    char *old_buffer, *address_buffer, *port_buffer;
    char *config;
    int length=0, user_deleted=0, found_server=0;

    user_settings_window = lookup_widget(GTK_WIDGET(button), "user_settings_window");
    settings_username_entry = lookup_widget(GTK_WIDGET(button), "settings_username_entry");
    username = gtk_entry_get_text(GTK_ENTRY(settings_username_entry));

    /* If the namefield in username is empty inform that we refuse to do anything */
    length = strlen(username);
    if( length==0 ) 
    {
       strcpy(info_buffer, _("Cant delete a user of zero length.\n"));
       info_window = create_info_window ();
       gtk_widget_show (info_window);
       return;
    }

    /* Dont ever delete the root user, it cant be added in the gui but could be added by the user */
    if( username[0]=='r' && username[1]=='o' && username[2]=='o' && username[3]=='t' && strlen(username)==4 ) 
    {
    	strcpy(info_buffer, _("Refusing to delete user root.\n"));
    	info_window = create_info_window ();
    	gtk_widget_show (info_window);
    	return;
    }

    /* Delete the configuration for the deleted user in the right server */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
       strcpy(info_buffer, _("Cant open the configuration:\n"));
       strcat(info_buffer, GP_CONF);
       strcat(info_buffer, _("\nRun GProFTPD as root\n"));
       info_window = create_info_window ();
       gtk_widget_show (info_window);
       return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);


    UserUsername = allocate(4096);
    strcpy(UserUsername, "User ");
    strcat(UserUsername, username);
    /* Avoid similar user deletion */
    strcat(UserUsername, "\n");
    
    AllowuserName = allocate(4096);
    strcpy(AllowuserName, "AllowUser ");
    strcat(AllowuserName, username);
    /* Avoid similar user deletion */
    strcat(AllowuserName, "\n");
    
    config = allocate(size_buffer); 

    old_buffer = allocate(size_buffer);
    user_settings = allocate(size_buffer);

    address_buffer = allocate(8192+15);
    port_buffer = allocate(8192+3);               


    /* Get everything except the selected users settings and allowuser in the selected server */

    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>", selected_server_address);
    }
    else
       sprintf(address_buffer, selected_server_address);
     
    sprintf(port_buffer, "Port %s", selected_server_port);


    /* Standard server selected, delete the selected user in this (first) server */
    if( ! strstr((char *)selected_server_type, "Virtualhost") )
      found_server=1;


    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	/* Is this the correct server to delete the user from.. */
        if( strstr("Virtualhost", (char *)selected_server_type) && ! found_server
	&&  strstr(old_buffer, address_buffer) )
	{
	    strcat(config, old_buffer);

	    /* Lets see if its the same port as the selected one */
	    /* If this server has the same port its the correct server .. the end. */
	    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		{
		    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    		    info_window=create_info_window();
    		    gtk_widget_show(info_window);
		    fclose(fp);
		    free(old_buffer);
		    free(config);
		    free(user_settings);
	    	    free(address_buffer);
		    free(port_buffer);
		    free(UserUsername);
		    free(AllowuserName);
		    return;
		}

		/* This will expect the servers port on the second line ! 
		 * else itll miss some vaules .. */
		if( strstr(old_buffer, "Port") && strstr(old_buffer, port_buffer) )
		{
		    found_server=1;

		    strcat(config, old_buffer);
		    break;
		}
		else
		  strcat(config, old_buffer);

		if( strstr(old_buffer, "</Virtualhost>") )
		  break;
	    }
	}
	else
	  strcat(config, old_buffer);
	 

	/* Continue until we find the selected server */
	if( found_server )
	{
	    break;
	}
    }


    if( ! found_server )
    {
        strcpy(info_buffer, _("Could not find the specified server\n"));
        strcat(info_buffer, _("Try reselecting the server by doubleclicking on it.\n"));
        info_window=create_info_window();
        gtk_widget_show(info_window);
	fclose(fp);
	free(old_buffer);
	free(address_buffer);
	free(port_buffer);
	free(config);
	free(user_settings);
	free(UserUsername);
	free(AllowuserName);
	return;
    }


    /* Here we have collected everything up to  
     * <Virtualhost HOSTNAME>
     * Port PORT_NR */

    while(fgets(old_buffer, size_buffer, fp) !=NULL)
    {


        /* Skip the Allowuser line in the LIMIT context */
	if( strstr(old_buffer, AllowuserName) )
	  continue;

	/* If this is this users settings, dont copy it */
        if( strstr(old_buffer, "<Anonymous ") && ! user_deleted )
        {
            strcpy(user_settings, old_buffer);        


	    while(fgets(old_buffer, size_buffer, fp)!=NULL)
	    {
        	strcat(user_settings, old_buffer);

		/* Is this the settings to delete.. */
		if( strstr(old_buffer, UserUsername) && ! strstr(old_buffer, "DirFakeUser") )
		  user_deleted=1;
		
		if( strstr(old_buffer, "</Anonymous>") )
		  break;
	    }

	    /* Get every other users settings */	    
            if( ! user_deleted )
              strcat(config, user_settings);
        }
    	else
	  {
	     /* Delete extra whitespace between the users settings and
	      * get everything but the this users settings. */
	      
	     if( strlen(old_buffer)>3 )
	       strcat(config, old_buffer);
	  }
    } 	  
    fclose(fp);
    free(old_buffer);
    free(address_buffer);
    free(port_buffer);
    free(UserUsername);
    free(AllowuserName);
    free(user_settings);

    /* Write the new config without the deleted users settings */
    if((fp=fopen(GP_CONF, "w+"))==NULL)
    {
        printf("Error Writing configuration here: %s\n", GP_CONF);
        return;
    }
    fputs(config, fp);
    fclose(fp);
    free(config);

    /* Create the systemuser delete question window and insert the username */
    userdel_question_window=create_userdel_question_window();
    gtk_widget_show(userdel_question_window);
    userdel_question_window = lookup_widget(GTK_WIDGET(userdel_question_window), "userdel_question_window");
    userdel_question_entry = lookup_widget(GTK_WIDGET(userdel_question_window), "userdel_question_entry");
    gtk_entry_set_text(GTK_ENTRY(userdel_question_entry), username);
    /* Destroy the user settings window update the gui and reread */
    gtk_widget_destroy(user_settings_window);

    fix_newlines_in_conf();

    list_entire(userlist_treeview, NULL);
    list_users(userlist_treeview, NULL);
    if( online )
      system("killall -1 proftpd");
}


void
on_username_rand_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Randomize a username and put it in the username box.
     * Append the username to the default directorypath box.
     */
    GtkWidget *useradd_username_entry;
    GtkWidget *useradd_directory_entry;
    GtkWidget *useradd_incoming_directory_entry;
    gchar *utf8=NULL;
    char *dir, *ul_dir;
    char *username;
    username = allocate(8192);
    dir = allocate(8192);
    ul_dir = allocate(8192);

    random_string(username, global_username_randlen);

    /* Insert the username in the username box */
    utf8 = g_locale_to_utf8(username, strlen(username), NULL, NULL, NULL);
    useradd_username_entry = lookup_widget (GTK_WIDGET (button), "useradd_username_entry");
    gtk_entry_set_text(GTK_ENTRY(useradd_username_entry), utf8);


    /* Insert the root directorypath with the added username */

    /* Workaround for users that are upgrading */    


    /* Set the useradd root directory and the upload direcory */
    if( strlen(gp_useradd_root_path)>0 && strlen(gp_useradd_root_path)<8000 )
    {
       sprintf(dir, "%s/%s", gp_useradd_root_path, username); 
       sprintf(ul_dir, "%s", gp_useradd_upload_path); 
    }
    else
      {
         sprintf(dir, "%sftp/%s", USERSHOME, username); 
         sprintf(ul_dir, "/upload"); 
      }

    utf8 = g_locale_to_utf8(dir, strlen(dir), NULL, NULL, NULL);
    useradd_directory_entry = lookup_widget(GTK_WIDGET(button), "useradd_directory_entry");
    gtk_entry_set_text(GTK_ENTRY(useradd_directory_entry), utf8);
    free(username);

    utf8 = g_locale_to_utf8(ul_dir, strlen(ul_dir), NULL, NULL, NULL);
    useradd_incoming_directory_entry = lookup_widget(GTK_WIDGET(button), "useradd_incoming_directory_entry");
    gtk_entry_set_text(GTK_ENTRY(useradd_incoming_directory_entry), utf8);

    free(dir);
    if( utf8!=NULL )
      g_free(utf8);
    sleep(1);
}


void
on_password_rand_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Randomize a password and put it in the passwordbox */
    GtkWidget *useradd_password_entry;
    gchar *utf8=NULL;
    char *password;
    password = allocate(8192);
    random_string(password, global_password_randlen);
    utf8 = g_locale_to_utf8(password, strlen(password), NULL, NULL, NULL);
    free(password);
    useradd_password_entry = lookup_widget (GTK_WIDGET (button), "useradd_password_entry");
    gtk_entry_set_text(GTK_ENTRY(useradd_password_entry), utf8);
    if( utf8!=NULL )
      g_free(utf8);
    sleep(1);
}


void
on_userlist_treeview_row_activated     (GtkTreeView     *treeview,
                                        GtkTreePath     *arg1,
                                        GtkTreeViewColumn *arg2,
                                        gpointer         user_data)
{
    /* If a row in the userlist is doubleclicked show the user settings window and insert the values */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *user_settings_window;
    GtkWidget *settings_username_entry;
    GtkWidget *settings_group_entry;
    GtkWidget *settings_homedirectory_entry;
    GtkWidget *gplock_checkbutton;
    GtkWidget *banned_checkbutton;
    GtkWidget *settings_require_password_entry;
    GtkWidget *settings_max_logins_entry;
    GtkWidget *settings_max_logins_spinbutton;
    GtkWidget *settings_login_from_entry;
    GtkWidget *settings_uploaddirectory_entry;

    /* 19 different settings */
    GtkWidget *uldir_list_checkbutton; 		// LIST NLST
    GtkWidget *uldir_upload_checkbutton;	// STOR STOU
    GtkWidget *uldir_append_checkbutton;	// APPE
    GtkWidget *uldir_download_checkbutton;	// RETR
    GtkWidget *uldir_rename_checkbutton;	// RNFR RNTO
    GtkWidget *uldir_delete_checkbutton;	// DELE
    GtkWidget *uldir_createdir_checkbutton;	// MKD XMKD
    GtkWidget *uldir_removedir_checkbutton;	// RMD XRMD
    GtkWidget *uldir_site_checkbutton;		// SITE
    GtkWidget *uldir_chmod_checkbutton;		// SITE_CHMOD
    GtkWidget *uldir_chgrp_checkbutton;		// SITE_CHGRP
    GtkWidget *uldir_showdate_checkbutton;	// MDTM
    GtkWidget *uldir_showwd_checkbutton;	// PWD XPWD
    GtkWidget *uldir_showsize_checkbutton;	// SIZE
    GtkWidget *uldir_stat_checkbutton;		// STAT
    GtkWidget *uldir_changewd_checkbutton;	// CWD XCWD
    GtkWidget *uldir_cdup_checkbutton;		// CDUP XCUP
    GtkTreeIter iter;
    GtkTreeModel *list_store;
    GtkTreeViewColumn *user_column;
    GtkTreePath *path;
    G_CONST_RETURN gchar *username;
    gchar *utf8=NULL;
    char *new_buffer, *old_buffer, *user_buffer, *address_buffer, *port_buffer, *spinval, *translate;
    long size_buffer;
    int found=0, i=0, x=0, gplock=0;
    userlist_treeview = lookup_widget (GTK_WIDGET (treeview), "userlist_treeview");
    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(userlist_treeview));
    gtk_tree_view_get_cursor(GTK_TREE_VIEW(userlist_treeview), &path, &user_column);
    gtk_tree_model_get_iter(list_store, &iter, path);
    gtk_tree_model_get(list_store, &iter, 0, &username, -1);

    user_settings_window = create_user_settings_window();
    gtk_widget_show(user_settings_window);

    user_settings_window = lookup_widget (GTK_WIDGET (user_settings_window), "user_settings_window");
    settings_username_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_username_entry");
    settings_group_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_group_entry");
    settings_homedirectory_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_homedirectory_entry");
    gplock_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "gplock_checkbutton");
    banned_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "banned_checkbutton");
    settings_require_password_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_require_password_entry");
    settings_max_logins_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_max_logins_entry");
    settings_max_logins_spinbutton = lookup_widget (GTK_WIDGET (user_settings_window), "settings_max_logins_spinbutton");
    settings_login_from_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_login_from_entry");
    settings_uploaddirectory_entry = lookup_widget (GTK_WIDGET (user_settings_window), "settings_uploaddirectory_entry");
    uldir_list_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_list_checkbutton");
    uldir_upload_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_upload_checkbutton");
    uldir_append_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_append_checkbutton");
    uldir_download_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_download_checkbutton");
    uldir_rename_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_rename_checkbutton");
    uldir_delete_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_delete_checkbutton");
    uldir_createdir_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_createdir_checkbutton");
    uldir_removedir_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_removedir_checkbutton");
    uldir_chmod_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_chmod_checkbutton");
    uldir_chgrp_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_chgrp_checkbutton");
    uldir_stat_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_stat_checkbutton");
    uldir_showdate_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_showdate_checkbutton");
    uldir_showwd_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_showwd_checkbutton");
    uldir_showsize_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_showsize_checkbutton");
    uldir_changewd_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_changewd_checkbutton");
    uldir_site_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_site_checkbutton");
    uldir_cdup_checkbutton = lookup_widget (GTK_WIDGET (user_settings_window), "uldir_cdup_checkbutton");

    if ((fp = fopen(GP_CONF, "r")) == NULL)
    {
	strcpy(info_buffer, _("Error reading the configuration here:\n"));
	strcat(info_buffer, GP_CONF);
	strcat(info_buffer, "\n");
        info_window = create_info_window ();
        gtk_widget_show (info_window);       
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer);
    new_buffer = allocate(size_buffer);   
    user_buffer = allocate(4096);
    spinval = allocate(1024);
    address_buffer = allocate(8192);
    port_buffer = allocate(8192);

    /* Set the banned status */
    sprintf(user_buffer, "%s", username);
    if( is_banned(user_buffer) )
    {
       gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(banned_checkbutton), TRUE);
    }
    else
       gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(banned_checkbutton), FALSE);

    /* Dont match a similar user */
    sprintf(user_buffer, "User %s\n", username);


    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>\n", selected_server_address);
    }
    else
       sprintf(address_buffer, selected_server_address);
     
    sprintf(port_buffer, "Port %s\n", selected_server_port);


    /* Scroll to the selected vhost */
    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
	while(fgets(old_buffer, size_buffer, fp)!=NULL)
	{
	    /* If its the correct address */
	    if( ! strcmp(old_buffer, address_buffer) )
	    {
	       while(fgets(old_buffer, size_buffer, fp)!=NULL)
	       {
		  /* This server was not the right one */
		  if( strstr(old_buffer, "</VirtualHost>") )
		    break;
		 
		  if( ! strcmp(old_buffer, port_buffer) )
		  {
		     found=1;
	             break;
	          }
	       }
	    }

	    if( found )
	      break;
	}
    }


    /* we have scrolled to a vhost or just began at the top */

    found=0;

    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	/* Pick up all <Anonymous (with the the homedirectory) */
	if( strstr(old_buffer, "<Anonymous") )
          strcpy(new_buffer, old_buffer);

	if( strlen(old_buffer) > 8000 )
	{
	    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
	    info_window=create_info_window();
	    gtk_widget_show(info_window);
	    fclose(fp);
	    free(old_buffer);
	    free(new_buffer);
	    free(address_buffer);
	    free(port_buffer);
	    return;
	}

	/* We have found the right user .. insert the settings */
	if( ! strcmp(old_buffer, user_buffer) && ! strstr(old_buffer, "AllowUser")
        && ! strstr(old_buffer, "DenyUser") && ! strstr(old_buffer, "FakeUser") )
	{
    	    if( strlen(new_buffer)>5 )    
    	    {
		found=1;

		/* Ftp root directory */
		new_buffer[strlen(new_buffer)-2]='\0';
		utf8 = g_locale_to_utf8(&new_buffer[11], strlen(&new_buffer[11]), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(settings_homedirectory_entry), utf8);

		/* Username */
		sscanf(old_buffer, "%*s %s", new_buffer);
		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_entry_set_text(GTK_ENTRY(settings_username_entry), utf8);

		/* Insert all the standard vaules like user, group etc */
		while(fgets(old_buffer, size_buffer, fp)!=NULL)
		{
    		    if( strstr(old_buffer, "Group") && found ) 
    		    {
			sscanf(old_buffer, "%*s %s", new_buffer);
			utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    			gtk_entry_set_text(GTK_ENTRY(settings_group_entry), utf8);
    		    }

    		    if( strstr(old_buffer, "AnonRequirePassword") && found ) 
    		    {
			sscanf(old_buffer, "%*s %s", new_buffer);
			translate = allocate(1024);
			
			if( strstr(new_buffer, "on") )
			  sprintf(translate, _("yes"));
			else
			  sprintf(translate, _("no"));
			
			utf8 = g_locale_to_utf8(translate, strlen(translate), NULL, NULL, NULL);
        		gtk_entry_set_text(GTK_ENTRY(settings_require_password_entry), utf8);
			free(translate);
    		    }
    		    if( strstr(old_buffer, "MaxClients") && found )
    		    {
			for(x=0; old_buffer[x]!='\0'; x++)
			{
	    	    	   if( old_buffer[x]=='"' )
		    	     break;
			}
			x++;
			if( old_buffer[x]!='\0' )
	    	          sprintf(new_buffer, "%s", &old_buffer[x]);
			for(x=0; new_buffer[x]!='\0'; x++)
			{
	    	    	    if( new_buffer[x]=='"' )
	    	    	    {
				new_buffer[x]='\0';
				break;
		    	    }
			}
			utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    			gtk_entry_set_text(GTK_ENTRY(settings_max_logins_entry), utf8);
			sscanf(old_buffer, "%*s %s", spinval);
			utf8 = g_locale_to_utf8(spinval, strlen(spinval), NULL, NULL, NULL);
        		gtk_entry_set_text(GTK_ENTRY(settings_max_logins_spinbutton), utf8);
    		    }
    		    if( strstr(old_buffer, "Allow from") && found )
    		    {
        		strcpy(new_buffer, old_buffer);
			for(i=0; new_buffer[i]!='\0'; i++)
			{
			    if( new_buffer[i-2]=='m' )
			    {
				new_buffer[strlen(new_buffer)-1]='\0';
				utf8 = g_locale_to_utf8(&new_buffer[i], strlen(&new_buffer[i]), NULL, NULL, NULL);
        			gtk_entry_set_text(GTK_ENTRY(settings_login_from_entry), utf8);
				break;
			    }
			    if( i>100 )
		    	      break;
			}	    
    		    }



// FIXME
		    /* Upload directory .. List any added directory here */
		    if( strstr(old_buffer, "<Directory ") && found )
		    {
        		strcpy(new_buffer, old_buffer);
			for(i=0; new_buffer[i]!='\0'; i++)
			{
	    		    /* "y " */
			    if( new_buffer[i-2]=='y' )
			    {
				new_buffer[strlen(new_buffer)-2]='\0';
				utf8 = g_locale_to_utf8(&new_buffer[i], strlen(&new_buffer[i]), NULL, NULL, NULL);
    				gtk_entry_set_text(GTK_ENTRY(settings_uploaddirectory_entry), utf8);
				break;
			    }
			    if( i>100 )
		    	      break;
			}	    
		    }
		    if( strstr(old_buffer, "UPLOAD_DIR_ALLOW") && found )
		    {
			if( strstr(old_buffer, "LIST") && strstr(old_buffer, "NLST") )
	    		  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_list_checkbutton), TRUE);
			if( strstr(old_buffer, "STOR") && strstr(old_buffer, "STOU") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_upload_checkbutton), TRUE);
			if( strstr(old_buffer, "APPE") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_append_checkbutton), TRUE);
			if( strstr(old_buffer, "RETR") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_download_checkbutton), TRUE);
			if( strstr(old_buffer, "RNFR") && strstr(old_buffer, "RNTO") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_rename_checkbutton), TRUE);
			if( strstr(old_buffer, "DELE") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_delete_checkbutton), TRUE);
			if( strstr(old_buffer, "MKD") && strstr(old_buffer, "XMKD") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_createdir_checkbutton), TRUE);
			if( strstr(old_buffer, "RMD") && strstr(old_buffer, "XRMD") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_removedir_checkbutton), TRUE);
			if( strstr(old_buffer, "SITE_CHMOD") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_chmod_checkbutton), TRUE);
			if( strstr(old_buffer, "SITE_CHGRP") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_chgrp_checkbutton), TRUE);
			if( strstr(old_buffer, "SITE") ) /* dont match SITE_CHMOD or SITE_CHGRP */
			{
	    		    for(x=0; old_buffer[x]!='\0'; x++)
	    		    {
	    			if( old_buffer[x]=='\0' || old_buffer[x+1]=='\0' || old_buffer[x+2]=='\0' || old_buffer[x+3]=='\0' || old_buffer[x+4]=='\0' )
				  break;
				if( old_buffer[x]=='S' && old_buffer[x+1]=='I' && old_buffer[x+2]=='T' && old_buffer[x+3]=='E' && old_buffer[x+4]==' ' )
				{
	    			    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_site_checkbutton), TRUE);
				    break;
				}
	    		    }
			}
			if( strstr(old_buffer, "MDTM") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_showdate_checkbutton), TRUE);
			/* Cant strstr PWD for some reason ! */
			if( strstr(old_buffer, "WD") ) /* PWD and XPWD */
			{
	    		    for(x=0; old_buffer[x]!='\0'; x++)
	    		    {
	    			if( old_buffer[x]=='\0' || old_buffer[x+1]=='\0' || old_buffer[x+2]=='\0' )
				  break;
				if( old_buffer[x]=='P' && old_buffer[x+1]=='W' && old_buffer[x+2]=='D' )
				{
	    			    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_showwd_checkbutton), TRUE);
				    break;
				}
	    		    }
			}
			if( strstr(old_buffer, "SIZE") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_showsize_checkbutton), TRUE);
			if( strstr(old_buffer, "STAT") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_stat_checkbutton), TRUE);
			if( strstr(old_buffer, "CWD") && strstr(old_buffer, "XCWD") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_changewd_checkbutton), TRUE);
			if( strstr(old_buffer, "CDUP") && strstr(old_buffer, "XCUP") )
	        	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(uldir_cdup_checkbutton), TRUE);
		    }
		    if( strstr(old_buffer, "#gplockstats") && found )
		      gplock=1;
		
		    /* The user has been listed .. break */
		    if( strstr(old_buffer, "</Anonymous") )
		      break;
		}
	    }
	}
	
	if( found )
	  break;
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    free(user_buffer);
    free(spinval);
    gtk_tree_path_free(path);
    
    /* Set the gplock checkbutton state (overwrite welcome.msg or not) */
    if( gplock )
    {
         gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(gplock_checkbutton), FALSE);
    }
    else
      {
         gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(gplock_checkbutton), TRUE);
      }

    /* Destroy the user_settings_window and show an error message if a user could not be found */
    if( ! found )
    {
	gtk_widget_destroy(user_settings_window);    
	sprintf(info_buffer, _("The user could not be found, this is a bug or %s has errors.\n"), GP_CONF);
	strcat(info_buffer, _("run a syntax check to find out if there are any problems.\n"));
	info_window=create_info_window();
	gtk_widget_show(info_window);
    }

    if( utf8!=NULL )
      g_free(utf8);
}


void
on_user_settings_change_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Change the users settings and reduce empty lines */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *user_settings_window;
    GtkWidget *settings_username_entry;
    GtkWidget *settings_group_entry;
    GtkWidget *settings_require_password_entry;
    GtkWidget *settings_password_entry;
    GtkWidget *settings_homedirectory_entry;
    GtkWidget *settings_max_logins_spinbutton;
    GtkWidget *settings_max_logins_entry;
    GtkWidget *settings_login_from_entry;
    GtkWidget *settings_uploaddirectory_entry;
    GtkWidget *gplock_checkbutton;
    GtkWidget *banned_checkbutton;
    GtkWidget *uldir_list_checkbutton; 		// LIST NLST
    GtkWidget *uldir_upload_checkbutton;	// STOR STOU
    GtkWidget *uldir_append_checkbutton;	// APPE
    GtkWidget *uldir_download_checkbutton;	// RETR
    GtkWidget *uldir_rename_checkbutton;	// RNFR RNTO
    GtkWidget *uldir_delete_checkbutton;	// DELE
    GtkWidget *uldir_createdir_checkbutton;	// MKD XMKD
    GtkWidget *uldir_removedir_checkbutton;	// RMD XRMD
    GtkWidget *uldir_site_checkbutton;		// SITE
    GtkWidget *uldir_chmod_checkbutton;		// SITE_CHMOD
    GtkWidget *uldir_chgrp_checkbutton;		// SITE_CHGRP
    GtkWidget *uldir_showdate_checkbutton;	// MDTM
    GtkWidget *uldir_showwd_checkbutton;	// PWD XPWD
    GtkWidget *uldir_showsize_checkbutton;	// SIZE
    GtkWidget *uldir_stat_checkbutton;		// STAT
    GtkWidget *uldir_changewd_checkbutton;	// CWD XCWD
    GtkWidget *uldir_cdup_checkbutton;		// CDUP XCUP

    /* This should be renamed... */
    GtkWidget *combo17; /* require password on off */

    G_CONST_RETURN gchar *password;
    G_CONST_RETURN gchar *username;
    G_CONST_RETURN gchar *group;
    G_CONST_RETURN gchar *upload_directory;
    G_CONST_RETURN gchar *root_directory;
    G_CONST_RETURN gchar *max_clients_number;
    G_CONST_RETURN gchar *max_clients_text;
    G_CONST_RETURN gchar *login_from;

    char *old_buffer, *config, *anon_dir, *root_dir, *upload_dir;
    char *banned_user, *temp_user, *address_buffer, *port_buffer;
    long size_buffer;
    int length=0, end=0, found=0;
    char UserUsername[4096]="";

    user_settings_window = lookup_widget(GTK_WIDGET(button), "user_settings_window");
    settings_password_entry = lookup_widget(GTK_WIDGET(button), "settings_password_entry");
    settings_username_entry = lookup_widget(GTK_WIDGET(button), "settings_username_entry");
    settings_group_entry = lookup_widget(GTK_WIDGET(button), "settings_group_entry");
    settings_require_password_entry = lookup_widget(GTK_WIDGET(button), "settings_require_password_entry");
    settings_homedirectory_entry = lookup_widget(GTK_WIDGET(button), "settings_homedirectory_entry");
    gplock_checkbutton = lookup_widget(GTK_WIDGET(button), "gplock_checkbutton");
    banned_checkbutton = lookup_widget(GTK_WIDGET(button), "banned_checkbutton");
    settings_max_logins_spinbutton = lookup_widget(GTK_WIDGET(button), "settings_max_logins_spinbutton");
    settings_max_logins_entry = lookup_widget(GTK_WIDGET(button), "settings_max_logins_entry");
    settings_login_from_entry = lookup_widget(GTK_WIDGET(button), "settings_login_from_entry");
    settings_uploaddirectory_entry = lookup_widget(GTK_WIDGET(button), "settings_uploaddirectory_entry");
    uldir_list_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_list_checkbutton");
    uldir_upload_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_upload_checkbutton");
    uldir_append_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_append_checkbutton");
    uldir_download_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_download_checkbutton");
    uldir_rename_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_rename_checkbutton");
    uldir_delete_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_delete_checkbutton");
    uldir_createdir_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_createdir_checkbutton");
    uldir_removedir_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_removedir_checkbutton");
    uldir_chmod_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_chmod_checkbutton");
    uldir_chgrp_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_chgrp_checkbutton");
    uldir_stat_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_stat_checkbutton");
    uldir_showdate_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_showdate_checkbutton");
    uldir_showwd_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_showwd_checkbutton");
    uldir_showsize_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_showsize_checkbutton");
    uldir_changewd_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_changewd_checkbutton");
    uldir_site_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_site_checkbutton");
    uldir_cdup_checkbutton = lookup_widget(GTK_WIDGET(button), "uldir_cdup_checkbutton");

    /* Require password yes no */
    combo17 = lookup_widget(GTK_WIDGET(button), "combo17");

    password = gtk_entry_get_text(GTK_ENTRY(settings_password_entry));
    length = strlen(password);

    /* If the user has written a password thats too short */
    if( length < 6 && length > 0 )
    {
       strcpy(info_buffer, _("\nThe minimum password length is 6 chars.\n"));
       info_window = create_info_window ();
       gtk_widget_show (info_window);
       return;
    }

    username = gtk_entry_get_text(GTK_ENTRY(settings_username_entry));
    root_directory = gtk_entry_get_text(GTK_ENTRY(settings_homedirectory_entry));
    upload_directory = gtk_entry_get_text(GTK_ENTRY(settings_uploaddirectory_entry));

    root_dir = allocate(8192);        
    upload_dir = allocate(8192);        

    strcpy(root_dir, root_directory);
    strcpy(upload_dir, upload_directory);

    /* If the user has written a new acceptable password and this user exists */
    if( length >= 6 )
    {
	password = gtk_entry_get_text(GTK_ENTRY(settings_password_entry));

#ifndef USE_DARWIN
	if( user_exists(username) )
#elif USE_DARWIN
	if( niutil_user_exists(username) )
#endif
	{
	    /* Should be checked more carefully but it was most likely changed */
#ifndef USE_DARWIN
	    password_user(username, password);
#elif USE_DARWIN
	    niutil_password_user(username, password);
#endif
    	    strcpy(info_buffer, _("\nThe Password was changed.\n"));
    	    info_window = create_info_window ();
    	    gtk_widget_show (info_window);
	}
	else
	    {
		strcpy(info_buffer, _("The password was not changed.\n"));
		strcat(info_buffer, _("The user didnt exist in shadow or passwd.\n"));
        	info_window = create_info_window ();
        	gtk_widget_show (info_window);
	    }
    }

    strcpy(UserUsername, "User ");
    strcat(UserUsername, username);
    /* Avoiding a similar user match */
    strcat(UserUsername, "\n");

    address_buffer = allocate(8192+15);

    port_buffer = allocate(8192+3);               

    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
       sprintf(address_buffer, "<VirtualHost %s>\n", selected_server_address);
    }
    else
       sprintf(address_buffer, selected_server_address);
     
    sprintf(port_buffer, "Port %s\n", selected_server_port);


    /* Make changes for this users settings */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
        strcpy(info_buffer, _("\nCant open proftpd.conf\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	free(address_buffer); free(port_buffer);
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    anon_dir = allocate(8192);        
    /* +16384 for directives added by gproftpd since the last upgrade */
    config = allocate(size_buffer+16384);
    old_buffer = allocate(size_buffer+4096);        

    /* If the selected server is a vhost we collect everything 
       up to the first vhost with the same name as the selected one */

    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
	while(fgets(old_buffer, size_buffer, fp)!=NULL)
	{
	    strcat(config, old_buffer);
	    
	    /* If its the correct address */
	    if( ! strcmp(old_buffer, address_buffer) )
	    {
	       while(fgets(old_buffer, size_buffer, fp)!=NULL)
	       {
		  strcat(config, old_buffer);
		 
		  /* This server was not the right one */
		  if( strstr(old_buffer, "</VirtualHost>") )
		    break;
		 
		  if( ! strcmp(old_buffer, port_buffer) )
		  {
		     found=1;
	             break;
	          }
	       }
	    }

	    if( found )
	      break;
	}
    }


    /* This will change the selected users settings */
    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	end=0;
	if( strstr(old_buffer, "<Anonymous ") )
	{
	    /* A space between the users settings */
	    strcat(config, "\n");
	    /* Current directory */
	    strcpy(anon_dir, old_buffer);
		    
	    while(fgets(old_buffer, size_buffer, fp)!=NULL)
	    {
		/* Detecting the right user ..... */
        	if( strstr(old_buffer, UserUsername) && ! strstr(old_buffer, "AllowUser") && ! strstr(old_buffer, "DirFakeUser") )
        	{
	    	    strcat(config, "<Anonymous ");
	    	    strcat(config, root_dir);
            	    strcat(config, ">\n");
	    	    strcat(config, UserUsername);

		    while(fgets(old_buffer, size_buffer,fp)!=NULL)
		    {
			if( strstr(old_buffer, "Group ") )
			{
            		    strcat(config, "Group ");
            		    strcat(config, group = gtk_entry_get_text(GTK_ENTRY(settings_group_entry)));
	    		    strcat(config, "\n");
			}
			else
			if( strstr(old_buffer, "AnonRequirePassword ") )
			{
            		    strcat(config, "AnonRequirePassword ");

			    if( combo_selection(combo17) == 0 )
	    		      strcat(config, "on\n");
	    		    else
			      strcat(config, "off\n");
			}
			else
			if( strstr(old_buffer, "#gplockstats") ) 
			{
			    /* Deleted this line from the conf */
			}
			else
			if( strstr(old_buffer, "MaxClients ") )
			{
	    		    strcat(config, "MaxClients ");
	    		    strcat(config, max_clients_number = gtk_entry_get_text(GTK_ENTRY(settings_max_logins_spinbutton)));
	    		    strcat(config, " \"");
	    		    strcat(config, max_clients_text = gtk_entry_get_text(GTK_ENTRY(settings_max_logins_entry)));
	    		    strcat(config, "\"\n");
			}
			else
			if( strstr(old_buffer, "Allow from ") )
			{
            		    strcat(config, " Allow from ");
	    		    login_from = gtk_entry_get_text(GTK_ENTRY(settings_login_from_entry));
			    if( strlen(login_from)==0 )
			    {
				strcat(config, "none\n");
			    }
			    else
			    {
	    			strcat(config, login_from);
	    			strcat(config, "\n");
			    }
			}
			else	/* The first directory it finds (upload) */
			if( strstr(old_buffer, "<Directory ") && strlen(upload_dir)>0 )
			{
			    strcat(config, "<Directory ");
			    strcat(config, upload_dir);
			    strcat(config, ">\n");
			}
			else
			if( strstr(old_buffer, "UPLOAD_DIR_ALLOW") )
			{
			    strcat(config, "<Limit UPLOAD_DIR_ALLOW");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_list_checkbutton)) ) 
			    strcat(config, " LIST NLST ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_upload_checkbutton)) ) 
			    strcat(config, " STOR STOU ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_append_checkbutton)) ) 
			    strcat(config, " APPE ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_download_checkbutton)) ) 
			    strcat(config, " RETR ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_rename_checkbutton)) ) 
			    strcat(config, " RNFR RNTO ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_delete_checkbutton)) ) 
			    strcat(config, " DELE ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_createdir_checkbutton)) ) 
			    strcat(config, " MKD XMKD ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_removedir_checkbutton)) ) 
			    strcat(config, " RMD XRMD ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_chmod_checkbutton)) ) 
			    strcat(config, " SITE_CHMOD ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_chgrp_checkbutton)) ) 
			    strcat(config, " SITE_CHGRP ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_stat_checkbutton)) ) 
			    strcat(config, " STAT ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_showdate_checkbutton)) ) 
			    strcat(config, " MDTM ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_showwd_checkbutton)) ) 
			    strcat(config, " PWD XPWD ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_showsize_checkbutton)) ) 
			    strcat(config, " SIZE ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_changewd_checkbutton)) ) 
			    strcat(config, " CWD XCWD ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_cdup_checkbutton)) ) 
			    strcat(config, " CDUP XCUP ");
			    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_site_checkbutton)) ) 
			    strcat(config, " SITE ");

			    strcat(config, ">\n");
			}
			else
			if( strstr(old_buffer, "UPLOAD_DIR_DENY") )
			{
			    strcat(config, "<Limit UPLOAD_DIR_DENY");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_list_checkbutton)) ) 
			    strcat(config, " LIST NLST ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_upload_checkbutton)) ) 
			    strcat(config, " STOR STOU ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_append_checkbutton)) ) 
			    strcat(config, " APPE ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_download_checkbutton)) ) 
			    strcat(config, " RETR ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_rename_checkbutton)) ) 
			    strcat(config, " RNFR RNTO ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_delete_checkbutton)) ) 
			    strcat(config, " DELE ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_createdir_checkbutton)) ) 
			    strcat(config, " MKD XMKD ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_removedir_checkbutton)) ) 
			    strcat(config, " RMD XRMD ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_chmod_checkbutton)) ) 
			    strcat(config, " SITE_CHMOD ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_chgrp_checkbutton)) ) 
			    strcat(config, " SITE_CHGRP ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_stat_checkbutton)) ) 
			    strcat(config, " STAT ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_showdate_checkbutton)) ) 
			    strcat(config, " MDTM ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_showwd_checkbutton)) ) 
			    strcat(config, " PWD XPWD ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_showsize_checkbutton)) ) 
			    strcat(config, " SIZE ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_changewd_checkbutton)) ) 
			    strcat(config, " CWD XCWD ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_cdup_checkbutton)) ) 
			    strcat(config, " CDUP XCUP ");
			    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uldir_site_checkbutton)) ) 
			    strcat(config, " SITE ");
			    strcat(config, ">\n");
			}
			else
			if( strlen(old_buffer) > 3 && ! strstr(old_buffer, "</Anonymous>") )
			{
			   /* Getting every user settings thats not the end </Anonymous> */
			   strcat(config, old_buffer);
			}

			if( strstr(old_buffer, "</Anonymous>") )
			{
			    /* Add the locked statistics flag to the users settings */
		    	    if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gplock_checkbutton)) )
			      strcat(config, "#gplockstats\n");
			    /* Get the end of the settings </Anonymous> */
			    strcat(config, old_buffer);
			    
	    		    /* Get everything else in the configuration */
			    while(fgets(old_buffer, size_buffer, fp)!=NULL)
			      strcat(config, old_buffer);
			}
		    }
		}
		else
		{
		    /* Copy the entire users settings (this is not the one to change) */
		    strcat(config, anon_dir);
		    strcat(config, old_buffer);
		    while(fgets(old_buffer, size_buffer, fp)!=NULL)
		    {
		        /* Get everything else */
			strcat(config, old_buffer);
			if( strstr(old_buffer, "</Anonymous>") )
			{
			    end=1;
		    	    break;
			}
		    }			
		} 	
	    
	    	if( end )
		break;       
	    }
	}
	else
	  {
	      /* Get everything that isnt a users settings or an empty line */
	      if( strlen(old_buffer) > 3 ) 
	        strcat(config, old_buffer); 
	  }
    }
    free(anon_dir);
    free(old_buffer);
    fclose(fp);


    /* Make the directories for this user */
    fix_path(root_dir);

    make_directory(root_dir, "0755");
    
    if( strlen(upload_dir)>0 )
    {
	fix_path(upload_dir);
	make_directory(upload_dir, "0777");
    }

    if( root_dir!=NULL )
	free(root_dir);

    if( upload_dir!=NULL )
	free(upload_dir);


    /* Write the new config with the changed users settings and update widget values */
    if((fp=fopen(GP_CONF, "w+"))==NULL) 
    {
	free(config);
	free(address_buffer); free(port_buffer);
        return;
    }
    fputs(config, fp);
    fclose(fp);
    free(config);

    /* We do any unbanning last for security */
    banned_user = allocate(8192);        
    sprintf(banned_user, "%s", username);
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(banned_checkbutton)) ) 
    {
	/* Ban the user */
	if( ! is_banned(banned_user) )
	{
	    if((fp=fopen(GP_FTPUSERS, "a"))==NULL) 
	    {
	    }
	    else
	      {
		 fputs("\n", fp);
		 fputs(username, fp);
		 fputs("\n", fp);
		 fclose(fp);
	      }
	}
    }
    else
      {
         /* Remove the banned user from ftpusers */
         if( is_banned(banned_user) )
	 {
	    if((fp=fopen(GP_FTPUSERS, "r"))==NULL) 
	    {
	    }
	    else
	      {
	         fseek(fp, 0, SEEK_END);
	         size_buffer=ftell(fp);
	         rewind(fp);
	         config = allocate(size_buffer+4096);        
	         old_buffer = allocate(size_buffer+4096);        
		 temp_user = allocate(8192);
		 while(fgets(old_buffer, size_buffer, fp)!=NULL)
		 {
		    sscanf(old_buffer, "%s", temp_user);
		    if( ! strcmp(temp_user, banned_user) )
		    {
		    }
		    else
	    	      strcat(config, old_buffer);
		 }			
		 fclose(fp);
		 free(old_buffer);
		 free(temp_user);

		 if((fp=fopen(GP_FTPUSERS, "w+"))==NULL) 
		 {
		 }
		 else
	           {
		      fputs(config, fp);
		      fclose(fp);
		   }
		 free(config);
	      }
	 }
      }    
    
      free(banned_user);
      free(address_buffer); 
      free(port_buffer);

      fix_newlines_in_conf();

      list_users(userlist_treeview, NULL);
      list_entire(userlist_treeview, NULL);
      gtk_widget_destroy(user_settings_window);

      if( online )
        system("killall -1 proftpd");
}


void
on_restore_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Ask what file(date) to restore (later) */
    GtkWidget *userlist_treeview;
    GtkWidget *entire_textview;
    char restore[16384]="";
    sprintf(restore, "cp %s/proftpd.conf %s/", GP_APPCONFDIR, GP_SYSCONFDIR);
    system(restore);
    userlist_treeview = lookup_widget (GTK_WIDGET (button), "userlist_treeview");
    entire_textview = lookup_widget (GTK_WIDGET (button), "entire_textview");
    list_servers(userlist_treeview, NULL);
    list_users(userlist_treeview, NULL);
    list_server_values(userlist_treeview, NULL);
    list_entire(entire_textview, NULL);
}


void
on_backup_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Set date/time */
    char backup[16384]="";
    sprintf(backup, "cp %s %s/", GP_CONF, GP_APPCONFDIR);
    system(backup); 
}


void
on_syntaxcheck_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    FILE *fp;
    GtkWidget *info_window;
    char *check_buffer;
    char check[8192]="";
    sprintf(check, "proftpd -tc %s 2>&1", GP_CONF);
    if((fp=popen(check, "r"))==NULL)
    {
       perror("popen");
       strcpy(info_buffer, "Cant open proftpd.conf\n");
       info_window = create_info_window ();
       gtk_widget_show (info_window);       
       return;
    }
    fflush(fp);
    check_buffer = allocate(8192);
    while (fgets(check_buffer, 8192, fp)!=NULL)
    {
    }
    strcpy(info_buffer, _("If there are no complaints the configuration is ok...\n\n"));
    strcat(info_buffer, check_buffer);
    strcat(info_buffer, _("\nCheck completed."));
    pclose(fp);
    free(check_buffer);
    info_window=create_info_window();
    gtk_widget_show(info_window);
}


void
on_save_entire_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Save entire */
    FILE *fp;
    GtkWidget *entire_textview;
    GtkWidget *userlist_treeview;
    GtkWidget *info_window;
    GtkTextBuffer *entire_config_text_buffer;
    GtkTextIter start, end;
    gchar *config_buffer=NULL;
    entire_textview = lookup_widget (GTK_WIDGET (button), "entire_textview");
    entire_config_text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(entire_textview));
    gtk_text_buffer_get_bounds(entire_config_text_buffer, &start, &end);
    config_buffer = gtk_text_iter_get_text(&start, &end);
    /* Stick it in proftpd.conf */
    if((fp = fopen(GP_CONF, "w+"))==NULL)
    {
       sprintf(info_buffer, _("Cant write to proftpd.conf here: \n%s\n"), GP_CONF);
       info_window=create_info_window();
       gtk_widget_show(info_window);       
       return;
    }
    
    fputs(config_buffer, fp);
    fclose(fp);
    /* Update the global tab, userlist, and the entire tab */
    userlist_treeview = lookup_widget (GTK_WIDGET (button), "userlist_treeview");
    entire_textview = lookup_widget (GTK_WIDGET (button), "entire_textview");

    list_servers(userlist_treeview, NULL);
    list_users(userlist_treeview, NULL);
    list_entire(entire_textview, NULL);
    list_server_values(entire_textview, NULL);

    if(config_buffer !=NULL)
      g_free(config_buffer);
    /* Dont reread so it can be syntax checked before deployed */
}


void
on_disc_update_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
   list_disc(userlist_treeview, NULL);
}


void
on_files_clear_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    FILE *fp;
    if((fp=fopen(GP_XFERLOG, "w+"))==NULL)
    {
       return;
    }
    fclose(fp);
    list_files(userlist_treeview, NULL);
}


void
on_files_update_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
    list_files(userlist_treeview, NULL);
}


void
on_security_update_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    list_secure(userlist_treeview, NULL);
}


void
on_kick_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Kick a user by name or pid */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *kick_entry;
    char *get_buffer, *kick_name, *kick_pid, *kick;
    int user_kick=0, pid_kick=0;
    G_CONST_RETURN gchar *username;
    kick_entry = lookup_widget (GTK_WIDGET (button), "kick_entry");
    username = gtk_entry_get_text(GTK_ENTRY(kick_entry));

    if( ! online )
      return;
    
    if( strlen(username)==0 )
    {
	strcpy(info_buffer, _("You must specify a username or process number.\n"));
	info_window = create_info_window();
        gtk_widget_show(info_window);
	return;
    }

    /* Get users pid and name */
    if((fp=popen("ftpwho -v", "r"))==NULL)
    {
	strcpy(info_buffer, _("popen error, user not kicked\n"));
        info_window = create_info_window();
        gtk_widget_show(info_window);
	return;
    }
    fflush(fp);
    kick_name = allocate(4096);
    kick_pid = allocate(4096);

    get_buffer = allocate(MAX_READ_POPEN+1);
    while(fgets(get_buffer, MAX_READ_POPEN, fp)!=NULL)
    {
	kick_pid[0]='\0'; kick_name[0]='\0';
	sscanf(get_buffer, "%s %s", kick_pid, kick_name);

	if( kick_name[strlen(kick_name)-1]=='\n' || kick_name[strlen(kick_name)-1]=='\r' )
	  kick_name[strlen(kick_name)-1]='\0';

	/* kill this user by name */
	if( ! strcmp(username, kick_name) && is_digitz(kick_pid) )
	{
	    user_kick=1;
	    break;
	}
	/* Kill this user by pid (supplied number is the same as any left most word in the output) */
	if( ! strcmp(username, kick_pid) && is_digitz(kick_pid)  )
	{
	    pid_kick=1;
	    break;
	}	
    }
    pclose(fp);
    free(get_buffer);
    free(kick_name);


    if( user_kick )
    {
	/* Kill the the users pid */
	kick = allocate(8192);
	sprintf(kick, "kill -15 %s", kick_pid);
	system(kick);
	free(kick);
    }
    else
    if( pid_kick )
    {
	/* Kill the the users pid */
	kick = allocate(8192);
	sprintf(kick, "kill -15 %s", username);
	system(kick);
	free(kick);
    }
    else
      {
	  strcpy(info_buffer, _("User or pid not found.\n"));
	  info_window = create_info_window();
          gtk_widget_show(info_window);
      }
    free(kick_pid);
}


void
on_kickban_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    /* ban a user then kick by name or pid */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *kick_entry;
    char *get_buffer, *kick_name, *kick_pid, *kick;
    int user_kick=0, pid_kick=0, was_kicked=0, was_banned=0;
    G_CONST_RETURN gchar *username;
    kick_entry = lookup_widget (GTK_WIDGET (button), "kick_entry");
    username = gtk_entry_get_text(GTK_ENTRY(kick_entry));
    
    if( strlen(username)==0 )
    {
	strcpy(info_buffer, _("You must specify a username or process number.\n"));
	info_window = create_info_window();
        gtk_widget_show(info_window);
	return;
    }

    kick_name = allocate(4096);
    kick_pid = allocate(4096);

    if( online )
    {
       /* Get users pid and name */
       if((fp=popen("ftpwho -v", "r"))==NULL)
       {
	  strcpy(info_buffer, _("popen error, user not kicked or banned.\n"));
          info_window = create_info_window();
          gtk_widget_show(info_window);
	  return;
       }
       fflush(fp);

       get_buffer = allocate(MAX_READ_POPEN+1);
       while(fgets(get_buffer, MAX_READ_POPEN, fp)!=NULL)
       {
	  kick_pid[0]='\0'; kick_name[0]='\0';
	  sscanf(get_buffer, "%s %s", kick_pid, kick_name);

	  if( kick_name[strlen(kick_name)-1]=='\n' || kick_name[strlen(kick_name)-1]=='\r' )
	    kick_name[strlen(kick_name)-1]='\0';

	  /* kill this user by name */
	  if( ! strcmp(username, kick_name) && is_digitz(kick_pid) )
	  {
	     user_kick=1;
	     break;
	  }
	  /* Kill this user by pid */
	  if( ! strcmp(username, kick_pid) && is_digitz(kick_pid)  )
	  {
	     pid_kick=1;
	     break;
	  }	
       }
       pclose(fp);
       free(get_buffer);
    }


    /* Put the user in ftpusers if its not banned already or is a pid */
    if( ! is_banned((char *)username) )
    {
	if((fp=fopen(GP_FTPUSERS, "a"))==NULL)
	{
	    sprintf(info_buffer, _("The user was not banned, could not write to:\n%s"), GP_FTPUSERS);
	    info_window = create_info_window();
    	    gtk_widget_show(info_window);
	}
	else
	  if( user_kick || pid_kick )
	  {
	     fputs("\n", fp);
	     fputs(kick_name, fp);
	     fclose(fp);
	     was_banned=1;
	  }
	  else
	    if( ! is_digitz((char *)username) )
	    {
	       fputs("\n", fp);
	       fputs(username, fp);
	       fclose(fp);
	       was_banned=1;       
	    }
	    else
	      {
        	 strcpy(info_buffer, _("Cant ban a non active user by PID.\n"));
        	 strcat(info_buffer, _("Misspelled maybe ?\n"));
        	 info_window = create_info_window();
        	 gtk_widget_show(info_window);
		 fclose(fp);
	      }
    }
    else
      if( is_banned((char *)username) && ! is_digitz((char *)username) )
      { 
         strcpy(info_buffer, _("The user was already banned.\n"));
         info_window = create_info_window();
         gtk_widget_show(info_window);
      }


    free(kick_name);


    if( user_kick || pid_kick )
    {
	/* Kill the the users pid */
	kick = allocate(8192);
	sprintf(kick, "kill -15 %s", kick_pid);
	system(kick);
	free(kick);
	was_kicked=1;
    }

    /* We want to be notified of additional success or failiure here */
    if( was_banned && ! was_kicked )
    {
        strcpy(info_buffer, _("The user was not currently in the ftp.\n"));
	strcat(info_buffer, _("The user was banned but not kicked.\n"));
	info_window = create_info_window();
        gtk_widget_show(info_window);
    }
    else
    if( was_banned && was_kicked )
    {
	strcpy(info_buffer, _("The user was kicked and banned.\n"));
	info_window = create_info_window();
        gtk_widget_show(info_window);
    }
      
    free(kick_pid);
    list_users(userlist_treeview, NULL);
}


void
on_shutdown_ok_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Shutdown the server */
    FILE *shutdown_file;
    char *shutdown;
    GtkWidget *shutdown_window;
    GtkWidget *new_acc_disabled_entry;
    GtkWidget *exist_users_dc_entry;
    GtkWidget *real_shutdown_entry;
    GtkWidget *shutdown_msg1_entry;
    G_CONST_RETURN gchar *get_new_login_disable;
    G_CONST_RETURN gchar *get_exist_user_disconnect;
    G_CONST_RETURN gchar *get_real_shutdown_entry;
    G_CONST_RETURN gchar *get_msg1;
    shutdown_window = lookup_widget (GTK_WIDGET (button), "shutdown_window");
    new_acc_disabled_entry = lookup_widget (GTK_WIDGET (button), "new_acc_disabled_entry");
    exist_users_dc_entry = lookup_widget (GTK_WIDGET (button), "exist_users_dc_entry");
    real_shutdown_entry = lookup_widget (GTK_WIDGET (button), "real_shutdown_entry");
    shutdown_msg1_entry = lookup_widget (GTK_WIDGET (button), "shutdown_msg1_entry");
    get_new_login_disable = gtk_entry_get_text(GTK_ENTRY(new_acc_disabled_entry));
    get_exist_user_disconnect = gtk_entry_get_text(GTK_ENTRY(exist_users_dc_entry));
    get_real_shutdown_entry = gtk_entry_get_text(GTK_ENTRY(real_shutdown_entry));
    get_msg1 = gtk_entry_get_text(GTK_ENTRY(shutdown_msg1_entry));
    shutdown = allocate(8192);
    strcpy(shutdown, "ftpshut -l ");
    strcat(shutdown, get_new_login_disable);
    strcat(shutdown, " -d ");
    strcat(shutdown, get_exist_user_disconnect);
    strcat(shutdown, " ");
    strcat(shutdown, get_real_shutdown_entry);
    strcat(shutdown, " \"");
    strcat(shutdown, get_msg1);
    strcat(shutdown, "\"");
    shutdown_file = popen(shutdown,"r");
    pclose(shutdown_file);    
    free(shutdown);
    gtk_widget_hide(shutdown_window);
}


void
on_userdir_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    /* If the directory button in the usertab is pressed show a fileselection */
    GtkWidget *userdir_selection;
    userdir_selection = create_userdir_selection();
    gtk_widget_show(userdir_selection);
}


void
on_userdir_select_ok_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *userdir_selection;
    G_CONST_RETURN gchar *userdir_path;
    gchar *utf8=NULL;
    char *buffy;
    buffy = allocate(8192);
    userdir_selection = lookup_widget (GTK_WIDGET (button), "userdir_selection");
    userdir_path = gtk_file_selection_get_filename(GTK_FILE_SELECTION(userdir_selection));
    sprintf(buffy, "%s", userdir_path);
    if( buffy[strlen(buffy)-1]=='\n' || buffy[strlen(buffy)-1]=='\r' )
      buffy[strlen(buffy)-1]='\0';
    if( buffy[strlen(buffy)-1]=='/' )
      buffy[strlen(buffy)-1]='\0';
    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(useradd_directory_entry), utf8);
    free(buffy);
    if( utf8!=NULL )
      g_free(utf8);
    gtk_widget_destroy(userdir_selection);
}


void
on_useradd_incoming_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
    /* If the incoming directory button in the usertab is pressed show a selection */
    GtkWidget *useradd_incoming_selection;
    useradd_incoming_selection = create_useradd_incoming_selection();
    gtk_widget_show(useradd_incoming_selection);
}


void
on_incoming_directory_ok_button_clicked (GtkButton       *button,
                                         gpointer         user_data)
{
    GtkWidget *useradd_incoming_selection;
    G_CONST_RETURN gchar *incoming_path;
    gchar *utf8=NULL;
    char *buffy, *new_buffy;
    int x=0;
    buffy = allocate(8192);
    new_buffy = allocate(8192);
    useradd_incoming_selection = lookup_widget (GTK_WIDGET (button), "useradd_incoming_selection");
    incoming_path = gtk_file_selection_get_filename(GTK_FILE_SELECTION(useradd_incoming_selection));
    /* Strip rn and the last slash from the full path, only use the last directory */
    sprintf(buffy, "%s", incoming_path);
    if( buffy[strlen(buffy)-1]=='\n' || buffy[strlen(buffy)-1]=='\r' )
      buffy[strlen(buffy)-1]='\0';
    if( buffy[strlen(buffy)-1]=='/' )
      buffy[strlen(buffy)-1]='\0';

    for(x=strlen(buffy)-2; buffy[x]; x--)
    {
	if( buffy[x]=='/' )
	{
	    snprintf(new_buffy, buffy[x], buffy+x);
	    break;	
	}
    }
    utf8 = g_locale_to_utf8(new_buffy, strlen(new_buffy), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(useradd_incoming_directory_entry), utf8);
    free(new_buffy);
    free(buffy);
    if( utf8!=NULL )
      g_free(utf8);
    gtk_widget_destroy(useradd_incoming_selection);
}


void
on_html_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Generate statistics to a html file using gprostats */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *html_entry;
    G_CONST_RETURN gchar *html_path;
    char generate[4096]="", buffy[40000]="";
    strcpy(info_buffer, "");
    html_entry = lookup_widget (GTK_WIDGET (button), "html_entry");
    html_path = gtk_entry_get_text(GTK_ENTRY(html_entry));
    strcpy(generate, "gprostats -html ");
    strcat(generate, html_path);
    if( (fp = popen(generate, "r")) == NULL )
    {
	strcpy(info_buffer, _("Welcome message generation failed"));
	strcat(info_buffer, _("No xferlog records found or popen failed\n"));
	info_window = create_info_window();
	gtk_widget_show(info_window);
	return;
    }
    fflush(fp);
    while(fgets(buffy, 40000,fp)!=NULL)
    {
        strcat(info_buffer, buffy);
    }
    pclose(fp);

    if( strlen(info_buffer)>3 )
    {
	strcat(info_buffer, "\n");
	info_window = create_info_window();
	gtk_widget_show(info_window);
    }
}


void
on_welcome_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Generate welcome message statistics for all active users */
    FILE *fp;
    GtkWidget *info_window;
    GtkWidget *welcome_entry;
    G_CONST_RETURN gchar *welcome_name;
    char generate[4096]="", buffy[40000]="";
    strcpy(info_buffer, "");
    welcome_entry = lookup_widget (GTK_WIDGET (button), "welcome_entry");
    welcome_name = gtk_entry_get_text(GTK_ENTRY(welcome_entry));
    strcpy(generate, "gprostats -w ");
    strcat(generate, welcome_name);
    strcat(generate, " -c ");
    strcat(generate, GP_CONF);
    strcat(generate, " -x ");
    strcat(generate, GP_XFERLOG);
    if( (fp = popen(generate, "r")) == NULL )
    {
	strcpy(info_buffer, _("Welcome message generation failed"));
	strcat(info_buffer, _("No xferlog records found or popen failed\n"));
	info_window = create_info_window();
	gtk_widget_show(info_window);
	return;
    }
    fflush(fp);
    while(fgets(buffy, 40000,fp)!=NULL)
    {
        strcat(info_buffer, buffy);
    }
    pclose(fp);

    if( strlen(info_buffer)>3 )
    {
	strcat(info_buffer, "\n");
	info_window = create_info_window();
	gtk_widget_show(info_window);
    }
}


void
on_tls_generate_certificate_button_clicked (GtkButton       *button,
                                    	    gpointer         user_data)
{
    FILE *fp;
    char *command;
    char *pem_path;
    GtkWidget *info_window;
    GtkWidget *tls_progressbar;
    GtkWidget *tls_ip_entry, *tls_email_entry, *tls_bits_spinbutton;
    GtkWidget *tls_password_entry, *tls_challenge_entry, *tls_valid_spinbutton;
    GtkWidget *tls_country_entry, *tls_state_entry, *tls_city_entry;
    GtkWidget *tls_org_entry, *tls_org_unit_entry;
    GtkWidget *tls_rsa_cert_entry;
    
    G_CONST_RETURN gchar *ip;
    G_CONST_RETURN gchar *email;
    G_CONST_RETURN gchar *bits;
    G_CONST_RETURN gchar *password;
    G_CONST_RETURN gchar *challenge;
    G_CONST_RETURN gchar *valid;
    G_CONST_RETURN gchar *country;
    G_CONST_RETURN gchar *state;
    G_CONST_RETURN gchar *city;
    G_CONST_RETURN gchar *org;
    G_CONST_RETURN gchar *org_unit;
    G_CONST_RETURN gchar *cert_filepath;
    gdouble val=0.0;
    
    tls_ip_entry = lookup_widget (GTK_WIDGET (button), "tls_ip_entry");
    tls_email_entry = lookup_widget (GTK_WIDGET (button), "tls_email_entry");
    tls_bits_spinbutton = lookup_widget (GTK_WIDGET (button), "tls_bits_spinbutton");
    tls_valid_spinbutton = lookup_widget (GTK_WIDGET (button), "tls_valid_spinbutton");
    tls_password_entry = lookup_widget (GTK_WIDGET (button), "tls_password_entry");
    tls_challenge_entry = lookup_widget (GTK_WIDGET (button), "tls_challenge_entry");
    tls_country_entry = lookup_widget (GTK_WIDGET (button), "tls_country_entry");
    tls_state_entry = lookup_widget (GTK_WIDGET (button), "tls_state_entry");
    tls_city_entry = lookup_widget (GTK_WIDGET (button), "tls_city_entry");
    tls_org_entry = lookup_widget (GTK_WIDGET (button), "tls_org_entry");
    tls_org_unit_entry = lookup_widget (GTK_WIDGET (button), "tls_org_unit_entry");
    tls_rsa_cert_entry = lookup_widget (GTK_WIDGET (button), "tls_rsa_cert_entry");
    tls_progressbar = lookup_widget (GTK_WIDGET (button), "tls_progressbar");

    ip = gtk_entry_get_text(GTK_ENTRY(tls_ip_entry));
    email = gtk_entry_get_text(GTK_ENTRY(tls_email_entry));
    bits = gtk_entry_get_text(GTK_ENTRY(tls_bits_spinbutton));
    password = gtk_entry_get_text(GTK_ENTRY(tls_password_entry));
    challenge = gtk_entry_get_text(GTK_ENTRY(tls_challenge_entry));
    valid = gtk_entry_get_text(GTK_ENTRY(tls_valid_spinbutton));
    country = gtk_entry_get_text(GTK_ENTRY(tls_country_entry));
    state = gtk_entry_get_text(GTK_ENTRY(tls_state_entry));
    city = gtk_entry_get_text(GTK_ENTRY(tls_city_entry));
    org = gtk_entry_get_text(GTK_ENTRY(tls_org_entry));
    org_unit = gtk_entry_get_text(GTK_ENTRY(tls_org_unit_entry));
    cert_filepath = gtk_entry_get_text(GTK_ENTRY(tls_rsa_cert_entry));

    strcpy(info_buffer, _("Every certificate field must be filled in\n"));

    /* Show error if a value is missing */
    if( strlen(ip)==0 || strlen(email)==0 || strlen(bits)==0 || strlen(password)==0 )
    {
	info_window = create_info_window();
	gtk_widget_show(info_window);
	return;    
    }

    if( strlen(challenge)==0 || strlen(valid)==0 || strlen(country)==0 || strlen(state)==0 )
    {
	info_window = create_info_window();
	gtk_widget_show(info_window);
	return;
    }

    if( strlen(city)==0 || strlen(org)==0 || strlen(org_unit)==0 )
    {
	info_window = create_info_window();
	gtk_widget_show(info_window);
	return;
    }

    val=0.0;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    if( cert_filepath == NULL )
    {
       printf("Error: TLS certificate file path needs a location\n");
       return;
    }

    pem_path = allocate(4096);
    snprintf(pem_path, 1024, "%s", cert_filepath);

    /* Make a new gprotls.conf with the chosen values. FIXME: one for each server */
    command = allocate(4096);
    strcpy(command, GP_APPCONFDIR);
    strcat(command, "/gprotls.conf");

    if((fp=fopen(command, "w+"))==NULL)
    {
	printf("Error writing gprotls.conf here: %s\n", command);
	free(command);
	free(pem_path);
	/* Show popup */
	return;
    }

    val=0.1;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    fputs("[ req ]\n", fp);
    fputs("default_bits       = ", fp);
    fputs(bits, fp); 				
    fputs("\n", fp);
    fputs("default_days       = ", fp);
    fputs(valid, fp); 				
    fputs("\n", fp);
    fputs("distinguished_name = req_distinguished_name\n", fp);
    fputs("prompt             = no\n", fp);
    fputs("output_password    = ", fp);
    fputs(password, fp);			       
    fputs("\n", fp);
    fputs("\n[ req_distinguished_name ]\n", fp);
    fputs("C            = ", fp);
    fputs(country, fp);			      
    fputs("\nST           = ", fp);
    fputs(state, fp);          
    fputs("\nL            = ", fp);
    fputs(city, fp);            
    fputs("\nO            = ", fp);
    fputs(org, fp);            
    fputs("\nOU           = ", fp);
    fputs(org_unit, fp);     
    fputs("\nCN           = ", fp);
    fputs(ip, fp);      
    fputs("\nemailAddress = ", fp);
    fputs(email, fp);  
    fputs("\n", fp);
    fputs("\n[ req_attributes ]", fp);
    fputs("\nchallengePassword = ", fp);
    fputs(challenge, fp);
    fputs("\n", fp);
    fclose(fp);

    val=0.2;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();
    
    /* Chmod_gprotls_conf_after_write */
    strcpy(command, "chmod 600 ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/gprotls.conf");
    exec_ssl(command, "Chmod_gprotls_conf_after_write");

    val=0.3;
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(tls_progressbar), _("This step can take a while"));
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();
    
    /* Trusted_cert_and_privkey */
    strcpy(command, "openssl req -new -newhdr -out ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/cert.csr -keyout ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd_privkey.pem -config ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/gprotls.conf");
    exec_ssl(command, "trusted_cert_and_privkey");

    val=0.4;
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(tls_progressbar), "");
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    /* Proftpd_key */
    strcpy(command, "openssl rsa -in ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd_privkey.pem -out ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.key -passin pass:");
    strcat(command, password);
    exec_ssl(command, "Proftpd_key");

    val=0.5;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    /* Dump_key */
    strcpy(command, "openssl rsa -in ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.key -out ");
    strcat(command, GP_APPCONFDIR); 
    strcat(command, "/dump.key");     
    exec_ssl(command, "Dump_key");

    val=0.6;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    /* Proftpd_cert */
    strcpy(command, "openssl x509 -in ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/cert.csr -out ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.cert -req -signkey ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/dump.key -days ");
    strcat(command, valid);
    exec_ssl(command, "Proftpd_cert");

    val=0.7;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    /* Text_output */
    strcpy(command, "openssl req -newhdr -in ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/cert.csr -text -out ");
    strcat(command, pem_path);
    strcat(command, " -config ");    
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/gprotls.conf");     
    exec_ssl(command, "Text_output");

    val=0.8;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    /* Combine_cert_with_pem */
    strcpy(command, "cat ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.cert >> ");
    strcat(command, pem_path);
    exec_ssl(command, "Combine_cert_with_pem");

    /* Combine_key_with_pem */
    strcpy(command, "cat ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.key >> ");
    strcat(command, pem_path);
    exec_ssl(command, "Combine_key_with_pem");

    /* Chmod_the_certificate */
    strcpy(command, "chmod 600 ");
    strcat(command, pem_path);
    exec_ssl(command, "Chmod_the_certificate");

    val=0.9;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    /* Clean_dump_key */
    strcpy(command, "rm -f ");
    strcat(command, GP_APPCONFDIR);
    strcat(command,"/dump.key");
    exec_ssl(command, "Clean_dump_key");
    /* Clean_priv_key */
    strcpy(command, "rm -f ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd_privkey.pem");
    exec_ssl(command, "Clean_priv_key");
    /* Clean_cert_csr */
    strcpy(command, "rm -f ");     
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/cert.csr");
    exec_ssl(command, "Clean_cert_csr");
    /* Clean proftpd_key */
    strcpy(command, "rm -f ");     
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.key");
    exec_ssl(command, "Clean_proftpd_key");
    /* Clean proftpd_cert */
    strcpy(command, "rm -f ");
    strcat(command, GP_APPCONFDIR);
    strcat(command, "/proftpd.cert");
    exec_ssl(command, "Clean_proftpd_cert");
    
    val=1.0;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(tls_progressbar), val);
    while(gtk_events_pending())
	  gtk_main_iteration();

    if( file_exists(pem_path) )
    {
	strcpy(info_buffer, _("The certificate has been created successfully\n"));
	strcat(info_buffer, _("and placed in the correct location.\n"));
	strcat(info_buffer, _("It will be used by new FTP-TLS logins.\n"));
    }
    else
      strcpy(info_buffer, _("The certificate has not been created, something went wrong.\n"));

    free(command);
    free(pem_path);

    info_window = create_info_window();
    gtk_widget_show(info_window);
}


void
on_add_server_button_clicked   (GtkButton       *button,
                                gpointer         user_data)
{
    FILE *fp;
    GtkWidget *info_window;
    char *server_config;

    if((fp=fopen(GP_CONF, "a"))==NULL)
    {
        sprintf(info_buffer, "%s %s %s", _("Cant open proftpd.conf for writing here:\n"), GP_CONF, _("\nRun GProFTPD as root\n"));
	info_window = create_info_window();
	gtk_widget_show(info_window);
        return;
    }
    
    /* The server configuration to be added */
    server_config = allocate(16384);

    strcpy(server_config, "<VirtualHost Unspecified>\n");
    strcat(server_config, "Port 65535\n");
    strcat(server_config, "ServerName \"Unspecified\"\n");
    strcat(server_config, "ServerIdent on \"Unspecified\"\n");

    /* Ask TJ about possible implications */
    strcat(server_config, "Bind \"0.0.0.0\"\n");

    /* The IANA-registered ephemeral port range */
    strcat(server_config, "PassivePorts 49152 65534\n");
    strcat(server_config, "#MasqueradeAddress None\n");
    strcat(server_config, "ServerAdmin Admin@this.domain\n");
    strcat(server_config, "Umask 022\n");
/*  strcpy(server_config, "RLimitCPU 70 70\n"); */
    strcat(server_config, "TimesGMT off\n");
    strcat(server_config, "MaxLoginAttempts 3\n");
    strcat(server_config, "TimeoutLogin 300\n");
    strcat(server_config, "TimeoutNoTransfer 120\n");
    strcat(server_config, "TimeoutIdle 120\n");
    
    strcat(server_config, "User ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");
    
    strcat(server_config, "Group ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");

    strcat(server_config, "DirFakeUser on ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");
    
    strcat(server_config, "DirFakeGroup on ");
    strcat(server_config, NOBODY);
    strcat(server_config, "\n");

/*  strcat(server_config, "DirFakeMode 0640\n"); doesnt have an onoff switch */

    strcat(server_config, "DefaultTransferMode binary\n");
    strcat(server_config, "AllowForeignAddress on\n");
    strcat(server_config, "DeleteAbortedStores off\n");

    strcat(server_config, "AllowRetrieveRestart on\n");
    strcat(server_config, "AllowStoreRestart on\n");
    strcat(server_config, "TransferRate RETR 30\n");
    strcat(server_config, "TransferRate STOR 50\n");
    strcat(server_config, "TransferRate STOU 50\n");
    strcat(server_config, "TransferRate APPE 50\n");

    strcat(server_config, "<IfModule mod_tls.c>\n");
    strcat(server_config, "TLSEngine off\n");
    strcat(server_config, "TLSRequired off\n");
    strcat(server_config, "TLSVerifyClient off\n");
    strcat(server_config, "TLSLog ");
    strcat(server_config, GP_VARDIR);
    strcat(server_config, "/log/proftpd_tls.log\n");
    strcat(server_config, "TLSRSACertificateFile ");
    strcat(server_config, GP_SYSCONFDIR);
    strcat(server_config, "/gproftpd/gproftpd.pem\n");
    strcat(server_config, "</IfModule>\n");

    strcat(server_config, "<Limit LOGIN>\n");
    strcat(server_config, "  DenyAll\n");
    strcat(server_config, "</Limit>\n");
    strcat(server_config, "</VirtualHost>\n");
    fputs("\n", fp);
    fputs(server_config, fp);
    fputs("\n", fp);
    fclose(fp);
    free(server_config);

    fix_newlines_in_conf();

    list_servers(userlist_treeview, NULL);
    list_server_values(userlist_treeview, NULL);
    list_entire(userlist_treeview, NULL);
}


void
on_delete_server_button_clicked   (GtkButton       *button,
                                   gpointer         user_data)
{
    FILE *fp;
    GtkWidget *info_window;
    GtkTreePath *path;
    GtkWidget *servers_treeview;
    GtkTreeIter iter;
    GtkTreeModel *list_store;
    G_CONST_RETURN gchar *server_address;
    G_CONST_RETURN gchar *server_type;
    G_CONST_RETURN gchar *server_port;
    gboolean edit=0;
    char *old_buffer, *config, *temp_vhost, *address_buffer, *port_buffer;
    int found_server=0, deleted_server=0;
    long size_buffer;

    address_buffer = allocate(8192+15);
    port_buffer = allocate(8192+3);               

    if( strstr((char *)selected_server_type, "Virtualhost") )
    {
       /* Added \n so it wont match another similar server */
       sprintf(address_buffer, "<VirtualHost %s>\n", selected_server_address);
    }
    else
      {
          strcpy(info_buffer, _("The standard server can not be deleted.\n"));
          strcat(info_buffer, _("Setting a servers port to 0 disables it.\n"));
          info_window = create_info_window ();
          gtk_widget_show (info_window);
          free(address_buffer);
	  free(port_buffer);
	  return;      
      }

    sprintf(port_buffer, "Port %s\n", selected_server_port);

    /* Standard server selected, delete the selected user in this (first) server */
    if( ! strstr((char *)selected_server_type, "Virtualhost") )
      found_server=1;

    if( strlen(address_buffer)==0 ) 
    {
        strcpy(info_buffer, _("Refusing to delete a server with no specified name.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
        return;
    }

    if( strlen(address_buffer)==0 ) 
    {
        strcpy(info_buffer, _("Refusing to delete a server with no specified name.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
        return;
    }

    if( strlen(port_buffer)==0 ) 
    {
        strcpy(info_buffer, _("Refusing to delete a server with no specified port.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
        return;
    }

    /* Delete the configuration for the deleted user in the right server */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
	strcpy(info_buffer, _("Cant open the proftpd.conf here:\n"));
        strcat(info_buffer, GP_CONF);
        strcat(info_buffer, _("\nRun GProFTPD as root\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    config = allocate(size_buffer); 

    old_buffer = allocate(size_buffer);

    temp_vhost = allocate(size_buffer);

    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	/* Is this the correct server..name to delete */
        if( strstr("Virtualhost", (char *)selected_server_type) && ! found_server
	&& ! strcmp(old_buffer, address_buffer) && ! deleted_server )
	{
	    strcpy(temp_vhost, old_buffer);
	    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		{
		    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    		    info_window=create_info_window();
    		    gtk_widget_show(info_window);
		    free(old_buffer);
		    free(config);
	    	    free(address_buffer);
		    free(port_buffer);
		    free(temp_vhost);
		    fclose(fp);
		    return;
		}

		strcat(temp_vhost, old_buffer);

		if( strstr(old_buffer, "Port ") && ! strcmp(old_buffer, port_buffer) )
		{
		    found_server=1;
		    deleted_server=1;

		    /* Scroll past this vhost */
		    while(fgets((char*)old_buffer, size_buffer, fp)!=NULL)
		    {
			if( strlen(old_buffer) > 8000 )
			{
			    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    			    info_window=create_info_window();
    			    gtk_widget_show(info_window);
			    free(old_buffer);
			    free(config);
	    		    free(address_buffer);
			    free(port_buffer);
			    free(temp_vhost);
			    fclose(fp);
			    return;
			}
		        strcat(temp_vhost, old_buffer);

			if( strstr(old_buffer, "</VirtualHost>") )
			  break;
		    }
		}
		if( strstr(old_buffer, "</VirtualHost>") )
		  break;
	    }
	    
	    if( ! found_server )
	    {
	      strcat(config, temp_vhost);
	    }
	    else
	      {
		 found_server=0;
	      }
	}
	else /* Get everything thats not a vhost */
	  strcat(config, old_buffer);
    }
    free(old_buffer);
    free(address_buffer);
    free(port_buffer);
    free(temp_vhost);
    fclose(fp);

    if( ! deleted_server )
    {
        strcpy(info_buffer, _("Could not delete the specified server\n"));
        strcat(info_buffer, _("Try reselecting the server by doubleclicking on it.\n"));
        info_window=create_info_window();
        gtk_widget_show(info_window);
	free(config);
	return;
    }

    /* Write the new config without the deleted vhost */
    if((fp=fopen(GP_CONF, "w+"))==NULL)
    {
        printf("Error Writing configuration here: %s\n", GP_CONF);
	free(config);
        return;
    }
    fputs(config, fp);
    fclose(fp);
    free(config);


    /* Set the treepath to the first row and list that servers settings */
    servers_treeview = lookup_widget(GTK_WIDGET(button), "servers_treeview");

    /* The defualt server must exist or this will break ! */
    path=gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(servers_treeview), path, NULL, edit);
    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(servers_treeview));
    gtk_tree_model_get_iter(list_store, &iter, path);
    gtk_tree_path_free(path);

    gtk_tree_model_get(list_store, &iter, 0, &server_address, -1);
    gtk_tree_model_get(list_store, &iter, 1, &server_port, -1);
    gtk_tree_model_get(list_store, &iter, 3, &server_type, -1);

    if( strlen(server_address)==0 )
    {
	printf("Server address is 0 chars, aborting selection\n");
	return;
    }
    if( strlen(server_port)==0 )
    {
	printf("Server port length is 0, aborting selection\n");
	return;
    }
    if( strlen(server_type)==0 )
    {
	printf("Server type length is 0, aborting selection\n");
	return;
    }
    strcpy(selected_server_address, server_address);
    strcpy(selected_server_port, server_port);
    strcpy(selected_server_type, server_type);

    fix_newlines_in_conf();

    list_servers(userlist_treeview, NULL);
    list_users(userlist_treeview, NULL);
    list_entire(userlist_treeview, NULL);
    list_server_values(userlist_treeview, NULL);
    if( online )
      system("killall -1 proftpd");
}


void
on_apply_server_changes_button_clicked(GtkButton *button,
                                       gpointer  user_data)
{
    /* Change the selected servers configuration. */
    FILE *fp;
    char *change_srv_ident;
    long size_buffer;
    int address_match=0, configuration_changed=0;
    char *old_buffer, *config, *temp_server, *conf_line, *address_buffer, *port_buffer;
    GtkWidget *info_window;
    GtkWidget *entire_textview;
    GtkWidget *global_server_name;
    GtkWidget *global_bind_tight_on_off;
    GtkWidget *global_server_admin_email;
    GtkWidget *global_server_port;
    GtkWidget *global_passive_ports_1_spinbutton;
    GtkWidget *global_passive_ports_2_spinbutton;
    GtkWidget *global_masquerade_entry;
    GtkWidget *global_masquerade_address_on_off;
    GtkWidget *global_max_connect;
    GtkWidget *global_idle_timeout;
    GtkWidget *global_resume_uploads;
    GtkWidget *global_resume_downloads;
    GtkWidget *global_download_bandwidth;
    GtkWidget *global_upload_bandwidth;
    GtkWidget *global_show_server_identity;
    GtkWidget *global_show_server_identity_on_off;

    /* These names should be changed... */
    GtkWidget *combo1; 	   /* server ident on off */
    GtkWidget *combo2;     /* ident lookups on off */
    GtkWidget *combo3;     /* reverse lookups on off */
    GtkWidget *combo4;     /* Timestandard on off FIXME GMT local time */
    GtkWidget *combo5;     /* transfermode binary ascii */
    GtkWidget *combo6;     /* FXP on off */

    GtkWidget *combo11;    /* delete aborted stores on off */

    GtkWidget *combo13;    /* resume downloads on off */
    GtkWidget *combo14;    /* resume uploads on off */
    GtkWidget *combo15;    /* fake user on off */
    GtkWidget *combo16;    /* fake group on off */
    GtkWidget *combo18;    /*  bind servers to their addresses on off */
    GtkWidget *combo19;    /* case randomization upper lower */
    GtkWidget *combo20;    /* masquerade address on off */
    GtkWidget *tls_combo1; /* tls engine on off */
    GtkWidget *tls_combo2; /* transfermode both data ctrl off */
    GtkWidget *tls_combo3; /* verify clients on off */
    
    GtkWidget *global_reverse_lookups;
    GtkWidget *global_default_transfer_mode;
    GtkWidget *global_ident_lookups;
    GtkWidget *global_allow_fxp;
    GtkWidget *global_server_user;
    GtkWidget *global_server_group;
    GtkWidget *global_fake_user_entry;
    GtkWidget *global_fake_group_entry;
    GtkWidget *global_fake_user_combo;
    GtkWidget *global_fake_group_combo;
    GtkWidget *global_time_standard;
    GtkWidget *global_max_login_attempts;
    GtkWidget *global_timeout_login;
    GtkWidget *global_delete_aborted_stores;
    GtkWidget *global_systemlog_entry;
    GtkWidget *global_rand_username;
    GtkWidget *global_rand_password;
    GtkWidget *global_rand_case;
    GtkWidget *global_useradd_root_path;
    GtkWidget *global_useradd_upload_path;
    GtkWidget *html_entry;
    GtkWidget *welcome_entry;
    GtkWidget *global_html_path;
    GtkWidget *global_welcome_path;
    GtkWidget *tls_use_combo_entry, *tls_use_encryption_combo_entry;
    GtkWidget *tls_verify_clients_combo_entry, *tls_protocols_entry;
    GtkWidget *tls_rsa_cert_entry, *tls_logfile_entry;
    G_CONST_RETURN gchar *current_change_name;
    G_CONST_RETURN gchar *current_change_bind_tight;
    G_CONST_RETURN gchar *current_change_server_admin;
    G_CONST_RETURN gchar *current_change_port;
    G_CONST_RETURN gchar *current_change_passive_ports_1;
    G_CONST_RETURN gchar *current_change_passive_ports_2;
    G_CONST_RETURN gchar *current_change_masquerade_address;
    G_CONST_RETURN gchar *current_change_masquerade_address_on_off;
    G_CONST_RETURN gchar *current_change_max_connect;
    G_CONST_RETURN gchar *current_change_no_transfer;
    G_CONST_RETURN gchar *current_change_identity;
    G_CONST_RETURN gchar *current_change_identity_on_off;
    G_CONST_RETURN gchar *current_change_transfer_mode;
    G_CONST_RETURN gchar *current_change_ident_lookups;
    G_CONST_RETURN gchar *current_change_reverse_lookups;
    G_CONST_RETURN gchar *current_change_server_user;
    G_CONST_RETURN gchar *current_change_server_group;
    G_CONST_RETURN gchar *current_change_fake_username;
    G_CONST_RETURN gchar *current_change_fake_groupname;
    G_CONST_RETURN gchar *current_change_fake_username_on_off;
    G_CONST_RETURN gchar *current_change_fake_groupname_on_off;
    G_CONST_RETURN gchar *current_change_allow_fxp;
    G_CONST_RETURN gchar *current_change_time_standard;
    G_CONST_RETURN gchar *current_change_max_login_attempts;
    G_CONST_RETURN gchar *current_change_timeout_login;
    G_CONST_RETURN gchar *current_change_resume_dl;
    G_CONST_RETURN gchar *current_change_download_bandwidth;
    G_CONST_RETURN gchar *current_change_resume_ul;
    G_CONST_RETURN gchar *current_change_upload_bandwidth;
    G_CONST_RETURN gchar *current_change_delete_aborted_stores;
    G_CONST_RETURN gchar *current_change_systemlog;
    G_CONST_RETURN gchar *current_change_rand_username;
    G_CONST_RETURN gchar *current_change_rand_password;
    G_CONST_RETURN gchar *current_change_rand_case;
    G_CONST_RETURN gchar *current_change_root_path;
    G_CONST_RETURN gchar *current_change_upload_path;
    G_CONST_RETURN gchar *current_change_html_path;
    G_CONST_RETURN gchar *current_change_welcome_name;
    G_CONST_RETURN gchar *current_tls_use_combo_entry;
    G_CONST_RETURN gchar *current_tls_use_encryption_combo_entry;
    G_CONST_RETURN gchar *current_tls_verify_clients_combo_entry;
    G_CONST_RETURN gchar *current_tls_protocols_entry;
    G_CONST_RETURN gchar *current_tls_rsa_cert_entry;
    G_CONST_RETURN gchar *current_tls_logfile_entry;
    global_server_name = lookup_widget (GTK_WIDGET (button), "global_server_name");
    global_bind_tight_on_off = lookup_widget (GTK_WIDGET (button), "global_bind_tight_on_off");
    global_server_admin_email = lookup_widget (GTK_WIDGET (button), "global_server_admin_email");    
    global_server_port = lookup_widget (GTK_WIDGET (button), "global_server_port");
    global_passive_ports_1_spinbutton = lookup_widget (GTK_WIDGET (button), "global_passive_ports_1_spinbutton");
    global_passive_ports_2_spinbutton = lookup_widget (GTK_WIDGET (button), "global_passive_ports_2_spinbutton");
    global_masquerade_entry = lookup_widget (GTK_WIDGET (button), "global_masquerade_entry");
    global_masquerade_address_on_off = lookup_widget (GTK_WIDGET (button), "global_masquerade_address_on_off");
    global_max_connect = lookup_widget (GTK_WIDGET (button), "global_max_connect");
    global_idle_timeout = lookup_widget (GTK_WIDGET (button), "global_idle_timeout");
    global_resume_uploads = lookup_widget (GTK_WIDGET (button), "global_resume_uploads");
    global_resume_downloads = lookup_widget (GTK_WIDGET (button), "global_resume_downloads");
    global_download_bandwidth = lookup_widget (GTK_WIDGET (button), "global_download_bandwidth");
    global_upload_bandwidth = lookup_widget (GTK_WIDGET (button), "global_upload_bandwidth");

    global_show_server_identity = lookup_widget (GTK_WIDGET (button), "global_show_server_identity");
    global_show_server_identity_on_off = lookup_widget (GTK_WIDGET (button), "global_show_server_identity_on_off");


    combo1 = lookup_widget (GTK_WIDGET (button), "combo1");

    combo2 = lookup_widget (GTK_WIDGET (button), "combo2");    
    combo3 = lookup_widget (GTK_WIDGET (button), "combo3");    
    combo4 = lookup_widget (GTK_WIDGET (button), "combo4");    
    combo5 = lookup_widget (GTK_WIDGET (button), "combo5");    
    combo6 = lookup_widget (GTK_WIDGET (button), "combo6");    

    combo11 = lookup_widget (GTK_WIDGET (button), "combo11");   

    combo13 = lookup_widget (GTK_WIDGET (button), "combo13");   
    combo14 = lookup_widget (GTK_WIDGET (button), "combo14");   
    combo15 = lookup_widget (GTK_WIDGET (button), "combo15");   
    combo16 = lookup_widget (GTK_WIDGET (button), "combo16");   
    combo18 = lookup_widget (GTK_WIDGET (button), "combo18");   
    combo19 = lookup_widget (GTK_WIDGET (button), "combo19");   
    combo20 = lookup_widget (GTK_WIDGET (button), "combo20");   
    tls_combo1 = lookup_widget (GTK_WIDGET (button), "tls_combo1");
    tls_combo2 = lookup_widget (GTK_WIDGET (button), "tls_combo2");
    tls_combo3 = lookup_widget (GTK_WIDGET (button), "tls_combo3");



    global_reverse_lookups = lookup_widget (GTK_WIDGET (button), "global_reverse_lookups");
    global_default_transfer_mode = lookup_widget (GTK_WIDGET (button), "global_default_transfer_mode");
    global_ident_lookups = lookup_widget (GTK_WIDGET (button), "global_ident_lookups");
    global_allow_fxp = lookup_widget (GTK_WIDGET (button), "global_allow_fxp");
    global_server_user = lookup_widget (GTK_WIDGET (button), "global_server_user");
    global_server_group = lookup_widget (GTK_WIDGET (button), "global_server_group");
    global_fake_user_entry = lookup_widget (GTK_WIDGET (button), "global_fake_user_entry");
    global_fake_user_combo = lookup_widget (GTK_WIDGET (button), "global_fake_user_combo");
    global_fake_group_entry = lookup_widget (GTK_WIDGET (button), "global_fake_group_entry");
    global_fake_group_combo = lookup_widget (GTK_WIDGET (button), "global_fake_group_combo");
    global_time_standard = lookup_widget (GTK_WIDGET (button), "global_time_standard");
    global_max_login_attempts = lookup_widget (GTK_WIDGET (button), "global_max_login_attempts");
    global_timeout_login = lookup_widget (GTK_WIDGET (button), "global_timeout_login");
    global_delete_aborted_stores = lookup_widget (GTK_WIDGET (button), "global_delete_aborted_stores");
    global_systemlog_entry = lookup_widget (GTK_WIDGET (button), "global_systemlog_entry");
    global_rand_username = lookup_widget (GTK_WIDGET (button), "global_rand_username");
    global_rand_password = lookup_widget (GTK_WIDGET (button), "global_rand_password");
    global_rand_case = lookup_widget (GTK_WIDGET (button), "global_rand_case");
    global_useradd_root_path = lookup_widget (GTK_WIDGET (button), "global_useradd_root_path");
    global_useradd_upload_path = lookup_widget (GTK_WIDGET (button), "global_useradd_upload_path");
    html_entry = lookup_widget (GTK_WIDGET (button), "html_entry");
    welcome_entry = lookup_widget (GTK_WIDGET (button), "welcome_entry");
    global_html_path = lookup_widget (GTK_WIDGET (button), "global_html_path");
    global_welcome_path = lookup_widget (GTK_WIDGET (button), "global_welcome_path");

    entire_textview = lookup_widget (GTK_WIDGET (button), "entire_textview");
    tls_use_combo_entry = lookup_widget (GTK_WIDGET (button), "tls_use_combo_entry");
    tls_use_encryption_combo_entry = lookup_widget (GTK_WIDGET (button), "tls_use_encryption_combo_entry");
    tls_verify_clients_combo_entry = lookup_widget (GTK_WIDGET (button), "tls_verify_clients_combo_entry");
    tls_protocols_entry = lookup_widget (GTK_WIDGET (button), "tls_protocols_entry");
    tls_rsa_cert_entry = lookup_widget (GTK_WIDGET (button), "tls_rsa_cert_entry");
    tls_logfile_entry = lookup_widget (GTK_WIDGET (button), "tls_logfile_entry");
    current_change_name = gtk_entry_get_text(GTK_ENTRY(global_server_name));
    current_change_bind_tight = gtk_entry_get_text(GTK_ENTRY(global_bind_tight_on_off));
    current_change_server_admin = gtk_entry_get_text(GTK_ENTRY(global_server_admin_email));
    current_change_port = gtk_entry_get_text(GTK_ENTRY(global_server_port));
    current_change_passive_ports_1 = gtk_entry_get_text(GTK_ENTRY(global_passive_ports_1_spinbutton));
    current_change_passive_ports_2 = gtk_entry_get_text(GTK_ENTRY(global_passive_ports_2_spinbutton));
    current_change_masquerade_address = gtk_entry_get_text(GTK_ENTRY(global_masquerade_entry));
    current_change_masquerade_address_on_off = gtk_entry_get_text(GTK_ENTRY(global_masquerade_address_on_off));
    current_change_max_connect = gtk_entry_get_text(GTK_ENTRY(global_max_connect));
    current_change_no_transfer = gtk_entry_get_text(GTK_ENTRY(global_idle_timeout));
    current_change_resume_ul = gtk_entry_get_text(GTK_ENTRY(global_resume_uploads));
    current_change_resume_dl = gtk_entry_get_text(GTK_ENTRY(global_resume_downloads));
    current_change_upload_bandwidth = gtk_entry_get_text(GTK_ENTRY(global_upload_bandwidth));
    current_change_download_bandwidth = gtk_entry_get_text(GTK_ENTRY(global_download_bandwidth));
    current_change_identity = gtk_entry_get_text(GTK_ENTRY(global_show_server_identity));
    current_change_identity_on_off = gtk_entry_get_text(GTK_ENTRY(global_show_server_identity_on_off));
    current_change_reverse_lookups = gtk_entry_get_text(GTK_ENTRY(global_reverse_lookups));
    current_change_transfer_mode = gtk_entry_get_text(GTK_ENTRY(global_default_transfer_mode));
    current_change_ident_lookups = gtk_entry_get_text(GTK_ENTRY(global_ident_lookups));
    current_change_server_user = gtk_entry_get_text(GTK_ENTRY(global_server_user));
    current_change_server_group = gtk_entry_get_text(GTK_ENTRY(global_server_group));
    current_change_fake_username = gtk_entry_get_text(GTK_ENTRY(global_fake_user_entry));
    current_change_fake_username_on_off = gtk_entry_get_text(GTK_ENTRY(global_fake_user_combo));
    current_change_fake_groupname = gtk_entry_get_text(GTK_ENTRY(global_fake_group_entry));
    current_change_fake_groupname_on_off = gtk_entry_get_text(GTK_ENTRY(global_fake_group_combo));
    current_change_allow_fxp = gtk_entry_get_text(GTK_ENTRY(global_allow_fxp));
    current_change_time_standard = gtk_entry_get_text(GTK_ENTRY(global_time_standard));
    current_change_max_login_attempts = gtk_entry_get_text(GTK_ENTRY(global_max_login_attempts));
    current_change_timeout_login = gtk_entry_get_text(GTK_ENTRY(global_timeout_login));
    current_change_delete_aborted_stores = gtk_entry_get_text(GTK_ENTRY(global_delete_aborted_stores));
    current_change_systemlog = gtk_entry_get_text(GTK_ENTRY(global_systemlog_entry));
    current_change_rand_username = gtk_entry_get_text(GTK_ENTRY(global_rand_username));
    current_change_rand_password = gtk_entry_get_text(GTK_ENTRY(global_rand_password));
    current_change_rand_case = gtk_entry_get_text(GTK_ENTRY(global_rand_case));
    current_change_root_path = gtk_entry_get_text(GTK_ENTRY(global_useradd_root_path));
    current_change_upload_path = gtk_entry_get_text(GTK_ENTRY(global_useradd_upload_path));
    current_change_html_path = gtk_entry_get_text(GTK_ENTRY(global_html_path));
    current_change_welcome_name = gtk_entry_get_text(GTK_ENTRY(global_welcome_path));
    current_tls_use_combo_entry = gtk_entry_get_text(GTK_ENTRY(tls_use_combo_entry));
    current_tls_use_encryption_combo_entry = gtk_entry_get_text(GTK_ENTRY(tls_use_encryption_combo_entry));
    current_tls_verify_clients_combo_entry = gtk_entry_get_text(GTK_ENTRY(tls_verify_clients_combo_entry));
    current_tls_protocols_entry = gtk_entry_get_text(GTK_ENTRY(tls_protocols_entry));
    current_tls_rsa_cert_entry = gtk_entry_get_text(GTK_ENTRY(tls_rsa_cert_entry));
    current_tls_logfile_entry = gtk_entry_get_text(GTK_ENTRY(tls_logfile_entry));

    address_buffer = allocate(8192+15);
    port_buffer = allocate(8192+3);               

    if( strstr((char *)selected_server_type, "Virtualhost") )
      sprintf(address_buffer, "<VirtualHost %s>\n", selected_server_address); 
   

    sprintf(port_buffer, "Port %s\n", selected_server_port);


    if( strlen(address_buffer)==0 && strstr((char *)selected_server_type, "Virtualhost") ) 
    {
        strcpy(info_buffer, _("Refusing to change a server without a specified name.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
        return;
    }

    if( strlen(port_buffer)==0 ) 
    {
        strcpy(info_buffer, _("Refusing to change a server without a specified port.\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
	free(address_buffer);
	free(port_buffer);
        return;
    }

    /* Change the configuration for the selected server */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
	strcpy(info_buffer, _("Cant open proftpd.conf here:\n"));
        strcat(info_buffer, GP_CONF);
        strcat(info_buffer, _("\nRun GProFTPD as root\n"));
        info_window = create_info_window ();
        gtk_widget_show (info_window);
        return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer = ftell(fp);
    rewind(fp);

    /* Incremented for possible additional conf values */
    config = allocate(size_buffer+16384);

    old_buffer = allocate(size_buffer);

    temp_server = allocate(size_buffer);

    conf_line = allocate(8192);

    change_srv_ident = allocate(8192);


/* ------------- Change the standard server ----------- */

    if( ! strstr("Virtualhost", (char *)selected_server_type) )
    {
	    configuration_changed=1;

	    while(fgets(old_buffer, size_buffer, fp)!=NULL)
	    {
		if( strlen(old_buffer) > 8000 )
		{
		    sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
		    info_window=create_info_window();
		    gtk_widget_show(info_window);
		    free(old_buffer);
		    free(config);
    		    free(address_buffer);
		    free(port_buffer);
		    free(temp_server);
		    free(conf_line);
		    free(change_srv_ident);
		    fclose(fp);
		    return;
		}

		/* Change matching server directives otherwise just gather them */

		/* If its an anonymous profile or a vhost */
		if( strstr(old_buffer, "<VirtualHost") || strstr(old_buffer, "<Anonymous") )
		{
		    strcat(config, old_buffer);
		    /* When <Anonymous or <VirtualHost is found we collect all other lines to the end */
		    while(fgets(old_buffer, size_buffer, fp)!=NULL)
		       strcat(config, old_buffer);
printf("Vhost or anon END\n");
		}
		else
		if( strstr(old_buffer, "ServerName") )
    		{          	
    		    sprintf(conf_line, "ServerName \"%s\"\n", current_change_name);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "ServerIdent") )
		{
		    if( combo_selection(combo1) == 0 )
		      sprintf(conf_line, "ServerIdent on \"%s\"\n", current_change_identity);
		    else
		      sprintf(conf_line, "ServerIdent off \"%s\"\n", current_change_identity);

    		    strcat(config, conf_line);
		}
	        else
		if( strstr(old_buffer, "MasqueradeAddress") )
		{
		    if( combo_selection(combo20) == 0 && strlen(current_change_masquerade_address) > 4 )
		      sprintf(conf_line, "MasqueradeAddress %s\n", current_change_masquerade_address);
		    else
		      if( strlen(current_change_masquerade_address) > 4 )
		        sprintf(conf_line, "#MasqueradeAddress %s\n", current_change_masquerade_address);
		    else
		      sprintf(conf_line, "#MasqueradeAddress None\n");

		    strcat(config, conf_line);
		}
		else  /* Set to server ident if on or servername ? */
		if( strstr(old_buffer, "Bind") && ! strstr(old_buffer, "SocketBindTight ") )
		{
    		    sprintf(conf_line, "Bind \"%s\"\n", current_change_name);
    		    strcat(config, conf_line);
		}
		else /* Bind to the selected ip or dns name */
		if( strstr(old_buffer, "SocketBindTight") )
		{
		    if( combo_selection(combo18) == 0 )
    		      sprintf(conf_line, "SocketBindTight on\n");
		    else
    		      sprintf(conf_line, "SocketBindTight off\n");

    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "ServerAdmin") )
		{
    		    sprintf(conf_line, "ServerAdmin %s\n",current_change_server_admin);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "Port") && old_buffer[4]==' ' )
		{
		    sprintf(conf_line, "Port %s\n",current_change_port);
		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "PassivePorts") )
		{
		    sprintf(conf_line, "PassivePorts %s %s\n",current_change_passive_ports_1, current_change_passive_ports_2);
		    strcat(config, conf_line);
		}
	        else
		if( strstr(old_buffer, "MaxInstances") )
		{
    		    sprintf(conf_line, "MaxInstances %s\n",current_change_max_connect);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "TimeoutNoTransfer") )
		{
    		    sprintf(conf_line, "TimeoutNoTransfer %s\n",current_change_no_transfer);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "TimeoutIdle") )
		{
    		    sprintf(conf_line, "TimeoutIdle %s\n",current_change_no_transfer);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "AllowStoreRestart") )
		{
		    if( combo_selection(combo14) == 0 )
    		      sprintf(conf_line, "AllowStoreRestart on\n");
		    else
    		      sprintf(conf_line, "AllowStoreRestart off\n");
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "AllowRetrieveRestart") )
		{
		    if( combo_selection(combo13) == 0 )
    		      sprintf(conf_line, "AllowRetrieveRestart on\n");
		    else
    		      sprintf(conf_line, "AllowRetrieveRestart off\n");
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "TransferRate RETR") )
		{
    		    sprintf(conf_line, "TransferRate RETR %s\n",current_change_download_bandwidth);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "TransferRate STOR") )
		{
    		    sprintf(conf_line, "TransferRate STOR %s\n",current_change_upload_bandwidth);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "TransferRate STOU") )
		{
    		    sprintf(conf_line, "TransferRate STOU %s\n",current_change_upload_bandwidth);
    		    strcat(config, conf_line);
		}
		else
		if( strstr(old_buffer, "TransferRate APPE") )
		{
    		    sprintf(conf_line, "TransferRate APPE %s\n",current_change_upload_bandwidth);
    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "UseReverseDNS") )
		{
		    if( combo_selection(combo3) == 0 )
    		      sprintf(conf_line, "UseReverseDNS on\n");
		    else
    		      sprintf(conf_line, "UseReverseDNS off\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "IdentLookups") )
		{
		    if( combo_selection(combo2) == 0 )
    		      sprintf(conf_line, "IdentLookups on\n");
		    else
    		      sprintf(conf_line, "IdentLookups off\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "DefaultTransferMode") )
		{
		    if( combo_selection(combo5) == 0 )
    		      sprintf(conf_line, "DefaultTransferMode binary\n");
		    else
    		      sprintf(conf_line, "DefaultTransferMode ascii\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "User") && old_buffer[4]==' ' )
		{
printf("Standard SERVER USER WAS CHANGED !!!\n");

		    sprintf(conf_line, "User %s\n",current_change_server_user);
    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "Group") && old_buffer[5]==' ' )
		{
		    sprintf(conf_line, "Group %s\n",current_change_server_group);
    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "DirFakeUser") )
		{
		    if( combo_selection(combo15) == 0 )
    		      sprintf(conf_line, "DirFakeUser on %s\n", current_change_fake_username);
		    else
    		      sprintf(conf_line, "DirFakeUser off %s\n", current_change_fake_username);

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "DirFakeGroup") )
		{
		    if( combo_selection(combo16) == 0 )
    		      sprintf(conf_line, "DirFakeGroup on %s\n", current_change_fake_groupname);
		    else
    		      sprintf(conf_line, "DirFakeGroup off %s\n", current_change_fake_groupname);

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "AllowForeignAddress") )
		{
		    if( combo_selection(combo6) == 0 )
    		      sprintf(conf_line, "AllowForeignAddress on\n");
		    else
    		      sprintf(conf_line, "AllowForeignAddress off\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "TimesGMT") )
		{
		    if( combo_selection(combo4) == 0 )
    		      sprintf(conf_line, "TimesGMT on\n");
		    else
    		      sprintf(conf_line, "TimesGMT off\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "MaxLoginAttempts") )
		{
		    sprintf(conf_line, "MaxLoginAttempts %s\n",current_change_max_login_attempts);
    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "TimeoutLogin") )
		{
		    sprintf(conf_line, "TimeoutLogin %s\n",current_change_timeout_login);
    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "DeleteAbortedStores") )
		{
		    if( combo_selection(combo11) == 0 )
    		      sprintf(conf_line, "DeleteAbortedStores on\n");
		    else
    		      sprintf(conf_line, "DeleteAbortedStores off\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "SystemLog") )
		{
    		    sprintf(conf_line, "SystemLog %s\n",current_change_systemlog);
    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "#gp_random_username_length") && strlen(current_change_rand_username)<=128 )
		{
    		    sprintf(conf_line, "#gp_random_username_length %s\n",current_change_rand_username);
    		    strcat(config, conf_line);
		    global_username_randlen=atoi(current_change_rand_username);
		}
		else
    		if( strstr(old_buffer, "#gp_random_password_length") && strlen(current_change_rand_password)<=128 )
		{
    		    sprintf(conf_line, "#gp_random_password_length %s\n",current_change_rand_password);
    		    strcat(config, conf_line);
		    global_password_randlen=atoi(current_change_rand_password);
		}
		else
    		if( strstr(old_buffer, "#gp_randomize_case") )
		{
		    if( combo_selection(combo19) == 0 )
    		      sprintf(conf_line, "#gp_randomize_case upper\n");
		    else
    		      sprintf(conf_line, "#gp_randomize_case lower\n");

    		    strcat(config, conf_line);
		}
		else
    		if( strstr(old_buffer, "#gp_useradd_root_path") && strlen(current_change_root_path)<=8000 )
		{
    		    sprintf(conf_line, "#gp_useradd_root_path %s\n", current_change_root_path);
    		    strcat(config, conf_line);
		    sprintf(gp_useradd_root_path, "%s", current_change_root_path);
		}
		else
    		if( strstr(old_buffer, "#gp_useradd_upload_path") && strlen(current_change_upload_path)<=8000 )
		{
    		    sprintf(conf_line, "#gp_useradd_upload_path %s\n",current_change_upload_path);
    		    strcat(config, conf_line);
		    sprintf(gp_useradd_upload_path, "%s", current_change_upload_path);
		}
		else
    		if( strstr(old_buffer, "#gp_html_path") )
		{
    		    sprintf(conf_line, "#gp_html_path %s\n",current_change_html_path);
    		    strcat(config, conf_line);
		    gtk_entry_set_text(GTK_ENTRY(html_entry), current_change_html_path);
		}
		else
    		if( strstr(old_buffer, "#gp_welcome_name") )
		{
    		    sprintf(conf_line, "#gp_welcome_name %s\n",current_change_welcome_name);
    		    strcat(config, conf_line);
		    gtk_entry_set_text(GTK_ENTRY(welcome_entry), current_change_welcome_name);
		}
		else
		if( use_tls )
		{ 
    		    if( strstr(old_buffer, "TLSEngine") )
		    {
			if( combo_selection(tls_combo1) == 0 )
    		    	  sprintf(conf_line, "TLSEngine on\n");
			else
    		          sprintf(conf_line, "TLSEngine off\n");

    			strcat(config, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TLSRequired") )
		    {
			if( combo_selection(tls_combo2) == 0 )
    		          sprintf(conf_line, "TLSRequired on\n");
			else 
			if( combo_selection(tls_combo2) == 1 )
    		          sprintf(conf_line, "TLSRequired data\n");
			else
			if( combo_selection(tls_combo2) == 2 )
    		          sprintf(conf_line, "TLSRequired ctrl\n");
			else
			if( combo_selection(tls_combo2) == 3 )
    		          sprintf(conf_line, "TLSRequired off\n");

			strcat(config, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TLSVerifyClient") )
		    {
			if( combo_selection(tls_combo3) == 0 )
    		          sprintf(conf_line, "TLSVerifyClient on\n");
			else
    		          sprintf(conf_line, "TLSVerifyClient off\n");

    	    		strcat(config, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TLSProtocol") )
		    {
    			sprintf(conf_line, "TLSProtocol %s\n", current_tls_protocols_entry);
    	    		strcat(config, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TLSLog") )
		    {
    			sprintf(conf_line, "TLSLog %s\n", current_tls_logfile_entry);
    			strcat(config, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TLSRSACertificateFile") )
		    {
    			sprintf(conf_line, "TLSRSACertificateFile %s\n", current_tls_rsa_cert_entry);
    			strcat(config, conf_line);
		    }
		    else
    		      strcat(config, old_buffer); /* Fatal TLS bug fixed DOH! */
		}
		else /* Get every line that doesnt match */
		  strcat(config, old_buffer);
	    }

        free(old_buffer);
        free(address_buffer);
        free(port_buffer);
        free(temp_server);
        free(conf_line);
        free(change_srv_ident);
        fclose(fp);
    }

/* ----------------- End of the standard server changes ------------------ */

/* The values for these 2 should be changed in the same function */

/* ------------ Change a selected virtualhost --------------- */

    if( strstr("Virtualhost", (char *)selected_server_type) )
    {
	while(fgets(old_buffer, size_buffer, fp)!=NULL)
	{
	    if( strlen(old_buffer) > 8000 )
	    {
	        sprintf(info_buffer, _("A line with over 8000 chars is not valid in: %s\n"), GP_CONF);
    	        info_window=create_info_window();
    	        gtk_widget_show(info_window);
	        free(old_buffer);
	        free(config);
		free(address_buffer);
		free(port_buffer);
		free(temp_server);
		free(conf_line);
		free(change_srv_ident);
		fclose(fp);
		return;
	    }

	    /* We have found the first virtualhost */
	    if( strstr(old_buffer, "<VirtualHost") )
	    {
	       strcpy(temp_server, old_buffer);
	       break;
	    }
	    else
	      strcat(config, old_buffer);
	}


	/* If this vhost doesnt have the right address we just add it to the config */
	if( strcmp(temp_server, (char *)address_buffer) )
	  strcat(config, temp_server);


        while(fgets(old_buffer, size_buffer, fp)!=NULL)
        {
	    /* Every new vhost name goes into temp_server */	
	    if( strstr(old_buffer, "<VirtualHost") )
	      strcpy(temp_server, old_buffer);
	    
	    if( ! strcmp(temp_server, (char *)address_buffer) )
	      address_match=1;

	    /* If the correct VirtualHost and port is found then change the settings */
	    if( strstr(old_buffer, "Port") && ! strcmp(old_buffer, (char *)port_buffer) && address_match )
	    {
		address_match=0;

		sprintf(temp_server, "\n<VirtualHost %s>\n", current_change_name);
	        strcat(temp_server, "Port ");
		strcat(temp_server, current_change_port);
		strcat(temp_server, "\n");
    		while(fgets(old_buffer, size_buffer, fp)!=NULL)
    		{
		    /* Change the VirtualHost settings.. */

		    /* At the end of the VirtualHost, copy everything else  */
		    if( strstr(old_buffer, "</VirtualHost") )
		    {
		        /* Add the changed config */
		        strcat(config, temp_server);
			configuration_changed=1;

		        strcat(config, old_buffer);
		    	while(fgets(old_buffer, size_buffer, fp)!=NULL)
    			   strcat(config, old_buffer);
printf("End of changed VHOST........\n");
		    }
		    if( strstr(old_buffer, "<Anonymous") )
		    {
		        /* Copy everything */
		        strcat(config, temp_server);
			configuration_changed=1;

		        strcat(config, old_buffer);
		    	while(fgets(old_buffer, size_buffer, fp)!=NULL)
    			   strcat(config, old_buffer);
		    }
		    else
		    if( strstr(old_buffer, "ServerName") )
	    	    {          	
        	        sprintf(conf_line, "ServerName \"%s\"\n",current_change_name);
        	        strcat(temp_server, conf_line);
    		    }
		    else
    		    if( strstr(old_buffer, "ServerIdent") )
		    {
			if( combo_selection(combo1) == 0 )
		          sprintf(conf_line, "ServerIdent on \"%s\"\n", current_change_identity);
			else
		          sprintf(conf_line, "ServerIdent off \"%s\"\n", current_change_identity);

    			strcat(temp_server, conf_line);
		    }
		    else  /* Set to server ident if on or servername ? */
		    if( strstr(old_buffer, "Bind") && ! strstr(old_buffer, "SocketBindTight ") )
		    {
    			sprintf(conf_line, "Bind \"%s\"\n", current_change_name);
    			strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "ServerAdmin") )
    		    {
        	        sprintf(conf_line, "ServerAdmin %s\n",current_change_server_admin);
        	        strcat(temp_server, conf_line);
    		    }
		    else
    		    if( strstr(old_buffer, "Port") && old_buffer[4]==' ' )
    		    {
		        if( strstr("Virtualhost", (char *)selected_server_type) )
		        {
			    printf("Dumped this old Port-line: %s\n", old_buffer);
			}
			else
			  {
        		     sprintf(conf_line, "Port %s\n",current_change_port);
        		     strcat(temp_server, conf_line);
			  }
    		    }
		    else
    		    if( strstr(old_buffer, "PassivePorts") )
    		    {
        		sprintf(conf_line, "PassivePorts %s %s\n",current_change_passive_ports_1, current_change_passive_ports_2);
        		strcat(temp_server, conf_line);
    		    }
		    else
    		    if( strstr(old_buffer, "MasqueradeAddress") )
    		    {
			if( combo_selection(combo20) == 0 && strlen(current_change_masquerade_address) > 4 )
		          sprintf(conf_line, "MasqueradeAddress %s\n", current_change_masquerade_address);
			else
		        if( strlen(current_change_masquerade_address) > 4 )
		          sprintf(conf_line, "#MasqueradeAddress %s\n", current_change_masquerade_address);
			else
		          sprintf(conf_line, "#MasqueradeAddress None\n");
			
			strcat(temp_server, conf_line);
    		    }
		    else
    		    if( strstr(old_buffer, "MaxInstances") )
    		    {
	    	        sprintf(conf_line, "MaxInstances %s\n",current_change_max_connect);
            	        strcat(temp_server, conf_line);
    		    }
		    else
    		    if( strstr(old_buffer, "TimeoutNoTransfer") )
    		    {
	    	        sprintf(conf_line, "TimeoutNoTransfer %s\n",current_change_no_transfer);
            	        strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TimeoutIdle") )
    		    {
	    	        sprintf(conf_line, "TimeoutIdle %s\n",current_change_no_transfer);
            	        strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "AllowStoreRestart") )
    		    {
			if( combo_selection(combo14) == 0 )
    		    	  sprintf(conf_line, "AllowStoreRestart on\n");
			else
    		          sprintf(conf_line, "AllowStoreRestart off\n");
    		    
			strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "AllowRetrieveRestart") )
		    {
			if( combo_selection(combo13) == 0 )
    		          sprintf(conf_line, "AllowRetrieveRestart on\n");
			else
    		    	  sprintf(conf_line, "AllowRetrieveRestart off\n");
    			
			strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TransferRate RETR") )
		    {
	    	        sprintf(conf_line, "TransferRate RETR %s\n",current_change_download_bandwidth);
            	        strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TransferRate STOR") )
		    {
	    	        sprintf(conf_line, "TransferRate STOR %s\n",current_change_upload_bandwidth);
            	        strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TransferRate STOU") )
		    {
	    	        sprintf(conf_line, "TransferRate STOU %s\n",current_change_upload_bandwidth);
            	        strcat(temp_server, conf_line);
		    }
		    else
    		    if( strstr(old_buffer, "TransferRate APPE") )
		    {
	    	        sprintf(conf_line, "TransferRate APPE %s\n",current_change_upload_bandwidth);
            	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "UseReverseDNS") )
		    {
			if( combo_selection(combo3) == 0 )
    		          sprintf(conf_line, "UseReverseDNS on\n");
			else
    		          sprintf(conf_line, "UseReverseDNS off\n");

        	        strcat(temp_server, conf_line);
		    }
		    else
            	    if( strstr(old_buffer, "IdentLookups") )
		    {
			if( combo_selection(combo2) == 0 )
    		          sprintf(conf_line, "IdentLookups on\n");
			else
    		          sprintf(conf_line, "IdentLookups off\n");

        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "DefaultTransferMode") )
		    {
			if( combo_selection(combo5) == 0 )
    		    	  sprintf(conf_line, "DefaultTransferMode binary\n");
			else
    		          sprintf(conf_line, "DefaultTransferMode ascii\n");

        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "User") && old_buffer[4]==' ' )
		    {
		        sprintf(conf_line, "User %s\n",current_change_server_user);
        	        strcat(temp_server, conf_line);
printf("VHOST USER WAS CHANGED !!!\n");
		    }
		    else
        	    if( strstr(old_buffer, "Group") && old_buffer[5]==' ' )
		    {
		        sprintf(conf_line, "Group %s\n",current_change_server_group);
        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "DirFakeUser") )
		    {
			if( combo_selection(combo15) == 0 )
    		          sprintf(conf_line, "DirFakeUser on %s\n", current_change_fake_username);
			else
    		          sprintf(conf_line, "DirFakeUser off %s\n", current_change_fake_username);

        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "DirFakeGroup") )
		    {
			if( combo_selection(combo16) == 0 )
    		          sprintf(conf_line, "DirFakeGroup on %s\n", current_change_fake_username);
			else
    		          sprintf(conf_line, "DirFakeGroup off %s\n", current_change_fake_username);

        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "AllowForeignAddress") )
		    {
			if( combo_selection(combo6) == 0 )
    		          sprintf(conf_line, "AllowForeignAddress on\n");
			else
    		          sprintf(conf_line, "AllowForeignAddress off\n");

        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "TimesGMT") )
		    {
			if( combo_selection(combo4) == 0 )
    		          sprintf(conf_line, "TimesGMT on\n");
			else
    		          sprintf(conf_line, "TimesGMT off\n");

        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "MaxLoginAttempts") )
		    {
		        sprintf(conf_line, "MaxLoginAttempts %s\n",current_change_max_login_attempts);
        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "TimeoutLogin") )
		    {
		        sprintf(conf_line, "TimeoutLogin %s\n",current_change_timeout_login);
        	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "DeleteAbortedStores") )
		    {
			if( combo_selection(combo11) == 0 )
    		          sprintf(conf_line, "DeleteAbortedStores on\n");
			else
    		          sprintf(conf_line, "DeleteAbortedStores off\n");

            	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "SystemLog") )
		    {
	    	        sprintf(conf_line, "SystemLog %s\n",current_change_systemlog);
            	        strcat(temp_server, conf_line);
		    }
		    else
        	    if( strstr(old_buffer, "#gp_random_username_length") && strlen(current_change_rand_username)<=128 )
		    {
	    	        sprintf(conf_line, "#gp_random_username_length %s\n",current_change_rand_username);
            	        strcat(temp_server, conf_line);
		        global_username_randlen=atoi(current_change_rand_username);
		    }
		    else
        	    if( strstr(old_buffer, "#gp_random_password_length") && strlen(current_change_rand_password)<=128 )
		    {
	    	        sprintf(conf_line, "#gp_random_password_length %s\n",current_change_rand_password);
            	        strcat(temp_server, conf_line);
		        global_password_randlen=atoi(current_change_rand_password);
		    }
		    else
        	    if( strstr(old_buffer, "#gp_useradd_root_path") && strlen(current_change_root_path)<=8000 )
		    {
	    	        sprintf(conf_line, "#gp_useradd_root_path %s\n", current_change_root_path);
            	        strcat(temp_server, conf_line);
    			sprintf(gp_useradd_root_path, "%s", current_change_root_path);
		    }
		    else
        	    if( strstr(old_buffer, "#gp_useradd_upload_path") && strlen(current_change_upload_path)<=8000 )
		    {
	    	        sprintf(conf_line, "#gp_useradd_upload_path %s\n",current_change_upload_path);
            	        strcat(temp_server, conf_line);
			sprintf(gp_useradd_upload_path, "%s", current_change_upload_path);
		    }
		    else
        	    if( strstr(old_buffer, "#gp_html_path") )
		    {
	    	        sprintf(conf_line, "#gp_html_path %s\n",current_change_html_path);
            	        strcat(temp_server, conf_line);
		        gtk_entry_set_text(GTK_ENTRY(html_entry), current_change_html_path);
		    }
		    else
        	    if( strstr(old_buffer, "#gp_welcome_name") )
		    {
	    	        sprintf(conf_line, "#gp_welcome_name %s\n",current_change_welcome_name);
            	        strcat(temp_server, conf_line);
		        gtk_entry_set_text(GTK_ENTRY(welcome_entry), current_change_welcome_name);
		    }
		    else
		    if( use_tls )
		    {
        		if( strstr(old_buffer, "TLSEngine") )
			{
			    if( combo_selection(tls_combo1) == 0 )
    		              sprintf(conf_line, "TLSEngine on\n");
			    else
    		              sprintf(conf_line, "TLSEngine off\n");

            	    	    strcat(temp_server, conf_line);
			}
			else
        		if( strstr(old_buffer, "TLSRequired") )
			{
			    if( combo_selection(tls_combo2) == 0 )
    		              sprintf(conf_line, "TLSRequired on\n");
			    else 
			    if( combo_selection(tls_combo2) == 1 )
    		              sprintf(conf_line, "TLSRequired data\n");
			    else
			    if( combo_selection(tls_combo2) == 2 )
    		              sprintf(conf_line, "TLSRequired ctrl\n");
			    else
			    if( combo_selection(tls_combo2) == 3 )
    		              sprintf(conf_line, "TLSRequired off\n");

            		    strcat(temp_server, conf_line);
			}
			else
        		if( strstr(old_buffer, "TLSVerifyClient") )
			{
			    if( combo_selection(tls_combo3) == 0 )
    		              sprintf(conf_line, "TLSVerifyClient on\n");
			    else
    		              sprintf(conf_line, "TLSVerifyClient off\n");

            		    strcat(temp_server, conf_line);
			}
			else
        		if( strstr(old_buffer, "TLSProtocol") )
			{
	    	    	    sprintf(conf_line, "TLSProtocol %s\n", current_tls_protocols_entry);
            		    strcat(temp_server, conf_line);
			}
			else
        		if( strstr(old_buffer, "TLSLog") )
			{
	    	    	    sprintf(conf_line, "TLSLog %s\n", current_tls_logfile_entry);
            	    	    strcat(temp_server, conf_line);
			}
			else
        		if( strstr(old_buffer, "TLSRSACertificateFile") )
			{
	    	    	    sprintf(conf_line, "TLSRSACertificateFile %s\n", current_tls_rsa_cert_entry);
            	    	    strcat(temp_server, conf_line);
			}
			else
            	          strcat(temp_server, old_buffer); /* TLS bug DOH! */
		    }
		    else
            	      strcat(temp_server, old_buffer);
		}
	    
	    }
	    else /* Get everything else but the beginning of the next vhost */
	      {
		  if( ! strcmp(old_buffer, (char *)address_buffer) )
		  {
		     /* Change later */
		  }
		  else
		    {
		       strcat(config, old_buffer);
		    }
	      }
	}
	free(old_buffer);
	free(address_buffer);
	free(port_buffer);
	free(change_srv_ident);
	free(temp_server);
        fclose(fp);
    }


    /* Write the new config if any changes where made */
    if( configuration_changed )
    {
	/* Make a space left check here */
	if((fp=fopen(GP_CONF, "w+"))==NULL)
	{
	    strcpy(info_buffer, _("Cant open proftpd.conf here:\n"));
    	    strcat(info_buffer, GP_CONF);
    	    strcat(info_buffer, _("\nRun GProFTPD as root\n"));
    	    info_window = create_info_window ();
    	    gtk_widget_show (info_window);
	    free(config);
    	    return;
	}
	fputs(config, fp);
	fclose(fp);
    }
    else
      {
         strcpy(info_buffer, _("Could not find the specified server, no changes where made.\n"));
         strcat(info_buffer, _("Try reselecting the server by doubleclicking on it.\n"));
         info_window=create_info_window();
         gtk_widget_show(info_window);
	 free(config);
    	 return;
      }


//printf("Config.............................\n%s\n", config);


    free(config);

    fix_newlines_in_conf();

    /* Reread the changes if online and update the gui */
    list_entire(userlist_treeview, NULL);
    list_users(userlist_treeview, NULL);

    /* We must also relist the server tab but the selected server should not change FIXME */
    list_servers(userlist_treeview, NULL);

    if( online )
      system("killall -1 proftpd");
}


void
on_import_users_button_clicked  (GtkButton       *button,
                        	 gpointer         user_data)
{
    GtkWidget *import_window;
    import_window = create_import_window();
    gtk_widget_show(import_window);
    userlist_treeview = lookup_widget(GTK_WIDGET(button), "userlist_treeview");
}
