/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  util.h: Utility functions.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef UTIL_H
#define UTIL_H

gdouble FixAngle(gdouble);               /* Reduce angles greater than 2*PI       */
gulong DayNum(gint, gint, gint);         /* Calculate daynum from m/d/y           */
gdouble CurrentDaynum(void);             /* Returns the current daynum            */
gchar *dnum2fstr(gdouble,const gchar *); /* Format (param) daynum into string     */
gchar *dnum2str(gdouble);                /* Format daynum into string             */
gchar *dnum2lstr(gdouble);               /* Format daynum into a longer string    */
guint KepCheck(gchar *, gchar *);        /* Torture test on kep. element set      */
gchar *SubString(gchar *,gchar,gchar);   /* Returns a substring                   */
void free_vector_notify_cb (gpointer);   /* Callback function; frees a gchar **   */

#endif
