/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  sattree.h:  This file contains functions to load files containing
              NASA 2-line element set from a specified directory or URL,
	      and return a GtkCTree containing satellite names and the
	      time when the element sets were generated (EPOCH).

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATTREE_H
#define SATTREE_H 1

/* How to load the dirs */
enum _sattree_mode {
	SATTREE_MODE_NONE = 0,   /* undefined... */
	SATTREE_MODE_FILE,       /* level 1, list dirs and files (default)    */ 
	SATTREE_MODE_SAT         /* level 2, also load the contents of files. */
};

typedef enum _sattree_mode sattree_mode;

GtkWidget *sattree_load_uris_recursive (gchar **dir, gchar **web,
					const gchar *filter,
					sattree_mode mode);


#endif
