/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satconfig-locations.c: Configuration wizard for Gnome Predict: Locations.
                         This module is responsible for the widgets and
			 callbacks related to ground station locations.

  Copyright (C)  2002-2005  Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATCONFIG_LOCATIONS_H
#define SATCONFIG_LOCATIONS_H

/* The pair count (resolution?) when calculationg mainhead locator.
   I assume, that the returned locator will contain 2 times pair_count
   characters.
   This parameter has to be passed to the longlat2locator procedure
   as of hamlib V1.2
*/
#define QRA_PAIR_COUNT 3

GtkWidget *satconfig_locations_open (void);
void satconfig_locations_cancel (void);
void satconfig_locations_finish (void);

#endif










