/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  fileio.c: Utility functions to save data. 

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include "satlog.h"
#include "defaults.h"
#include "fileio.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

extern GtkWidget *app;

gint fileio_save_vector (gchar *fn,
			 const gchar *header,
			 const gchar *footer,
			 gchar **vec,
			 guint xsize, guint ysize, guint yzero,
			 gchar *s1, gchar *s2 )
{
	/* This function saves the text vector vec with size
	   elements in the text file fn. s1 is the separator
	   in the vector elements, while s2 is the separator
	   that will be used in the text file.
	   "yzero" is the number of lines to skip.
	*/
	guint i,j;
	gchar **buff;
	FILE *of;

	if (!fn) {
		satlog_log (SAT_LOG_CRITICAL, _("fileio: NULL filename reveived!"));
		return -1;
	}
	of = fopen (fn, "w");
	if (of) {
		if (header)
			fprintf (of, "%s", header);
		for ( i=yzero; i<ysize; i++ ) {
			buff = g_strsplit ( vec[i], s1, xsize );
			for ( j=0; j<xsize; j++)
				fprintf (of, "%s%s", buff[j], s2);
			fprintf (of, "\n");
			/*			fprintf (of, "%s%s%s\n", buff[0], s2, buff[1] );*/
			g_strfreev (buff);
		}
		if (footer)
			fprintf (of, "%s", footer);
		fclose (of);
		gnome_app_message (GNOME_APP (app), _("File created succesfully."));
	}
	else {
		gnome_app_error (GNOME_APP (app), _("There was an error creating the file."));
	}
	return 0;
}


gint
fileio_file_copy (const gchar *in, const gchar *out)
{
	FILE *ifp,*ofp;
	int c;

	g_return_val_if_fail (in != NULL, 1);
	g_return_val_if_fail (out != NULL, 1);

	if ((ifp = fopen (in, "r")) == NULL)
		return 1;
	if ((ofp = fopen (out, "w")) == NULL) {
		fclose (ifp);
		return 1;
	}

	while ((c = getc (ifp)) != EOF)
		putc (c, ofp);

	fclose (ifp);
	fclose (ofp);
	return 0;
}
