/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  extra-widgets.c: Functions to create embeddable and reusable widgets.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include "extra-widgets.h"

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

const gchar *gfx_filter_desc[] = {
	N_("Automatic from extension"),
	"PNG", "JPEG", "GIF", "PCX",
	"TIFF", "BMP", "WMF", "XPM", "XBM",
	"PNM", "HRZ", "PAT", "PSP", "PSD",
	"SGI", "TGA", "XWD"
};

const gchar *gfx_filter_ext[] = {
        NULL,
	"png", "jpg", "gif", "pcx",
	"tif", "bmp", "wmf", "xpm", "xbm",
	"pnm", "hrz", "pat", "psp", "psd",
	"sgi", "tga", "xwd"
};


extern GtkWidget *app;  /* main.c, needed for stock button */


GtkWidget *filesel_graphic_filter ()
{
	/* This function creates a GtkOptionMenu containing
	   valid image file extensions. Used as filter in the
	   image file selector dialog.
	*/
	GtkWidget *optionmenu,*menu,*item;
	guint i;

	menu = gtk_menu_new ();
	for (i=0; i<GFX_FILTER_NUM; i++) {
		item = gtk_menu_item_new_with_label (gfx_filter_desc[i]);
		gtk_object_set_data (GTK_OBJECT (item), "filter", GUINT_TO_POINTER (i));
		gtk_menu_append (GTK_MENU (menu), item);
	}

	optionmenu = gtk_option_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
	return optionmenu;
}
	   



GtkWidget *gpredict_stock_pixmap_button (const gchar *label,
					 const gchar *stock_pixmap,
					 const gchar *tooltips)
{
	/* Create a button with a stock pixmap. Either label or stock_pixmap can be NULL
	   but not both.
	*/
	GtkWidget *button;
	GtkTooltips *kooltips;

	/* we need either a label or a pixmap */
	g_return_val_if_fail (((label != NULL) || (stock_pixmap != NULL)), NULL);
	
	if (stock_pixmap)
		button = gnome_pixmap_button (gnome_stock_pixmap_widget (app, stock_pixmap), label);
	else
		button = gtk_button_new_with_label (label);

	if (tooltips) {
		kooltips = gtk_tooltips_new ();
		gtk_tooltips_set_tip (kooltips, button, tooltips, NULL);
	}

	return button;
}


GtkWidget *gpredict_pixmap_button (const gchar *label,
				   const gchar *subdir,
				   const gchar *pixmapfile,
				   const gchar *tooltips)
{
	/* Create a pixmap button with label 'label', pixmap 'PACKAGE_PIXMAPS_DIR/subdir/pixmap'
	   and tooltips 'tooltips'. Any of these params can be NULL but at least either the
	   label or the pixmap has to be non-null.
	*/
	GtkWidget *button;
	GtkWidget *pixmap;
	GtkTooltips *kooltips;
	gchar *pixmappath;

	/* we need either a label or a pixmap */
	g_return_val_if_fail (((label != NULL) || (pixmapfile != NULL)), NULL);

	/* If we have a pixmap, create a pixmap button */
	if (pixmapfile) {
		pixmappath = g_strconcat (PACKAGE_PIXMAPS_DIR, G_DIR_SEPARATOR_S,
					  (subdir) ? subdir : "." ,
					  G_DIR_SEPARATOR_S, pixmapfile, NULL);
		pixmap = gnome_pixmap_new_from_file (pixmappath);
		if (label) {
			button = gnome_pixmap_button (pixmap, label);
		}
		else {
			button = gnome_pixmap_button (pixmap, "");
		}
		g_free (pixmappath);
	}
	/* otherwise create a regular button */
	else {
		button = gtk_button_new_with_label (label);
	}

	if (tooltips) {
		kooltips = gtk_tooltips_new ();
		gtk_tooltips_set_tip (kooltips, button, tooltips, NULL);
	}

	return button;
}




GtkWidget *gpredict_mini_button (const gchar *subdir,
				 const gchar *pixmapfile,
				 const gchar *tooltips)
{
	/* Create a pixmap button with no label, pixmap 'PACKAGE_PIXMAPS_DIR/subdir/pixmap'
	   and tooltips 'tooltips'.
	*/
	GtkWidget *button;
	GtkWidget *pixmap;
	GtkTooltips *kooltips;
	gchar *pixmappath;

	/* If we have a pixmap, create a pixmap button */
	if (pixmapfile) {
		pixmappath = g_strconcat (PACKAGE_PIXMAPS_DIR, G_DIR_SEPARATOR_S,
					  (subdir) ? subdir : "." ,
					  G_DIR_SEPARATOR_S, pixmapfile, NULL);
		pixmap = gnome_pixmap_new_from_file (pixmappath);

		button = gtk_button_new ();
		gtk_container_add (GTK_CONTAINER (button), pixmap);
		gtk_object_set_data (GTK_OBJECT (button), "pixmap", pixmap);

		g_free (pixmappath);
	}
	/* otherwise create a regular button */
	else {
		button = gtk_button_new_with_label ("X");
	}

	if (tooltips) {
		kooltips = gtk_tooltips_new ();
		gtk_tooltips_set_tip (kooltips, button, tooltips, NULL);
	}

	return button;
}
